'\"
.so man.macros
.TH Composite n "" Tk "Perl/Tk Constructs"
.SH "NAME"
Defining a new \- composite widget class
.SH "SYNOPSIS"
.PP
.DS
\&  package Whatever;
\&  @ISA = qw(Tk::Frame);  # or Tk::Toplevel
\&         
\&  Tk::Widget->Construct('Whatever'); 
\&         
\&  sub Populate 
\&  {      
\&   my ($cw,$args) = @_;
\&         
\&   my $flag = delete $args->{-flag};
\&   if (defined $flag)
\&    {    
\&     # handle -flag => xxx which can only be done at create time
\&     # the delete above ensures that new() does not try and
\&     # do $cw->configure(-flag => xxx)
\&    }    
\&         
\&   $w = $cw->Component(...);
\&         
\&   $cw->Delegates(...);
\&   $cw->ConfigSpecs('-cursor' =>     [SELF,cursor,Cursor,undef],
\&                    '-something'  => [METHOD,dbName,dbClass,'default'],
\&                    '-text'       => [$label,dbName,dbClass,'default'],
\&                    '-heading'    => [Tk::Config->new($head,-text),heading,Heading,'My Heading']
\&                   ); 
\&  }      
\&         
\&  sub something
\&  {      
\&   my ($cw,$value) = @_;
\&   if (@_ > 1)
\&    {    
\&     # set it 
\&    }    
\&   return # current value
\&  }      
\&         
\&  1;     
.DE
.SH "DESCRIPTION"
The intention behind a composite is to create a higher-level widget, 
sometimes called a "super-widget" or "meta-widget".  Most often, a composite will be
built upon other widgets by \fBusing\fR them, as opposed to specializing on them.  
For example, the supplied composite widget \fBLabEntry\fR is \fImade of\fR an
\fBEntry\fR and a \fBLabel\fR; it is neither a \fIkind-of\fR \fBLabel\fR
nor is it a \fIkind-of\fR \fBEntry\fR.
.PP
Most of the work of a composite widget consist in creating subwidgets, 
arrange to dispatch configure options to the proper subwidgets and manage
composite-specific configure options.
.IP "Composite widget creation" 4
Since perl/Tk is heavilly using an object-oriented approach, it is no
suprise that creating a composite goes through a \fBnew()\fR method.
However, the composite does not normally define a \fBnew()\fR method
itself: it is usually sufficient to simply inherit it from
\fBTk::Widget\fR.  
.PP
This is what happens when the composite use
.PP
\&        @ISA = qw(Tk::Frame);  # or Tk::Toplevel
.br
to specify its inheritance chain.  To complete the initialisation of the
widget, it must call the \fBConstruct\fR method from class \fBWidget\fR.  That
method accepts the name of the new class to create, i.e. the package name
of your composite widget:
.PP
\&        Tk::Widget->Construct('Whatever'); 
.br
Here, \fBWhatever\fR is the package name (aka the widget's \fBclass\fR).  This
will define a constructor method for \fBWhatever\fR, normally named after the 
widget's class.  Instanciating that composite in client code would
the look like:
.PP
\&        $top = MainWindow->new();   # Creates a top-level main window
.br
.br
\&        $cw = $top->Whatever();     # Creates an instance of composite widget
.br
\&                                    # 'Whatever'
.br
Whenever a composite is instanciated in client code,
\fBTk::Widget::new()\fR will be invoked via the widget's class
constructor.  That \fBnew\fR method will call 
.PP
\&        $cw->InitObject(\e%args);
.br
where \fB%args\fR is the arguments passed to the widget's constructor.  Note
that \fBInitObject\fR receives a \fBreference\fR to the hash array
containing all arguments.
.PP
For composite widgets that needs an underlying frame, \fBInitObject\fR
will typically be inherited from \fBTk::Frame\fR, that is, no method of
this name will appear in the composite package.  For composites that
don't need a frame, \fBInitObject\fR will typically be defined in the
composite class (package).  Compare the \fBLabEntry\fR composite with 
\fBOptionmenu\fR: the former is \fBFrame\fR based while the latter is \fBWidget\fR 
based.
.PP
In \fBFrame\fR based composites, \fBTk::Frame::InitObject()\fR will call
\fBPopulate()\fR, which should be defined to create the characteristic
subwidgets of the class.
.PP
\fBWidget\fR based composites don't need an extra \fBPopulate\fR layer; they
typically have their own \fBInitObject\fR method that will create subwidgets.
.IP "Creating Subwidgets" 4
Subwidget creation happens usually in \fBPopulate()\fR (\fBFrame\fR based) 
or \fBInitObject()\fR (\fBWidget\fR based).  The composite usually calls the
subwidget's constructor method either directly, for "private" subwidgets, 
or indirectly through the \fBComponent\fR method for subwidgets that should
be advertised to clients.
.PP
\fBPopulate\fR may call \fBDelegates\fR to direct calls to methods 
of chosen subwidgets. For simple composites, typically most if not all 
methods are directed
to a single subwidget \- e.g. \fBScrListbox\fR directs all methods to the core
\fBListbox\fR so that \fB$composite\fR\->\fIget\fR\|(...) calls \fB$listbox\fR\->\fIget\fR\|(...). 
.PP
\fBFurther steps for \fR\fBFrame\fR \fBbased composites\fR
.PP
\fBPopulate\fR should also call \fBConfigSpecs()\fR to specify the
way that configure-like options should be handled in the composite.
Once \fBPopulate\fR returns, method \fBTk::Frame::ConfigDefault\fR
walks through the \fBConfigSpecs\fR entries and populates
%$args hash with defaults for options from X resources (.Xdefaults, etc).
.PP
When  \fBInitObject()\fR returns to \fBTk::Widget::new()\fR, 
a call to \fB$cw\fR\->\fIconfigure\fR\|(%$args) is made which sets *all* the options.

.SH "SEE ALSO"
ConfigSpecs
