'\"
'\" Copyright (c) 1990-1992 The Regents of the University of California.
'\" Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) update.n 1.9 95/05/20 16:34:48
'\" 
.so man.macros
.TH update n "" Tk "Tk Generic Methods"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
update \- Process pending events and/or when-idle handlers
.SH SYNOPSIS
\fI$widget\fR->\fBupdate\fR
.br
\fI$widget\fR->\fBidletasks\fR
.BE

.SH DESCRIPTION
.PP
The \fBupdate\fR method is used to bring the entire application world
``up to date.''
It flushes all pending output to the display,  waits for the
server to process that output and return errors or events,
handles all pending events of any sort (including when-idle handlers),
and repeats this set of operations until there are no pending
events, no pending when-idle handlers, no pending output to the server,
and no operations still outstanding at the server.  
.PP
The \fBidletasks\fR method behaves as above but
no new events or errors are processed;  only when-idle
idlers are invoked.
This causes operations that are normally deferred, such as display
updates and window layout calculations, to be performed immediately.
.PP
The \fBidletasks\fR method is useful in scripts where
changes have been made to the application's state and you want those
changes to appear on the display immediately, rather than waiting
for the script to complete.  Most display updates are performed as
idle handlers, so \fBidletasks\fR will cause them to run.
However, there are some kinds of updates that only happen in
response to events, such as those triggered by window size changes;
these updates will not occur in \fBidletasks\fR.
.PP
The \fBupdate\fR method is useful in scripts where
you are performing a long-running computation but you still want
the application to respond to user interactions;  if you occasionally
call \fBupdate\fR then user input will be processed during the
next call to \fBupdate\fR.

.SH KEYWORDS
event, flush, handler, idle, update
