/* Copyright (C) 1996, 1997 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef _SEMAPHORE_H
# error "Never include <bits/semaphore.h> directly; use <semaphore.h> instead."
#endif


/* Due to the implementation of the load-locked/store-conditional
   instructions, we cannot pack semaphores closer than a cache line
   or risk threads deadlocking on unrelated semaphores.  */

typedef struct {
  long int sem_status;
  long int sem_reserved[3];
} sem_t;
