/* Copyright (C) 1995, 1996, 1997 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef	_SYSCALL_H
#define	_SYSCALL_H	1

/* This file should list the numbers of the system the system knows.
   But instead of duplicating this we use the information available
   from the kernel sources.  */
#include <asm/unistd.h>

/*
 * SVR4 syscalls are in the range from 1 to 999
 */
#define SYS_SVR4			0
#define SYS_SVR4_syscall		(SYS_SVR4 +   0)
#define SYS_SVR4_exit			(SYS_SVR4 +   1)
#define SYS_SVR4_fork			(SYS_SVR4 +   2)
#define SYS_SVR4_read			(SYS_SVR4 +   3)
#define SYS_SVR4_write			(SYS_SVR4 +   4)
#define SYS_SVR4_open			(SYS_SVR4 +   5)
#define SYS_SVR4_close			(SYS_SVR4 +   6)
#define SYS_SVR4_wait			(SYS_SVR4 +   7)
#define SYS_SVR4_creat			(SYS_SVR4 +   8)
#define SYS_SVR4_link			(SYS_SVR4 +   9)
#define SYS_SVR4_unlink			(SYS_SVR4 +  10)
#define SYS_SVR4_exec			(SYS_SVR4 +  11)
#define SYS_SVR4_chdir			(SYS_SVR4 +  12)
#define SYS_SVR4_gtime			(SYS_SVR4 +  13)
#define SYS_SVR4_mknod			(SYS_SVR4 +  14)
#define SYS_SVR4_chmod			(SYS_SVR4 +  15)
#define SYS_SVR4_chown			(SYS_SVR4 +  16)
#define SYS_SVR4_sbreak			(SYS_SVR4 +  17)
#define SYS_SVR4_stat			(SYS_SVR4 +  18)
#define SYS_SVR4_lseek			(SYS_SVR4 +  19)
#define SYS_SVR4_getpid			(SYS_SVR4 +  20)
#define SYS_SVR4_mount			(SYS_SVR4 +  21)
#define SYS_SVR4_umount			(SYS_SVR4 +  22)
#define SYS_SVR4_setuid			(SYS_SVR4 +  23)
#define SYS_SVR4_getuid			(SYS_SVR4 +  24)
#define SYS_SVR4_stime			(SYS_SVR4 +  25)
#define SYS_SVR4_ptrace			(SYS_SVR4 +  26)
#define SYS_SVR4_alarm			(SYS_SVR4 +  27)
#define SYS_SVR4_fstat			(SYS_SVR4 +  28)
#define SYS_SVR4_pause			(SYS_SVR4 +  29)
#define SYS_SVR4_utime			(SYS_SVR4 +  30)
#define SYS_SVR4_stty			(SYS_SVR4 +  31)
#define SYS_SVR4_gtty			(SYS_SVR4 +  32)
#define SYS_SVR4_access			(SYS_SVR4 +  33)
#define SYS_SVR4_nice			(SYS_SVR4 +  34)
#define SYS_SVR4_statfs			(SYS_SVR4 +  35)
#define SYS_SVR4_sync			(SYS_SVR4 +  36)
#define SYS_SVR4_kill			(SYS_SVR4 +  37)
#define SYS_SVR4_fstatfs		(SYS_SVR4 +  38)
#define SYS_SVR4_setpgrp		(SYS_SVR4 +  39)
#define SYS_SVR4_cxenix			(SYS_SVR4 +  40)
#define SYS_SVR4_dup			(SYS_SVR4 +  41)
#define SYS_SVR4_pipe			(SYS_SVR4 +  42)
#define SYS_SVR4_times			(SYS_SVR4 +  43)
#define SYS_SVR4_profil			(SYS_SVR4 +  44)
#define SYS_SVR4_plock			(SYS_SVR4 +  45)
#define SYS_SVR4_setgid			(SYS_SVR4 +  46)
#define SYS_SVR4_getgid			(SYS_SVR4 +  47)
#define SYS_SVR4_sig			(SYS_SVR4 +  48)
#define SYS_SVR4_msgsys			(SYS_SVR4 +  49)
#define SYS_SVR4_sysmips		(SYS_SVR4 +  50)
#define SYS_SVR4_sysacct		(SYS_SVR4 +  51)
#define SYS_SVR4_shmsys			(SYS_SVR4 +  52)
#define SYS_SVR4_semsys			(SYS_SVR4 +  53)
#define SYS_SVR4_ioctl			(SYS_SVR4 +  54)
#define SYS_SVR4_uadmin			(SYS_SVR4 +  55)
#define SYS_SVR4_exch 			(SYS_SVR4 +  56)
#define SYS_SVR4_utssys			(SYS_SVR4 +  57)
#define SYS_SVR4_fsync			(SYS_SVR4 +  58)
#define SYS_SVR4_exece			(SYS_SVR4 +  59)
#define SYS_SVR4_umask			(SYS_SVR4 +  60)
#define SYS_SVR4_chroot			(SYS_SVR4 +  61)
#define SYS_SVR4_fcntl			(SYS_SVR4 +  62)
#define SYS_SVR4_ulimit			(SYS_SVR4 +  63)
#define SYS_SVR4_reserved1		(SYS_SVR4 +  64)
#define SYS_SVR4_reserved2		(SYS_SVR4 +  65)
#define SYS_SVR4_reserved3		(SYS_SVR4 +  66)
#define SYS_SVR4_reserved4		(SYS_SVR4 +  67)
#define SYS_SVR4_reserved5		(SYS_SVR4 +  68)
#define SYS_SVR4_reserved6		(SYS_SVR4 +  69)
#define SYS_SVR4_advfs			(SYS_SVR4 +  70)
#define SYS_SVR4_unadvfs		(SYS_SVR4 +  71)
#define SYS_SVR4_unused1		(SYS_SVR4 +  72)
#define SYS_SVR4_unused2		(SYS_SVR4 +  73)
#define SYS_SVR4_rfstart		(SYS_SVR4 +  74)
#define SYS_SVR4_unused3		(SYS_SVR4 +  75)
#define SYS_SVR4_rdebug			(SYS_SVR4 +  76)
#define SYS_SVR4_rfstop			(SYS_SVR4 +  77)
#define SYS_SVR4_rfsys			(SYS_SVR4 +  78)
#define SYS_SVR4_rmdir			(SYS_SVR4 +  79)
#define SYS_SVR4_mkdir			(SYS_SVR4 +  80)
#define SYS_SVR4_getdents		(SYS_SVR4 +  81)
#define SYS_SVR4_libattach		(SYS_SVR4 +  82)
#define SYS_SVR4_libdetach		(SYS_SVR4 +  83)
#define SYS_SVR4_sysfs			(SYS_SVR4 +  84)
#define SYS_SVR4_getmsg			(SYS_SVR4 +  85)
#define SYS_SVR4_putmsg			(SYS_SVR4 +  86)
#define SYS_SVR4_poll			(SYS_SVR4 +  87)
#define SYS_SVR4_lstat			(SYS_SVR4 +  88)
#define SYS_SVR4_symlink		(SYS_SVR4 +  89)
#define SYS_SVR4_readlink		(SYS_SVR4 +  90)
#define SYS_SVR4_setgroups		(SYS_SVR4 +  91)
#define SYS_SVR4_getgroups		(SYS_SVR4 +  92)
#define SYS_SVR4_fchmod			(SYS_SVR4 +  93)
#define SYS_SVR4_fchown			(SYS_SVR4 +  94)
#define SYS_SVR4_sigprocmask		(SYS_SVR4 +  95)
#define SYS_SVR4_sigsuspend		(SYS_SVR4 +  96)
#define SYS_SVR4_sigaltstack		(SYS_SVR4 +  97)
#define SYS_SVR4_sigaction		(SYS_SVR4 +  98)
#define SYS_SVR4_sigpending		(SYS_SVR4 +  99)
#define SYS_SVR4_setcontext		(SYS_SVR4 + 100)
#define SYS_SVR4_evsys			(SYS_SVR4 + 101)
#define SYS_SVR4_evtrapret		(SYS_SVR4 + 102)
#define SYS_SVR4_statvfs		(SYS_SVR4 + 103)
#define SYS_SVR4_fstatvfs		(SYS_SVR4 + 104)
#define SYS_SVR4_reserved7		(SYS_SVR4 + 105)
#define SYS_SVR4_nfssys			(SYS_SVR4 + 106)
#define SYS_SVR4_waitid			(SYS_SVR4 + 107)
#define SYS_SVR4_sigsendset		(SYS_SVR4 + 108)
#define SYS_SVR4_hrtsys			(SYS_SVR4 + 109)
#define SYS_SVR4_acancel		(SYS_SVR4 + 110)
#define SYS_SVR4_async			(SYS_SVR4 + 111)
#define SYS_SVR4_priocntlset		(SYS_SVR4 + 112)
#define SYS_SVR4_pathconf		(SYS_SVR4 + 113)
#define SYS_SVR4_mincore		(SYS_SVR4 + 114)
#define SYS_SVR4_mmap			(SYS_SVR4 + 115)
#define SYS_SVR4_mprotect		(SYS_SVR4 + 116)
#define SYS_SVR4_munmap			(SYS_SVR4 + 117)
#define SYS_SVR4_fpathconf		(SYS_SVR4 + 118)
#define SYS_SVR4_vfork			(SYS_SVR4 + 119)
#define SYS_SVR4_fchdir			(SYS_SVR4 + 120)
#define SYS_SVR4_readv			(SYS_SVR4 + 121)
#define SYS_SVR4_writev			(SYS_SVR4 + 122)
#define SYS_SVR4_xstat			(SYS_SVR4 + 123)
#define SYS_SVR4_lxstat			(SYS_SVR4 + 124)
#define SYS_SVR4_fxstat			(SYS_SVR4 + 125)
#define SYS_SVR4_xmknod			(SYS_SVR4 + 126)
#define SYS_SVR4_clocal			(SYS_SVR4 + 127)
#define SYS_SVR4_setrlimit		(SYS_SVR4 + 128)
#define SYS_SVR4_getrlimit		(SYS_SVR4 + 129)
#define SYS_SVR4_lchown			(SYS_SVR4 + 130)
#define SYS_SVR4_memcntl		(SYS_SVR4 + 131)
#define SYS_SVR4_getpmsg		(SYS_SVR4 + 132)
#define SYS_SVR4_putpmsg		(SYS_SVR4 + 133)
#define SYS_SVR4_rename			(SYS_SVR4 + 134)
#define SYS_SVR4_nuname			(SYS_SVR4 + 135)
#define SYS_SVR4_setegid		(SYS_SVR4 + 136)
#define SYS_SVR4_sysconf		(SYS_SVR4 + 137)
#define SYS_SVR4_adjtime		(SYS_SVR4 + 138)
#define SYS_SVR4_sysinfo		(SYS_SVR4 + 139)
#define SYS_SVR4_reserved8		(SYS_SVR4 + 140)
#define SYS_SVR4_seteuid		(SYS_SVR4 + 141)
#define SYS_SVR4_PYRAMID_statis		(SYS_SVR4 + 142)
#define SYS_SVR4_PYRAMID_tuning		(SYS_SVR4 + 143)
#define SYS_SVR4_PYRAMID_forcerr	(SYS_SVR4 + 144)
#define SYS_SVR4_PYRAMID_mpcntl		(SYS_SVR4 + 145)
#define SYS_SVR4_reserved9		(SYS_SVR4 + 146)
#define SYS_SVR4_reserved10		(SYS_SVR4 + 147)
#define SYS_SVR4_reserved11		(SYS_SVR4 + 148)
#define SYS_SVR4_reserved12		(SYS_SVR4 + 149)
#define SYS_SVR4_reserved13		(SYS_SVR4 + 150)
#define SYS_SVR4_reserved14		(SYS_SVR4 + 151)
#define SYS_SVR4_reserved15		(SYS_SVR4 + 152)
#define SYS_SVR4_reserved16		(SYS_SVR4 + 153)
#define SYS_SVR4_reserved17		(SYS_SVR4 + 154)
#define SYS_SVR4_reserved18		(SYS_SVR4 + 155)
#define SYS_SVR4_reserved19		(SYS_SVR4 + 156)
#define SYS_SVR4_reserved20		(SYS_SVR4 + 157)
#define SYS_SVR4_reserved21		(SYS_SVR4 + 158)
#define SYS_SVR4_reserved22		(SYS_SVR4 + 159)
#define SYS_SVR4_reserved23		(SYS_SVR4 + 160)
#define SYS_SVR4_reserved24		(SYS_SVR4 + 161)
#define SYS_SVR4_reserved25		(SYS_SVR4 + 162)
#define SYS_SVR4_reserved26		(SYS_SVR4 + 163)
#define SYS_SVR4_reserved27		(SYS_SVR4 + 164)
#define SYS_SVR4_reserved28		(SYS_SVR4 + 165)
#define SYS_SVR4_reserved29		(SYS_SVR4 + 166)
#define SYS_SVR4_reserved30		(SYS_SVR4 + 167)
#define SYS_SVR4_reserved31		(SYS_SVR4 + 168)
#define SYS_SVR4_reserved32		(SYS_SVR4 + 169)
#define SYS_SVR4_reserved33		(SYS_SVR4 + 170)
#define SYS_SVR4_reserved34		(SYS_SVR4 + 171)
#define SYS_SVR4_reserved35		(SYS_SVR4 + 172)
#define SYS_SVR4_reserved36		(SYS_SVR4 + 173)
#define SYS_SVR4_reserved37		(SYS_SVR4 + 174)
#define SYS_SVR4_reserved38		(SYS_SVR4 + 175)
#define SYS_SVR4_reserved39		(SYS_SVR4 + 176)
#define SYS_SVR4_reserved40		(SYS_SVR4 + 177)
#define SYS_SVR4_reserved41		(SYS_SVR4 + 178)
#define SYS_SVR4_reserved42		(SYS_SVR4 + 179)
#define SYS_SVR4_reserved43		(SYS_SVR4 + 180)
#define SYS_SVR4_reserved44		(SYS_SVR4 + 181)
#define SYS_SVR4_reserved45		(SYS_SVR4 + 182)
#define SYS_SVR4_reserved46		(SYS_SVR4 + 183)
#define SYS_SVR4_reserved47		(SYS_SVR4 + 184)
#define SYS_SVR4_reserved48		(SYS_SVR4 + 185)
#define SYS_SVR4_reserved49		(SYS_SVR4 + 186)
#define SYS_SVR4_reserved50		(SYS_SVR4 + 187)
#define SYS_SVR4_reserved51		(SYS_SVR4 + 188)
#define SYS_SVR4_reserved52		(SYS_SVR4 + 189)
#define SYS_SVR4_reserved53		(SYS_SVR4 + 190)
#define SYS_SVR4_reserved54		(SYS_SVR4 + 191)
#define SYS_SVR4_reserved55		(SYS_SVR4 + 192)
#define SYS_SVR4_reserved56		(SYS_SVR4 + 193)
#define SYS_SVR4_reserved57		(SYS_SVR4 + 194)
#define SYS_SVR4_reserved58		(SYS_SVR4 + 195)
#define SYS_SVR4_reserved59		(SYS_SVR4 + 196)
#define SYS_SVR4_reserved60		(SYS_SVR4 + 197)
#define SYS_SVR4_reserved61		(SYS_SVR4 + 198)
#define SYS_SVR4_reserved62		(SYS_SVR4 + 199)
#define SYS_SVR4_reserved63		(SYS_SVR4 + 200)
#define SYS_SVR4_aread			(SYS_SVR4 + 201)
#define SYS_SVR4_awrite			(SYS_SVR4 + 202)
#define SYS_SVR4_listio			(SYS_SVR4 + 203)
#define SYS_SVR4_mips_acancel		(SYS_SVR4 + 204)
#define SYS_SVR4_astatus		(SYS_SVR4 + 205)
#define SYS_SVR4_await			(SYS_SVR4 + 206)
#define SYS_SVR4_areadv			(SYS_SVR4 + 207)
#define SYS_SVR4_awritev		(SYS_SVR4 + 208)
#define SYS_SVR4_MIPS_reserved1		(SYS_SVR4 + 209)
#define SYS_SVR4_MIPS_reserved2		(SYS_SVR4 + 210)
#define SYS_SVR4_MIPS_reserved3		(SYS_SVR4 + 211)
#define SYS_SVR4_MIPS_reserved4		(SYS_SVR4 + 212)
#define SYS_SVR4_MIPS_reserved5		(SYS_SVR4 + 213)
#define SYS_SVR4_MIPS_reserved6		(SYS_SVR4 + 214)
#define SYS_SVR4_MIPS_reserved7		(SYS_SVR4 + 215)
#define SYS_SVR4_MIPS_reserved8		(SYS_SVR4 + 216)
#define SYS_SVR4_MIPS_reserved9		(SYS_SVR4 + 217)
#define SYS_SVR4_MIPS_reserved10	(SYS_SVR4 + 218)
#define SYS_SVR4_MIPS_reserved11	(SYS_SVR4 + 219)
#define SYS_SVR4_MIPS_reserved12	(SYS_SVR4 + 220)
#define SYS_SVR4_CDC_reserved1		(SYS_SVR4 + 221)
#define SYS_SVR4_CDC_reserved2		(SYS_SVR4 + 222)
#define SYS_SVR4_CDC_reserved3		(SYS_SVR4 + 223)
#define SYS_SVR4_CDC_reserved4		(SYS_SVR4 + 224)
#define SYS_SVR4_CDC_reserved5		(SYS_SVR4 + 225)
#define SYS_SVR4_CDC_reserved6		(SYS_SVR4 + 226)
#define SYS_SVR4_CDC_reserved7		(SYS_SVR4 + 227)
#define SYS_SVR4_CDC_reserved8		(SYS_SVR4 + 228)
#define SYS_SVR4_CDC_reserved9		(SYS_SVR4 + 229)
#define SYS_SVR4_CDC_reserved10		(SYS_SVR4 + 230)
#define SYS_SVR4_CDC_reserved11		(SYS_SVR4 + 231)
#define SYS_SVR4_CDC_reserved12		(SYS_SVR4 + 232)
#define SYS_SVR4_CDC_reserved13		(SYS_SVR4 + 233)
#define SYS_SVR4_CDC_reserved14		(SYS_SVR4 + 234)
#define SYS_SVR4_CDC_reserved15		(SYS_SVR4 + 235)
#define SYS_SVR4_CDC_reserved16		(SYS_SVR4 + 236)
#define SYS_SVR4_CDC_reserved17		(SYS_SVR4 + 237)
#define SYS_SVR4_CDC_reserved18		(SYS_SVR4 + 238)
#define SYS_SVR4_CDC_reserved19		(SYS_SVR4 + 239)
#define SYS_SVR4_CDC_reserved20		(SYS_SVR4 + 240)

/*
 * SYS V syscalls are in the range from 1000 to 1999
 */
#define SYS_SYSV			1000
#define SYS_SYSV_syscall		(SYS_SYSV +   0)
#define SYS_SYSV_exit			(SYS_SYSV +   1)
#define SYS_SYSV_fork			(SYS_SYSV +   2)
#define SYS_SYSV_read			(SYS_SYSV +   3)
#define SYS_SYSV_write			(SYS_SYSV +   4)
#define SYS_SYSV_open			(SYS_SYSV +   5)
#define SYS_SYSV_close			(SYS_SYSV +   6)
#define SYS_SYSV_wait			(SYS_SYSV +   7)
#define SYS_SYSV_creat			(SYS_SYSV +   8)
#define SYS_SYSV_link			(SYS_SYSV +   9)
#define SYS_SYSV_unlink			(SYS_SYSV +  10)
#define SYS_SYSV_execv			(SYS_SYSV +  11)
#define SYS_SYSV_chdir			(SYS_SYSV +  12)
#define SYS_SYSV_time			(SYS_SYSV +  13)
#define SYS_SYSV_mknod			(SYS_SYSV +  14)
#define SYS_SYSV_chmod			(SYS_SYSV +  15)
#define SYS_SYSV_chown			(SYS_SYSV +  16)
#define SYS_SYSV_brk			(SYS_SYSV +  17)
#define SYS_SYSV_stat			(SYS_SYSV +  18)
#define SYS_SYSV_lseek			(SYS_SYSV +  19)
#define SYS_SYSV_getpid			(SYS_SYSV +  20)
#define SYS_SYSV_mount			(SYS_SYSV +  21)
#define SYS_SYSV_umount			(SYS_SYSV +  22)
#define SYS_SYSV_setuid			(SYS_SYSV +  23)
#define SYS_SYSV_getuid			(SYS_SYSV +  24)
#define SYS_SYSV_stime			(SYS_SYSV +  25)
#define SYS_SYSV_ptrace			(SYS_SYSV +  26)
#define SYS_SYSV_alarm			(SYS_SYSV +  27)
#define SYS_SYSV_fstat			(SYS_SYSV +  28)
#define SYS_SYSV_pause			(SYS_SYSV +  29)
#define SYS_SYSV_utime			(SYS_SYSV +  30)
#define SYS_SYSV_stty			(SYS_SYSV +  31)
#define SYS_SYSV_gtty			(SYS_SYSV +  32)
#define SYS_SYSV_access			(SYS_SYSV +  33)
#define SYS_SYSV_nice			(SYS_SYSV +  34)
#define SYS_SYSV_statfs			(SYS_SYSV +  35)
#define SYS_SYSV_sync			(SYS_SYSV +  36)
#define SYS_SYSV_kill			(SYS_SYSV +  37)
#define SYS_SYSV_fstatfs		(SYS_SYSV +  38)
#define SYS_SYSV_setpgrp		(SYS_SYSV +  39)
#define SYS_SYSV_syssgi			(SYS_SYSV +  40)
#define SYS_SYSV_dup			(SYS_SYSV +  41)
#define SYS_SYSV_pipe			(SYS_SYSV +  42)
#define SYS_SYSV_times			(SYS_SYSV +  43)
#define SYS_SYSV_profil			(SYS_SYSV +  44)
#define SYS_SYSV_plock			(SYS_SYSV +  45)
#define SYS_SYSV_setgid			(SYS_SYSV +  46)
#define SYS_SYSV_getgid			(SYS_SYSV +  47)
#define SYS_SYSV_sig			(SYS_SYSV +  48)
#define SYS_SYSV_msgsys			(SYS_SYSV +  49)
#define SYS_SYSV_sysmips		(SYS_SYSV +  50)
#define SYS_SYSV_acct			(SYS_SYSV +  51)
#define SYS_SYSV_shmsys			(SYS_SYSV +  52)
#define SYS_SYSV_semsys			(SYS_SYSV +  53)
#define SYS_SYSV_ioctl			(SYS_SYSV +  54)
#define SYS_SYSV_uadmin			(SYS_SYSV +  55)
#define SYS_SYSV_sysmp			(SYS_SYSV +  56)
#define SYS_SYSV_utssys			(SYS_SYSV +  57)
#define SYS_SYSV_USG_reserved1		(SYS_SYSV +  58)
#define SYS_SYSV_execve			(SYS_SYSV +  59)
#define SYS_SYSV_umask			(SYS_SYSV +  60)
#define SYS_SYSV_chroot			(SYS_SYSV +  61)
#define SYS_SYSV_fcntl			(SYS_SYSV +  62)
#define SYS_SYSV_ulimit			(SYS_SYSV +  63)
#define SYS_SYSV_SAFARI4_reserved1	(SYS_SYSV +  64)
#define SYS_SYSV_SAFARI4_reserved2	(SYS_SYSV +  65)
#define SYS_SYSV_SAFARI4_reserved3	(SYS_SYSV +  66)
#define SYS_SYSV_SAFARI4_reserved4	(SYS_SYSV +  67)
#define SYS_SYSV_SAFARI4_reserved5	(SYS_SYSV +  68)
#define SYS_SYSV_SAFARI4_reserved6	(SYS_SYSV +  69)
#define SYS_SYSV_advfs			(SYS_SYSV +  70)
#define SYS_SYSV_unadvfs		(SYS_SYSV +  71)
#define SYS_SYSV_rmount			(SYS_SYSV +  72)
#define SYS_SYSV_rumount		(SYS_SYSV +  73)
#define SYS_SYSV_rfstart		(SYS_SYSV +  74)
#define SYS_SYSV_getrlimit64		(SYS_SYSV +  75)
#define SYS_SYSV_setrlimit64		(SYS_SYSV +  76)
#define SYS_SYSV_nanosleep		(SYS_SYSV +  77)
#define SYS_SYSV_lseek64		(SYS_SYSV +  78)
#define SYS_SYSV_rmdir			(SYS_SYSV +  79)
#define SYS_SYSV_mkdir			(SYS_SYSV +  80)
#define SYS_SYSV_getdents		(SYS_SYSV +  81)
#define SYS_SYSV_sginap			(SYS_SYSV +  82)
#define SYS_SYSV_sgikopt		(SYS_SYSV +  83)
#define SYS_SYSV_sysfs			(SYS_SYSV +  84)
#define SYS_SYSV_getmsg			(SYS_SYSV +  85)
#define SYS_SYSV_putmsg			(SYS_SYSV +  86)
#define SYS_SYSV_poll			(SYS_SYSV +  87)
#define SYS_SYSV_sigreturn		(SYS_SYSV +  88)
#define SYS_SYSV_accept			(SYS_SYSV +  89)
#define SYS_SYSV_bind			(SYS_SYSV +  90)
#define SYS_SYSV_connect		(SYS_SYSV +  91)
#define SYS_SYSV_gethostid		(SYS_SYSV +  92)
#define SYS_SYSV_getpeername		(SYS_SYSV +  93)
#define SYS_SYSV_getsockname		(SYS_SYSV +  94)
#define SYS_SYSV_getsockopt		(SYS_SYSV +  95)
#define SYS_SYSV_listen			(SYS_SYSV +  96)
#define SYS_SYSV_recv			(SYS_SYSV +  97)
#define SYS_SYSV_recvfrom		(SYS_SYSV +  98)
#define SYS_SYSV_recvmsg		(SYS_SYSV +  99)
#define SYS_SYSV_select			(SYS_SYSV + 100)
#define SYS_SYSV_send			(SYS_SYSV + 101)
#define SYS_SYSV_sendmsg		(SYS_SYSV + 102)
#define SYS_SYSV_sendto			(SYS_SYSV + 103)
#define SYS_SYSV_sethostid		(SYS_SYSV + 104)
#define SYS_SYSV_setsockopt		(SYS_SYSV + 105)
#define SYS_SYSV_shutdown		(SYS_SYSV + 106)
#define SYS_SYSV_socket			(SYS_SYSV + 107)
#define SYS_SYSV_gethostname		(SYS_SYSV + 108)
#define SYS_SYSV_sethostname		(SYS_SYSV + 109)
#define SYS_SYSV_getdomainname		(SYS_SYSV + 110)
#define SYS_SYSV_setdomainname		(SYS_SYSV + 111)
#define SYS_SYSV_truncate		(SYS_SYSV + 112)
#define SYS_SYSV_ftruncate		(SYS_SYSV + 113)
#define SYS_SYSV_rename			(SYS_SYSV + 114)
#define SYS_SYSV_symlink		(SYS_SYSV + 115)
#define SYS_SYSV_readlink		(SYS_SYSV + 116)
#define SYS_SYSV_lstat			(SYS_SYSV + 117)
#define SYS_SYSV_nfsmount		(SYS_SYSV + 118)
#define SYS_SYSV_nfssvc			(SYS_SYSV + 119)
#define SYS_SYSV_getfh			(SYS_SYSV + 120)
#define SYS_SYSV_async_daemon		(SYS_SYSV + 121)
#define SYS_SYSV_exportfs		(SYS_SYSV + 122)
#define SYS_SYSV_setregid		(SYS_SYSV + 123)
#define SYS_SYSV_setreuid		(SYS_SYSV + 124)
#define SYS_SYSV_getitimer		(SYS_SYSV + 125)
#define SYS_SYSV_setitimer		(SYS_SYSV + 126)
#define SYS_SYSV_adjtime		(SYS_SYSV + 127)
#define SYS_SYSV_BSD_getime		(SYS_SYSV + 128)
#define SYS_SYSV_sproc			(SYS_SYSV + 129)
#define SYS_SYSV_prctl			(SYS_SYSV + 130)
#define SYS_SYSV_procblk		(SYS_SYSV + 131)
#define SYS_SYSV_sprocsp		(SYS_SYSV + 132)
#define SYS_SYSV_sgigsc			(SYS_SYSV + 133)
#define SYS_SYSV_mmap			(SYS_SYSV + 134)
#define SYS_SYSV_munmap			(SYS_SYSV + 135)
#define SYS_SYSV_mprotect		(SYS_SYSV + 136)
#define SYS_SYSV_msync			(SYS_SYSV + 137)
#define SYS_SYSV_madvise		(SYS_SYSV + 138)
#define SYS_SYSV_pagelock		(SYS_SYSV + 139)
#define SYS_SYSV_getpagesize		(SYS_SYSV + 140)
#define SYS_SYSV_quotactl		(SYS_SYSV + 141)
#define SYS_SYSV_libdetach		(SYS_SYSV + 142)
#define SYS_SYSV_BSDgetpgrp		(SYS_SYSV + 143)
#define SYS_SYSV_BSDsetpgrp		(SYS_SYSV + 144)
#define SYS_SYSV_vhangup		(SYS_SYSV + 145)
#define SYS_SYSV_fsync			(SYS_SYSV + 146)
#define SYS_SYSV_fchdir			(SYS_SYSV + 147)
#define SYS_SYSV_getrlimit		(SYS_SYSV + 148)
#define SYS_SYSV_setrlimit		(SYS_SYSV + 149)
#define SYS_SYSV_cacheflush		(SYS_SYSV + 150)
#define SYS_SYSV_cachectl		(SYS_SYSV + 151)
#define SYS_SYSV_fchown			(SYS_SYSV + 152)
#define SYS_SYSV_fchmod			(SYS_SYSV + 153)
#define SYS_SYSV_wait3			(SYS_SYSV + 154)
#define SYS_SYSV_socketpair		(SYS_SYSV + 155)
#define SYS_SYSV_sysinfo		(SYS_SYSV + 156)
#define SYS_SYSV_nuname			(SYS_SYSV + 157)
#define SYS_SYSV_xstat			(SYS_SYSV + 158)
#define SYS_SYSV_lxstat			(SYS_SYSV + 159)
#define SYS_SYSV_fxstat			(SYS_SYSV + 160)
#define SYS_SYSV_xmknod			(SYS_SYSV + 161)
#define SYS_SYSV_ksigaction		(SYS_SYSV + 162)
#define SYS_SYSV_sigpending		(SYS_SYSV + 163)
#define SYS_SYSV_sigprocmask		(SYS_SYSV + 164)
#define SYS_SYSV_sigsuspend		(SYS_SYSV + 165)
#define SYS_SYSV_sigpoll		(SYS_SYSV + 166)
#define SYS_SYSV_swapctl		(SYS_SYSV + 167)
#define SYS_SYSV_getcontext		(SYS_SYSV + 168)
#define SYS_SYSV_setcontext		(SYS_SYSV + 169)
#define SYS_SYSV_waitsys		(SYS_SYSV + 170)
#define SYS_SYSV_sigstack		(SYS_SYSV + 171)
#define SYS_SYSV_sigaltstack		(SYS_SYSV + 172)
#define SYS_SYSV_sigsendset		(SYS_SYSV + 173)
#define SYS_SYSV_statvfs		(SYS_SYSV + 174)
#define SYS_SYSV_fstatvfs		(SYS_SYSV + 175)
#define SYS_SYSV_getpmsg		(SYS_SYSV + 176)
#define SYS_SYSV_putpmsg		(SYS_SYSV + 177)
#define SYS_SYSV_lchown			(SYS_SYSV + 178)
#define SYS_SYSV_priocntl		(SYS_SYSV + 179)
#define SYS_SYSV_ksigqueue		(SYS_SYSV + 180)
#define SYS_SYSV_readv			(SYS_SYSV + 181)
#define SYS_SYSV_writev			(SYS_SYSV + 182)
#define SYS_SYSV_truncate64		(SYS_SYSV + 183)
#define SYS_SYSV_ftruncate64		(SYS_SYSV + 184)
#define SYS_SYSV_mmap64			(SYS_SYSV + 185)
#define SYS_SYSV_dmi			(SYS_SYSV + 186)
#define SYS_SYSV_pread			(SYS_SYSV + 187)
#define SYS_SYSV_pwrite			(SYS_SYSV + 188)

/*
 * BSD 4.3 syscalls are in the range from 2000 to 2999
 */
#define SYS_BSD43			2000
#define SYS_BSD43_syscall		(SYS_BSD43 +   0)
#define SYS_BSD43_exit			(SYS_BSD43 +   1)
#define SYS_BSD43_fork			(SYS_BSD43 +   2)
#define SYS_BSD43_read			(SYS_BSD43 +   3)
#define SYS_BSD43_write			(SYS_BSD43 +   4)
#define SYS_BSD43_open			(SYS_BSD43 +   5)
#define SYS_BSD43_close			(SYS_BSD43 +   6)
#define SYS_BSD43_wait			(SYS_BSD43 +   7)
#define SYS_BSD43_creat			(SYS_BSD43 +   8)
#define SYS_BSD43_link			(SYS_BSD43 +   9)
#define SYS_BSD43_unlink		(SYS_BSD43 +  10)
#define SYS_BSD43_exec			(SYS_BSD43 +  11)
#define SYS_BSD43_chdir			(SYS_BSD43 +  12)
#define SYS_BSD43_time			(SYS_BSD43 +  13)
#define SYS_BSD43_mknod			(SYS_BSD43 +  14)
#define SYS_BSD43_chmod			(SYS_BSD43 +  15)
#define SYS_BSD43_chown			(SYS_BSD43 +  16)
#define SYS_BSD43_sbreak		(SYS_BSD43 +  17)
#define SYS_BSD43_oldstat		(SYS_BSD43 +  18)
#define SYS_BSD43_lseek			(SYS_BSD43 +  19)
#define SYS_BSD43_getpid		(SYS_BSD43 +  20)
#define SYS_BSD43_oldmount		(SYS_BSD43 +  21)
#define SYS_BSD43_umount		(SYS_BSD43 +  22)
#define SYS_BSD43_setuid		(SYS_BSD43 +  23)
#define SYS_BSD43_getuid		(SYS_BSD43 +  24)
#define SYS_BSD43_stime			(SYS_BSD43 +  25)
#define SYS_BSD43_ptrace		(SYS_BSD43 +  26)
#define SYS_BSD43_alarm			(SYS_BSD43 +  27)
#define SYS_BSD43_oldfstat		(SYS_BSD43 +  28)
#define SYS_BSD43_pause			(SYS_BSD43 +  29)
#define SYS_BSD43_utime			(SYS_BSD43 +  30)
#define SYS_BSD43_stty			(SYS_BSD43 +  31)
#define SYS_BSD43_gtty			(SYS_BSD43 +  32)
#define SYS_BSD43_access		(SYS_BSD43 +  33)
#define SYS_BSD43_nice			(SYS_BSD43 +  34)
#define SYS_BSD43_ftime			(SYS_BSD43 +  35)
#define SYS_BSD43_sync			(SYS_BSD43 +  36)
#define SYS_BSD43_kill			(SYS_BSD43 +  37)
#define SYS_BSD43_stat			(SYS_BSD43 +  38)
#define SYS_BSD43_oldsetpgrp		(SYS_BSD43 +  39)
#define SYS_BSD43_lstat			(SYS_BSD43 +  40)
#define SYS_BSD43_dup			(SYS_BSD43 +  41)
#define SYS_BSD43_pipe			(SYS_BSD43 +  42)
#define SYS_BSD43_times			(SYS_BSD43 +  43)
#define SYS_BSD43_profil		(SYS_BSD43 +  44)
#define SYS_BSD43_msgsys		(SYS_BSD43 +  45)
#define SYS_BSD43_setgid		(SYS_BSD43 +  46)
#define SYS_BSD43_getgid		(SYS_BSD43 +  47)
#define SYS_BSD43_ssig			(SYS_BSD43 +  48)
#define SYS_BSD43_reserved1		(SYS_BSD43 +  49)
#define SYS_BSD43_reserved2		(SYS_BSD43 +  50)
#define SYS_BSD43_sysacct		(SYS_BSD43 +  51)
#define SYS_BSD43_phys			(SYS_BSD43 +  52)
#define SYS_BSD43_lock			(SYS_BSD43 +  53)
#define SYS_BSD43_ioctl			(SYS_BSD43 +  54)
#define SYS_BSD43_reboot		(SYS_BSD43 +  55)
#define SYS_BSD43_mpxchan		(SYS_BSD43 +  56)
#define SYS_BSD43_symlink		(SYS_BSD43 +  57)
#define SYS_BSD43_readlink		(SYS_BSD43 +  58)
#define SYS_BSD43_execve		(SYS_BSD43 +  59)
#define SYS_BSD43_umask			(SYS_BSD43 +  60)
#define SYS_BSD43_chroot		(SYS_BSD43 +  61)
#define SYS_BSD43_fstat			(SYS_BSD43 +  62)
#define SYS_BSD43_reserved3		(SYS_BSD43 +  63)
#define SYS_BSD43_getpagesize		(SYS_BSD43 +  64)
#define SYS_BSD43_mremap		(SYS_BSD43 +  65)
#define SYS_BSD43_vfork			(SYS_BSD43 +  66)
#define SYS_BSD43_vread			(SYS_BSD43 +  67)
#define SYS_BSD43_vwrite		(SYS_BSD43 +  68)
#define SYS_BSD43_sbrk			(SYS_BSD43 +  69)
#define SYS_BSD43_sstk			(SYS_BSD43 +  70)
#define SYS_BSD43_mmap			(SYS_BSD43 +  71)
#define SYS_BSD43_vadvise		(SYS_BSD43 +  72)
#define SYS_BSD43_munmap		(SYS_BSD43 +  73)
#define SYS_BSD43_mprotect		(SYS_BSD43 +  74)
#define SYS_BSD43_madvise		(SYS_BSD43 +  75)
#define SYS_BSD43_vhangup		(SYS_BSD43 +  76)
#define SYS_BSD43_vlimit		(SYS_BSD43 +  77)
#define SYS_BSD43_mincore		(SYS_BSD43 +  78)
#define SYS_BSD43_getgroups		(SYS_BSD43 +  79)
#define SYS_BSD43_setgroups		(SYS_BSD43 +  80)
#define SYS_BSD43_getpgrp		(SYS_BSD43 +  81)
#define SYS_BSD43_setpgrp		(SYS_BSD43 +  82)
#define SYS_BSD43_setitimer		(SYS_BSD43 +  83)
#define SYS_BSD43_wait3			(SYS_BSD43 +  84)
#define SYS_BSD43_swapon		(SYS_BSD43 +  85)
#define SYS_BSD43_getitimer		(SYS_BSD43 +  86)
#define SYS_BSD43_gethostname		(SYS_BSD43 +  87)
#define SYS_BSD43_sethostname		(SYS_BSD43 +  88)
#define SYS_BSD43_getdtablesize		(SYS_BSD43 +  89)
#define SYS_BSD43_dup2			(SYS_BSD43 +  90)
#define SYS_BSD43_getdopt		(SYS_BSD43 +  91)
#define SYS_BSD43_fcntl			(SYS_BSD43 +  92)
#define SYS_BSD43_select		(SYS_BSD43 +  93)
#define SYS_BSD43_setdopt		(SYS_BSD43 +  94)
#define SYS_BSD43_fsync			(SYS_BSD43 +  95)
#define SYS_BSD43_setpriority		(SYS_BSD43 +  96)
#define SYS_BSD43_socket		(SYS_BSD43 +  97)
#define SYS_BSD43_connect		(SYS_BSD43 +  98)
#define SYS_BSD43_oldaccept		(SYS_BSD43 +  99)
#define SYS_BSD43_getpriority		(SYS_BSD43 + 100)
#define SYS_BSD43_send			(SYS_BSD43 + 101)
#define SYS_BSD43_recv			(SYS_BSD43 + 102)
#define SYS_BSD43_sigreturn		(SYS_BSD43 + 103)
#define SYS_BSD43_bind			(SYS_BSD43 + 104)
#define SYS_BSD43_setsockopt		(SYS_BSD43 + 105)
#define SYS_BSD43_listen		(SYS_BSD43 + 106)
#define SYS_BSD43_vtimes		(SYS_BSD43 + 107)
#define SYS_BSD43_sigvec		(SYS_BSD43 + 108)
#define SYS_BSD43_sigblock		(SYS_BSD43 + 109)
#define SYS_BSD43_sigsetmask		(SYS_BSD43 + 110)
#define SYS_BSD43_sigpause		(SYS_BSD43 + 111)
#define SYS_BSD43_sigstack		(SYS_BSD43 + 112)
#define SYS_BSD43_oldrecvmsg		(SYS_BSD43 + 113)
#define SYS_BSD43_oldsendmsg		(SYS_BSD43 + 114)
#define SYS_BSD43_vtrace		(SYS_BSD43 + 115)
#define SYS_BSD43_gettimeofday		(SYS_BSD43 + 116)
#define SYS_BSD43_getrusage		(SYS_BSD43 + 117)
#define SYS_BSD43_getsockopt		(SYS_BSD43 + 118)
#define SYS_BSD43_reserved4		(SYS_BSD43 + 119)
#define SYS_BSD43_readv			(SYS_BSD43 + 120)
#define SYS_BSD43_writev		(SYS_BSD43 + 121)
#define SYS_BSD43_settimeofday		(SYS_BSD43 + 122)
#define SYS_BSD43_fchown		(SYS_BSD43 + 123)
#define SYS_BSD43_fchmod		(SYS_BSD43 + 124)
#define SYS_BSD43_oldrecvfrom		(SYS_BSD43 + 125)
#define SYS_BSD43_setreuid		(SYS_BSD43 + 126)
#define SYS_BSD43_setregid		(SYS_BSD43 + 127)
#define SYS_BSD43_rename		(SYS_BSD43 + 128)
#define SYS_BSD43_truncate		(SYS_BSD43 + 129)
#define SYS_BSD43_ftruncate		(SYS_BSD43 + 130)
#define SYS_BSD43_flock			(SYS_BSD43 + 131)
#define SYS_BSD43_semsys		(SYS_BSD43 + 132)
#define SYS_BSD43_sendto		(SYS_BSD43 + 133)
#define SYS_BSD43_shutdown		(SYS_BSD43 + 134)
#define SYS_BSD43_socketpair		(SYS_BSD43 + 135)
#define SYS_BSD43_mkdir			(SYS_BSD43 + 136)
#define SYS_BSD43_rmdir			(SYS_BSD43 + 137)
#define SYS_BSD43_utimes		(SYS_BSD43 + 138)
#define SYS_BSD43_sigcleanup		(SYS_BSD43 + 139)
#define SYS_BSD43_adjtime		(SYS_BSD43 + 140)
#define SYS_BSD43_oldgetpeername	(SYS_BSD43 + 141)
#define SYS_BSD43_gethostid		(SYS_BSD43 + 142)
#define SYS_BSD43_sethostid		(SYS_BSD43 + 143)
#define SYS_BSD43_getrlimit		(SYS_BSD43 + 144)
#define SYS_BSD43_setrlimit		(SYS_BSD43 + 145)
#define SYS_BSD43_killpg		(SYS_BSD43 + 146)
#define SYS_BSD43_shmsys		(SYS_BSD43 + 147)
#define SYS_BSD43_quota			(SYS_BSD43 + 148)
#define SYS_BSD43_qquota		(SYS_BSD43 + 149)
#define SYS_BSD43_oldgetsockname	(SYS_BSD43 + 150)
#define SYS_BSD43_sysmips		(SYS_BSD43 + 151)
#define SYS_BSD43_cacheflush		(SYS_BSD43 + 152)
#define SYS_BSD43_cachectl		(SYS_BSD43 + 153)
#define SYS_BSD43_debug			(SYS_BSD43 + 154)
#define SYS_BSD43_reserved5		(SYS_BSD43 + 155)
#define SYS_BSD43_reserved6		(SYS_BSD43 + 156)
#define SYS_BSD43_nfs_mount		(SYS_BSD43 + 157)
#define SYS_BSD43_nfs_svc		(SYS_BSD43 + 158)
#define SYS_BSD43_getdirentries		(SYS_BSD43 + 159)
#define SYS_BSD43_statfs		(SYS_BSD43 + 160)
#define SYS_BSD43_fstatfs		(SYS_BSD43 + 161)
#define SYS_BSD43_unmount		(SYS_BSD43 + 162)
#define SYS_BSD43_async_daemon		(SYS_BSD43 + 163)
#define SYS_BSD43_nfs_getfh		(SYS_BSD43 + 164)
#define SYS_BSD43_getdomainname		(SYS_BSD43 + 165)
#define SYS_BSD43_setdomainname		(SYS_BSD43 + 166)
#define SYS_BSD43_pcfs_mount		(SYS_BSD43 + 167)
#define SYS_BSD43_quotactl		(SYS_BSD43 + 168)
#define SYS_BSD43_oldexportfs		(SYS_BSD43 + 169)
#define SYS_BSD43_smount		(SYS_BSD43 + 170)
#define SYS_BSD43_mipshwconf		(SYS_BSD43 + 171)
#define SYS_BSD43_exportfs		(SYS_BSD43 + 172)
#define SYS_BSD43_nfsfh_open		(SYS_BSD43 + 173)
#define SYS_BSD43_libattach		(SYS_BSD43 + 174)
#define SYS_BSD43_libdetach		(SYS_BSD43 + 175)
#define SYS_BSD43_accept		(SYS_BSD43 + 176)
#define SYS_BSD43_reserved7		(SYS_BSD43 + 177)
#define SYS_BSD43_reserved8		(SYS_BSD43 + 178)
#define SYS_BSD43_recvmsg		(SYS_BSD43 + 179)
#define SYS_BSD43_recvfrom		(SYS_BSD43 + 180)
#define SYS_BSD43_sendmsg		(SYS_BSD43 + 181)
#define SYS_BSD43_getpeername		(SYS_BSD43 + 182)
#define SYS_BSD43_getsockname		(SYS_BSD43 + 183)
#define SYS_BSD43_aread			(SYS_BSD43 + 184)
#define SYS_BSD43_awrite		(SYS_BSD43 + 185)
#define SYS_BSD43_listio		(SYS_BSD43 + 186)
#define SYS_BSD43_acancel		(SYS_BSD43 + 187)
#define SYS_BSD43_astatus		(SYS_BSD43 + 188)
#define SYS_BSD43_await			(SYS_BSD43 + 189)
#define SYS_BSD43_areadv		(SYS_BSD43 + 190)
#define SYS_BSD43_awritev		(SYS_BSD43 + 191)

/*
 * POSIX syscalls are in the range from 3000 to 3999
 */
#define SYS_POSIX			3000
#define SYS_POSIX_syscall		(SYS_POSIX +   0)
#define SYS_POSIX_exit			(SYS_POSIX +   1)
#define SYS_POSIX_fork			(SYS_POSIX +   2)
#define SYS_POSIX_read			(SYS_POSIX +   3)
#define SYS_POSIX_write			(SYS_POSIX +   4)
#define SYS_POSIX_open			(SYS_POSIX +   5)
#define SYS_POSIX_close			(SYS_POSIX +   6)
#define SYS_POSIX_wait			(SYS_POSIX +   7)
#define SYS_POSIX_creat			(SYS_POSIX +   8)
#define SYS_POSIX_link			(SYS_POSIX +   9)
#define SYS_POSIX_unlink		(SYS_POSIX +  10)
#define SYS_POSIX_exec			(SYS_POSIX +  11)
#define SYS_POSIX_chdir			(SYS_POSIX +  12)
#define SYS_POSIX_gtime			(SYS_POSIX +  13)
#define SYS_POSIX_mknod			(SYS_POSIX +  14)
#define SYS_POSIX_chmod			(SYS_POSIX +  15)
#define SYS_POSIX_chown			(SYS_POSIX +  16)
#define SYS_POSIX_sbreak		(SYS_POSIX +  17)
#define SYS_POSIX_stat			(SYS_POSIX +  18)
#define SYS_POSIX_lseek			(SYS_POSIX +  19)
#define SYS_POSIX_getpid		(SYS_POSIX +  20)
#define SYS_POSIX_mount			(SYS_POSIX +  21)
#define SYS_POSIX_umount		(SYS_POSIX +  22)
#define SYS_POSIX_setuid		(SYS_POSIX +  23)
#define SYS_POSIX_getuid		(SYS_POSIX +  24)
#define SYS_POSIX_stime			(SYS_POSIX +  25)
#define SYS_POSIX_ptrace		(SYS_POSIX +  26)
#define SYS_POSIX_alarm			(SYS_POSIX +  27)
#define SYS_POSIX_fstat			(SYS_POSIX +  28)
#define SYS_POSIX_pause			(SYS_POSIX +  29)
#define SYS_POSIX_utime			(SYS_POSIX +  30)
#define SYS_POSIX_stty			(SYS_POSIX +  31)
#define SYS_POSIX_gtty			(SYS_POSIX +  32)
#define SYS_POSIX_access		(SYS_POSIX +  33)
#define SYS_POSIX_nice			(SYS_POSIX +  34)
#define SYS_POSIX_statfs		(SYS_POSIX +  35)
#define SYS_POSIX_sync			(SYS_POSIX +  36)
#define SYS_POSIX_kill			(SYS_POSIX +  37)
#define SYS_POSIX_fstatfs		(SYS_POSIX +  38)
#define SYS_POSIX_getpgrp		(SYS_POSIX +  39)
#define SYS_POSIX_syssgi		(SYS_POSIX +  40)
#define SYS_POSIX_dup			(SYS_POSIX +  41)
#define SYS_POSIX_pipe			(SYS_POSIX +  42)
#define SYS_POSIX_times			(SYS_POSIX +  43)
#define SYS_POSIX_profil		(SYS_POSIX +  44)
#define SYS_POSIX_lock			(SYS_POSIX +  45)
#define SYS_POSIX_setgid		(SYS_POSIX +  46)
#define SYS_POSIX_getgid		(SYS_POSIX +  47)
#define SYS_POSIX_sig			(SYS_POSIX +  48)
#define SYS_POSIX_msgsys		(SYS_POSIX +  49)
#define SYS_POSIX_sysmips		(SYS_POSIX +  50)
#define SYS_POSIX_sysacct		(SYS_POSIX +  51)
#define SYS_POSIX_shmsys		(SYS_POSIX +  52)
#define SYS_POSIX_semsys		(SYS_POSIX +  53)
#define SYS_POSIX_ioctl			(SYS_POSIX +  54)
#define SYS_POSIX_uadmin		(SYS_POSIX +  55)
#define SYS_POSIX_exch			(SYS_POSIX +  56)
#define SYS_POSIX_utssys		(SYS_POSIX +  57)
#define SYS_POSIX_USG_reserved1		(SYS_POSIX +  58)
#define SYS_POSIX_exece			(SYS_POSIX +  59)
#define SYS_POSIX_umask			(SYS_POSIX +  60)
#define SYS_POSIX_chroot		(SYS_POSIX +  61)
#define SYS_POSIX_fcntl			(SYS_POSIX +  62)
#define SYS_POSIX_ulimit		(SYS_POSIX +  63)
#define SYS_POSIX_SAFARI4_reserved1	(SYS_POSIX +  64)
#define SYS_POSIX_SAFARI4_reserved2	(SYS_POSIX +  65)
#define SYS_POSIX_SAFARI4_reserved3	(SYS_POSIX +  66)
#define SYS_POSIX_SAFARI4_reserved4	(SYS_POSIX +  67)
#define SYS_POSIX_SAFARI4_reserved5	(SYS_POSIX +  68)
#define SYS_POSIX_SAFARI4_reserved6	(SYS_POSIX +  69)
#define SYS_POSIX_advfs			(SYS_POSIX +  70)
#define SYS_POSIX_unadvfs		(SYS_POSIX +  71)
#define SYS_POSIX_rmount		(SYS_POSIX +  72)
#define SYS_POSIX_rumount		(SYS_POSIX +  73)
#define SYS_POSIX_rfstart		(SYS_POSIX +  74)
#define SYS_POSIX_reserved1		(SYS_POSIX +  75)
#define SYS_POSIX_rdebug		(SYS_POSIX +  76)
#define SYS_POSIX_rfstop		(SYS_POSIX +  77)
#define SYS_POSIX_rfsys			(SYS_POSIX +  78)
#define SYS_POSIX_rmdir			(SYS_POSIX +  79)
#define SYS_POSIX_mkdir			(SYS_POSIX +  80)
#define SYS_POSIX_getdents		(SYS_POSIX +  81)
#define SYS_POSIX_sginap		(SYS_POSIX +  82)
#define SYS_POSIX_sgikopt		(SYS_POSIX +  83)
#define SYS_POSIX_sysfs			(SYS_POSIX +  84)
#define SYS_POSIX_getmsg		(SYS_POSIX +  85)
#define SYS_POSIX_putmsg		(SYS_POSIX +  86)
#define SYS_POSIX_poll			(SYS_POSIX +  87)
#define SYS_POSIX_sigreturn		(SYS_POSIX +  88)
#define SYS_POSIX_accept		(SYS_POSIX +  89)
#define SYS_POSIX_bind			(SYS_POSIX +  90)
#define SYS_POSIX_connect		(SYS_POSIX +  91)
#define SYS_POSIX_gethostid		(SYS_POSIX +  92)
#define SYS_POSIX_getpeername		(SYS_POSIX +  93)
#define SYS_POSIX_getsockname		(SYS_POSIX +  94)
#define SYS_POSIX_getsockopt		(SYS_POSIX +  95)
#define SYS_POSIX_listen		(SYS_POSIX +  96)
#define SYS_POSIX_recv			(SYS_POSIX +  97)
#define SYS_POSIX_recvfrom		(SYS_POSIX +  98)
#define SYS_POSIX_recvmsg		(SYS_POSIX +  99)
#define SYS_POSIX_select		(SYS_POSIX + 100)
#define SYS_POSIX_send			(SYS_POSIX + 101)
#define SYS_POSIX_sendmsg		(SYS_POSIX + 102)
#define SYS_POSIX_sendto		(SYS_POSIX + 103)
#define SYS_POSIX_sethostid		(SYS_POSIX + 104)
#define SYS_POSIX_setsockopt		(SYS_POSIX + 105)
#define SYS_POSIX_shutdown		(SYS_POSIX + 106)
#define SYS_POSIX_socket		(SYS_POSIX + 107)
#define SYS_POSIX_gethostname		(SYS_POSIX + 108)
#define SYS_POSIX_sethostname		(SYS_POSIX + 109)
#define SYS_POSIX_getdomainname		(SYS_POSIX + 110)
#define SYS_POSIX_setdomainname		(SYS_POSIX + 111)
#define SYS_POSIX_truncate		(SYS_POSIX + 112)
#define SYS_POSIX_ftruncate		(SYS_POSIX + 113)
#define SYS_POSIX_rename		(SYS_POSIX + 114)
#define SYS_POSIX_symlink		(SYS_POSIX + 115)
#define SYS_POSIX_readlink		(SYS_POSIX + 116)
#define SYS_POSIX_lstat			(SYS_POSIX + 117)
#define SYS_POSIX_nfs_mount		(SYS_POSIX + 118)
#define SYS_POSIX_nfs_svc		(SYS_POSIX + 119)
#define SYS_POSIX_nfs_getfh		(SYS_POSIX + 120)
#define SYS_POSIX_async_daemon		(SYS_POSIX + 121)
#define SYS_POSIX_exportfs		(SYS_POSIX + 122)
#define SYS_POSIX_SGI_setregid		(SYS_POSIX + 123)
#define SYS_POSIX_SGI_setreuid		(SYS_POSIX + 124)
#define SYS_POSIX_getitimer		(SYS_POSIX + 125)
#define SYS_POSIX_setitimer		(SYS_POSIX + 126)
#define SYS_POSIX_adjtime		(SYS_POSIX + 127)
#define SYS_POSIX_SGI_bsdgettime	(SYS_POSIX + 128)
#define SYS_POSIX_SGI_sproc		(SYS_POSIX + 129)
#define SYS_POSIX_SGI_prctl		(SYS_POSIX + 130)
#define SYS_POSIX_SGI_blkproc		(SYS_POSIX + 131)
#define SYS_POSIX_SGI_reserved1		(SYS_POSIX + 132)
#define SYS_POSIX_SGI_sgigsc		(SYS_POSIX + 133)
#define SYS_POSIX_SGI_mmap		(SYS_POSIX + 134)
#define SYS_POSIX_SGI_munmap		(SYS_POSIX + 135)
#define SYS_POSIX_SGI_mprotect		(SYS_POSIX + 136)
#define SYS_POSIX_SGI_msync		(SYS_POSIX + 137)
#define SYS_POSIX_SGI_madvise		(SYS_POSIX + 138)
#define SYS_POSIX_SGI_mpin		(SYS_POSIX + 139)
#define SYS_POSIX_SGI_getpagesize	(SYS_POSIX + 140)
#define SYS_POSIX_SGI_libattach		(SYS_POSIX + 141)
#define SYS_POSIX_SGI_libdetach		(SYS_POSIX + 142)
#define SYS_POSIX_SGI_getpgrp		(SYS_POSIX + 143)
#define SYS_POSIX_SGI_setpgrp		(SYS_POSIX + 144)
#define SYS_POSIX_SGI_reserved2		(SYS_POSIX + 145)
#define SYS_POSIX_SGI_reserved3		(SYS_POSIX + 146)
#define SYS_POSIX_SGI_reserved4		(SYS_POSIX + 147)
#define SYS_POSIX_SGI_reserved5		(SYS_POSIX + 148)
#define SYS_POSIX_SGI_reserved6		(SYS_POSIX + 149)
#define SYS_POSIX_cacheflush		(SYS_POSIX + 150)
#define SYS_POSIX_cachectl		(SYS_POSIX + 151)
#define SYS_POSIX_fchown		(SYS_POSIX + 152)
#define SYS_POSIX_fchmod		(SYS_POSIX + 153)
#define SYS_POSIX_wait3			(SYS_POSIX + 154)
#define SYS_POSIX_mmap			(SYS_POSIX + 155)
#define SYS_POSIX_munmap		(SYS_POSIX + 156)
#define SYS_POSIX_madvise		(SYS_POSIX + 157)
#define SYS_POSIX_BSD_getpagesize	(SYS_POSIX + 158)
#define SYS_POSIX_setreuid		(SYS_POSIX + 159)
#define SYS_POSIX_setregid		(SYS_POSIX + 160)
#define SYS_POSIX_setpgid		(SYS_POSIX + 161)
#define SYS_POSIX_getgroups		(SYS_POSIX + 162)
#define SYS_POSIX_setgroups		(SYS_POSIX + 163)
#define SYS_POSIX_gettimeofday		(SYS_POSIX + 164)
#define SYS_POSIX_getrusage		(SYS_POSIX + 165)
#define SYS_POSIX_getrlimit		(SYS_POSIX + 166)
#define SYS_POSIX_setrlimit		(SYS_POSIX + 167)
#define SYS_POSIX_waitpid		(SYS_POSIX + 168)
#define SYS_POSIX_dup2			(SYS_POSIX + 169)
#define SYS_POSIX_reserved2		(SYS_POSIX + 170)
#define SYS_POSIX_reserved3		(SYS_POSIX + 171)
#define SYS_POSIX_reserved4		(SYS_POSIX + 172)
#define SYS_POSIX_reserved5		(SYS_POSIX + 173)
#define SYS_POSIX_reserved6		(SYS_POSIX + 174)
#define SYS_POSIX_reserved7		(SYS_POSIX + 175)
#define SYS_POSIX_reserved8		(SYS_POSIX + 176)
#define SYS_POSIX_reserved9		(SYS_POSIX + 177)
#define SYS_POSIX_reserved10		(SYS_POSIX + 178)
#define SYS_POSIX_reserved11		(SYS_POSIX + 179)
#define SYS_POSIX_reserved12		(SYS_POSIX + 180)
#define SYS_POSIX_reserved13		(SYS_POSIX + 181)
#define SYS_POSIX_reserved14		(SYS_POSIX + 182)
#define SYS_POSIX_reserved15		(SYS_POSIX + 183)
#define SYS_POSIX_reserved16		(SYS_POSIX + 184)
#define SYS_POSIX_reserved17		(SYS_POSIX + 185)
#define SYS_POSIX_reserved18		(SYS_POSIX + 186)
#define SYS_POSIX_reserved19		(SYS_POSIX + 187)
#define SYS_POSIX_reserved20		(SYS_POSIX + 188)
#define SYS_POSIX_reserved21		(SYS_POSIX + 189)
#define SYS_POSIX_reserved22		(SYS_POSIX + 190)
#define SYS_POSIX_reserved23		(SYS_POSIX + 191)
#define SYS_POSIX_reserved24		(SYS_POSIX + 192)
#define SYS_POSIX_reserved25		(SYS_POSIX + 193)
#define SYS_POSIX_reserved26		(SYS_POSIX + 194)
#define SYS_POSIX_reserved27		(SYS_POSIX + 195)
#define SYS_POSIX_reserved28		(SYS_POSIX + 196)
#define SYS_POSIX_reserved29		(SYS_POSIX + 197)
#define SYS_POSIX_reserved30		(SYS_POSIX + 198)
#define SYS_POSIX_reserved31		(SYS_POSIX + 199)
#define SYS_POSIX_reserved32		(SYS_POSIX + 200)
#define SYS_POSIX_reserved33		(SYS_POSIX + 201)
#define SYS_POSIX_reserved34		(SYS_POSIX + 202)
#define SYS_POSIX_reserved35		(SYS_POSIX + 203)
#define SYS_POSIX_reserved36		(SYS_POSIX + 204)
#define SYS_POSIX_reserved37		(SYS_POSIX + 205)
#define SYS_POSIX_reserved38		(SYS_POSIX + 206)
#define SYS_POSIX_reserved39		(SYS_POSIX + 207)
#define SYS_POSIX_reserved40		(SYS_POSIX + 208)
#define SYS_POSIX_reserved41		(SYS_POSIX + 209)
#define SYS_POSIX_reserved42		(SYS_POSIX + 210)
#define SYS_POSIX_reserved43		(SYS_POSIX + 211)
#define SYS_POSIX_reserved44		(SYS_POSIX + 212)
#define SYS_POSIX_reserved45		(SYS_POSIX + 213)
#define SYS_POSIX_reserved46		(SYS_POSIX + 214)
#define SYS_POSIX_reserved47		(SYS_POSIX + 215)
#define SYS_POSIX_reserved48		(SYS_POSIX + 216)
#define SYS_POSIX_reserved49		(SYS_POSIX + 217)
#define SYS_POSIX_reserved50		(SYS_POSIX + 218)
#define SYS_POSIX_reserved51		(SYS_POSIX + 219)
#define SYS_POSIX_reserved52		(SYS_POSIX + 220)
#define SYS_POSIX_reserved53		(SYS_POSIX + 221)
#define SYS_POSIX_reserved54		(SYS_POSIX + 222)
#define SYS_POSIX_reserved55		(SYS_POSIX + 223)
#define SYS_POSIX_reserved56		(SYS_POSIX + 224)
#define SYS_POSIX_reserved57		(SYS_POSIX + 225)
#define SYS_POSIX_reserved58		(SYS_POSIX + 226)
#define SYS_POSIX_reserved59		(SYS_POSIX + 227)
#define SYS_POSIX_reserved60		(SYS_POSIX + 228)
#define SYS_POSIX_reserved61		(SYS_POSIX + 229)
#define SYS_POSIX_reserved62		(SYS_POSIX + 230)
#define SYS_POSIX_reserved63		(SYS_POSIX + 231)
#define SYS_POSIX_reserved64		(SYS_POSIX + 232)
#define SYS_POSIX_reserved65		(SYS_POSIX + 233)
#define SYS_POSIX_reserved66		(SYS_POSIX + 234)
#define SYS_POSIX_reserved67		(SYS_POSIX + 235)
#define SYS_POSIX_reserved68		(SYS_POSIX + 236)
#define SYS_POSIX_reserved69		(SYS_POSIX + 237)
#define SYS_POSIX_reserved70		(SYS_POSIX + 238)
#define SYS_POSIX_reserved71		(SYS_POSIX + 239)
#define SYS_POSIX_reserved72		(SYS_POSIX + 240)
#define SYS_POSIX_reserved73		(SYS_POSIX + 241)
#define SYS_POSIX_reserved74		(SYS_POSIX + 242)
#define SYS_POSIX_reserved75		(SYS_POSIX + 243)
#define SYS_POSIX_reserved76		(SYS_POSIX + 244)
#define SYS_POSIX_reserved77		(SYS_POSIX + 245)
#define SYS_POSIX_reserved78		(SYS_POSIX + 246)
#define SYS_POSIX_reserved79		(SYS_POSIX + 247)
#define SYS_POSIX_reserved80		(SYS_POSIX + 248)
#define SYS_POSIX_reserved81		(SYS_POSIX + 249)
#define SYS_POSIX_reserved82		(SYS_POSIX + 250)
#define SYS_POSIX_reserved83		(SYS_POSIX + 251)
#define SYS_POSIX_reserved84		(SYS_POSIX + 252)
#define SYS_POSIX_reserved85		(SYS_POSIX + 253)
#define SYS_POSIX_reserved86		(SYS_POSIX + 254)
#define SYS_POSIX_reserved87		(SYS_POSIX + 255)
#define SYS_POSIX_reserved88		(SYS_POSIX + 256)
#define SYS_POSIX_reserved89		(SYS_POSIX + 257)
#define SYS_POSIX_reserved90		(SYS_POSIX + 258)
#define SYS_POSIX_reserved91		(SYS_POSIX + 259)
#define SYS_POSIX_netboot		(SYS_POSIX + 260)
#define SYS_POSIX_netunboot		(SYS_POSIX + 261)
#define SYS_POSIX_rdump			(SYS_POSIX + 262)
#define SYS_POSIX_setsid		(SYS_POSIX + 263)
#define SYS_POSIX_getmaxsig		(SYS_POSIX + 264)
#define SYS_POSIX_sigpending		(SYS_POSIX + 265)
#define SYS_POSIX_sigprocmask		(SYS_POSIX + 266)
#define SYS_POSIX_sigsuspend		(SYS_POSIX + 267)
#define SYS_POSIX_sigaction		(SYS_POSIX + 268)
#define SYS_POSIX_MIPS_reserved1	(SYS_POSIX + 269)
#define SYS_POSIX_MIPS_reserved2	(SYS_POSIX + 270)
#define SYS_POSIX_MIPS_reserved3	(SYS_POSIX + 271)
#define SYS_POSIX_MIPS_reserved4	(SYS_POSIX + 272)
#define SYS_POSIX_MIPS_reserved5	(SYS_POSIX + 273)
#define SYS_POSIX_MIPS_reserved6	(SYS_POSIX + 274)
#define SYS_POSIX_MIPS_reserved7	(SYS_POSIX + 275)
#define SYS_POSIX_MIPS_reserved8	(SYS_POSIX + 276)
#define SYS_POSIX_MIPS_reserved9	(SYS_POSIX + 277)
#define SYS_POSIX_MIPS_reserved10	(SYS_POSIX + 278)
#define SYS_POSIX_MIPS_reserved11	(SYS_POSIX + 279)
#define SYS_POSIX_TANDEM_reserved1	(SYS_POSIX + 280)
#define SYS_POSIX_TANDEM_reserved2	(SYS_POSIX + 281)
#define SYS_POSIX_TANDEM_reserved3	(SYS_POSIX + 282)
#define SYS_POSIX_TANDEM_reserved4	(SYS_POSIX + 283)
#define SYS_POSIX_TANDEM_reserved5	(SYS_POSIX + 284)
#define SYS_POSIX_TANDEM_reserved6	(SYS_POSIX + 285)
#define SYS_POSIX_TANDEM_reserved7	(SYS_POSIX + 286)
#define SYS_POSIX_TANDEM_reserved8	(SYS_POSIX + 287)
#define SYS_POSIX_TANDEM_reserved9	(SYS_POSIX + 288)
#define SYS_POSIX_TANDEM_reserved10	(SYS_POSIX + 289)
#define SYS_POSIX_TANDEM_reserved11	(SYS_POSIX + 290)
#define SYS_POSIX_TANDEM_reserved12	(SYS_POSIX + 291)
#define SYS_POSIX_TANDEM_reserved13	(SYS_POSIX + 292)
#define SYS_POSIX_TANDEM_reserved14	(SYS_POSIX + 293)
#define SYS_POSIX_TANDEM_reserved15	(SYS_POSIX + 294)
#define SYS_POSIX_TANDEM_reserved16	(SYS_POSIX + 295)
#define SYS_POSIX_TANDEM_reserved17	(SYS_POSIX + 296)
#define SYS_POSIX_TANDEM_reserved18	(SYS_POSIX + 297)
#define SYS_POSIX_TANDEM_reserved19	(SYS_POSIX + 298)
#define SYS_POSIX_TANDEM_reserved20	(SYS_POSIX + 299)
#define SYS_POSIX_SGI_reserved7		(SYS_POSIX + 300)
#define SYS_POSIX_SGI_reserved8		(SYS_POSIX + 301)
#define SYS_POSIX_SGI_reserved9		(SYS_POSIX + 302)
#define SYS_POSIX_SGI_reserved10	(SYS_POSIX + 303)
#define SYS_POSIX_SGI_reserved11	(SYS_POSIX + 304)
#define SYS_POSIX_SGI_reserved12	(SYS_POSIX + 305)
#define SYS_POSIX_SGI_reserved13	(SYS_POSIX + 306)
#define SYS_POSIX_SGI_reserved14	(SYS_POSIX + 307)
#define SYS_POSIX_SGI_reserved15	(SYS_POSIX + 308)
#define SYS_POSIX_SGI_reserved16	(SYS_POSIX + 309)
#define SYS_POSIX_SGI_reserved17	(SYS_POSIX + 310)
#define SYS_POSIX_SGI_reserved18	(SYS_POSIX + 311)
#define SYS_POSIX_SGI_reserved19	(SYS_POSIX + 312)
#define SYS_POSIX_SGI_reserved20	(SYS_POSIX + 313)
#define SYS_POSIX_SGI_reserved21	(SYS_POSIX + 314)
#define SYS_POSIX_SGI_reserved22	(SYS_POSIX + 315)
#define SYS_POSIX_SGI_reserved23	(SYS_POSIX + 316)
#define SYS_POSIX_SGI_reserved24	(SYS_POSIX + 317)
#define SYS_POSIX_SGI_reserved25	(SYS_POSIX + 318)
#define SYS_POSIX_SGI_reserved26	(SYS_POSIX + 319)

/*
 * Linux syscalls are in the range from 4000 to 4999
 * Hopefully these syscall numbers are unused ...  If not everyone using
 * statically linked binaries is pretty <censored - the government>.  You've
 * been warned.
 */
#define SYS_Linux			4000
#define SYS_syscall			(SYS_Linux +   0)
#define SYS_exit			(SYS_Linux +   1)
#define SYS_fork			(SYS_Linux +   2)
#define SYS_read			(SYS_Linux +   3)
#define SYS_write			(SYS_Linux +   4)
#define SYS_open			(SYS_Linux +   5)
#define SYS_close			(SYS_Linux +   6)
#define SYS_waitpid			(SYS_Linux +   7)
#define SYS_creat			(SYS_Linux +   8)
#define SYS_link			(SYS_Linux +   9)
#define SYS_unlink			(SYS_Linux +  10)
#define SYS_execve			(SYS_Linux +  11)
#define SYS_chdir			(SYS_Linux +  12)
#define SYS_time			(SYS_Linux +  13)
#define SYS_mknod			(SYS_Linux +  14)
#define SYS_chmod			(SYS_Linux +  15)
#define SYS_chown			(SYS_Linux +  16)
#define SYS_break			(SYS_Linux +  17)
#define SYS_oldstat			(SYS_Linux +  18)
#define SYS_lseek			(SYS_Linux +  19)
#define SYS_getpid			(SYS_Linux +  20)
#define SYS_mount			(SYS_Linux +  21)
#define SYS_umount			(SYS_Linux +  22)
#define SYS_setuid			(SYS_Linux +  23)
#define SYS_getuid			(SYS_Linux +  24)
#define SYS_stime			(SYS_Linux +  25)
#define SYS_ptrace			(SYS_Linux +  26)
#define SYS_alarm			(SYS_Linux +  27)
#define SYS_oldfstat			(SYS_Linux +  28)
#define SYS_pause			(SYS_Linux +  29)
#define SYS_utime			(SYS_Linux +  30)
#define SYS_stty			(SYS_Linux +  31)
#define SYS_gtty			(SYS_Linux +  32)
#define SYS_access			(SYS_Linux +  33)
#define SYS_nice			(SYS_Linux +  34)
#define SYS_ftime			(SYS_Linux +  35)
#define SYS_sync			(SYS_Linux +  36)
#define SYS_kill			(SYS_Linux +  37)
#define SYS_rename			(SYS_Linux +  38)
#define SYS_mkdir			(SYS_Linux +  39)
#define SYS_rmdir			(SYS_Linux +  40)
#define SYS_dup				(SYS_Linux +  41)
#define SYS_pipe			(SYS_Linux +  42)
#define SYS_times			(SYS_Linux +  43)
#define SYS_prof			(SYS_Linux +  44)
#define SYS_brk				(SYS_Linux +  45)
#define SYS_setgid			(SYS_Linux +  46)
#define SYS_getgid			(SYS_Linux +  47)
#define SYS_signal			(SYS_Linux +  48)
#define SYS_geteuid			(SYS_Linux +  49)
#define SYS_getegid			(SYS_Linux +  50)
#define SYS_acct			(SYS_Linux +  51)
#define SYS_phys			(SYS_Linux +  52)
#define SYS_lock			(SYS_Linux +  53)
#define SYS_ioctl			(SYS_Linux +  54)
#define SYS_fcntl			(SYS_Linux +  55)
#define SYS_mpx				(SYS_Linux +  56)
#define SYS_setpgid			(SYS_Linux +  57)
#define SYS_ulimit			(SYS_Linux +  58)
#define SYS_oldolduname			(SYS_Linux +  59)
#define SYS_umask			(SYS_Linux +  60)
#define SYS_chroot			(SYS_Linux +  61)
#define SYS_ustat			(SYS_Linux +  62)
#define SYS_dup2			(SYS_Linux +  63)
#define SYS_getppid			(SYS_Linux +  64)
#define SYS_getpgrp			(SYS_Linux +  65)
#define SYS_setsid			(SYS_Linux +  66)
#define SYS_sigaction			(SYS_Linux +  67)
#define SYS_sgetmask			(SYS_Linux +  68)
#define SYS_ssetmask			(SYS_Linux +  69)
#define SYS_setreuid			(SYS_Linux +  70)
#define SYS_setregid			(SYS_Linux +  71)
#define SYS_sigsuspend			(SYS_Linux +  72)
#define SYS_sigpending			(SYS_Linux +  73)
#define SYS_sethostname			(SYS_Linux +  74)
#define SYS_setrlimit			(SYS_Linux +  75)
#define SYS_getrlimit			(SYS_Linux +  76)
#define SYS_getrusage			(SYS_Linux +  77)
#define SYS_gettimeofday		(SYS_Linux +  78)
#define SYS_settimeofday		(SYS_Linux +  79)
#define SYS_getgroups			(SYS_Linux +  80)
#define SYS_setgroups			(SYS_Linux +  81)
#define SYS_reserved82			(SYS_Linux +  82)
#define SYS_symlink			(SYS_Linux +  83)
#define SYS_oldlstat			(SYS_Linux +  84)
#define SYS_readlink			(SYS_Linux +  85)
#define SYS_uselib			(SYS_Linux +  86)
#define SYS_swapon			(SYS_Linux +  87)
#define SYS_reboot			(SYS_Linux +  88)
#define SYS_readdir			(SYS_Linux +  89)
#define SYS_mmap			(SYS_Linux +  90)
#define SYS_munmap			(SYS_Linux +  91)
#define SYS_truncate			(SYS_Linux +  92)
#define SYS_ftruncate			(SYS_Linux +  93)
#define SYS_fchmod			(SYS_Linux +  94)
#define SYS_fchown			(SYS_Linux +  95)
#define SYS_getpriority			(SYS_Linux +  96)
#define SYS_setpriority			(SYS_Linux +  97)
#define SYS_profil			(SYS_Linux +  98)
#define SYS_statfs			(SYS_Linux +  99)
#define SYS_fstatfs			(SYS_Linux + 100)
#define SYS_ioperm			(SYS_Linux + 101)
#define SYS_socketcall			(SYS_Linux + 102)
#define SYS_syslog			(SYS_Linux + 103)
#define SYS_setitimer			(SYS_Linux + 104)
#define SYS_getitimer			(SYS_Linux + 105)
#define SYS_stat			(SYS_Linux + 106)
#define SYS_lstat			(SYS_Linux + 107)
#define SYS_fstat			(SYS_Linux + 108)
#define SYS_olduname			(SYS_Linux + 109)
#define SYS_iopl			(SYS_Linux + 110)
#define SYS_vhangup			(SYS_Linux + 111)
#define SYS_idle			(SYS_Linux + 112)
#define SYS_vm86			(SYS_Linux + 113)
#define SYS_wait4			(SYS_Linux + 114)
#define SYS_swapoff			(SYS_Linux + 115)
#define SYS_sysinfo			(SYS_Linux + 116)
#define SYS_ipc				(SYS_Linux + 117)
#define SYS_fsync			(SYS_Linux + 118)
#define SYS_sigreturn			(SYS_Linux + 119)
#define SYS_clone			(SYS_Linux + 120)
#define SYS_setdomainname		(SYS_Linux + 121)
#define SYS_uname			(SYS_Linux + 122)
#define SYS_modify_ldt			(SYS_Linux + 123)
#define SYS_adjtimex			(SYS_Linux + 124)
#define SYS_mprotect			(SYS_Linux + 125)
#define SYS_sigprocmask			(SYS_Linux + 126)
#define SYS_create_module		(SYS_Linux + 127)
#define SYS_init_module			(SYS_Linux + 128)
#define SYS_delete_module		(SYS_Linux + 129)
#define SYS_get_kernel_syms		(SYS_Linux + 130)
#define SYS_quotactl			(SYS_Linux + 131)
#define SYS_getpgid			(SYS_Linux + 132)
#define SYS_fchdir			(SYS_Linux + 133)
#define SYS_bdflush			(SYS_Linux + 134)
#define SYS_sysfs			(SYS_Linux + 135)
#define SYS_personality			(SYS_Linux + 136)
#define SYS_afs_syscall			(SYS_Linux + 137) /* Syscall for Andrew File System */
#define SYS_setfsuid			(SYS_Linux + 138)
#define SYS_setfsgid			(SYS_Linux + 139)
#define SYS__llseek			(SYS_Linux + 140)
#define SYS_getdents			(SYS_Linux + 141)
#define SYS__newselect			(SYS_Linux + 142)
#define SYS_syscall_flock		(SYS_Linux + 143)
#define SYS_msync			(SYS_Linux + 144)
#define SYS_readv			(SYS_Linux + 145)
#define SYS_writev			(SYS_Linux + 146)
#define SYS_cacheflush			(SYS_Linux + 147)
#define SYS_cachectl			(SYS_Linux + 148)
#define SYS_sysmips			(SYS_Linux + 149)
#define SYS_setup			(SYS_Linux + 150)	/* used only by init, to get system going */
#define SYS_getsid			(SYS_Linux + 151)
#define SYS_fdatasync			(SYS_Linux + 152)
#define SYS__sysctl			(SYS_Linux + 153)
#define SYS_mlock			(SYS_Linux + 154)
#define SYS_munlock			(SYS_Linux + 155)
#define SYS_mlockall			(SYS_Linux + 156)
#define SYS_munlockall			(SYS_Linux + 157)
#define SYS_sched_setparam		(SYS_Linux + 158)
#define SYS_sched_getparam		(SYS_Linux + 159)
#define SYS_sched_setscheduler		(SYS_Linux + 160)
#define SYS_sched_getscheduler		(SYS_Linux + 161)
#define SYS_sched_yield			(SYS_Linux + 162)
#define SYS_sched_get_priority_max	(SYS_Linux + 163)
#define SYS_sched_get_priority_min	(SYS_Linux + 164)
#define SYS_sched_rr_get_interval	(SYS_Linux + 165)
#define SYS_nanosleep			(SYS_Linux + 166)
#define SYS_mremap			(SYS_Linux + 167)
#define SYS_accept			(SYS_Linux + 168)
#define SYS_bind			(SYS_Linux + 169)
#define SYS_connect			(SYS_Linux + 170)
#define SYS_getpeername			(SYS_Linux + 171)
#define SYS_getsockname			(SYS_Linux + 172)
#define SYS_getsockopt			(SYS_Linux + 173)
#define SYS_listen			(SYS_Linux + 174)
#define SYS_recv			(SYS_Linux + 175)
#define SYS_recvfrom			(SYS_Linux + 176)
#define SYS_recvmsg			(SYS_Linux + 177)
#define SYS_send			(SYS_Linux + 178)
#define SYS_sendmsg			(SYS_Linux + 179)
#define SYS_sendto			(SYS_Linux + 180)
#define SYS_setsockopt			(SYS_Linux + 181)
#define SYS_shutdown			(SYS_Linux + 182)
#define SYS_socket			(SYS_Linux + 183)
#define SYS_socketpair			(SYS_Linux + 184)
#define SYS_setresuid			(SYS_Linux + 185)
#define SYS_getresuid			(SYS_Linux + 186)
#define SYS_query_module		(SYS_Linux + 187)
#define SYS_poll			(SYS_Linux + 188)
#define SYS_nfsservctl			(SYS_Linux + 189)

#endif	/* sys/syscall.h */
