/*
 * Use cascadebutton as a push button
 */
#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/CascadeB.h>
#include <Xm/MenuShell.h>
#include <Xm/RepType.h>
#include <Xm/SelectioB.h>

#include <Xm/XmP.h>

char *fallback[] = {
	"*cascade1.labelString:			Menu",
	"*cascade1.mnemonic:			M",
	NULL	/* The end */
};

void PrintIt(Widget w)
{
	fprintf(stderr, "Widget %s activated\n", XtName(w));
}

int
main(int argc, char **argv)
{
    XtAppContext theApp;
    Widget toplevel, rc;
    Widget cascade1;
    Arg		al[5];
    int		ac;

/* Install converter to make the command line indicated above work */
    XmRepTypeInstallTearOffModelConverter();

/* Toplevel and Menu Bar */
    toplevel = XtVaAppInitialize(&theApp, "test5", NULL, 0, &argc, argv,
		fallback, NULL);
    rc = XmCreateMenuBar(toplevel, "menubar", NULL, 0);

    cascade1 = XtVaCreateManagedWidget("cascade1", xmCascadeButtonWidgetClass,
		rc, NULL);

    XtAddCallback(cascade1, XmNactivateCallback, PrintIt, NULL);

    XtManageChild(rc);
    XtRealizeWidget(toplevel);
    XtAppMainLoop(theApp);    
    exit(0);
}

