#include <Xm/XmP.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/MenuShell.h>
#include <Xm/MainWP.h>
#include <Xm/MessageB.h>
#include <Xm/Command.h>
#include <stdio.h>
#include <XmI/XmI.h>

void
dump_sw(char *where, Widget w)
{
#if 0
/* Toggle this for 2.0.  Manager has popup handler added in 2.0 */
    w = (Widget)((char *)w + 4);
#endif
    printf(where);
    printf("Given W: %d H: %d\n", SW_GivenWidth(w), SW_GivenHeight(w));
    printf("Area W: %d H: %d\n", SW_CWWidth(w), SW_CWHeight(w));
    printf("MWArea W: %d H: %d\n", MW_AreaWidth(w), MW_AreaHeight(w));
    printf("Pad W: %d H: %d\n", SW_MarginWidth(w), SW_MarginHeight(w));
    printf("Offset X: %d Y: %d\n", SW_CWX(w), SW_CWY(w));
    printf("Spacing: %d\n", SW_Spacing(w));
    printf("Has: %d %d\n", SW_HasHSB(w), SW_HasVSB(w));
    printf("HSB: %d %d %d %d\n", SW_HSBX(w), SW_HSBY(w),
	                         SW_HSBWidth(w), SW_HSBHeight(w));
    printf("VSB: %d %d %d %d\n", SW_VSBX(w), SW_VSBY(w),
	                         SW_VSBWidth(w), SW_VSBHeight(w));
    printf("HSB values: %d %d %d %d\n", SW_HSBMinimum(w), SW_HSBMaximum(w),
	                         SW_HSBValue(w), SW_HSBSliderSize(w));
    printf("VSB values: %d %d %d %d\n", SW_VSBMinimum(w), SW_VSBMaximum(w),
	                         SW_VSBValue(w), SW_VSBSliderSize(w));
    printf("Done.\n\n");
}

int
main(int argc, char **argv)
{
    XtAppContext theApp;
    Widget shell, toplevel, menubar, filepane;
    Widget button, button1, button2, sep;
    Widget saveAsPane, button3, button4, button5;
    Widget button6, button7, editpane;
    Widget mb, com;
    Widget one, two, three;
    XmString xmstr;

    shell = XtVaAppInitialize(&theApp, "mainW", NULL, 0,
				 &argc, argv, NULL, NULL);

    toplevel = XmCreateMainWindow(shell, "MainWindow", NULL, 0);
    XtVaSetValues(toplevel, XmNshowSeparator, True, NULL);
    XtManageChild(toplevel);
dump_sw("after init\n", toplevel);

    menubar = XmCreateMenuBar(toplevel,
			      "menuBar",
			      NULL,0);
dump_sw("after add menu\n", toplevel);
    XtManageChild(menubar);
dump_sw("after manage menu\n", toplevel);

    filepane = XmCreatePulldownMenu(menubar,
				    "pane",
				    NULL,0);

    xmstr = XmStringCreateSimple("File");
    
    button = XtVaCreateManagedWidget("File",
				     xmCascadeButtonWidgetClass,
				     menubar,
				     XmNsubMenuId, filepane,
                                     XmNlabelString, xmstr,
				     NULL);

    editpane = XmCreatePulldownMenu(menubar,
				    "pane2",
				    NULL, 0);

    button6 = XtVaCreateManagedWidget("Edit",
				      xmCascadeButtonGadgetClass,
				      menubar,
				      XmNsubMenuId, editpane,
				      NULL);

    button7 = XtVaCreateManagedWidget("Cut",
				      xmPushButtonGadgetClass,
				      editpane,
				      NULL);

    button1 = XtVaCreateManagedWidget("Open",
				      xmPushButtonGadgetClass,
				      filepane,
				      NULL);

    sep = XtVaCreateManagedWidget("sep",
				  xmSeparatorGadgetClass,
                                  filepane,
                                  NULL);

    button2 = XtVaCreateManagedWidget("Close",
				      xmPushButtonWidgetClass,
				      filepane,
				      NULL);

    saveAsPane = XmCreatePulldownMenu(filepane,
				      "save_as",
				      NULL, 0);

    button3 = XtVaCreateManagedWidget("Save As",
				      xmCascadeButtonWidgetClass,
				      filepane,
				      XmNsubMenuId, saveAsPane,
				      NULL);

    button4 = XtVaCreateManagedWidget("MS Word",
				      xmPushButtonWidgetClass,
				      saveAsPane,
				      NULL);

    button5 = XtVaCreateManagedWidget("LaTeX",
				      xmPushButtonWidgetClass,
				      saveAsPane,
				      NULL);

    mb = XtVaCreateManagedWidget("mb", xmMessageBoxWidgetClass, toplevel, NULL);
dump_sw("after create message\n", toplevel);
    XtVaSetValues(toplevel, XmNmessageWindow, mb, NULL);
dump_sw("after set message\n", toplevel);

    com = XtVaCreateManagedWidget("com", xmCommandWidgetClass, toplevel, NULL);
dump_sw("after create command\n", toplevel);

    one = XtVaCreateManagedWidget("form", xmFormWidgetClass, toplevel,
				  NULL);
dump_sw("after create form\n", toplevel);

    two = XtVaCreateManagedWidget("two", xmPushButtonWidgetClass, one,
				  XmNtopAttachment, XmATTACH_FORM,
				  XmNbottomAttachment, XmATTACH_FORM,
				  XmNleftAttachment, XmATTACH_NONE,
				  XmNrightAttachment, XmATTACH_FORM,
				  NULL);
dump_sw("after create two\n", toplevel);

    three = XtVaCreateManagedWidget("three", xmPushButtonWidgetClass, one,
				    XmNtopAttachment, XmATTACH_FORM,
				    XmNbottomAttachment, XmATTACH_FORM,
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNrightAttachment, XmATTACH_WIDGET,
				    XmNrightWidget, two,
				    NULL);
dump_sw("after create three\n", toplevel);

    XmMainWindowSetAreas(toplevel, menubar, com, NULL, NULL, one);
dump_sw("after set areas\n", toplevel);

    XtRealizeWidget(shell);
dump_sw("after realize\n", toplevel);

    XtAppMainLoop(theApp);

    exit(0);
}

