/*								-*- C++ -*-
 * $Id: WIN_groupbox.cpp,v 1.3 1997-01-15 14:59:03+01 mho Exp $
 *
 * Purpose: group box choice panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_groupbox.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxGroupBox
#include "wx.h"
#define  Uses_EnforcerWidget
#include <widgets.h>

//-----------------------------------------------------------------------------
// create and destroy group box
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxGroupBox, wxItem)

wxGroupBox::wxGroupBox(void) : wxItem()
{
    __type = wxTYPE_GROUP_BOX;
}

wxGroupBox::wxGroupBox(wxPanel *panel, Const char *label, int x, int y, int width,
		       int height, long style, Constdata char *name)
{
    __type = wxTYPE_GROUP_BOX;

    Create(panel, label, x, y, width, height, style, name);
}

Bool wxGroupBox::Create(wxPanel *panel, Const char *label, int x, int y, int width,
			int height, long style, Constdata char *name)
{
    ChainToPanel(panel, style, name);

    // create frame
    FWidget() = HWidget() = XtVaCreateManagedWidget
	(name, xfwfEnforcerWidgetClass, GetParentWidget(parent),
	 XtNlabel,       label,
	 XtNalignment,   (label_position == wxVERTICAL) ? XfwfTop : XfwfTopLeft,
	 XtNbackground,  bg.GetPixel(&cmap),
	 XtNforeground,  label_fg.GetPixel(&cmap),
	 XtNfont,        label_font.GetInternalFont(),
	 XtNframeType,   ((style & wxBORDER) ? XfwfSunken : XfwfChiseled),
	 XtNframeWidth,  2,
	 XtNhighlightThickness, 0, XtNtraversalOn, FALSE,
	 NULL);
    // panel positioning
    panel->PositionItem(this, x, y, 
			(width  > -1 ? width  : wxGROUP_BOX_WIDTH),
			(height > -1 ? height : wxGROUP_BOX_HEIGHT));
    AddEventHandlers();
    return TRUE;
}

void wxGroupBox::SetLabelFont(wxFont *new_font)
{
    SetFont(new_font);
    label_font=new_font;
}

