/*
 * ratStdFolder.h --
 *
 *      Declarations of functions used in the Std folder and messages
 *
 * TkRat software and its included text is Copyright 1996,1997,1998
 * by Martin Forssn
 *
 * The full text of the legal notice is contained in the file called
 * COPYRIGHT, included with this distribution.
 */

#ifndef _RATSTDFOLDER
#define _RATSTDFOLDER

#include "ratFolder.h"

/*
 * This list correlates to the ratStdTypeNames array in ratStdFolder.c
 */
typedef enum {RAT_BERKELY, RAT_IMAP, RAT_POP, RAT_MH} RatStdFolderType;

RatGetHeadersProc Std_GetHeadersProc;
RatGetEnvelopeProc Std_GetEnvelopeProc;
RatCreateBodyProc Std_CreateBodyProc;
RatFetchTextProc Std_FetchTextProc;
RatEnvelopeProc Std_EnvelopeProc;
RatSetIndexProc Std_SetIndexProc;
RatMsgDeleteProc Std_MsgDeleteProc;
RatMakeChildrenProc Std_MakeChildrenProc;
RatFetchBodyProc Std_FetchBodyProc;
RatBodyDeleteProc Std_BodyDeleteProc;
RatInfoProc Std_GetInfoProc;

/* ratStdMessage.c */
extern char *RatStdMessageCreate (Tcl_Interp *interp, RatFolderInfoPtr infoPtr,
	MAILSTREAM *stream, int msgNo, RatStdFolderType type, char *host,
	char *user);

#endif /* _RATSTDFOLDER */
