## Copyright (C) 1996, 1997  Kurt Hornik
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## usage:  nth (M, IND)
##
## For a string `list' M, i.e., a character array where the rows are the
## individual strings padded to the right with string_fill_char, extract
## a list of strings as specified by the vector IND.
## E.g., if
##   M = ["This is"; "a test"; "matrix"],
## then
##   [u, v, w] = nth (M, [1 3 1])
## returns
##   u = "This is"
##   v = "matrix"
##   w = "This is"
## (at least if string_fill_char is 0).

## Author:  KH <Kurt.Hornik@ci.tuwien.ac.at>
## Description:  Extract strings from a string list

function [...] = nth (M, IND)
  
  if (nargin != 2)
    usage ("nth (M, IND");
  endif

  if !isstr (M)
    error ("nth:  M must be a matrix of strings")
  endif
  if ((min (size (IND)) > 1) || any (IND < 1) || any (IND > rows (M))) 
    error ("nth:  IND must be a vector with entries in {1, ..., rows(M)}")
  endif

  maxlen = columns (M);
  for i = IND;
    vr_val (substr (M(i,:), 1,
		    (maxlen 
		     - length (find (M(i,:) == string_fill_char))))); 
  endfor

endfunction
