/* cmalloc.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "cmalloc.h"

/* Allocate memory and check if anything was actually allocated.
   If not, print an error message or do something else */

/* Also does a few checks that the library functions should already do */

static void std_alloc_fail()
{
	fprintf(stderr, "Out of memory\n");
	exit(EXIT_FAILURE);
}

static void (*alloc_fail)(void) = std_alloc_fail;

void cmalloc_init(void (*new_fail)(void))
{
	if (new_fail) alloc_fail = new_fail;
	else alloc_fail = std_alloc_fail;
}


void *cmalloc(size_t size)
{
	void *p;

	p = malloc(size);
	if (p == NULL) alloc_fail();
	return p;
}

void *crealloc(void *ptr, size_t size)
{
	void *p;

	p = realloc(ptr, size);
	if (p == NULL) alloc_fail();
	return p;
}

void *ccalloc(size_t nmemb, size_t size)
{
	void *p;

	p = calloc(nmemb, size);
	if (p == NULL) alloc_fail();
	return p;
}

char *cstrdup(const char *s)
{
	char *p;

	if (s) p = malloc(strlen(s)+1);
	else p = NULL;
	if (p == NULL) alloc_fail();
	else strcpy(p, s);
	return p;
}

/* just check to see that the pointer is not NULL */
void cfree(void *ptr)
{
	free(ptr);
}

