#include "defs.h"
#include <xview/file_chsr.h>
#include <fcntl.h>
#include <errno.h>
#include "Garmin.h"

enum PROTOCOL mode = NONE;


extern int focus_x, focus_y;
extern Display *display;
extern Frame frame;
extern File_chooser p_openfile, p_savefile;


char   MenuItem[255];



void MenuHandleFromFile();
void MenuHandleToFile();



void SetPosition(item, event)
Panel_item  item;
Event       *event;
{
  focus_x = event_x(event);
  focus_y = event_y(event);
}

/*****************************************************************************/
/*****************************************************************************/
void MenuHandlePreferences()
{
  MenuNoQuit();
  ChangePrefs();
}



/*****************************************************************************/
/* Handle submenu for download to GPS.                                       */
/*****************************************************************************/
void MenuHandleFrom(menu, menu_item)
Menu      menu;
Menu_item menu_item;
{
  char FileName[255];

  MenuNoQuit();

  sprintf(FileName, "Output");
  if (strncasecmp(MenuItem, "Alma", 4) == 0) {
    sprintf(FileName, "GPS_45_Almanac_Data");
  }
  if (strncasecmp(MenuItem, "Rout", 4) == 0) {
    sprintf(FileName, "GPS_45_Route_Data");
  }
  if (strncasecmp(MenuItem, "Trac", 4) == 0) {
    sprintf(FileName, "GPS_45_Track_Data");
  }
  if (strncasecmp(MenuItem, "Wayp", 4) == 0) {
    sprintf(FileName, "GPS_45_Waypoint_Data");
  }

  sprintf(MenuItem, "%s", xv_get(menu_item, MENU_STRING));

  FileSave(&FileName);
  xv_set(p_savefile, FILE_CHOOSER_NOTIFY_FUNC, MenuHandleFromFile, NULL);
}



void MenuHandleFromFile(fc, path, file, client_data, op, event, row)
File_chooser    fc;
char            *path;
char            *file;
Xv_opaque       client_data;
Panel_list_op   op;
Event           *event;
int             row;
{
  FILE   *refNum;
  char   temp[255];


  xv_set(frame, FRAME_BUSY, TRUE, NULL);
  if (path == NULL) {
    xv_set(frame, FRAME_BUSY, FALSE, NULL);
    return;
  }

  xv_set(p_savefile, XV_SHOW, FALSE, NULL);
  XFlush(display);
  sleep(1);

/*
  if (mode != GARMIN) {
    Message("Set the GPS receiver I/O SETUP to \"GRMN/GRMN\".");
    mode = GARMIN;
  }
*/

  refNum = fopen(path, "wt");
  if (refNum == NULL) {
    sprintf(temp, "Can't open file %s", path);
    Error(&temp);
    xv_set(frame, FRAME_BUSY, FALSE, NULL);
    return;
  }

  if (strncasecmp(MenuItem, "Alma", 4) == 0) {
    getGPSInfo(refNum, ALMANAC);
  }
  if (strncasecmp(MenuItem, "Rout", 4) == 0) {
    getGPSInfo(refNum, ROUTE);
  }
  if (strncasecmp(MenuItem, "Trac", 4) == 0) {
    getGPSInfo(refNum, TRACK);
  }
  if (strncasecmp(MenuItem, "Wayp", 4) == 0) {
    getGPSInfo(refNum, WAYPOINT);
  }

  fclose(refNum);

  xv_set(frame, FRAME_BUSY, FALSE, NULL);
}

/*****************************************************************************/
/* Handle submenu for upload to GPS.                                         */
/*****************************************************************************/
void MenuHandleTo(menu, menu_item)
Menu      menu;
Menu_item menu_item;
{
  char FileName[255];

  MenuNoQuit();

  if (strncasecmp(MenuItem, "Rout", 4) == 0) {
    sprintf(FileName, "GPS_45_Route_Data");
  }
  if (strncasecmp(MenuItem, "Trac", 4) == 0) {
    sprintf(FileName, "GPS_45_Track_Data");
  }
  if (strncasecmp(MenuItem, "Wayp", 4) == 0) {
    sprintf(FileName, "GPS_45_Waypoint_Data");
  }

  sprintf(MenuItem, "%s", xv_get(menu_item, MENU_STRING));

  FileOpen(&FileName);
  xv_set(p_openfile, FILE_CHOOSER_NOTIFY_FUNC, MenuHandleToFile, NULL);
}



void MenuHandleToFile(fc, path, file, client_data, op, event, row)
File_chooser    fc;
char            *path;
char            *file;
Xv_opaque       client_data;
Panel_list_op   op;
Event           *event;
int             row;
{
  FILE   *refNum;
  char   temp[255];

  xv_set(frame, FRAME_BUSY, TRUE, NULL);
  if (path == NULL) {
    xv_set(frame, FRAME_BUSY, FALSE, NULL);
    return;
  }

  xv_set(p_openfile, XV_SHOW, FALSE, NULL);
  XFlush(display);
  sleep(1);

/*  if (mode != GARMIN) {
    Message("Set the GPS receiver I/O SETUP to \"GRMN/GRMN\".");
    mode = GARMIN;
  }
*/

  refNum = fopen(path, "rt");
  if (refNum == NULL) {
    sprintf(temp, "Can't open file %s", path);
    Error(&temp);
    xv_set(frame, FRAME_BUSY, FALSE, NULL);
    return;
  }

  if (strncasecmp(MenuItem, "Rout", 4) == 0) {
    sendGPSInfo(refNum, ROUTE);
  }
  if (strncasecmp(MenuItem, "Trac", 4) == 0) {
    sendGPSInfo(refNum, TRACK);
  }
  if (strncasecmp(MenuItem, "Wayp", 4) == 0) {
    sendGPSInfo(refNum, WAYPOINT);
  }

  xv_set(frame, FRAME_BUSY, FALSE, NULL);
}




