/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@sdsu.edu>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * $Id: fonts.c,v 2.1 1997/01/05 18:41:39 papowell Exp $
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"


/*
 * This function decides which font to download by reading the
 * MACHINESFONTS file.
 */
void selectfont()
{
	char *fntname, *t;
	int len;
	char fontpath[MAXPATHLEN];

	/* find font for current job */
	fntname = 0;
	if(zopts != NULL){
        if ((fntname=strstr(zopts,"font="))){
			log(1,"-Zfont option detected");
			if( (fntname=strchr(fntname,'=')) ){
				static char *dups;
				if( dups ) free(dups);
				dups = 0;

				fntname++;
				/* use a duplicate of the string */
				fntname = strdup(fntname);
				if( (t = strpbrk(fntname, " \t" )) ) *t = 0;
			}
		}
	}

	if( fntname == 0 || *fntname == 0 ) fntname = fnt_scan(host);
	if( fntname == 0 || *fntname == 0 ) fntname = default_font;
	if( fntname && *fntname == 0 ) fntname = 0;
		
	/* we will reset between jobs, so we just return */
	if( fntname == 0 ){
		log(4,"selectfont: NO default font, sending '%s'", PGRESET );
		len = strlen(PGRESET);
		if (writecn(STDOUT, PGRESET, len) != len){
			logerr(3,"Cannot send PGRESET string");
		}
		return;
	}
	strncpy( fontpath, FONTPATH, sizeof(fontpath)-2 );
	fontpath[sizeof(fontpath)-2] = 0;
	fontpath[sizeof(fontpath)-1] = 0;
	len = strlen( fontpath );
	if( len > 0 && fontpath[len-1] != '/' ){
		strcpy( fontpath+len, "/" );
		++len;
	}
	if( fntname[0] == '/' ){
		strncpy( fontpath, fntname, sizeof(fontpath)-2 );
	} else {
		strncpy( fontpath+len, fntname, sizeof(fontpath)-len-2 );
	}

	log(4,"selectfont: font '%s'", fontpath );
	sendfont(fontpath);

	/* select the font either downloaded or from previous job */
	t = SELFONT;
	len = strlen( t );
	if (writecn(STDOUT, t, len ) != len ) {
		log(2,"Cannot send SELFONT string '%s'", SELFONT );
	} else {
		log(2,"Font selected successfully");
	}
	log(4,"selectfont: done");
}

char *fnt_scan( mchn )
char *mchn;
{
	FILE *fontfp;
	char *s, *name, *dir, *file;
	static char *end_value;
	int len;
	char fontpath[MAXPATHLEN];
	char fileline[MAXPATHLEN];

	if( mchn == 0 || *mchn == 0 ) return( (char *) 0 );

	strncpy( fontpath, FONTPATH, sizeof(fontpath)-2 );
	fontpath[sizeof(fontpath)-2] = 0;
	fontpath[sizeof(fontpath)-1] = 0;
	len = strlen( fontpath );
	if( len > 0 && fontpath[len-1] != '/' ){
		strcpy( fontpath+len, "/" );
		++len;
	}
	s = MACHINESFONTS;
	if( s[0] == '/' ){
		strncpy( fontpath, s, sizeof(fontpath)-2 );
	} else {
		strncpy( fontpath+len, s, sizeof(fontpath)-len-2 );
	}
	log(4, "Opening host font file '%s'", fontpath);
	if( (fontfp = fopen( fontpath, "r" )) == NULL ){
		log(2, "fnt_scan: missing host font file '%s'", fontpath );
		return( (char *)0 );
	}

	while( fgets( fileline, sizeof(fileline)-1, fontfp ) ) {
		log(4, "line '%s'", fileline);
		name = fileline;
		if( (s = strchr( name, '\n' ) ) ) *s = 0;
		while( isspace(*name) ) ++name;
		if ( *name == '#' )	continue;
		dir = strpbrk(name, " \t" );
		if( dir == 0 ) continue;
		while( isspace( *dir ) ) *dir++ = 0;
		if( *dir == 0 ) continue;
		log(4,"fnt_scan: checking '%s' = '%s', dir '%s'", mchn, name, dir );
		if( strcasecmp( mchn, name ) ) continue;
		file = strpbrk(dir, " \t" );
		if( file ){
			*file++ = 0;
			while( isspace(*file) ) ++file;
			s = strpbrk(file, " \t" );
			if( s ) *s = 0;
		}
		log(4,"fnt_scan: dir '%s' file '%s'", dir, file );
		strncpy( fontpath, FONTPATH, sizeof(fontpath)-2 );
		fontpath[sizeof(fontpath)-2] = 0;
		fontpath[sizeof(fontpath)-1] = 0;
		len = strlen( fontpath );
		if( len > 0 && fontpath[len-1] != '/' ){
			strcpy( fontpath+len, "/" );
			++len;
		}
		if( dir[0] == '/' ){
			strncpy( fontpath, dir, sizeof(fontpath)-2 );
		} else {
			strncpy( fontpath+len, dir, sizeof(fontpath)-len-2 );
		}
		if( file && *file ){
			len = strlen( fontpath );
			if( len > 0 && fontpath[len-1] != '/' ){
				strcpy( fontpath+len, "/" );
				++len;
			}
			strncpy( fontpath+len, file, sizeof(fontpath)-len -2);
		}
		break;
	}

	fclose( fontfp );
	if( end_value ) free( end_value );
	end_value = strdup( fontpath );
	return( end_value );
}
