/*
 * hold.h: header for hold.c
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: hold.h,v 1.4 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _HOLD_H_
#define _HOLD_H_

/* Hold: your general doubly-linked list type structure */

#include "irc_std.h"

typedef struct HoldStru
{
	char	*str;
	struct	HoldStru	*next;
	struct	HoldStru	*prev;
	int	logged;
}	Hold;

struct WindowStru;

extern	void	remove_from_hold_list _((struct WindowStru *));
extern	void	add_to_hold_list _((struct WindowStru *, char *, int));
extern	void	hold_mode _((struct WindowStru *, int, int));
extern	int	hold_output _((struct WindowStru *));
extern	char	*hold_queue _((struct WindowStru *));
extern	void	reset_hold _((struct WindowStru *));
extern	int	hold_queue_logged _((struct WindowStru *));
extern	void	toggle_stop_screen _((char, char *));
#endif /* _HOLD_H_ */
