
/***

error.c - An error-handling subroutine--just displays a red error box

Written by Gerard Paul Java
Copyright (c) Gerard Paul Java 1997, 1998

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***/

#include <curses.h>
#include <panel.h>
#include "deskman.h"
#include "attrs.h"

void errbox(char *message, char *prompt, int *response)
{
    WINDOW *win;
    PANEL *panel;

    win = newwin(4, 45, 10, 10);
    panel = new_panel(win);

    wattrset(win, ERRBOXATTR);
    colorwin(win);
    box(win, ACS_VLINE, ACS_HLINE);
    wmove(win, 2, 2);
    wprintw(win, "%s", prompt);
    wattrset(win, ERRTXTATTR);
    wmove(win, 1, 2);
    wprintw(win, "%s", message);
    update_panels();
    doupdate();
    *response = wgetch(win);

    del_panel(panel);
    delwin(win);
    update_panels();
    doupdate();
}
