/*
 * ircaux.h: header file for ircaux.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: ircaux.h,v 1.6 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _IRCAUX_H_
#define _IRCAUX_H_

#include "irc.h"
#include "irc_std.h"
#include <stdio.h>

typedef int comp_len_func (char *, char *, int);
typedef int comp_func (char *, char *);


char *	check_nickname 		(char *);
char *	next_arg 		(char *, char **);
char *	new_next_arg 		(char *, char **);
char *	new_new_next_arg 	(char *, char **, char *);
char *	last_arg 		(char **);
char *	expand_twiddle 		(char *);
char *	upper 			(char *);
char *	lower 			(char *);
char *	sindex			(register char *, char *);
char *	rsindex 		(register char *, char *, char *, int);
char *	path_search 		(char *, char *);
char *	double_quote 		(const char *, const char *, char *);
char *	n_malloc_strcpy		(char **, const char *, const char *, const int);
char *	malloc_str2cpy		(char **, const char *, const char *);
char *	n_malloc_strcat 		(char **, const char *, const char *, const int);
char *	m_s3cat_s 		(char **, const char *, const char *);
char *	m_s3cat 		(char **, const char *, const char *);
char *	m_3cat 			(char **, const char *, const char *);
char *	m_e3cat 		(char **, const char *, const char *);
char *	m_2dup 			(const char *, const char *);
char *	m_3dup 			(const char *, const char *, const char *);
char *	m_opendup 		(const char *, ...);
char *	n_m_strdup 		(const char *, const char *, const int);
void	wait_new_free 		(char **);
char *	malloc_sprintf 		(char **, const char *, ...);
char *	m_sprintf 		(const char *, ...);
int	is_number 		(char *);
char *	my_ctime 		(time_t);
int	my_stricmp 		(const unsigned char *, unsigned const char *);
int	my_strnicmp 		(const unsigned char *, const unsigned char *, size_t);
int	my_strnstr 		(const unsigned char *, const unsigned char *, size_t);
int	scanstr 		(char *, char *);
void	really_free 		(int);
char *	chop 			(char *, int);
char *	strmcpy 		(char *, const char *, int);
char *	strmcat 		(char *, const char *, int);
char *	strmcat_ue 		(char *, const char *, int);
char *	n_m_strcat_ues 		(char **, char *, int, const char *, const int);
char *	stristr 		(const char *, const char *);
char *	rstristr 		(char *, char *);
FILE *	uzfopen 		(char **, char *, int);
int	end_strcmp 		(const char *, const char *, int);
void	ircpanic		(char *, ...) __A(1);

int	fw_strcmp 		(comp_len_func *, char *, char *);
int	lw_strcmp 		(comp_func *, char *, char *);
int	open_to 		(char *, int, off_t);
struct timeval get_time 	(struct timeval *);
double 	time_diff 		(struct timeval, struct timeval);
char *	plural 			(int);
int	time_to_next_minute 	(void);
 char *	remove_trailing_spaces 	(char *);
char *	ltoa 			(long);
char *	strformat 		(char *, char *, int, char);
char *	chop_word 		(char *);
int	splitw 			(char *, char ***);
char *	unsplitw 		(char ***, int);
int	check_val 		(char *);
 char *	strextend 		(char *, char, int);
char *	pullstr 		(char *, char *);
int 	empty 			(const char *);
char *	safe_new_next_arg 	(char *, char **);
char *	MatchingBracket 	(register char *, register char, register char);
int	word_count 		(char *);
int	parse_number 		(char **);
char *	remove_brackets 	(char *, char *, int *);
u_long	hashpjw 		(char *, u_long);
char *	m_dupchar 		(int);
char *	strmccat		(char *, char, int);
off_t	file_size		(char *);
int	is_root			(char *, char *, int);
size_t	streq			(const char *, const char *);
char *	n_m_strndup		(const char *, size_t, const char *, const int);
#ifndef HAVE_VSNPRINTF
	int	vsnprintf 		(char *, size_t, const char *, va_list);
#endif
#ifndef HAVE_SNPRINTF
	int	snprintf 		(char *, size_t, const char *, ...) __A(3);
#endif

char *	on_off (int);
char *	rfgets (char *, int, FILE *);
char *  strmopencat             (char *, int, ...);
long my_atol (char *);
char *s_next_arg (char **);
char *next_in_comma_list (char *, char **);
void	strip_control	(const char *, char *);
int	figure_out_address (char *, char **, char **, char **, char **, int *);
int	count_char		(const unsigned char *, const unsigned char);
char *	strnrchr		(char *, char, int);
void	mask_digits		(char **);
const char *strfill (char, int);
char *ov_strcpy (char *, const char *);
char *strpcat(char *, const char *, ...);
char *chomp(char *);
size_t ccspan(const char *, int);


/* From words.c */
#define SOS -32767
#define EOS 32767
char	*search (register char *, char **, char *, int);
char	*move_to_abs_word (register char *, char **, int);
char	*move_word_rel (register char *, char **, int);
char	*extract (register char *, int, int);
char	*extract2 (register char *, int, int);
int	match (register char *, register char *);
int	wild_match (register const unsigned char *, register const unsigned char *);

/* Used for connect_by_number */
#define SERVICE_SERVER 0
#define SERVICE_CLIENT 1
#define PROTOCOL_TCP 0
#define PROTOCOL_UDP 1

/* Used from network.c */
int connect_by_number (char *, unsigned short *, int, int, int);
struct hostent *resolv (const char *);
struct hostent *lookup_host (const char *);
struct hostent *lookup_ip (const char *);
char *host_to_ip (const char *);
char *ip_to_host (const char *);
char *one_to_another (const char *);


void	FixColorAnsi (unsigned char *);

#ifdef NON_BLOCKING_CONNECTS
int	set_blocking (int);
int	set_non_blocking (int);
#endif

#define my_isspace(x) \
	((x) == 9 || (x) == 10 || (x) == 11 || (x) == 12 || (x) == 13 || (x) == 32)
  
#define my_isdigit(x) \
(*x >= '0' && *x <= '9') || \
((*x == '-'  || *x == '+') && (x[1] >= '0' && x[1] <= '9'))

#define	_1KB	(1024.0)
#define	_1MEG	(1024.0*1024.0)
#define	_1GIG	(1024.0*1024.0*1024.0)
#define	_1TER	(1024.0*1024.0*1024.0*1024.0)
#define	_1ETA	(1024.0*1024.0*1024.0*1024.0*1024.0)

#define	_GMKs(x)	( (x > _1ETA) ? "Eb" : ((x > _1TER) ? "Tb" : ((x > _1GIG) ? "Gb" : \
			((x > _1MEG) ? "Mb" : ((x > _1KB)? "Kb" : "bytes")))))

#define	_GMKv(x)	((x > _1ETA) ? \
			(double)(x/_1ETA) : ((x > _1TER) ? \
			(double)(x/_1TER) : ((x > _1GIG) ? \
			(double)(x/_1GIG) : ((x > _1MEG) ? \
			(double)(x/_1MEG) : ((x > _1KB) ? \
			(double)(x/_1KB): (double)x)))) )

static  inline int vt100_decode	(register unsigned char chr)
{
	static enum {
		Normal, Escape, SCS, CSI, DCS, DCSData, DCSEscape
	} vtstate = Normal;

	if (chr == 0x1B) 	/* ASCII ESC */
		if (vtstate == DCSData || vtstate == DCSEscape)
			vtstate = DCSEscape;
		else {
			vtstate = Escape;
			return 1;
		}
	else if (chr == 0x18 || chr == 0x1A) 		/* ASCII CAN & SUB */
		vtstate = Normal;

	else if (chr == 0xE || chr == 0xF)		/* ASCII SO & SI */
		;

	/* C0 codes are dispatched without changing machine state!  Oh, my! */
	else if (chr < 0x20) 
		return 0;

	switch (vtstate) 
	{
		case Normal:
			return 0;
			break;
		case Escape:
			switch (chr) 
			{
				case '[':
					vtstate = CSI;
					break;
				case 'P':
					vtstate = DCS;
					break;
				case '(':
				case ')':
					vtstate = SCS;
					break;
				default:
					vtstate = Normal;
			}
			return 1;
			break;
		case SCS:
			vtstate = Normal;
			break;
		case CSI:
			if (isalpha(chr))
				vtstate = Normal;
			break;
		case DCS:
			if (chr >= 0x40 && chr <= 0x7E)
				vtstate = DCSData;
			break;
		case DCSData:
			break;
		case DCSEscape:
			vtstate = Normal;
			break;
	}
	return 1;

}

/* how many ansi escape chars do we have in string?
 * if len -1 count full string, otherwise, count len chars 
 */
   
static inline int count_ansi(const char *str, int len)
{
	register int count = 0;
	for (; *str && len; str++, len--)
		if (vt100_decode(*str))
			count++;
	return count;
}


void	*n_malloc 	(size_t, const char *, const int);
void	*n_realloc	(void **, size_t, const char *, const int);

void	*n_free 	(void **, const char *, const int);

#define new_malloc(x) n_malloc(x, __FILE__, __LINE__)
#define new_free(x) n_free((void **)(x), __FILE__, __LINE__)

/*#define new_realloc(x,y) n_realloc((x),(y),__FILE__,__LINE__)*/

#define RESIZE(x, y, z) n_realloc     ((void **)& (x), sizeof(y) * (z), __FILE__, __LINE__)
#define malloc_strcpy(x, y) n_malloc_strcpy((char **)x, (char *)y, __FILE__, __LINE__)
#define malloc_strcat(x, y) n_malloc_strcat((char **)x, (char *)y, __FILE__, __LINE__)
#define m_strdup(x) n_m_strdup(x, __FILE__, __LINE__)
#define m_strcat_ues(x, y, z) n_m_strcat_ues(x, y, z, __FILE__, __LINE__)
#define m_strndup(x, y) n_m_strndup(x, y, __FILE__, __LINE__)

char	*encode (const char *, int);
char	*decode (const char *);

#endif /* _IRCAUX_H_ */
