/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/types.h>
#include <sys/errno.h>
#endif
#include <dirent.h>
#if defined Linux || defined NEXTSTEP
#include <sys/dir.h>
#endif
#include "connect.h"
#include "main.h"

extern long offset[SONAME];
   
void sending(struct client_type  *clientstr) {
   FILE *fp = (*statstr)->fp;
   char *hostname = (*statstr)->_HOSTNAME_;
   char **argv;
   char name[LONAME];
   char fstr[BUFSIZE];
   char *sargv[LONAME*64]; /* Hopefully this will be enough ;^) */
   FILE *fd, *fe=stderr;
   DIR *ff;
   unsigned long ci;
   int ofse=0;
   int bmode;
   register int n;
   int mode=0;
   int c, lastrr=0;
   struct stat buf;
#if defined Linux || defined NEXTSTEP
   struct direct *dir;
#else
   struct dirent *dir;
#endif

   for (argv=clientstr->argv; --(clientstr->argc); argv++) {
      if (!(*statstr)->_STANDARD_INPUT_) {
         bzero((char *)&name, LONAME);
         bcopy((*argv), name, strlen((*argv)));
         /*
          * Get protection bits.
          */
         stat((*argv), &buf);
         bmode = buf.st_mode;
         mode = 0;
         for (c=3; c; c--) {
            if (bmode & S_IREAD)  mode |= 04;
            if (bmode & S_IWRITE) mode |= 02;
            if (bmode & S_IEXEC)  mode |= 01;
            bmode <<= 3;
            mode <<= 3;
         }
         mode >>= 3;

         /*
          * Check file.
          */
         if (access(name, F_OK) != 0 ) {
            fprintf(stderr, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
            if (pftplog) {
               if ((fe = fopen(pftplog , "a")) != NULL) {
                  fprintf(fe, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
                  fclose(fe);
               }
            }
            continue;
         }
         else if (!buf.st_size) {
            fprintf(stderr, "** File %s is empty.\n", name);
            if (pftplog) {
               if ((fe = fopen(pftplog, "a")) != NULL) {
                  fprintf(fe, "** File %s is empty.\n", name);
                  fclose(fe);
               }
            }
            continue;
         }
         else if ((*statstr)->_RECURS_ && (buf.st_mode & S_IFDIR)) {
            struct client_type *tmpstr;
            MEM_CHECK((tmpstr = (struct client_type *)calloc(1, sizeof(struct client_type))));
            if ((ff = opendir(name)) == NULL) {
               fprintf(stderr, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
               if (pftplog) {
                  if ((fe = fopen(pftplog, "a")) != NULL) {
                     fprintf(fe, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
                     fclose(fe);
                  }
               }
               continue;
            }
#if defined NEXTSTEP
            for (c = 0; (dir = readdir(ff)) > 0; c++) {
#else
            for (c = 0; (dir = readdir(ff)) != NULL; c++) {
#endif
               if (dir->d_ino == 0) {
                  c--;
                  continue;
               }
               if (strcmp(".", dir->d_name) && strcmp("..", dir->d_name)) {
                  MEM_CHECK((sargv[c] = (char *)calloc(LONAME, sizeof(char))));
                  strcpy(sargv[c], name);
                  if (sargv[c][strlen(sargv[c])-1] != '/') strcat(sargv[c], "/");
                  strcat(sargv[c], dir->d_name);
               }
               else {
                  c--;
               }
            }
            closedir(ff);

            tmpstr->argc = c + 1;
            tmpstr->argv = sargv;
            
            sending(tmpstr);
            free(tmpstr);
            while (c) {
               c--; 
               if (sargv[c]) free(sargv[c]);
            }
            continue;
         }
         else if ((buf.st_mode & S_IFMT) != S_IFREG) {
            fprintf(stderr, "** %s is not a regular file.\n", name);
            continue;
         }
      }
         
      /*
       * Open file for reading.
       */
      if ((*statstr)->_STANDARD_INPUT_) {
         fd = stdin;
      }
      else if ((fd = fopen(name, "r")) == NULL) {
         fprintf(stderr, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
         if (pftplog) {
            if ((fe = fopen(pftplog, "a")) != NULL) {
               fprintf(fe, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
               fclose(fe);
            }
         }
         continue;
      }
      else if (*(offset+ofse) >= 0) {
         if (fseek(fd, *(offset+ofse), 0)) {
            fprintf(stderr, "** %s: %s\n", name, _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         buf.st_size -= *(offset+ofse);
         ofse++;
      }

      /*
       * Send information about the file.
       */
      for (ci=0; (c=*(name+ci)); ci++)
         if (c == ' ' || c == '\t' || c == '\n') name[ci] = '_';
      if ((*statstr)->_STANDARD_INPUT_) {
            strcpy(name, "|"); mode = 0644; buf.st_size = 0;
      }
      fprintf(fp, "%s %d %ld\nH", name, mode, buf.st_size);
      fflush(fp);

      /*
       * Read from local file and write to filter/remote port.
       */
      if (!(*statstr)->_STANDARD_INPUT_) (*statstr)->lol = 1;
      fprintf(stderr, "* Sending %s %s to %s ...%s",
      (*statstr)->_STANDARD_INPUT_ ? "a stream": "file", 
      (*statstr)->_STANDARD_INPUT_ ? "\b": (*argv), hostname, 
      (*statstr)->_STANDARD_INPUT_ ? "\n": "");
      if (!(*statstr)->_STANDARD_INPUT_) {
         int rr = BUFSIZE > buf.st_size ? buf.st_size: BUFSIZE;
         if (lastrr != rr) {
            if (setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char *)&rr, sizeof(rr)) < 0) {
               fprintf(stderr, "** setsockopt: %s\n", _PFTP_ERROR_ARRAY_);
               exit(1);
            }
            lastrr = rr;
         }
         for (ci=n=0; (n = fread(fstr, sizeof(char), rr, fd)) > 0; ci+=n)
            fwrite(fstr, sizeof(char), n, fp);
         fclose(fd);
      }
      else {
         if ((*statstr)->_STDIN_BUFSIZ_) {
            if (setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char *)&((*statstr)->_STDIN_BUFSIZ_), sizeof((*statstr)->_STDIN_BUFSIZ_)) < 0) {
               fprintf(stderr, "** setsockopt: %s\n", _PFTP_ERROR_ARRAY_);
               exit(1);
            }
         }
         for (ci=0; (c = fgetc(fd)) != EOF; ci++) fputc(c, fp);
      }

      fflush(stderr);
      if ((ci == (unsigned long)buf.st_size) || (*statstr)->_STANDARD_INPUT_) {
         if ((*statstr)->lol) fprintf(stderr, "\r");
         fprintf(stderr, "--> %s (%ld bytes) sent to %s.\n",
         (*statstr)->_STANDARD_INPUT_ ? "Stream": (*argv), ci, hostname);
      }
      else {
         /*
          * Though the network buffer is probably too big.
          */
         fprintf(stderr, "** Sending %s to %s failed!\n", (*statstr)->_STANDARD_INPUT_ ? "stream": (*argv), hostname);
         if (pftplog) {
            if ((fe = fopen(pftplog, "a")) != NULL) {
               fprintf(fe, "** Sending %s to %s failed!\n", (*statstr)->_STANDARD_INPUT_ ? "stream": (*argv), hostname);
               fclose(fe);
            }
         }
      }
   }
   fflush(fp);
}
