/*  VER 166   TAB P   $Id: getarticle.c,v 1.2 1997/08/14 13:39:43 src Exp $
 *
 *  fetch articles via an NNTP server
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "statistics.h"
#include "nntp.h"

long bytes_in_spool; /* external: number of bytes read */
long latest_where;   /* external: last article read OK */

/* 
 *  BUG: this can be a real memory hog
 *  BUG: perhaps we should have had a maxlimit here...
 */
char *temp_store = 0;
long temp_len = 0;
#define TEMP_STEP 100000 /* BUG: tuneable? */

static char cur_group[80]; /* for error reporting */
static int no_stat = 0; /* for hosts that lack a STAT */

/*
 *  read an article proper
 *  and feed it to the spool
 *  return false on errors that mean we should not continue
 */
static int 
read_article(void)
{
    char line[NNTP_STRLEN+1];
    char buf[40];
    int newline = 1;
    long len;
    long bytecount = 0L; /* BUG: */

    line[NNTP_STRLEN] = '\0'; /* better safe than sorry */

    /* fetch the article, header and body */
    for (;;) {
	if (!get_server_msg(line, NNTP_STRLEN)) {
	    /* timeout: simply give up */
	    return 0;
	}
	len = strlen(line);
	gross_bytecount += len;

	/* end of file */
	if (newline && line[0]=='.' && (line[1]=='\r' || line[1]=='\n')) break;

	/* find and strip newlines */
	newline = 0;
	while (len > 0 && (line[len-1]=='\r' || line[len-1]=='\n')) {
	    /* fix by: "J. Richard Sladkey" <jrs@foliage.com> */
	    if (line[len-1]=='\n') newline=1;
	    --len;
	}
	if (bytecount+len+newline > temp_len) {
	     /* there is not enough room */
	     temp_store = temp_store ? realloc(temp_store,temp_len+TEMP_STEP)
				     : malloc(TEMP_STEP);
	     if (!temp_store) {
		 log_msg(L_ERR,"out of memory");
		 return 0;
	     }
	     temp_len += TEMP_STEP;
	}
	if (len > 0) memcpy(temp_store+bytecount,line,len);
	bytecount += len;
	if (newline) temp_store[bytecount++] = '\n';
    }
    sprintf(line," writing %ld bytes", bytecount);
    progtitle2(cur_group, line);

    if (!write_in_coming(temp_store,bytecount)) return 0;

    bytes_in_spool += bytecount;
    net_bytecount += bytecount;
    ++fetched_articles;

    return 1;
}

/*
 *  fetch current article proper
 *  return false if no point in continuing
 */
static int 
handle_article(char *status, long where)
{
    int ok;
    long a;
    char *endptr;

    switch (strtoul(status,&endptr,10)) {
    case OK_ARTICLE:			/* article OK */
	/* BUG: verify article number against outstanding requests... */
	a = strtoul(endptr,&endptr,10); /* verify article number */
	if (a != where) {
	    if (a==0 && window <= 1) {
		/* OK, we'll allow it - presumably a non-conforming server */
		static told = 0;
		if (!told) {
		    log_msg(L_INFO,"no article number in ARTICLE response: %s",
								       status);
		    told = 1;
		}
	    } else {
		log_msg(L_ERR,"ARTICLE %ld out of phase: %s", where, status);
		return 0;
	    }
	}
	if (ok = read_article()) {
	    /* article is presumably OK */
	    latest_where = where;
	    if (debug_opt == 2) {
		/* show that something is happening */
		fputc('.',stderr);
		fflush(stderr);
	    }
	}
	return ok;

    case ERR_NOARTIG:			/* no such article in group */
    case ERR_NOART:			/* no such article */
	/* BUG: message does not contain an article number... */
	progtitle2(cur_group, ", no article");
	/* article has disappeared, ignore it */
	log_msg(L_DEBUG,"article in %s disappeared: %s",cur_group,status);
	latest_where = where;
	return 1;

    case OK_HEAD:			/* not complete... */
    case OK_BODY:			/* not complete... */
    case OK_NOTEXT:			/* not complete... */
    case ERR_NCING:			/* not in group */
    case ERR_NOCRNT:			/* nothing selected */
	/* should not happen... */
    default:				/* otherwise, protocol error */
	progtitle2(cur_group, ", error");
	log_msg(L_ERR,"NNTP article read error: got \"%s\"", status);
	/* stop here */
	return 0;
    }
}

/*
 *  fetch current article proper
 *  return false if no point in continuing
 */
static int 
current_article(long where)
{
    char request[NNTP_STRLEN+1];

    if (no_stat) {
	sprintf(request, " %ld", where);
	progtitle2(cur_group, request);
    }

    sprintf(request, "ARTICLE %ld%s", where, newline);

    return put_request(request,handle_article,where);
}

/*
 *  handle article STAT result	
 */
static int 
handle_stat(char *status,long where)
{
    char msgid[NNTP_STRLEN+1];
    long a;
    char *endptr;

    switch (strtoul(status,&endptr,10)) {
    case OK_NOTEXT:			/* follows STAT... */
	/* 223 3800 <jeqk9rzgqa4.fsf@storm.stud.ntnu.no> status */
	if (sscanf(endptr,"%ld %[^ \n\t]",&a,msgid) != 2) {
	    log_msg(L_ERR,"bad STAT reponse: %s", status);
	    return 0;
	}
	if (a != where) {
	    log_msg(L_ERR,"STAT %ld out of phase: %s", where, status);
	    return 0;
	}
	/* check if already in news history database */
	if ((!history || history[0]) && history_lookup(msgid)) {
	    ++history_articles;
	    latest_where = where;
	    return 1;
	}
	/* check if read already */
	if (!new_msgid(msgid)) {
	    ++already_articles;
	    latest_where = where;
	    return 1;
	}
	/* check if triggered by message ID filter */
	if (do_mfilter(msgid)) {
	    ++mfilter_articles;
	    latest_where = where;
	    return 1;
	}
	/* BUG: have max file size?? */

	log_msg(L_DEBUG4,"fetching article %ld",where);
	return current_article(where);

    case ERR_COMMAND:			/* STAT is not implemented */
	progtitle2(cur_group, ", no STAT");
	log_msg(L_INFO,"server lacks STAT command: %s",status);
	no_stat = 1;
    case 99:
	log_msg(L_DEBUG4,"unconditionally fetching article %ld",where);
	return current_article(where);

    case ERR_NOARTIG:			/* no such article in group */
    case ERR_NOART:			/* no such article */
	progtitle2(cur_group, ", no article");
	/* article no longer there, ignore it */
	log_msg(L_DEBUG,"article %ld in %s not on server",where,cur_group);
	return 1;

    case OK_ARTICLE:			/* follows ARTICLE... */
    case OK_HEAD:			/* follows HEAD... */
    case OK_BODY:			/* follows BODY... */
    case ERR_NCING:			/* not in group */
    case ERR_NOCRNT:			/* nothing selected */
	/* should not happen... */
    default:				/* otherwise, protocol error */
	progtitle2(cur_group, ", STAT error");
	log_msg(L_ERR,"NNTP article read error: got \"%s\"", status);
	/* stop here */
	return 0;
    }
}

/*
 *  fetch an article in current group
 *  return false if no point in continuing
 */
int 
fetch_article(long where)
{
    char request[NNTP_STRLEN+1];
    char status[NNTP_STRLEN+1];

    if (no_stat) {
	sprintf(status,"%d",99);
	return handle_stat(status,where);
    }

    /* enquire article status and message ID */
    sprintf(request, " %ld", where);
    progtitle2(cur_group, request);

    sprintf(request, "STAT %ld%s", where,newline);
    
    return put_request(request,handle_stat,where);
}

/*
 *  select a group		
 *  return 1 if OK, 0 if no group, -1 if no point in continuing
 */
static int 
handle_group(char *status,char *group,long *firstp,long *lastp)
{
    int ok = 0;
    long msgs;
    char *endptr;

    switch (strtoul(status,&endptr,10)) {
    case OK_GROUP:			/* Group selected */
	if (sscanf(endptr,"%ld %ld %ld",&msgs,firstp,lastp) != 3) {
	    log_msg(L_ERR,"group select bad format: \"%s\"", status);
	    return -1;
	}
	++fetched_groups;
	return 1;

    case ERR_NOGROUP:			/* server haven't seen it before */
	log_msg(L_ERR,"server does not carry group \"%s\"", group);
	return 0;

    case ERR_NOAUTH:			/* server won't allow us in here */
	log_msg(L_ERR,"authorization required for group \"%s\"", group);
	return 0;

    default:				/* otherwise, protocol error */
	log_msg(L_ERR,"NNTP group select protocol error: got \"%s\"", status);
	return -1;
    }
}

/*
 *  select a group		
 *  return 1 if OK, 0 if no group, -1 if no point in continuing
 */
int 
select_group(char *group,long *firstp,long *lastp)
{
    int ok = 0;
    long msgs;
    char request[NNTP_STRLEN+1];
    char status[NNTP_STRLEN+1];

    strncpy(cur_group,group,sizeof(cur_group)-1); /* for error reporting */
    progtitle(cur_group);

    sprintf(request, "GROUP %s%s", group,newline);

    if (!put_server_msg(request)) {
	return -1;
    }

    /* get status */
    if (!get_server_nntp(status, sizeof(status))) {
	/* timeout */
	return -1;
    }
    return handle_group(status,group,firstp,lastp);
}
