/*  VER 063  TAB P   $Id: logmsg.c,v 1.2 1997/08/14 13:39:44 src Exp $
 *
 *  handle error messages and such...
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 */

#include "common.h"
#include "proto.h"
#include "options.h"

#include <errno.h>

#if HAVE_SYSLOG_H
#  include <syslog.h>
#endif

/*
 *  NOTE: we conveniently avoid including "proto.h"
 *	  here, so that it doesn't crash with the log_msg()
 *	  definition if we must use varargs.h
 */
#if HAVE_VPRINTF
#  if HAVE_STDARG_H
#    include <stdarg.h>
#  else
#    if HAVE_VARARGS_H
#      include <varargs.h>
#      define USE_VA_ALIST 1
#    else
#      undef HAVE_VPRINTF /* we don't know how to use it anyway */
#    endif
#  endif
#endif

/*
 *  open log facility
 */	
void 
log_open(void)
{
    /* open syslog if required */
#if HAVE_SYSLOG_H
#  ifdef LOG_NEWS
    openlog(pname, LOG_PID, LOG_NEWS);
#  else
#    ifdef LOG_USER
    openlog(pname, LOG_PID, LOG_USER);
#    else
    /* openlog is not really required - syslog will do it for us */
#    endif
#  endif
#endif
}

/*
 *  log a message   
 *
 *  the type is:
 *    L_ERR	syslog LOG_ERR
 *    L_ERRno	syslog LOG_ERR, consult errno
 *    L_INFO	syslog LOG_INFO
 *    L_DEBUG	 debug
 *    L_GET	 debug, w/crlf
 *    L_PUT	 debug, w/crlf
 */	
#if HAVE_VPRINTF
#  if USE_VA_ALIST
void 
log_msg(type, va_alist)
    int type;
    va_dcl
#  else
void 
log_msg(int type, char *fmt, ...)
#  endif
#else
void 
log_msg(int type, char *fmt, char *arg1,char *arg2,char *arg3,char *arg4)
#endif
{
    int e;
    char buf[BUFSIZ]; /* BUG: do we risk overwriting it? */

#if HAVE_VPRINTF
#  if USE_VA_ALIST
    /* traditional method */
    va_list ap;
    char *fmt;
    va_start(ap);
    fmt = va_arg(ap,char *);
#  else
    /* ANSI method, HAVE_STDARG_H */
    va_list ap;
    va_start(ap, fmt);
#  endif
#else
    /* 
     *	try to make a surrogate 
     *	we assume that on those architectures where this trick
     *	doesn't work there we will surely have stdarg.h or varargs.h
     */
#define vsprintf(buf, fmt, ap) sprintf(buf, fmt, arg1, arg2, arg3, arg4)
#endif

    switch (type) {
    default:
    case L_ERRno:
    case L_ERR:
	e = errno;
	vsprintf(buf, fmt, ap);
#if HAVE_STRERROR
	if (type == L_ERRno) {
	    sprintf(buf + strlen (buf), ": %s", strerror(e));
	}
#endif
	strcat(buf, "\n");
#if HAVE_SYSLOG_H
	if (!debug_opt) {
	    syslog(LOG_ERR, buf);
	} else 
#endif
	{
	    fprintf(stderr, "%s: %s", pname, buf);
	    fflush(stderr);
	}
	break;

    case L_INFO:
	vsprintf(buf, fmt, ap);
	strcat(buf, "\n");
#if HAVE_SYSLOG_H
	if (!debug_opt) {
	    syslog(LOG_INFO, buf);
	} else 
#endif
	{
	    fprintf(stderr, "%s", buf);
	    fflush(stderr);
	}
	break;

    case L_GET:
	if (debug_opt >= 3) {
	    vsprintf(buf, fmt, ap);
	    fprintf(stderr, "<- %s", buf);
	    fflush(stderr);
	}
	break;

    case L_PUT:
	if (debug_opt >= 3) {
	    vsprintf(buf, fmt, ap);
	    fprintf(stderr, "-> %s", buf);
	    fflush(stderr);
	}
	break;

    case L_DEBUG4:
	if (debug_opt < 4) break;
    case L_DEBUG: 
	if (debug_opt >= 1) {
	    vsprintf(buf, fmt, ap);
	    fprintf(stderr, "%s\n", buf);
	    fflush(stderr);
	}
	break;
    }
#if HAVE_VPRINTF
    va_end(ap);
#endif
}

