# MkMain.tcl: Main-Menu of X-CD-Roast
# 21.3.97 tn


# prepare main-root-window

proc MkMainWindow { w } {
global XCDR_VERSION
global CDRICO

	toplevel $w

	wm title $w "X-CD-Roast $XCDR_VERSION"
	wm iconbitmap $w @$CDRICO
	wm geometry $w 830x540

	#set frame1 [MkMainMenu $w]
	set frame3 [MkMainStatus $w]
	set frame2 [MkMainNoteBook $w]

	#pack $frame1 -side top -fill x
	pack $frame3 -side bottom -fill x
	pack $frame2 -side top -expand yes -fill both -padx 4 -pady 4

}

proc MkMainMenu { top } {

	set w [frame $top.f1 -bd 2 -relief raised]
	
	menubutton $w.file -menu $w.file.m -text File -underline 0 \
		-takefocus 0
	menubutton $w.opt -menu $w.opt.m -text Options -underline 0 \
		-takefocus 0
	menubutton $w.help -menu $w.help.m -text Help -underline 0 \
		-takefocus 0

	menu $w.file.m
	$w.file.m add command -label "Open ... " -underline 1 \
		-accelerator "Ctrl+O"
	$w.file.m add sep
	$w.file.m add command -label "Exit     " -command exit -underline 1 \
		-accelerator "Ctrl+X"

	menu $w.opt.m
	$w.opt.m add sep

	menu $w.help.m
	$w.help.m add command -label "About" -underline 1 \
		-accelerator "Ctrl+A"

	pack $w.file $w.opt -side left
	pack $w.help -side right 

	bind all <Control-x> "exit"

	return $w
}


proc MkMainStatus {top} {
global statusbar

	set w [frame $top.f3 -relief raised -bd 1]
	set statusbar \
	[label $w.status -font -*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*\
	-relief sunken -bd 1]

	button $w.help -font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"\
		-text "Help" -bd 1 -command "spawnhelp .help"

	tixForm $statusbar -padx 3 -pady 3 -left 0 -right %70
	tixForm $w.help -padx 3 -right %100
	return $w
}


proc MkMainNoteBook { top } {
global statusbar
global sidebar
global maincanv

	set w [frame $top.f2]
	
	frame $w.l -relief raised -bd 1 
	tixForm $w.l -left 0 -right %20 -bottom %100 -top %0
	set sidebar $w.l

	frame $w.r -relief raised -bd 1 
	tixForm $w.r -fill both -bottom %100 -top %0 -left %20 -right %100

	# contains the path to the main-window
	set maincanv $w.r

	mainsidebar
	MkSub 0 $maincanv $sidebar.all

	return $w
}


# draw sidebar

proc mainsidebar { } {
global sidebar 
global statusbar
global maincanv
global forcesetup

	set w $sidebar.all
	catch { destroy $w }
	frame $w
	pack $w -expand 1 -fill both

	button $w.b1 -text "SCSI/IDE-Info" -command "MkSub 1 $maincanv $w"
	button $w.b2 -text "Setup" -command "MkSub 2 $maincanv $w"
	button $w.b3 -text "Copy Data-CD" -command "MkSub 3 $maincanv $w"
	button $w.b4 -text "Copy Audio-CD" -command "MkSub 4 $maincanv $w"
	button $w.b5 -text "Master CD" -command "MkSub 5 $maincanv $w"
	button $w.b6 -text "Exit" -command "exit"
	tixForm $w.b1 -top %10 -left %10 -right %90
	tixForm $w.b2 -top %20 -left %10 -right %90
	tixForm $w.b3 -top %30 -left %10 -right %90
	tixForm $w.b4 -top %40 -left %10 -right %90
	tixForm $w.b5 -top %50 -left %10 -right %90
	tixForm $w.b6 -top %65 -left %10 -right %90

	tixBalloon $w.bal1 -state status -statusbar $statusbar -initwait 0
	$w.bal1 bind $w.b1 -msg "Shows all SCSI- and IDE-devices available on the system"
	tixBalloon $w.bal2 -state status -statusbar $statusbar -initwait 0
	$w.bal2 bind $w.b2 -msg "Setup your hardware"
	tixBalloon $w.bal3 -state status -statusbar $statusbar -initwait 0
	$w.bal3 bind $w.b3 -msg "Copy a Data-CD"
	tixBalloon $w.bal4 -state status -statusbar $statusbar -initwait 0
	$w.bal4 bind $w.b4 -msg "Copy or create an Audio-CD"
	tixBalloon $w.bal5 -state status -statusbar $statusbar -initwait 0
	$w.bal5 bind $w.b5 -msg "Master a Data-CD"
	tixBalloon $w.bal6 -state status -statusbar $statusbar -initwait 0
	$w.bal6 bind $w.b6 -msg "Quit X-CD-Roast"

	catch { destroy $maincanv.all }
	frame $maincanv.all
	pack $maincanv.all -expand 1 -fill both
	MkSub 0 $maincanv $w

	# if setup is forced, lock all other options
	if { $forcesetup == 1 } {
		$w.b3 config -state disabled
		$w.b4 config -state disabled
		$w.b5 config -state disabled
	}	

}


proc MkSub { id w but } {
global scsidevices
global XCDR_VERSION

	catch { destroy $w.all }
	frame $w.all
	pack $w.all -expand 1 -fill both
	set m $w.all

	deactivebutton $but.b1
	deactivebutton $but.b2
	deactivebutton $but.b3
	deactivebutton $but.b4
	deactivebutton $but.b5

	if { $id == 0 } {
		MkMainLogo $m
	}
	if { $id == 1 } {
		activebutton $but.b1
		MkInfo $m
	}
	if { $id == 2 } {
		activebutton $but.b2
		MkSetup $m
	}
	if { $id == 3 } {
		activebutton $but.b3
		MkDataCopy $m
	}
	if { $id == 4 } {
		activebutton $but.b4
		MkAudioCopy $m
	}
	if { $id == 5 } {
		activebutton $but.b5
		MkMaster $m
	}
}

proc MkMainLogo { w } {
global XCDR_VERSION
global TRANSPARENT_GIF_COLOR
global LOGOICO
global DISCLAIMACCEPTED
global XCDR_DISCLAIMERDONTSHOWAGAIN
global QUICKLOAD
global SUB_VERSION
global RELEASE_DATE

#	label $w.title -font "-*-times-bold-r-normal-*-18-*-*-*-*-*-*-*" \
#		-bd 0 -width 30 -anchor c \
#		-text "Welcome to X-CD-Roast $XCDR_VERSION"
#	pack $w.title -expand 1 -fill both

	uplevel #0 set TRANSPARENT_GIF_COLOR [$w cget -bg] 

	# Load title-screen into memory
	if { $QUICKLOAD == 0 } {
		image create photo xcdrlogo -file $LOGOICO 

		label $w.logo -image xcdrlogo
		pack $w.logo
	} else {
		label $w.title -text "X-CD-Roast"
		pack $w.title -pady 100
	}

	if { $SUB_VERSION != "" } {
		set addstr "- $SUB_VERSION"
	} else {
		set addstr ""
	}

	# here we need a 100dpi-font...not everybody got these installed,
	# so I use a safety hook
	set ok [catch { label $w.ver -text "Version $XCDR_VERSION $addstr" \
		-font "-*-times-bold-i-*-*-*-240-100-100-*-*-*-*" \
		-anchor c -fg red } ]

	# the above command failed...so lets try the default font
	if { $ok != 0 } {
	label $w.ver -text "Version $XCDR_VERSION $addstr" \
		-anchor c -fg red
	}

	pack $w.ver

	label $w.name -text "by Thomas Niederreiter" \
		-anchor c -fg black
	label $w.name2 -text "$RELEASE_DATE" \
		-anchor c -fg black

	pack $w.name $w.name2 

	message $w.inc -text "                  Includes:\n cdrecord-1.6 by Jrg Schilling\nmkisofs-1.12b3 by Eric Youngdale" -width 300
	pack $w.inc -side bottom -anchor c -padx 40

	if { $DISCLAIMACCEPTED == "" && $XCDR_DISCLAIMERDONTSHOWAGAIN != 1 } {
		set DISCLAIMACCEPTED ok
		show_disclaimer .disclaim $w
	}
	
}


# show the disclaimer

proc show_disclaimer { w wold } {
global XCDR_DISCLAIMERDONTSHOWAGAIN

	# wait until the main-window is drawn
	update

	set oldf [createsubwindow $w .root 0 "" ]

	# position of mainwindow
        set oldpx [winfo x .root]
        set oldpy [winfo y .root]
	wm geometry $w +[expr $oldpx + 220]+[expr $oldpy + 295]

	label $w.1 -text "DISCLAIMER" -anchor c
	pack $w.1 -pady 5

	message $w.m -width 550  \
	-font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"\
	-text \
"You're going to have to use this at your own risk, I am not responsible\
for any damage done by this program.\nFor\
example, If after installing this software, you sit back in your easy\
chair to burn a CD, and you slide backwards slightly, bumping the table\
behind you, which knocks a radio into the pool right outside your computer\
room, killing the people in the pool, causing a massive short, which blacks\
out the entire city, but not after causing the power plant supplying your\
area with power, which just happens to be on a well known fault line, to\
explode, causing a massive earthquake, which sends California into the\
ocean.... IT'S NOT MY FAULT!!!  \n\
(This disclaimer was stolen from someone, so credits go to that unknown\
person)"

	pack $w.m -fill x -expand 1

       	canvas $w.c0 -height 0 -width 550 -relief sunken -borderwidth 1
        pack $w.c0 -pady 1

	checkbutton $w.cb -text "Don't show this disclaimer again" \
		-font "-*-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*" \
		-variable XCDR_DISCLAIMERDONTSHOWAGAIN
	pack $w.cb 	

	button $w.b -text "Accept" \
		-command "destroysubwindow $w .root {$oldf} 2"
	button $w.b2 -text "Exit" \
		-command "exit"

	pack $w.b $w.b2 -side left -expand 1 -fill both

}


