#include <stdio.h>
#include <libgus.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <malloc.h>
#include <assert.h>

#if 0
#define PRELOAD_ALL
#endif
#define INPUT_DEVICE	GUS_MIDID_UART
#define OUTPUT_DEVICE	(GUS_MIDID_SYNTH+0x00)
#if 1
#define PROGRAM		GUS_MIDI_PROGRAM( 0, 0 )
#else
#define PROGRAM		GUS_MIDI_PROGRAM( 48, 216 )
#endif

static int pgm;
static int global_tick;

static void input_note_on( void *private, int device, int chn, int note, int vel )
{
  printf( "= %i => note on - device = %i, chn = %i, note = %i, vel = %i\n", global_tick, device, chn, note, vel );
}

static void input_note_off( void *private, int device, int chn, int note, int vel )
{
  printf( "= %i => note off - device = %i, chn = %i, note = %i, vel = %i\n", global_tick, device, chn, note, vel );
}

static void input_note_pressure( void *private, int device, int chn, int note, int vel )
{
  printf( "= %i => note pressure - device = %i, chn = %i, note = %i, vel = %i\n", global_tick, device, chn, note, vel );
}

static void input_channel_pressure( void *private, int device, int chn, int vel )
{
  printf( "= %i => channel pressure - device = %i, chn = %i, vel = %i\n", global_tick, device, chn, vel );
}

static void input_bender( void *private, int device, int chn, int bender )
{
  printf( "= %i => bender - device = %i, chn = %i, bender = %i\n", global_tick, device, chn, bender );
}

static void input_program_change( void *private, int device, int chn, int program )
{
#ifndef PRELOAD_ALL
  if ( gus_midi_output_device( OUTPUT_DEVICE ) -> cap & GUS_MIDI_CAP_MEMORY )
    {
      int old_pgm = pgm;
      gus_instrument_t instr;

      if ( chn != 9 )
        {
          gus_midi_timer_stop();
          pgm = program;
          printf( ">>>> Loading instrument %i/%i... ", pgm >> 16, pgm & 0xffff ); fflush( stdout );
          memset( &instr, 0, sizeof( instr ) );
          instr.number.instrument = old_pgm;
          gus_midi_memory_free( OUTPUT_DEVICE, &instr );
          gus_midi_preload_program( OUTPUT_DEVICE, &pgm, 1 );
          printf( "Done...\n" );
          gus_midi_program_change( OUTPUT_DEVICE, chn, pgm );
          gus_midi_write();
          gus_midi_timer_start();
        }
    }
#endif
  printf( "= %i => program change - device = %i, chn = %i, program = %i\n", global_tick, device, chn, program );
}

static void input_control( void *private, int device, int chn, int p1, int p2 )
{
  printf( "= %i => control - device = %i, chn = %i, p1 = %i, p2 = %i\n", global_tick, device, chn, p1, p2 );
}

static void input_sysex( void *private, int device, unsigned char *data, int len )
{
  int i;

  printf( "= %i => sysex - device = %i, len = %i\n", global_tick, device, len );
  for ( i = 0; i < len; i++ )
    printf( "%02x:", data[ i ] );
  printf( "\n" );
}

static void input_echo( void *private, unsigned char *data, int len )
{
  if ( len == sizeof( int ) )
    global_tick = *(int *)data;
}

static void input_wait( void *private, unsigned int tick )
{
  printf( "= %i => wait ticks = %i\n", global_tick, tick );
}

static void input_mtc_quarter( void *private, int device, int quarter )
{
  printf( "= %i => mtc quarter - device = %i, quarter = %i\n", global_tick, device, quarter );
}

static void input_song_select( void *private, int device, int song )
{
  printf( "= %i => song select - device = %i, song = %i\n", global_tick, device, song );
}

static void input_song_position( void *private, int device, int position )
{
  printf( "= %i => song position - device = %i, position = %i\n", global_tick, device, position );
}

static void input_tune_request( void *private, int device )
{
  printf( "= %i => tune request - device = %i\n", global_tick, device );
}

static void input_start( void *private, int device )
{
  printf( "= %i => sequencer start - device = %i\n", global_tick, device );
}

static void input_continue( void *private, int device )
{
  printf( "= %i => sequencer continue - device = %i\n", global_tick, device );
}

static void input_stop( void *private, int device )
{
  printf( "= %i => sequencer stop - device = %i\n", global_tick, device );
}

static gus_midi_callbacks_t midi_input_callbacks = {
  17,
  NULL,
  input_note_on,
  input_note_off,
  input_note_pressure,
  input_channel_pressure,
  input_bender,
  input_program_change,
  input_control,
  input_sysex,
  input_echo,
  input_wait,
  input_mtc_quarter,
  input_song_select,
  input_song_position,
  input_tune_request,
  input_start,
  input_continue,
  input_stop,
};

void main()
{
  int midi_fd, i;
  int local_tick;
  gus_midi_device_t *device_in, *device_out;
  fd_set read_fds, write_fds;
  struct GUS_STRU_EFFECT effect;
  
  device_out = malloc( sizeof( gus_midi_device_t ) );
  device_in = malloc( sizeof( gus_midi_device_t ) );
  assert( device_out );
  assert( device_in );
  device_out -> device = OUTPUT_DEVICE;
  device_out -> mode = GUS_MIDI_OPEN_MODE_WRITE;
  device_out -> channels = 0xffff;	/* not used here - only with GUS_MIDID_COMMON device */
  device_out -> midi_device = 0x10;
  device_out -> emulation = GUS_MIDI_EMUL_AUTO;
  device_out -> next = device_in;
  device_in -> device = INPUT_DEVICE;
  device_in -> mode = GUS_MIDI_OPEN_MODE_READ;
  device_in -> channels = 0xffff;		/* not used for input routines */
  device_in -> midi_device = 0x10;
  device_in -> emulation = GUS_MIDI_EMUL_AUTO;
  device_in -> next = NULL;

  if ( gus_midi_open( GUS_MIDI_BOTH, device_out, 2048, 0 ) < 0 )
    {
      printf( "open error: %s\n", gus_midi_error );
      return;
    }
  pgm = PROGRAM;
  gus_midi_emulation_set( OUTPUT_DEVICE, GUS_MIDI_EMUL_GS );
  if ( gus_midi_output_device( OUTPUT_DEVICE ) -> cap & GUS_MIDI_CAP_SYNTH )
    {
      gus_info_t info;
      
      assert( !gus_midi_synth_info( OUTPUT_DEVICE, &info ) );
      if ( info.flags & GUS_STRU_INFO_F_ENHANCED )
        {
          gus_effect_interwave( &effect, GUS_EFFECT_INTERWAVE_1_HALL2, GUS_EFFECT_INTERWAVE_3_CHORUS3 );
          gus_midi_effect_setup( OUTPUT_DEVICE, &effect );
        }
    }
#ifndef PRELOAD_ALL
  gus_midi_preload_program( OUTPUT_DEVICE, &pgm, 1 );
#else
  gus_midi_preload_bank( OUTPUT_DEVICE, "ALL" );
#endif
  gus_midi_reset();
  for ( i = 0; i < 16; i++ )
    if ( i != 9 )
      {
        gus_midi_control( OUTPUT_DEVICE, i, GUS_MCTL_MSB_BANK, GUS_MIDI_PROGRAM_BANK( pgm ) );
        gus_midi_program_change( OUTPUT_DEVICE, i, GUS_MIDI_PROGRAM_PROG( pgm ) );
      }
#if 1
  gus_midi_program_change( OUTPUT_DEVICE, 9, 32 );
#endif
  gus_midi_write();
  printf( "Ready.\n" );
  gus_midi_timer_tempo( 100 );		/* 100Hz */
  gus_midi_timer_start();
  gus_midi_threshold( 70 );		/* midi threshold */
  local_tick = global_tick = 0;
  midi_fd = gus_midi_get_handle();
  /*
   * It's very easy...
   *   SET MIDI THRU from INPUT_DEVICE channel INPUT_CHANNEL
   *                 to   OUTPUT_DEVICE channel 0 velocity <don't change>
   * You can set midi thru from one source to (GUS_MIDID_LAST + 1) destonations..
   */
#if 1
  for ( i = 0; i < 16; i++ )
    assert( !gus_midi_thru_channel_set( INPUT_DEVICE, i, OUTPUT_DEVICE, i, 255 ) );
#else
  gus_midi_thru_channel_set( INPUT_DEVICE, INPUT_CHANNEL, OUTPUT_DEVICE, 0, 127 );
#endif
  while ( 1 )
    {
      FD_ZERO( &read_fds );
      FD_ZERO( &write_fds );
      FD_SET( midi_fd, &read_fds );
      FD_SET( midi_fd, &write_fds );
      select( midi_fd + 1, &read_fds, &write_fds, NULL, NULL );
      if ( FD_ISSET( midi_fd, &read_fds ) )
        gus_midi_input( &midi_input_callbacks );
      if ( FD_ISSET( midi_fd, &write_fds ) )
        {
          gus_midi_echo( (char *)&local_tick, sizeof( local_tick ) );
          local_tick++;
          gus_midi_wait( 5 );
          gus_midi_write();
        }
    }
  gus_midi_timer_stop();
  gus_midi_close();
}
