#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libgus.h>

#define FROM_CARD	0
#define TO_CARD		0

#define ENV_TYPE	1
#define ENV_TEST	4

int i;
static int cards;

void main()
{
  int card, i;
  unsigned char *ptr;
  FILE *in;
  gus_instrument_t instr;
  gus_layer_t layer;
  gus_wave_t wave;

/*
 *  at first - load wave to memory
 */

  ptr = malloc( 11492 - 0x50 );
  if ( ( in = fopen( "brass.smp", "rb" ) ) == NULL )
    {
      printf( "File brass.smp needed...\n" );
      return;
    }
  fseek( in, 0x50, SEEK_SET );
  fread( ptr, 11492 - 0x50, 1, in );
  fclose( in );

/*
 *  fill download structure with right values
 */

  memset( &instr, 0, sizeof( instr ) );
  memset( &layer, 0, sizeof( layer ) );
  memset( &wave, 0, sizeof( wave ) );

  instr.info.layer = &layer;
  layer.wave = &wave;

  instr.mode = layer.mode = wave.mode = GUS_INSTR_SIMPLE;
  wave.begin.ptr = ptr;
  wave.format = GUS_WAVE_LOOP | GUS_WAVE_UNSIGNED;
  wave.loop_start = 4011 << 4;
  wave.loop_end = 11400 << 4;
  wave.size = 11412;
  
  /* ultraclick elimination !!!! it's very important!!! */

  ptr[ 11400 ] = ptr[ 4011 ];

/*
 *  simple test if we have GUS card(s)
 */
    
  if ( ( cards = gus_cards() ) < 0 )
    {
      printf( "No GUS card found..\n" );
      return;
    }

/*
 *  open all possible GUS cards
 */

  for ( card = FROM_CARD; card < cards; card++ )
    {
      if ( gus_open( card, 4096, 0 ) < 0 )
        {
          printf( "Error by open card #%i\n", card );
          continue;
        }
      gus_queue_write_set_size( 256 );			/* write queue in items */

      /* time to reset GF1 chip and select number of voices and instruments */
      
      gus_reset( 14, 0x00000000 );	/* voices, dynamic voices */

      /* download sample to GUS DRAM (this maybe used during playing, too) */
      
      if ( gus_memory_alloc( &instr ) < 0 )
        {
          printf( "Download error?\n" );
          continue;
        }
        
      /* start the timer */
        
      gus_timer_tempo( 100 );	/* tempo - 100Hz */
      gus_timer_start(); 
    }
    
  for ( card = FROM_CARD; card <= TO_CARD; card++ )
    {
      gus_select( card );		/* select output card */
      
#if 1
      /* start voice with sample #0 at 8000Hz, volume=0, pan=52*64 */
      gus_do_voice_start( 0, 0, 8000, 0, 52 * 64 );
      gus_do_voice_start( 1, 0, 8200, 8162, 124 * 64 );
      gus_do_voice_start( 2, 0, 8200, 8162, 132 * 64 + 63 );
      gus_do_voice_start( 3, 0, 8400, 8162, 203 * 64 + 63 );
      
      for ( i = 0; i < 1024; i++ )
        {
          gus_do_voice_volume( 0, i * 16 );
          gus_do_wait( 1 );		/* wait 1 tick */
        }
      for ( i = 0; i < 1000; i++ )
        {
          gus_do_voice_frequency( 0, 8000 + i * 2 );
          gus_do_wait( 1 );
        }
#if 1
      gus_do_voice_stop( 0, 0x00 );
      gus_do_voice_stop( 1, 0x00 );
      gus_do_voice_stop( 2, 0x00 );
      gus_do_voice_stop( 3, 0x00 );
#endif
      gus_do_wait( 10 * 60 * 1000000 );
#endif
      gus_do_flush();			/* flush command queue to driver */
      gus_queue_flush();
    }

/*
 *  at last - close all cards...
 */

  for ( card = FROM_CARD; card < cards; card++ )
    gus_close( card );
    
  free( ptr );
}

