/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 *  Routines for InterWave ROM control
 */

#include <string.h>
#include "libgus.h"
#include "libgus_local.h"

/*
 *  local functions
 */

int gus_access_synth( void )
{
  return GUS_ACCESS_SYNTH;
}

int gus_access_insman( void )
{
  return GUS_ACCESS_INSMAN;
}

int gus_access_midi( int midi_device )
{
  return GUS_ACCESS_MIDI | ( midi_device & 0xff );
}

/*
 *
 */
 
char *gus_model( int gus_version )
{
  char *pstr;

  switch ( gus_version ) {
    case GUS_CARD_VERSION_CLASSIC:
    case GUS_CARD_VERSION_CLASSIC1:
    case GUS_CARD_VERSION_CLASSIC_ICS:
      pstr = "Gravis UltraSound Classic";
      break;
    case GUS_CARD_VERSION_EXTREME:
      pstr = "Gravis UltraSound Extreme";
      break;
    case GUS_CARD_VERSION_ACE:
      pstr = "Gravis UltraSound ACE";
      break;
    case GUS_CARD_VERSION_MAX:
    case GUS_CARD_VERSION_MAX1:
      pstr = "Gravis UltraSound MAX";
      break;
    case GUS_CARD_VERSION_PNP:
      pstr = "Gravis UltraSound Plug & Play";
      break;
    case GUS_CARD_VERSION_DYNASONIC:
      pstr = "Dynasonic 3-D";
      break;
    default:
      pstr = "Uknown Card";
      break;
  }
  return strdup( pstr );
}

