/*
 *  Copyright (c) by Jaroslav Kysela (Perex soft)
 *  Convert functions
 */

#include "libgus.h"
#include "libgus_local.h"

/*
 *  EXPORTED FUNCTIONS
 */

/*
 *  ----------------- delta
 */

void gus_convert_delta( unsigned int type, unsigned char *dest,
			unsigned char *src, size_t size )
{
  if ( !( type & GUS_WAVE_DELTA ) ) return;
  if ( type & GUS_WAVE_16BIT )
    {
      if ( type & GUS_WAVE_UNSIGNED )	/* unsigned */
        {
          unsigned short wnew = 0;
          
          while ( size-- > 0 )
            {
              put_unsigned_word( dest, wnew = get_unsigned_word( src ) + wnew );
              src += sizeof( wnew );
              dest += sizeof( wnew );
            }
        }
       else
        {
          signed short wnew = 0;
          
          while ( size-- > 0 )
            {
              put_signed_word( dest, wnew = get_signed_word( src ) + wnew );
              src += sizeof( wnew );
              dest += sizeof( wnew );
            }
        }
    }
   else
    {
      if ( type & GUS_WAVE_UNSIGNED )	/* unsigned */
        {
          unsigned char wnew = 0;
          
          while ( size-- > 0 )
            {
              put_unsigned_byte( dest, wnew = get_unsigned_byte( src ) + wnew );
              src += sizeof( wnew );
              dest += sizeof( wnew );
            }
        }
       else
        {
          signed char wnew = 0;

          while ( size-- > 0 )
            {
              put_signed_byte( dest, wnew = get_signed_byte( src ) + wnew );
              src += sizeof( wnew );
              dest += sizeof( wnew );
            }
        }
    }
}

void gus_convert_8bit_to_16bit( unsigned short *dest, unsigned char *src, size_t size )
{
  src += size - 1;
  dest += size - 1;
  while ( size-- > 0 )
    *(dest--) = *(src--);
}
