/*  
 *  This file is part of abc2ps, Copyright (C) 1996,1997 Michael Methfessel
 *  See file abc2ps.c for details.
 */
 
/*  subroutines connected with output of music  */


/* ----- nwidth ----- */
/* Sets the prefered width for a note depending on the duration.
   Return value is default space on right and left side. 
   Function is determined by values at 0, 1/2, 1.
   Return value is 1.0 for quarter note. */
float nwidth (len)
int len;
{
  float a,b,x,p,x0,p0;

  a=2*(f1p-2*f5p+f0p);
  b=f1p-f0p-a;
  x = (float)len/(float)BASE;
  p = a*x*x + b*x + f0p;

  x0 = 0.25;
  p0 = a*x0*x0 + b*x0 + f0p;
  p  = p/p0;

/*  printf (" nwid  l 1/%d w %.3f\n", BASE/len, p);  */
  return p;
}

/* ----- xwidth -- --- */
/* same as nwidth but for stretched system */
float xwidth (len)
int len;
{
  float a,b,x,p,x0,p0;

  a=2*(f1x-2*f5x+f0x);
  b=f1x-f0x-a;
  x = (float)len/(float)BASE;
  p = a*x*x + b*x + f0x;

  x0 = 0.25;
  p0 = a*x0*x0 + b*x0 + f0x;
  p  = p/p0;

  return p;
}

/* ----- followed_by_note ------ */
int followed_by_note (k)
int k;
{
  int i;
  
  for (i=k+1;i<nsym;i++) {
    switch (sym[i].type) {
    case INVISIBLE:
      break;
    case NOTE: 
    case REST:
      return i;
      break;
    default:
      return -1;
    }
  }
  return -1; 
}

/* ----- preceded_by_note ------ */
int preceded_by_note (k)
int k;
{
  int i;
  
  for (i=k-1;i>=0;i--) {
    switch (sym[i].type) {
    case INVISIBLE:
      break;
    case NOTE: 
    case REST:
      return i;
      break;
    default:
      return -1;
    }
  }
  return -1; 
}

void xch (i,j)  /* sub to exchange two integers */
int *i,*j;
{
  int k;
  k=*i;
  *i=*j;
  *j=k;
}



/* ----- print_linetype ----------- */
void print_linetype (t)
int t;
{

  if      (t== COMMENT)           printf("COMMENT\n");
  else if (t== MUSIC)             printf("MUSIC\n"); 
  else if (t== TO_BE_CONTINUED)   printf("TO_BE_CONTINUED\n");
  else if (t== E_O_F)             printf("E_O_F\n");
  else if (t== INFO)              printf("INFO\n");             
  else if (t== TITLE)             printf("TITLE\n");            
  else if (t== METER)             printf("METER\n");  
  else if (t== PARTS)             printf("PARTS\n");  
  else if (t== KEY)               printf("KEY\n");  
  else if (t== XREF)              printf("XREF\n");     
  else if (t== DLEN)              printf("DLEN\n");  
  else if (t== HISTORY)           printf("HISTORY\n");  
  else if (t== BLANK)             printf("BLANK\n");
  else                            printf("UNKNOWN LINE TYPE\n");
}

/* ----- print_syms: show sym properties set by parser ------ */
void print_syms(num)
int num;
{
  int i,t,j,y;
  char dsym[21] = {' ', '~', '.', 'J', 'M', 'H', 'u', 'v', 'R'};
  char bsym[10]  = {'-', '1' ,'2', '3', '4', '5', '6', '7', '8', '9'};

  printf ("\n---------- Symbol list ----------\n");
  printf ("word  slur  eol  num  description\n");

  for (i=0;i<num;i++) {
    printf (" %c %c   %c %c   %c  ", 
            bsym[sym[i].word_st], bsym[sym[i].word_end],
            bsym[sym[i].slur_st], bsym[sym[i].slur_end],
            bsym[sym[i].eoln] ); 
/*  printf (" %d %d   %d %d   %d  ", sym[i].word_st,sym[i].word_end,
            sym[i].slur_st,sym[i].slur_end,sym[i].eoln);  */
    printf ("%4d  ", i);
    t=sym[i].type;
    switch (t) {

    case NOTE:
    case REST:
      if (t==NOTE) printf ("NOTE ");
      if (t==REST) printf ("REST ");
      if (sym[i].npitch>1) printf (" [");
      for (j=0;j<sym[i].npitch;j++) {
        printf (" ");
        if (sym[i].accs[j]==A_SH) printf ("^");
        if (sym[i].accs[j]==A_NT) printf ("=");
        if (sym[i].accs[j]==A_FT) printf ("_");
        y=3*(sym[i].pits[j]-18)+sym[i].yadd;
        printf ("%2d-%-2d", y, sym[i].lens[j]);

        printf ("\ni=%d\n",i);
        for (j=0;j<sym[i].npitch;j++) 
          printf ("j=%d  sl1=%d  sl2=%d\n", j,sym[i].sl1[j],sym[i].sl2[j]);


      }
      if (sym[i].npitch>1) printf (" ]");
      if (sym[i].p_plet)  
        printf ("  (%d:%d:%d", sym[i].p_plet,sym[i].q_plet,sym[i].r_plet);
      if (strlen(sym[i].text)>0) printf ("  \"%s\"", sym[i].text);
      if (sym[i].dc.n>0) {
        printf ("  deco ");
        for (j=0;j<sym[i].dc.n;j++) 
          printf ("%c",dsym[sym[i].dc.t[j]]);
      }
      if (sym[i].gr.n>0) {
        printf ("  grace ");
        for (j=0;j<sym[i].gr.n;j++) {
          if (j>0) printf ("-");
          if (sym[i].gr.a[j]==A_SH) printf ("^");
          if (sym[i].gr.a[j]==A_NT) printf ("=");
          if (sym[i].gr.a[j]==A_FT) printf ("_");
          printf ("%d",sym[i].gr.p[j]);
        }
      }


      break;

    case BAR:
      printf ("BAR  ======= ");
      if (sym[i].u==B_SNGL)  printf ("single");
      if (sym[i].u==B_DBL)   printf ("double");
      if (sym[i].u==B_LREP)  printf ("left repeat");
      if (sym[i].u==B_RREP)  printf ("right repeat");
      if (sym[i].u==B_DREP)  printf ("double repeat");
      if (sym[i].u==B_FAT1)  printf ("thick-thin");
      if (sym[i].u==B_FAT2)  printf ("thin-thick");
      if (sym[i].u==B_INVIS) printf ("invisible");
      if (sym[i].v) printf (", ending %d", sym[i].v);
      break;

    case CLEF:
      printf ("CLEF    ");
      break;

    case TIMESIG:
      printf ("TIMESIG  ");
      if (sym[i].w==1)      printf ("C");
      else if (sym[i].w==2) printf ("C|");
      else                  printf ("%d/%d", sym[i].u,sym[i].v);
      break;

    case KEYSIG: 
      printf ("KEYSIG   ");
      if (sym[i].u==A_SH) printf ("sharps ");
      if (sym[i].u==A_FT) printf ("flats ");
      printf ("%d to %d", sym[i].u,sym[i].v);
      if (sym[i].w <= sym[i].v) 
        printf (", neutrals from %d\n", sym[i].w); 
      break;

    case INVISIBLE:
      printf ("INVIS   ");
      break;

    default:
      printf ("UNKNOWN ");
      break;
    }
    printf ("\n");

  }
  printf ("\n");
}

/* ----- set_head_directions ----------- */

#define ABS(a)  ((a)>0) ? (a) : (-a)

/* decide whether to shift heads to other side of stem on chords */
/* also position accidentals to avoid too much overlap */
void set_head_directions (s)
struct SYMBOL *s;
{
  int i,n,nx,sig,d,da,shift,nac;
  int i1,i2,m;
  float dx,xx,xmn;

  n=s->npitch;
  sig=-1;
  if (s->stem>0) sig=1;
  for (i=0;i<n;i++) {
    s->shhd[i]=0; 
    s->shac[i]=8; 
    if (s->head==H_OVAL) s->shac[i]+=3; 
    s->xmn=0;
    s->xmx=0;
  }
  if (n<2) return;

  /* sort heads by pitch */
  for (;;) {
    nx=0;
    for (i=1;i<n;i++) {
      if ( (s->pits[i]-s->pits[i-1])*sig>0 ) {
        xch (&s->pits[i],&s->pits[i-1]);
        xch (&s->lens[i],&s->lens[i-1]);
        xch (&s->accs[i],&s->accs[i-1]);
        xch (&s->sl1[i],&s->sl1[i-1]); 
        xch (&s->sl2[i],&s->sl2[i-1]); 
        xch (&s->ti1[i],&s->ti1[i-1]); 
        xch (&s->ti2[i],&s->ti2[i-1]); 
        nx++;
      }
    }
    if (!nx) break;
  }
  
  shift=0;                                 /* shift heads */
  for (i=n-2;i>=0;i--) {
    d=s->pits[i+1]-s->pits[i];
    if (d<0) d=-d;
    if ((d>=2) || (d==0)) 
      shift=0;
    else {
      shift=1-shift;
      if (shift) {
        dx=7.8;
        if (s->head==H_EMPTY) dx=7.8;
        if (s->head==H_OVAL)  dx=10.0;
        if (s->stem==-1) s->shhd[i]=-dx;
        else             s->shhd[i]=dx;
      }
    }
    if (s->shhd[i] < s->xmn) s->xmn = s->shhd[i];
    if (s->shhd[i] > s->xmx) s->xmx = s->shhd[i];
  }

  shift=0;                                 /* shift accidentals */
  i1=0; i2=n-1;
  if (sig<0) { i1=n-1; i2=0; }
  for (i=i1; ; i=i+sig) {          /* count down in terms of pitch */
    xmn=0;                         /* left-most pos of a close head */
    nac=99;                        /* relative pos of next acc above */
    for (m=0;m<n;m++) {
      xx=s->shhd[m];
      d=s->pits[m]-s->pits[i];
      da=ABS(d);
      if ((da<=5) && (s->shhd[m]<xmn)) xmn=s->shhd[m];
      if ((d>0) && (da<nac) && s->accs[m]) nac=da;
    }
    s->shac[i]=8.5-xmn+s->shhd[i];   /* aligns accidentals in column */
    if (s->head==H_EMPTY) s->shac[i] += 1.0;
    if (s->head==H_OVAL)  s->shac[i] += 3.0;
    if (s->accs[i]) {
      if (nac>=6)                        /* no overlap */
        shift=0;
      else if (nac>=4) {                 /* weak overlap */
        if (shift==0) shift=1;
        else          shift=shift-1;
      }
      else {                             /* strong overlap */
        if      (shift==0) shift=2;
        else if (shift==1) shift=3;
        else if (shift==2) shift=1;
        else if (shift==3) shift=0;
      }

      while (shift>=4) shift -=4;
      s->shac[i] += 3*shift;
    }
    if (i==i2) break;
  }

}


/* ----- set_sym_chars: set symbol characteristics  --- */
void set_sym_chars ()
{
  int i,np,m,ymn,ymx;
  float yav,yy;

  for (i=0;i<nsym;i++) {   
    if ((sym[i].type==NOTE)||(sym[i].type==REST)) {
      sym[i].y=3*(sym[i].pits[0]-18)+sym[i].yadd;
      if (sym[i].type==REST) sym[i].y=12;
      yav=0;
      ymn=1000;
      ymx=-1000;
      np=sym[i].npitch;
      for (m=0;m<np;m++) {
        yy=3*(sym[i].pits[m]-18)+sym[i].yadd;
        yav=yav+yy/np;
        if (yy<ymn) ymn=yy;
        if (yy>ymx) ymx=yy;
      }
      sym[i].ymn=ymn;
      sym[i].ymx=ymx;
      sym[i].yav=yav;
      sym[i].ylo=ymn;
      sym[i].yhi=ymx;

    }
  }
}

/* ----- set_beams: decide on beams ---- */
void set_beams ()
{
  int j,lastnote,start_flag;
  int num,nplet;
  
  /* separate words at notes without flags */
  start_flag=0;
  lastnote=-1;
  for (j=0;j<nsym;j++) {
    if (sym[j].type==NOTE) {
      if (start_flag) {
        sym[j].word_st=1;
        start_flag=0;
      }
      if (sym[j].flags==0) {
        if (lastnote>=0) sym[lastnote].word_end=1;
        sym[j].word_st=1;
        sym[j].word_end=1;
        start_flag=1;
      }
      lastnote=j;
    }
  }

  /* separate words before and after n-plet */
  if (CUT_NPLETS) {
    num=nplet=0;
    lastnote=-1;
    for (j=0;j<nsym;j++) {
      if (sym[j].type==NOTE) {
        num++;
        if (nplet && (num==nplet)) {       
          if (lastnote>=0) sym[lastnote].word_end=1; 
          sym[j].word_st=1;
        }
        if (sym[j].p_plet) {                
          nplet=sym[j].r_plet;
          num=0;
          if (lastnote>=0) sym[lastnote].word_end=1;
          sym[j].word_st=1;
        }
        lastnote=j;
      }
    } 
  }
  
}

/* ----- set_stems: decide on stem directions and lengths ---- */
void set_stems ()
{
  int beam,j,k,n,stem,laststem;
  float avg,slen,lasty,dy;
  
  /* set stem directions; near middle, use previous direction */
  beam=0;
  laststem=0;       
  for (j=0; j<nsym; j++) {
    if (sym[j].type!=NOTE) laststem=0; 

    if (sym[j].type==NOTE) {

      sym[j].stem=0;                  
      if (sym[j].len<WHOLE) sym[j].stem=1;
      if (sym[j].yav>=12) sym[j].stem=-sym[j].stem;
      if ((sym[j].yav>11) && (sym[j].yav<13) && (laststem!=0)) {
        dy=sym[j].yav-lasty;
        if ((dy>-7) && (dy<7)) sym[j].stem=laststem;
      }
      
      if (sym[j].word_st && (!sym[j].word_end)) {   /* start of beam */
        avg=0; 
        n=0;
        for (k=j;k<nsym;k++) {
          if (sym[k].type==NOTE) {
            avg=avg+sym[k].yav;
            n++;
          }
          if (sym[k].word_end) break;
        }
        avg=avg/n;
        stem=1;
        if (avg>=12) stem=-1;
        if ((avg>11) && (avg<13) && (laststem!=0)) stem=laststem;
        beam=1;
      }
      
      if (beam) sym[j].stem=stem;
      if (sym[j].word_end) beam=0;
      if (bagpipe) sym[j].stem=-1;
      if (sym[j].len>=WHOLE) sym[j].stem=0;
      laststem=sym[j].stem;
      if (sym[j].len>=HALF) laststem=0;
      lasty=sym[j].yav;
    }
  }
  
  /* shift notes in chords (need stem direction to do this) */
  for (j=0;j<nsym;j++) 
    if (sym[j].type==NOTE) set_head_directions (&sym[j]);
  

  /* set height of stem end, without considering beaming for now */
  for (j=0; j<nsym; j++) if (sym[j].type==NOTE) {
    slen=STEM;
    if (sym[j].npitch>1) slen=STEM_CH; 
    if (sym[j].flags==3) slen += 4;
    if (sym[j].flags==4) slen += 9;
    if ((sym[j].flags>2) && (sym[j].stem==1)) slen -= 1;
    if (sym[j].stem==1) {
      sym[j].y=sym[j].ymn;
      sym[j].ys=sym[j].ymx+slen;
    }
    else if (sym[j].stem==-1) {
      sym[j].y=sym[j].ymx;
      sym[j].ys=sym[j].ymn-slen;
    }
    else {
      sym[j].y=sym[j].ymx;
      sym[j].ys=sym[j].ymx;
    }
  }
}

/* ----- set_sym_widths: set widths and prefered space --- */
/* This routine sets the minimal left and right widths wl,wr
   so that successive symbols are still separated when
   no extra glue is put between them. It also sets the prefered 
   spacings pl,pr for good output and xl,xr for expanded layout.
   All distances in pt relative to the symbol center. */

#define AT_LEAST(a,b)  if((a)<(b)) a=b;
void set_sym_widths ()
{
  int i,n,j0,j,m,f,n1,n2,bt,k,sl;
  float xx,w,swfac;
  char t[81];

  swfac=1.0;
  if (strstr(cfmt.vocalfont.name,"Times-Roman"))    swfac=1.00;
  if (strstr(cfmt.vocalfont.name,"Times-Bold"))     swfac=1.05;
  if (strstr(cfmt.vocalfont.name,"Helvetica"))      swfac=1.10;
  if (strstr(cfmt.vocalfont.name,"Helvetica-Bold")) swfac=1.15;

  for (i=0;i<nsym;i++) {
    switch (sym[i].type) {
      
    case INVISIBLE:   /* empty space; shrink,space,stretch from u,v,w */
      sym[i].wl=sym[i].wr=0.5*sym[i].u;
      sym[i].pl=sym[i].pr=0.5*sym[i].v;
      sym[i].xl=sym[i].xr=0.5*sym[i].w;
      break;

    case NOTE:
    case REST:
      f=followed_by_note(i);
      sym[i].wl=sym[i].wr=4.5;
      sym[i].pl=sym[i].pr=nwidth(sym[i].len);
      sym[i].xl=sym[i].xr=xwidth(sym[i].len);

      if (sym[i].head==H_OVAL)  sym[i].wl=sym[i].wr=20.0;
      if (sym[i].head==H_EMPTY) sym[i].wl=sym[i].wr=12.0;
      
      /* room for shifted heads and accidental signs */
      for (m=0;m<sym[i].npitch;m++) {
        xx=sym[i].shhd[m];
        AT_LEAST (sym[i].wr, xx+6); 
        AT_LEAST (sym[i].wl, -xx+6); 
        if (sym[i].accs[m]) {
          xx=xx-sym[i].shac[m]; 
          AT_LEAST (sym[i].wl, -xx+3); 
        }
        AT_LEAST (sym[i].xl, -xx+3); 
        sym[i].pl=sym[i].wl;
        sym[i].xl=sym[i].wl;
      }
        
      /* room for slide */
      for (k=0;k<sym[i].dc.n;k++) {
        if (sym[i].dc.t[k]==D_SLIDE) sym[i].wl += 10;
      }

      /* room for grace notes */
      if (sym[i].gr.n>0) {
        xx=GSPACE0;
        if (sym[i].gr.a[0]) xx=xx+3.5;
        for (j=1;j<sym[i].gr.n;j++) {                   
          xx=xx+GSPACE;
          if (sym[i].gr.a[j]) xx=xx+4;
        }
        sym[i].wl = sym[i].wl + xx+1;
        sym[i].pl = sym[i].pl + xx+1;
        sym[i].xl = sym[i].xl + xx+1;
      }
      
      /* space for flag if stem goes up on standalone note */
      if (sym[i].word_st && sym[i].word_end) 
        if ((sym[i].stem==1) && sym[i].flags>0) 
          AT_LEAST (sym[i].wr, 12);

      /* leave room for dots */
      if (sym[i].dots>0) {
        AT_LEAST (sym[i].wr,12+sym[i].xmx);
        if (sym[i].dots>=2) sym[i].wr=sym[i].wr+3.5;
        n=(int) sym[i].y;
        /* special case: standalone with up-stem and flags */
        if (sym[i].flags && (sym[i].stem==1) && !(n%6)) 
          if ((sym[i].word_st==1) && (sym[i].word_end==1)) {
            sym[i].wr=sym[i].wr+DOTSHIFT;
            sym[i].pr=sym[i].pr+DOTSHIFT;
            sym[i].xr=sym[i].xr+DOTSHIFT;
          }
      }

      /* extra space when down stem follows up stem */
      j0=preceded_by_note(i);
      if ((j0>=0) && (sym[j0].stem==1) && (sym[i].stem==-1)) 
        AT_LEAST (sym[i].wl, 7);

      /* make sure helper lines don't overlap */
      if ((j0>=0) && (sym[i].y>27) && (sym[j0].y>27)) 
        AT_LEAST (sym[i].wl, 7.5);

      /* leave room guitar chord */
      if (strlen(sym[i].text)>0) {
        /* special case: guitar chord under ending 1 or 2 */
        /* leave some room to the left of the note */
        if ((i>0) && (sym[i-1].type==BAR)) {
          bt=sym[i-1].v;
          if (bt) AT_LEAST (sym[i].wl, 18);
        }
        /* rest is same for all guitar chord cases */
        if ((f>0) && (strlen(sym[f].text)>0)) {
          tex_str(sym[i].text,t,&w);
          xx=1.1*cfmt.gchordfont.size*w;
          AT_LEAST (sym[i].wr, xx);
        }
      }        

      /* leave room for vocals under note */
      if (!cfmt.musiconly) {
        for (j=0;j<NWLINE;j++) {
          if (sym[i].wordp[j]) {
            sl=tex_str(sym[i].wordp[j],t,&w);
            xx=swfac*cfmt.vocalfont.size*(w+cwid(' '));
            AT_LEAST (sym[i].wr,xx-5);
          }
        } 
      }
        
      AT_LEAST (sym[i].pl, sym[i].wl);
      AT_LEAST (sym[i].xl, sym[i].wl);
      AT_LEAST (sym[i].pr, sym[i].wr);
      AT_LEAST (sym[i].xr, sym[i].wr);
      break;
      
    case BAR:
      if (sym[i].u==B_SNGL)         sym[i].wl=sym[i].wr=3;
      else if (sym[i].u==B_DBL)   { sym[i].wl=7; sym[i].wr=4;  }
      else if (sym[i].u==B_LREP)  { sym[i].wl=5; sym[i].wr=12; }
      else if (sym[i].u==B_RREP)  { sym[i].wl=12; sym[i].wr=5; }
      else if (sym[i].u==B_DREP)    sym[i].wl=sym[i].wr=12;
      else if (sym[i].u==B_FAT1)  { sym[i].wl=3;  sym[i].wr=9; }
      else if (sym[i].u==B_FAT2)  { sym[i].wl=9;  sym[i].wr=3; }
      else if (sym[i].u==B_INVIS)   sym[i].wl=sym[i].wr=0;
      sym[i].pl=sym[i].wl;
      sym[i].pr=sym[i].wr;
      sym[i].xl=sym[i].wl;
      sym[i].xr=sym[i].wr;
      break;
      
    case CLEF:
      sym[i].wl=sym[i].wr=sym[i].xl=12;
      sym[i].pl=sym[i].pr=sym[i].xr=12;
      break;
      
    case KEYSIG:
      n1=sym[i].u;    
      n2=sym[i].v;    
      if (n2>=n1) {
        sym[i].wl=5;
        sym[i].wr=5*(n2-n1+1)+5;
        sym[i].pl=sym[i].wl;
        sym[i].pr=sym[i].wr;
        sym[i].xl=sym[i].wl;
        sym[i].xr=sym[i].wr;
      }
      else {
        sym[i].wl=sym[i].pl=sym[i].xl=3;
        sym[i].wr=sym[i].pr=sym[i].xr=3;
      }
      break;

    case TIMESIG:
      sym[i].wl=8+4*(strlen(sym[i].text)-1);
      sym[i].wr=sym[i].wl+4;
      sym[i].pl=sym[i].wl;
      sym[i].pr=sym[i].wr;
      sym[i].xl=sym[i].wl;
      sym[i].xr=sym[i].wr;
      break;
      
    default:
      printf (">>> cannot set width for sym type %d\n", sym[i].type);
      sym[i].wl=sym[i].wr=sym[i].xl=0;
      sym[i].pl=sym[i].pr=sym[i].xr=0;
      break;
    }

  }
}


/* ----- set_sym_glue --------- */
/*  Sets the characteristics of the glue between symbols, then
    positions the symbols along the staff. If staff is overfull,
    only does symbols which fit in, returns this number. */
int set_sym_glue (nsymtot,width,realwidth)
int nsymtot;
float width;
float *realwidth;
{
  int i,j,i0,j0,nn,nplet,ii,lastbar,nsym1,bars,ncount;
  int vbnp,vbnx,vnbp,vnbx;
  float w0,w1,w2, space,shrink,stretch,alfa,beta,w,x,glue,dy,fac;
  float alfa0,beta0;

  alfa0=ALFA_X;                       /* max shrink and stretch */
  if (cfmt.continueall) alfa0=cfmt.maxshrink;
  if (gmode==G_SHRINK)  alfa0=1.0;
  if (gmode==G_SPACE)   alfa0=0.0;
  if (gmode==G_STRETCH) alfa0=1.0;
  beta0=BETA_X;
  if (cfmt.continueall) beta0=BETA_C;

  /* make the note lengths for default spaces at bars */
  vbnp=(rbnp*meter1*BASE)/meter2;
  vbnx=(rbnx*meter1*BASE)/meter2;
  vnbp=(rnbp*meter1*BASE)/meter2;
  vnbx=(rnbx*meter1*BASE)/meter2;
  nplet=0;
  lastbar=-1;
  bars=-1;
  ncount=0;
  
  for (i=0;i<nsym;i++) {
    if (i>0) {
      sym[i].shrink=sym[i-1].wr+sym[i].wl;
      sym[i].space=sym[i-1].pr+sym[i].pl;
      sym[i].stretch=sym[i-1].xr+sym[i].xl;
    }      
    else {
      sym[i].shrink=sym[i].wl;
      sym[i].space=sym[i].pl;
      sym[i].stretch=sym[i].xl;
    }
    j=preceded_by_note(i);

    switch (sym[i].type) {
    case NOTE:
    case REST:

      if (j>=0) {                   /* two notes behind each other */
        w1 = lnnp*nwidth(sym[j].len);
        w2 = lnnp*nwidth(sym[i].len);
        sym[i].space = bnnp*w1 + (1-bnnp)*0.5*(w1+w2);
        w1 = lnnx*xwidth(sym[j].len);
        w2 = lnnx*xwidth(sym[i].len);
        sym[i].stretch = bnnx*w1 + (1-bnnx)*0.5*(w1+w2);
        /* squeeze notes a bit if big jump in pitch */
        if ((sym[i].type==NOTE)&&(sym[j].type==NOTE)) {
          dy=sym[i].y-sym[j].y;
          if (dy<0) dy=-dy;
          fac=1-0.010*dy; 
          if (fac<0.9) fac=0.9;
          sym[i].space=sym[i].space*fac;
          sym[i].stretch=sym[i].stretch*fac;
        } 
      }
      
      else {                        /* note at start of bar */
        w1 = lbnp*nwidth(sym[i].len);
        w0 = lbnp*nwidth(vbnp);
        sym[i].space = bbnp*w1 + (1-bbnp)*w0 + sym[i-1].pr;
        w1 = lbnx*xwidth(sym[i].len);
        w0 = lbnx*xwidth(vbnx);
        sym[i].stretch = bbnx*w1 + (1-bbnx)*w0 + sym[i-1].xr;
        i0=i; j0=j;                 /* remember start of bar */
        nn=0;                       /* counter for notes in bar */
      }

      if (sym[i].word_st==0) {      /* reduce spacing within a beam */
        sym[i].space   = fnnp*sym[i].space;  
        sym[i].stretch = fnnx*sym[i].stretch;  
      }
      
      if (sym[i].p_plet>0)               /* reduce spacing in n-plet */
        nplet=sym[i].r_plet-1 ;   
      else {
        if(nplet>0) {
          nplet--;
          sym[i].space   = gnnp*sym[i].space;  
          sym[i].stretch = gnnx*sym[i].stretch;  
        }
      }

      nn++;
      ncount++;
      if (bars<0)  bars=0;
      break;
      
    default:   
      if (j>=0) {                   /* end of bar reached */
        w1 = lnbp*nwidth(sym[j].len);
        w0 = lnbp*nwidth(vnbp);
        sym[i].space = bnbp*w1 + (1-bnbp)*w0 + sym[i].pl;
        w1 = lnbx*xwidth(sym[j].len);
        w0 = lnbx*xwidth(vnbx);
        sym[i].stretch = bnbx*w1 + (1-bnbx)*w0 + sym[i].xl;
        
        if (nn==1) {                /* only one note in measure */
          /* special treatment only if length at least one-half measure */
          if ((2*sym[j].len) >= ((meter1*BASE)/meter2)) {
            w0 = 0.5*ln0p*nwidth(sym[j].len);
            sym[i0].space = bn0p*w0 + (1-bn0p)*sym[i0].space;
            sym[i].space  = bn0p*w0 + (1-bn0p)*sym[i].space;
            w0 = 0.5*ln0x*xwidth(sym[j].len);
            sym[i0].stretch = bn0x*w0 + (1-bn0x)*sym[i0].stretch;
            sym[i].stretch  = bn0x*w0 + (1-bn0x)*sym[i].stretch;
          }
        }
      }

      break;
    }
    
    /* make sure that shrink <= space <= stretch */
    if (sym[i].space<sym[i].shrink)  sym[i].space=sym[i].shrink;
    if (sym[i].stretch<sym[i].space) sym[i].stretch=sym[i].space; 
    
    space=shrink=stretch=0;
    for (ii=0;ii<=i;ii++) {
      space=space+sym[ii].space;
      shrink=shrink+sym[ii].shrink;
      stretch=stretch+sym[ii].stretch;
    }

    alfa=0;                                      /* check width now */
    if (space>shrink) alfa=(space-width)/(space-shrink); 
    if (verbose>11) 
      printf ("glue[%d] %d (%.1f,%.1f,%.1f) shr,sp %.1f %.1f  %.1f %d %d\n",
              i,sym[i].type,sym[i].shrink,sym[i].space,sym[i].stretch,
              shrink,space,alfa,bars,ncount);
    
    if ((alfa>alfa0) && ((ncount>1)||(bars>0))) {
      w=alfa0*shrink+(1-alfa0)*space;
      if ((!cfmt.continueall) || (verbose>4)) {
        if (verbose<=3) printf ("\n");
        printf ("++++ Overfull after %d bar%s in staff %d\n",
                bars, bars==1 ? "" : "s", mline);
      }
      nsym1=i;
      if ((sym[i-2].type==NOTE)||(sym[i-2].type==REST)) nsym1=i-1;
      if (lastbar>=0) {
        nsym1=lastbar+1;
        if (verbose>7) printf ("Backtrack to bar at i=%d\n",lastbar);
      }
      break;
    }

    if ((sym[i].type==BAR) && (sym[i].u!=B_INVIS) && (ncount>0)) {
      if ((i>0) && (sym[i-1].type!=BAR) && (sym[i-1].u!=B_INVIS))
        lastbar=i;
      if (bars>=0) bars++;
    }
    nsym1=i+1;
  }

  /* ---- end of loop over symbols ------ */
  
  space=shrink=stretch=0;
  for (i=0;i<nsym1;i++) {
    space=space+sym[i].space;
    shrink=shrink+sym[i].shrink;
    stretch=stretch+sym[i].stretch;
  }

  /* if last symbol is not a bar, add preceding space again */
  i=nsym1-1;
  if (sym[i].type != BAR) { 
    shrink  += sym[i].shrink;
    space   += sym[i].space;
    stretch += sym[i].stretch;
  }
  
  /* ---- set the glue, calculate final symbol positions ---- */

  if (verbose>9) {
    printf ("Output %d symbols of %d\n", nsym1,nsym);
    printf ("width %.2f, shrink,space,stretch %.2f, %.2f, %.2f\n",
            width,shrink,space,stretch);
  }

  alfa=beta=0;
  if (space>width) { 
    alfa=99;
    if (space>shrink) alfa=(space-width)/(space-shrink); 
  }
  else { 
    beta=99;
    if (stretch>space) beta=(width-space)/(stretch-space); 
  }
  if (verbose>12) printf ("start with alfa=%.2f, b=%.2f\n", alfa, beta);
  
  if (gmode==G_SHRINK)  { alfa=1; beta=0;}     /* force minimal spacing */
  if (gmode==G_STRETCH) { alfa=0; beta=1;}     /* force stretched spacing */
  if (gmode==G_SPACE)   { alfa=beta=0;   }     /* force natural spacing */

  if (alfa>alfa0) { alfa=alfa0; beta=0; }
  
  if (beta>beta0) {
    if ((!cfmt.continueall) || (nsym<nsymtot)) {
      if (verbose<=3) printf ("\n");
      printf ("++++ Underfull (%.0fpt of %.0fpt) in staff %d\n", 
              (beta0*stretch+(1-beta0)*space)*cfmt.scale,
              cfmt.staffwidth,mline);
    }
    alfa=0; 
    if (!cfmt.stretchstaff) beta=0;
    if ((!cfmt.stretchlast) && (nsym1==nsymtot)) {
      alfa=alfa_last;    /* shrink undefull last line same as previous */
      beta=beta_last;
    }
  }

  if (verbose>12) printf ("now alfa=%.3f, beta=%.3f\n", alfa, beta);
  w=alfa*shrink+beta*stretch+(1-alfa-beta)*space;
  if (verbose>=3) {
    if (alfa>0)      printf ("Shrink staff %.0f%%",  100*alfa);
    else if (beta>0) printf ("Stretch staff %.0f%%", 100*beta);
    else             printf ("No shrink or stretch");
    printf (" to width %.0f (%.0f,%.0f,%.0f)\n",w,shrink,space,stretch);
  }

  x=0; 
  for (i=0;i<nsym1;i++) {
    glue=alfa*sym[i].shrink+beta*sym[i].stretch+(1-alfa-beta)*sym[i].space;
    x=x+glue;
    sym[i].x=x;
    if (verbose>11) printf ("pos[%d]: type=%d  pos=%.2f\n", i,sym[i].type,x);
  }

  /* add small random shifts to positions */
  for (i=1;i<nsym1-1;i++) {
    if ((sym[i].type==NOTE) || (sym[i].type==REST)) {
      w1=sym[i].x-sym[i-1].x;
      w2=sym[i+1].x-sym[i].x;
      if (w2<w1) w1=w2;
      x=RANFAC*ranf(-w1,w1);
      sym[i].x=sym[i].x+x; 
    }
  }

  alfa_last=alfa;
  beta_last=beta;
  *realwidth=w;
  return nsym1;
}

/* ----- draw_timesig ------- */
void draw_timesig (x,s)
struct SYMBOL s;
float x;
{
  if (s.w==1) 
    PUT1("%.1f csig\n", x)
  else if (s.w==2) 
    PUT1("%.1f ctsig\n", x)
  else 
/*    PUT3("%.1f (%d) (%d) tsig\n", x, s.u, s.v) */
    PUT3("%.1f (%s) (%d) tsig\n", x, s.text, s.v)
}

/* ----- draw_keysig ------- */
void draw_keysig (x,s)
struct SYMBOL s;
float x;
{
  float p;
  int i,n1,n2,n3,t;
  int sh_pos[8]={0,  24,15,27,18,9,21,15};
  int ft_pos[8]={0,  12,21,9,18,6,15,3};

  n1=s.u;               /* which symbol to start with */
  n2=s.v;               /* up to which symbol to go */
  n3=s.w;               /* draw neutrals instead starting from this one */
  t =s.t;               /* type of symbol: sharp or flat */

  if (n2>7) {
    printf ("++++ Keysig seems to have %d symbols ???\n", n2);
    return;
  }
  
  if (t==A_SH) {
    p=x;
    for (i=n1;i<=n2;i++) {
      if (i>=n3) 
        PUT2("%.1f %d nt0 ",p,sh_pos[i]+y_add)
      else       
        PUT2("%.1f %d sh0 ",p,sh_pos[i]+y_add)
      p=p+5;
    }
    PUT0("\n")
  }
  else if (t==A_FT) {
    p=x;
    for (i=n1;i<=n2;i++) {
      if (i>=n3) 
        PUT2("%.1f %d nt0 ", p, ft_pos[i]+y_add)
      else
        PUT2("%.1f %d ft0 ", p, ft_pos[i]+y_add)
      p=p+5;
    }
    PUT0("\n")
  }
  else 
    bug ("wrong type in draw_keysig", 0);
  
}


/* ----- draw_bar ------- */
void draw_bar (x,s)
struct SYMBOL s;
float x;
{

  if (s.u==B_SNGL)                        /* draw the bar */
    PUT1("%.1f bar\n", x)
  else if (s.u==B_DBL)  
    PUT1("%.1f dbar\n", x)
  else if (s.u==B_LREP) 
    PUT2("%.1f fbar1 %.1f rdots\n", x, x+10)
  else if (s.u==B_RREP) {
    PUT2("%.1f fbar2 %.1f rdots\n", x, x-10)
  }
  else if (s.u==B_DREP) {
    PUT2("%.1f fbar1 %.1f rdots\n", x-1, x+9)
    PUT2("%.1f fbar2 %.1f rdots\n", x+1, x-9)
  }
  else if (s.u==B_FAT1) 
    PUT1("%.1f fbar1\n", x)
  else if (s.u==B_FAT2) 
    PUT1("%.1f fbar2\n", x)
  else if (s.u==B_INVIS)
    ;
  else
    printf (">>> cannot draw bar type %d\n", s.u);
  PUT0("\n")
  
}  

/* ----- update_endings: remember where to draw endings ------- */
void update_endings (x,s)
struct SYMBOL s;
float x;
{
  int i;
  
  if (num_ending>0) {
    i=num_ending-1;
    if (ending[i].num==1) 
      mes1++;
    else {
      mes2++;
      if (mes2==mes1) ending[i].b=x;
    }
  }
  
  if (s.v) {         
    if (num_ending>0)
      if (ending[num_ending-1].num==1) ending[num_ending-1].b=x-3;
    ending[num_ending].a=x;
    ending[num_ending].b=-1;
    ending[num_ending].num=s.v;
    if (s.v==1) mes1=0;
    else        mes2=0;
    num_ending++;
  }
  
}  

/* ----- draw_endings ------- */
void draw_endings ()
{
  int i;

  for (i=0;i<num_ending;i++) {
    if (ending[i].b<0) 
      PUT3("%.1f %.1f (%d) end2\n", 
           ending[i].a, ending[i].a+50, ending[i].num)
    else {
      if (ending[i].num==1) {
        PUT3("%.1f %.1f (%d) end1\n", 
             ending[i].a, ending[i].b, ending[i].num)
      }
      else {
        PUT3("%.1f %.1f (%d) end1\n", 
             ending[i].a, ending[i].b, ending[i].num)
      }
    }
  }
  num_ending=0;

}   

/* ----- draw_rest ----- */
void draw_rest (x,yy,s,gchy)
struct SYMBOL s;
float x,yy;
float *gchy;
{

  int y,i;
  float dotx,doty;

  *gchy=38;
  if (s.invis) return;

  y=(int) s.y;
  PUT2("%.2f %.0f", x, yy)

  if (s.head==H_OVAL)       PUT0(" r1")  
  else if (s.head==H_EMPTY) PUT0(" r2")
  else {
    if (s.flags==0)      PUT0(" r4")
    else if (s.flags==1) PUT0(" r8")
    else if (s.flags==2) PUT0(" r16")
    else if (s.flags==3) PUT0(" r32")
    else                 PUT0(" r64")
  }

  if (y%6) { dotx=6.5; doty=0; }                   /* dots */
  else     { dotx=6.5; doty=3; }
  if (s.head==H_OVAL)  { dotx=8; doty=-3; }
  if (s.head==H_EMPTY) { dotx=8; doty=3;  }
  for (i=0;i<s.dots;i++) {
    PUT2(" %.1f %.1f dt", dotx, doty)
    dotx=dotx+3.5;
  }


  PUT0("\n")
}

/* ----- draw_gracenotes ----- */
void draw_gracenotes (x,w,d,s)
struct SYMBOL *s;
float x,w,d;
{
  int i,n,y,acc,ii,m;
  float xg[20],yg[20],lg,px[20],py[20],xx,yy;
  float s1,sx,sy,sxx,sxy,a,b,delta,lmin;
  float x0,y0,x1,y1,x2,y2,x3,y3,bet1,bet2,dy1,dy2,dx,dd,fac,facx;

  n=s->gr.n;
  if (n==0) return;

  facx=0.3;
  fac=d/w-1;
  if (fac<0) fac=0;
  fac=1+(fac*facx)/(fac+facx);

  dx=0;
  for (m=0;m<s->npitch;m++) {              /* room for accidentals */
    dd=-s->shhd[m];
    if (s->accs[m]) dd=-s->shhd[m]+s->shac[m];
    if ((s->accs[m]==A_FT)||(s->accs[m]==A_NT)) dd=dd-2;
    if (dx<dd) dx=dd;
  }
  
  xx=x-fac*(dx+GSPACE0);
  for (i=n-1;i>=0;i--) {                   /* set note positions */
    yg[i]=3*(s->gr.p[i]-18)+s->yadd;
    if (i==n-1) {                             /* some subtle shifts.. */
      if(yg[i]>=s->ymx)  xx=xx+1;              /* gnote above a bit closer */ 
      if((yg[i]<s->ymn-7)&&(n==1)) xx=xx-2;   /* below with flag further */
    }

    if (i<n-1) {
      if (yg[i]>yg[i+1]+8) xx=xx+fac*1.8;
    }

    xg[i]=xx;
    xx=xx-fac*GSPACE;
    if (s->gr.a[i]) xx=xx-3.5;
  }
  
  if (n>1) {
    s1=sx=sy=sxx=sxy=0;                    /* linear fit through stems */
    for (i=0;i<n;i++) {      
      px[i]=xg[i]+GSTEM_XOFF;
      py[i]=yg[i]+GSTEM;
      s1 += 1; sx += px[i]; sy += py[i];
      sxx += px[i]*px[i]; sxy += px[i]*py[i];
    }
    delta=s1*sxx-sx*sx;                   /* beam fct: y=ax+b */
    a=(s1*sxy-sx*sy)/delta;
    if (a>BEAM_SLOPE) a=BEAM_SLOPE;
    if (a<-BEAM_SLOPE) a=-BEAM_SLOPE;  
    b=(sy-a*sx)/s1;

    if (bagpipe) { a=0; b=35; }

    lmin=100;                           /* shift to get min stems */
    for (i=0;i<n;i++) {      
      px[i]=xg[i]+GSTEM_XOFF;
      py[i]=a*px[i]+b;
      lg=py[i]-yg[i];
      if (lg<lmin) lmin=lg;
    }
    if (lmin<10) b=b+10-lmin;
  }

  for (i=0;i<n;i++) {                     /* draw grace notes */
    if (n>1) {
      px[i]=xg[i]+GSTEM_XOFF;
      py[i]=a*px[i]+b;
      lg=py[i]-yg[i];
      PUT3("%.1f %.1f %.1f gnt ", xg[i],yg[i],lg)
    }
    else {
      lg=GSTEM;
      PUT3("%.1f %.1f %.1f gn1 ", xg[i],yg[i],lg)
    }      

    acc=s->gr.a[i];
    if (acc==A_SH) PUT2("%.1f %.1f gsh0 ",xg[i]-4.5,yg[i])
    if (acc==A_FT) PUT2("%.1f %.1f gft0 ",xg[i]-4.5,yg[i])
    if (acc==A_NT) PUT2("%.1f %.1f gnt0 ",xg[i]-4.5,yg[i])

    y = (int)yg[i];                         /* helper lines */
    if (y<=-6) {
      if (y%6) PUT2("%.1f %d ghl ",xg[i], y+3) 
      else     PUT2("%.1f %d ghl ",xg[i], y) 
    }  
    if (y>=30) {
      if (y%6) PUT2("%.1f %d ghl ",xg[i], y-3) 
      else     PUT2("%.1f %d ghl ",xg[i], y) 
    }  
  }
  
  if (n>1)                                /* beam */
    if (bagpipe) 
      PUT4("%.1f %.1f %.1f %.1f gbm3 ", px[0],py[0],px[n-1],py[n-1])
    else
      PUT4("%.1f %.1f %.1f %.1f gbm2 ", px[0],py[0],px[n-1],py[n-1])


  bet1=0.2;                            /* slur */
  bet2=0.8;     
  yy=1000; 
  for (i=n-1;i>=0;i--) if (yg[i]<=yy) {yy=yg[i]; ii=i;}
  x0=xg[ii];
  y0=yg[ii]-5;
  if (ii>0) { x0=x0-4; y0=y0+1; }
  x3=x-1;
  y3=s->ymn-5;
  dy1=(x3-x0)*0.4;
  if (dy1>3) dy1=3;
  dy2=dy1;

  if (yg[ii]>s->ymn+7){
    x0=xg[ii]-1;
    y0=yg[ii]-4.5;
    y3=s->ymn+1.5;
    x3=x-dx-5.5;
    dy2=(y0-y3)*0.2;
    dy1=(y0-y3)*0.8;
    bet1=0.0;
  }

  if (y3>y0+4) {
    y3=y0+4;
    x0=xg[ii]+2;
    y0=yg[ii]-4;
  }

  x1=bet1*x3+(1-bet1)*x0;
  y1=bet1*y3+(1-bet1)*y0-dy1;
  x2=bet2*x3+(1-bet2)*x0;
  y2=bet2*y3+(1-bet2)*y0-dy2;

  PUT4(" %.1f %.1f %.1f %.1f", x1,y1,x2,y2);
  PUT4(" %.1f %.1f %.1f %.1f gsl\n", x3,y3,x0,y0);

}

/* ----- draw_basic_note: draw m-th head with accidentals and dots -- */
void draw_basic_note (x,w,d,s,m)
struct SYMBOL *s;
float x,w,d;
int m;
{
  int y,i,yy;
  float dotx,doty,xx,dx,avail,add,fac;

  y=3*(s->pits[m]-18)+s->yadd;                    /* height on staff */
  
  xx=x+s->shhd[m];                              /* draw head */
  PUT2("%.1f %d", xx, y)              
  if (s->head==H_OVAL)  PUT0(" HD")
  if (s->head==H_EMPTY) PUT0(" Hd")
  if (s->head==H_FULL)  PUT0(" hd")
  if (s->shhd[m]) {                  
    yy=0;
    if (y>=30) { yy=y; if (yy%6) yy=yy-3; }
    if (y<=-6) { yy=y; if (yy%6) yy=yy+3; }
    if (yy) PUT1(" %d hl", yy)
  }

  if (s->dots) {                                /* add dots */
    if (y%6) { dotx=8; doty=0; }    
    else     { dotx=8; doty=3; }
    if (s->stem==-1) 
      dotx=dotx+s->xmx-s->shhd[m]; 
    else
      dotx=dotx+s->xmx-s->shhd[m];
    if (s->dots && s->flags && (s->stem==1) && !(y%6)) 
      if ((s->word_st==1) && (s->word_end==1) && (s->npitch==1))
        dotx=dotx+DOTSHIFT; 
    if (s->head==H_EMPTY) dotx=dotx+1;
    if (s->head==H_OVAL)  dotx=dotx+2;
    for (i=0;i<s->dots;i++) {
      PUT2(" %.1f %.1f dt", dotx, doty)
      dotx=dotx+3.5;
    }
  }

  if (s->accs[m]) {                          /* add accidentals */
    fac=1.0;
    avail=d-w-3;
    add=0.3*avail;
    fac=1+add/s->wl;
    if (fac<1) fac=1;
    if (fac>1.2) fac=1.2;
    dx=fac*s->shac[m];    
    if (s->accs[m]==A_SH) PUT1(" %.1f sh", dx)  
    if (s->accs[m]==A_NT) PUT1(" %.1f nt", dx)
    if (s->accs[m]==A_FT) PUT1(" %.1f ft", dx)
  }
}


/* ----- draw_decorations ----- */
float draw_decorations (x,s,tp)
struct SYMBOL *s;
float x;
float *tp;
{
  int y,sig,k,deco,m;
  float yc,xc,y1,top,top1,dx,dy;


  top=-1000;
  for (k=s->dc.n-1;k>=0;k--) {                 /*  decos close to head */
    deco=s->dc.t[k];

    if ((deco==D_STACC)||(deco==D_EMBAR)) {         /* dot or bar mark */
      sig=1; if (s->stem==1) sig=-1;
      y=s->y+6*sig;
      if (y<top+3) y=top+3;
      if (!(y%6) && (y>=0) && (y<=24)) y+=3*sig;
      if (top<y) top=y;
      if (deco==D_STACC) PUT1(" %d stc",y)
      else               PUT1(" %d emb",y)
    }
    
    if (deco==D_SLIDE) {                           /* slide */
      yc=s->ymn;
      xc=5;
      for (m=0;m<s->npitch;m++) {                       
        dx=5-s->shhd[m];
        if (s->head==H_OVAL) dx=dx+2.5; 
        if (s->accs[m]) dx=4-s->shhd[m]+s->shac[m];
        dy=3*(s->pits[m]-18)+s->yadd-yc;
        if ((dy<10) && (dx>xc)) xc=dx; 
      }
      yc=s->ymn;
      PUT2(" %.1f %.1f sld", yc, xc)
    }
  }
  
  top1=top;
  for (k=s->dc.n-1;k>=0;k--) {                 /*  decos further away */
    deco=s->dc.t[k];
    if (deco==D_GRACE) {                           /* gracing marker */
      yc=s->ymx+9; 
      if (s->stem==1) yc=s->ys+5;
      if (yc<30) yc=30;
      if (yc<top+4) yc=top+4;
      if (top<yc+2) top=yc+2;
      PUT1(" %.2f grm", yc)
    }

    if (deco==D_ROLL) {                            /* roll sign */
      y=s->y;
      if (s->stem==1) {
        yc=s->y-5;
        if (yc>-2) yc=-2;
        PUT1(" %.2f cpd", yc)
      }
      else {
        yc=s->y+5;
        if (s->dots && (!(y%6))) yc=s->y+6;
        if (yc<26) yc=26;
        if (yc<top+1) yc=top+1;
        if (top<yc+8) top=yc+8;
        PUT1(" %.2f cpu", yc)
      }
    } 
    
    if (deco==D_HOLD) {                           /* hold sign */
      yc=27;
      if (s->stem==1) 
        y1=s->ys+4; 
      else 
        y1=s->ymx+6;
      if (yc<y1) yc=y1;
      if (yc<top+4) yc=top+4;
      if (top<yc+12) top=yc+12;
      PUT1(" %.1f hld", yc)
    }
    
    if (deco==D_TRILL) {                          /* trill sign */
      yc=30;
      if (s->stem==1) 
        y1=s->ys+5; 
      else 
        y1=s->ymx+7;
      if (yc<y1) yc=y1;
      if (yc<top+1) yc=top+1;
      if (top<yc+8) top=yc+8;
      PUT1(" %.1f trl", yc)
    }

    if ((deco==D_UPBOW)||(deco==D_DOWNBOW)) {     /* bowing signs */
      yc=21;
      if (s->stem==1) 
        y1=s->ys+4; 
      else 
        y1=s->ymx+8;
      if (yc<y1) yc=y1;
      if (yc<top+4) yc=top+4;
      if (top<yc+10) top=yc+10;
      if (deco==D_UPBOW)   PUT1(" %.1f upb", yc)
      if (deco==D_DOWNBOW) PUT1(" %.1f dnb", yc)
    }
  }
  *tp=top;
  return top1;
}


/* ----- draw_note ----- */
float draw_note (x,w,d,s,fl,gchy)
struct SYMBOL *s;
float x,w,d;
float *gchy;
int fl;
{
  char c,cc;
  int y,i,m,k;
  float yc,slen,slen0,top,top2,xx;
  slen0=STEM;

  draw_gracenotes (x, w, d, s);                /* draw grace notes */

  c = 'd'; cc='u';
  if (s->stem==1) { c='u'; cc='d'; }
  slen=s->stem*(s->ys-s->y);

  for (m=0;m<s->npitch;m++) {                       
    if (m>0) PUT0(" ")
    draw_basic_note (x,w,d,s,m);             /* draw note heads */
    xx=3*(s->pits[m]-18)+s->yadd-s->y;
    xx=xx*xx;
    if (xx<0.01) {                                 /* add stem */
      if (s->stem) PUT2(" %.1f s%c",slen,c) 
      if (fl && (s->flags>0))                      /* add flags */
        PUT3(" %.1f f%d%c",slen,s->flags,c)
    }
    if ((m>0) && (s->pits[m]==s->pits[m-1])) {     /* unions */
      if (s->stem) PUT2(" %.2f s%c",slen0,cc) 
      if (s->flags>0)                    
        PUT3(" %.1f f%d%c",slen0,s->flags,cc)
    }
  }

  top=draw_decorations (x,s,&top2);                /* add decorations */
  
  y = s->ymn;                                      /* lower helper lines */
  if (y<=-6) {                           
    for (i=-6;i>=y;i=i-6) PUT1(" %d hl", i)
    if (s->head==H_OVAL) PUT0("1")
  }
  y = s->ymx;                                      /* upper helper lines */
  if (y>=30) {
    for (i=30;i<=y;i=i+6) PUT1(" %d hl", i)
    if (s->head==H_OVAL) PUT0("1")
  }

  *gchy=38;
  if (strlen(s->text)>0) {                         /* position guitar chord */
    yc=*gchy;
    if (yc<y+8) yc=y+8;
    if (yc<s->ys+4) yc=s->ys+4;
    for (k=0;k<s->dc.n;k++) {
      if ((s->dc.t[k]==D_GRACE) && (yc<y+12)) yc=y+12;
    }
    if (yc<top2) yc=top2;
    *gchy=yc;
  }    

  PUT0("\n")
    
  return top;

}


/* ----- vsh: up/down shift needed to get k*6  ----- */
float vsh (x,dir)
int dir;
float x;
{
  int ix,iy,ir;
  float x1,xx;
  x1=x*dir;
  ix=x1+600.999;
  ir=ix%6;
  iy=ix-600;
  if (ir>0) iy=iy+6-ir;
  xx=iy*dir;
  return xx-x;
}


/* ----- rnd3: up/down shift needed to get k*3  ----- */
float rnd3(x)
float x;
{
  int ix,iy,ir;
  float xx;

  ix=x+600.999-1.5;
  ir=ix%3;
  iy=ix-600;
  if (ir>0) iy=iy+3-ir;
  xx=iy;
  return xx-x;
}


/* ----- rnd6: up/down shift needed to get k*6  ----- */
float rnd6(x)
float x;
{
  int ix,iy,ir;
  float xx;

  ix=x+600.999-3.0;
  ir=ix%6;
  iy=ix-600;
  if (ir>0) iy=iy+6-ir;
  xx=iy;
  return xx-x;
}


/* ----- b_pos ----- */
float b_pos (stem,flags,b)
int stem,flags;
float b;
{
  float bb,d1,d2,add;
  float top,bot;

  if (stem==1) {
    top=b;
    bot=b-(flags-1)*BEAM_SHIFT-BEAM_DEPTH;
    if (bot>26) return b;
  }
  else {
    bot=b;
    top=b+(flags-1)*BEAM_SHIFT+BEAM_DEPTH;
    if (top<-2) return b;
  }

  d1=rnd6(top-BEAM_OFFSET);
  d2=rnd6(bot+BEAM_OFFSET); 
  add=d1;
  if (d1*d1>d2*d2) add=d2;
  bb=b+add;

/*  printf ("stem %d top %.1f, bot%.1f, choices %.1f %.1f => %.1f\n", 
          stem, top,bot, d1,d2, add); */
/*  printf ("b_pos(%d) b=%.1f to %.1f\n", stem,b,bb); */

  return bb;
}


/* ----- calculate_beam ----- */
int calculate_beam (i0,bm)
int i0;
struct BEAM *bm;
{
  int j,j1,j2,i,stem,notes,flags;
  float x,y,ys,a,b,max_stem_err,stem_err,min_stem,slen,yyg,yg,try;
  float s,sx,sy,sxx,sxy,syy,delta,hh,dev,dev2,a0;
  
  j1=i0;                      /* find first and last note in beam */
  j2=-1;
  stem=sym[j1].stem;        
  for (j=i0;j<nsym;j++) 
    if (sym[j].word_end) {
      j2=j;
      break;
    }
  if (j2==-1) {
    return 0;
  }
  
  notes=flags=0;                /* set x positions, count notes and flags */
  for (j=j1;j<=j2;j++) {
    if(sym[j].type==NOTE) {   
      sym[j].xs=sym[j].x+stem*STEM_XOFF;
      sym[j].stem=stem;
      if (sym[j].flags>flags) flags=sym[j].flags;
      notes++;
    }
  }
  
  s=sx=sy=sxx=sxy=syy=0;              /* linear fit through stem ends */
  for (j=j1;j<=j2;j++) if (sym[j].type==NOTE) {
    x=sym[j].xs;
    y=sym[j].ymx+STEM*stem;
    s += 1; sx += x; sy += y;
    sxx += x*x; sxy += x*y; syy += y*y;
  }

  delta=s*sxx-sx*sx;                  /* beam fct: y=ax+b */
  a=(s*sxy-sx*sy)/delta;
  b=(sy-a*sx)/s;

  /* the next few lines modify the slope of the beam */
  if (notes>=3) {                   
    hh=syy-a*sxy-b*sy;                /* flatten if notes not in line */
    dev=0;
    if (hh>0) {
      dev2=hh/(notes-2);
      if (dev2>0.5) a=BEAM_FLATFAC*a;   
    }
  }


  if (a>=0) a=BEAM_SLOPE*a/(BEAM_SLOPE+a);   /* max steepness for beam */
  else      a=BEAM_SLOPE*a/(BEAM_SLOPE-a);


  /* to decide if to draw flat etc. use normalized slope a0 */
  a0=a*(sym[j2].xs-sym[j1].xs)/(20*(notes-1));

  if ((a0<BEAM_THRESH) && (a0>-BEAM_THRESH)) a=0;  /* flat below threshhold */

  b=(sy-a*sx)/s;                        /* recalculate b for new slope */

/*  if (flags>1) b=b+2*stem;*/      /* leave a bit more room if several beams */

  if (bagpipe) { b=-11; a=0; }

  max_stem_err=0;                        /* check stem lengths */
  for (j=j1;j<=j2;j++) if (sym[j].type==NOTE) {
    if (sym[j].npitch==1) {
      min_stem=STEM_MIN;
      if (sym[j].flags==2) min_stem=STEM_MIN2;
      if (sym[j].flags==3) min_stem=STEM_MIN3;
      if (sym[j].flags==4) min_stem=STEM_MIN4;
    }
    else {
      min_stem=STEM_CH_MIN;
      if (sym[j].flags==2) min_stem=STEM_CH_MIN2;
      if (sym[j].flags==3) min_stem=STEM_CH_MIN3;
      if (sym[j].flags==4) min_stem=STEM_CH_MIN4;
    }
    min_stem=min_stem+BEAM_DEPTH+BEAM_SHIFT*(sym[j].flags-1);
    ys=a*sym[j].xs+b;
    if (stem==1) slen=ys-sym[j].ymx;
    else         slen=sym[j].ymn-ys;
    stem_err=min_stem-slen;
    if (stem_err>max_stem_err) max_stem_err=stem_err;
  } 
  
  if (max_stem_err>0)                   /* shift beam if stems too short */
    b=b+stem*max_stem_err;

  for (j=j1+1;j<=j2;j++) if (sym[j].type==NOTE) {  /* room for gracenotes */
    for (i=0;i<sym[j].gr.n;i++) {
      yyg=a*(sym[j].x-GSPACE0)+b;
      yg=3*(sym[j].gr.p[i]-18)+sym[j].yadd;
      if (stem==1) {
        try=(yg+GSTEM)-(yyg-BEAM_DEPTH-2);
        if (try>0) b=b+try;
      }
      else {
        try=(yg)-(yyg+BEAM_DEPTH+7);
        if (try<0) b=b+try;
      }
    }
  }

  if ((a<0.01) && (a>-0.01))       /* shift flat beams onto staff lines */
    b=b_pos (stem,flags,b); 

  for (j=j1;j<=j2;j++) if (sym[j].type==NOTE) {    /* final stems */
    sym[j].ys=a*sym[j].xs+b;
  } 

  bm->i1=j1;                      /* save beam parameters in struct */
  bm->i2=j2;
  bm->a=a;
  bm->b=b;
  bm->stem=stem;
  bm->t=stem*BEAM_DEPTH;
  return 1;
}

  
/* ----- rest_under_beam ----- */
float rest_under_beam (x,head,bm)
float x;
int head;
struct BEAM *bm;
{
  float y,tspace,bspace;
  int j1,j2,j,nf,iy;

  tspace=9;
  bspace=11;
  if ((head==H_OVAL)||(head==H_EMPTY)) tspace=bspace=4;
  
  j1=bm->i1;
  j2=bm->i2;
  nf=0;
  for (j=j1;j<=j2;j++) 
    if ((sym[j].type==NOTE)||(sym[j].flags>nf)) nf=sym[j].flags;
  
  if (bm->stem==1) {
    y=bm->a*x+bm->b;
    y=y-BEAM_DEPTH-(nf-1)*BEAM_SHIFT;
    y=y-tspace;
    if (y>12) y=12;
  }
  else {
    y=bm->a*x+bm->b;
    y=y+BEAM_DEPTH+(nf-1)*BEAM_SHIFT;
    y=y+bspace;
    if (y<12) y=12;
  }

  if ((head==H_OVAL)||(head==H_EMPTY)) {
    iy=(y+3.0)/6,0; 
    y=6*iy;
  }

  return y;
}

/* ----- draw_beam_num: draw number on a beam ----- */
void draw_beam_num (bm,num,xn)
struct BEAM *bm;
int num;
float xn;
{
  float yn;
  
  if (bm->stem==-1) 
    yn=bm->a*xn+bm->b-12;
  else 
    yn=bm->a*xn+bm->b+4;
  
  PUT3("%.1f %.1f (%d) bnum\n", xn, yn, num)

}

  
/* ----- draw_beam: draw a single beam ----- */
void draw_beam (x1,x2,dy,bm)
float x1,x2,dy;
struct BEAM *bm;
{
  float y1,y2;

  y1=bm->a*x1+bm->b-bm->stem*dy;
  y2=bm->a*x2+bm->b-bm->stem*dy;
  PUT5("%.1f %.1f %.1f %.1f %.1f bm\n", x1,y1,x2,y2,bm->t)
}
  
/* ----- draw_beams: draw the beams for one word ----- */
void draw_beams (bm)
struct BEAM *bm;
{
  int j,j1,j2,j3,inbeam,k1,k2,num,p,r;
  float x1,x2,xn;
  
  j1=bm->i1;
  j2=bm->i2;

  /* make first beam over whole word */
  x1=sym[j1].xs;
  x2=sym[j2].xs;
  num=sym[j1].u;
  
  for (j=j1;j<=j2;j++) {    /* numbers for nplets on same beam */
    if (sym[j].p_plet>0) {
      p=sym[j].p_plet;
      r=sym[j].r_plet;
      j3=j+r-1;
      if (j3<=j2) {  
        xn=0.5*(sym[j].xs+sym[j3].xs);
        draw_beam_num (bm,p,xn);
        sym[j].p_plet=0;
      }
    }
  }
  
  draw_beam (x1,x2,0.0,bm);
  
  /* second beams where two or more flags */
  k1=0;
  inbeam=0;
  for (j=j1;j<=j2;j++) {
    if (sym[j].type!=NOTE) continue;
    if ((!inbeam) && (sym[j].flags>=2)) {
      k1=j;
      inbeam=1;
    }
    if (inbeam && ((sym[j].flags<2) || (j==j2))) {
      if ((sym[j].flags>=2) && (j==j2)) k2=j;
      x1=sym[k1].xs;
      x2=sym[k2].xs;
      inbeam=0;
      if (k1==k2) {
        if (k1==j1) draw_beam (x1+BEAM_STUB,x1,BEAM_SHIFT,bm);
        else        draw_beam (x1-BEAM_STUB,x1,BEAM_SHIFT,bm);
      }
      else 
        draw_beam (x1,x2,BEAM_SHIFT,bm);
      inbeam=0;
    }
    k2=j;
  }
  
  /* third beams where three or more flags */
  k1=0;
  inbeam=0;
  for (j=j1;j<=j2;j++) {
    if (sym[j].type!=NOTE) continue;
    if ((!inbeam) && (sym[j].flags>=3)) {
      k1=j;
      inbeam=1;
    }
    if (inbeam && ((sym[j].flags<3) || (j==j2))) {
      if ((sym[j].flags>=3) && (j==j2)) k2=j;
      x1=sym[k1].xs;
      x2=sym[k2].xs;
      inbeam=0;
      if (k1==k2) {
        if (k1==j1) draw_beam (x1+BEAM_STUB,x1,2*BEAM_SHIFT,bm);
        else        draw_beam (x1-BEAM_STUB,x1,2*BEAM_SHIFT,bm);
      }
      else 
        draw_beam (x1,x2,2*BEAM_SHIFT,bm);
      inbeam=0;
    }
    k2=j;
  }
  
  /* fourth beams where four or more flags */
  k1=0;
  inbeam=0;
  for (j=j1;j<=j2;j++) {
    if (sym[j].type!=NOTE) continue;
    if ((!inbeam) && (sym[j].flags>=4)) {
      k1=j;
      inbeam=1;
    }
    if (inbeam && ((sym[j].flags<4) || (j==j2))) {
      if ((sym[j].flags>=4) && (j==j2)) k2=j;
      x1=sym[k1].xs;
      x2=sym[k2].xs;
      inbeam=0;
      if (k1==k2) {
        if (k1==j1) draw_beam (x1+BEAM_STUB,x1,3*BEAM_SHIFT,bm);
        else        draw_beam (x1-BEAM_STUB,x1,3*BEAM_SHIFT,bm);
      }
      else 
        draw_beam (x1,x2,3*BEAM_SHIFT,bm);
      inbeam=0;
    }
    k2=j;
  }
  
}

/* ----- extreme: return min or max, depending on s ----- */
float extreme (s, a, b)
float s,a,b;
{

  if (s>0) {
    if (a>b) return a;
    return b;
  }
  else {
    if (a<b) return a;
    return b;
  }
}

/* ----- draw_bracket  ----- */
void draw_bracket (p,j1,j2)
int p,j1,j2;
{
  float x1,x2,y1,y2,xm,ym,s,s0,xx,yy,yx,dy;
  int j;

  x1=sym[j1].x-4;
  x2=sym[j2].x+4;
  y1=sym[j1].ymx+10;
  y2=sym[j2].ymx+10;

  if (sym[j1].stem==1) { y1=sym[j1].ys+8; x1=x1+3; }
  if (sym[j2].stem==1) { y2=sym[j2].ys+8; x2=x2+3; }
    
  if (y1<32) y1=32;
  if (y2<32) y2=32; 

  xm=0.5*(x1+x2);
  ym=0.5*(y1+y2);

  s=(y2-y1)/(x2-x1);
  s0=(sym[j2].ymx-sym[j1].ymx)/(x2-x1);
  if (s0>0) {
    if (s<0) s=0; if (s>s0) s=s0; 
  }
  else {
    if (s>0) s=0; if (s<s0) s=s0; 
  }
  if (s*s < 0.1*0.1) s=0;


  dy=0;           /* shift up bracket if needed */
  for (j=j1;j<=j2;j++) {
    if ((sym[j].type==NOTE) || (sym[j].type==REST)) {
      xx=sym[j].x;
      yy=ym+(xx-xm)*s;
      yx=sym[j].ymx+10;
      if (sym[j].stem==1) yx=sym[j].ys+8;
      if (yx-yy>dy) dy=yx-yy;
    }
  }
  ym=ym+dy;
  y1=ym+s*(x1-xm);
  y2=ym+s*(x2-xm);
  
  xx=xm-6;
  yy=ym+s*(xx-xm);
  PUT4("%.1f %.1f %.1f %.1f hbr ",  x1,y1,xx,yy)

  xx=xm+6;
  yy=ym+s*(xx-xm);
  PUT4("%.1f %.1f %.1f %.1f hbr ",  x2,y2,xx,yy)

  yy=0.5*(y1+y2);
  PUT3("%.1f %.1f (%d) bnum\n", xm, yy-4, p)

}

/* ----- draw_nplet_brackets  ----- */
void draw_nplet_brackets ()
{
  int i,j,k,p,r,c;
  
  for (i=0;i<nsym;i++) {
    if ((sym[i].type==NOTE) || (sym[i].type==REST)) {
      if (sym[i].p_plet>0) {
        p=sym[i].p_plet;
        r=sym[i].r_plet;
        c=r;
        k=i;
        for (j=i;j<nsym;j++) {
          if ((sym[j].type==NOTE) || (sym[j].type==REST)) {
            c--; 
            k=j; 
            if (c==0) break;
          }
        }
        draw_bracket (p,i,k);
      }
    }
  }
}


/* ----- slur_direction: decide whether slur goes up or down --- */
float slur_direction (k1,k2)
int k1,k2;
{
  float s;
  int i,are_stems,are_downstems,y_max;

  are_stems=are_downstems=0;  
  y_max=300;
  for (i=k1;i<=k2;i++) {
    if (sym[i].type==NOTE) {
      if (sym[i].stem != 0 )  are_stems=1;
      if (sym[i].stem == -1 ) are_downstems=1;
      if (sym[i].ymn<y_max) y_max=sym[i].ymn;
    }
  }
  s=-1;
  if (are_downstems) s=1;
  if (!are_stems) {
    s=1;
    if (y_max<12) s=-1;
  }
  return s;
}

/* ----- output_slur: output slur -- --- */
void output_slur (x1,y1,x2,y2,s,height,shift)
float x1,y1,x2,y2,s,height,shift;
{
  float alfa,beta,mx,my,xx1,yy1,xx2,yy2,dx,dy,dz,a,add;
       
  alfa=0.3;                
  beta=0.45;

  /* for wide flat slurs, make shape more square */
  dy=y2-y1;
  if (dy<0) dy=-dy;
  dx=x2-x1;
  if (dx<0) dx=-dx;
  a=dy/dx;
  if ((a<0.7) && dx>40) {
    add=0.2*(dx-40)/100;
    alfa=0.3+add;
    if (alfa>0.7) alfa=0.7;
  }


  /* alfa, beta, and height determine Bezier control points pp1,pp2 
   *
   *           X====alfa===|===alfa=====X  
   *          /            |             \
   *        pp1            |              pp2
   *        /            height            \
   *      beta             |                beta
   *      /                |                 \
   *    p1                 m                  p2
   *       
   */


  mx=0.5*(x1+x2);
  my=0.5*(y1+y2);

  xx1=mx+alfa*(x1-mx);
  yy1=my+alfa*(y1-my)+height;
  xx1=x1+beta*(xx1-x1);
  yy1=y1+beta*(yy1-y1); 

  xx2=mx+alfa*(x2-mx);
  yy2=my+alfa*(y2-my)+height;
  xx2=x2+beta*(xx2-x2);
  yy2=y2+beta*(yy2-y2); 

  dx=0.03*(x2-x1);
  if (dx>10.0) dx=10.0;
  dy=1.0;
  dz=0.20;
  if (x2-x1>100) dz=dz+0.001*(x2-x1);
  if (dz>0.6) dz=0.6;

  PUT4("%.1f %.1f %.1f %.1f ", 
       xx2-dx, yy2+shift+s*dy, xx1+dx, yy1+shift+s*dy)
  PUT3("%.1f %.1f 0 %.1f ", x1,y1+shift+s*dz,s*dz)
  PUT4("%.1f %.1f %.1f %.1f ", xx1,yy1+shift,xx2,yy2+shift)
  PUT4("%.1f %.1f %.1f %.1f SL\n", x2,y2+shift, x1,y1+shift)


/*PUT4("%.2f %.2f %.2f %.2f ", xx1,yy1+shift,xx2,yy2+shift)
  PUT4("%.2f %.2f %.2f %.2f sl\n", x2,y2+shift, x1,y1+shift)*/

  return;
}

/* ----- draw_slur (not a pretty routine, this) ----- */
void draw_slur (k1,k2,nn,level)
int k1,k2,level,nn;
{
  float x01,x02,y01,y02;
  float x1,y1,x2,y2,yy,height,addx,addy;
  float s,shift,hmin,a;
  float x,y,z,h,dx,dy;
  int i;

  s=slur_direction (k1,k2);
  
  /* fix endpoints */
  if (sym[k1].type==NOTE) {            /* here if k1 points to note */
    x01=sym[k1].x;
    yy=sym[k1].ymn; if (s>0) yy=sym[k1].ymx;
    y01=extreme(s,yy+s*6,sym[k1].ys+s*2);
    if (sym[k1].word_end) {
      yy=sym[k1].ymn; if (s>0) yy=sym[k1].ymx;
      y01=yy+s*6;
      if ((sym[k1].stem==1)&&(s==1)) x01=x01+4;
    }
    if ((s>0) && (y01<sym[k1].dc.top+2.5)) y01=sym[k1].dc.top+2.5;
  }

  if (sym[k2].type==NOTE) {            /* here if k2 points to note */
    x02=sym[k2].x;
    yy=sym[k2].ymn; if (s>0) yy=sym[k2].ymx;
    y02=extreme(s,yy+s*6,sym[k2].ys+s*2);
    if (sym[k2].word_st) {
      yy=sym[k2].ymn; if (s>0) yy=sym[k2].ymx;
      y02=yy+s*6;
      if ((sym[k2].stem==-1)&&(s==-1)) x02=x02-3;
    }  
    if ((s>0) && (y02<sym[k2].dc.top+2.5)) y02=sym[k2].dc.top+2.5;
  }

  if (sym[k1].type!=NOTE) {
    x01=sym[k1].x+sym[k1].wr;
    y01=y02+1.2*s; 
    if (nn>1) {
      if(s==1) { if (y01<28) y01=28; } 
      else     { if (y01>-4) y01=-4; }
    }
  }
  
  if (sym[k2].type!=NOTE) {
    x02=sym[k2].x; 
    y02=y01+1.2*s; 
    if (nn>1) {
      if (s==1) {if (y02<28) y02=28; }
      else      {if (y02>-4) y02=-4; }
    }
  }

  /* shift endpoints */
  addx=0.04*(x02-x01);
  if (addx>3.0) addx=3.0;
  addy=0.02*(x02-x01);
  if (addy>3.0) addy=3.0;
  x1 = x01+addx;
  x2 = x02-addx;
  y1=y01+s*addy;
  y2=y02+s*addy;

  a=(y2-y1)/(x2-x1);                    /* slur steepness */     
  if (a >  SLUR_SLOPE) a= SLUR_SLOPE;  
  if (a < -SLUR_SLOPE) a=-SLUR_SLOPE;  
  if (a>0) {
    if (s ==  1) y1=y2-a*(x2-x1);
    if (s == -1) y2=y1+a*(x2-x1);
  }
  else {
    if (s == -1) y1=y2-a*(x2-x1);
    if (s ==  1) y2=y1+a*(x2-x1);
  }  

  /* for big vertical jump, shift endpoints */
  y=y2-y1; if (y>8) y=8; if (y<-8) y=-8; 
  z=y; if(z<0) z=-z; dx=0.5*z; dy=0.3*z;
  if (y>0) {
    if (s==1) { x2=x2-dx; y2=y2-dy; }
    if (s==-1) { x1=x1+dx; y1=y1+dy; }
  }
  else {
    if (s==1) { x1=x1+dx; y1=y1-dy; }
    if (s==-1) { x2=x2-dx; y2=y2+dy; }
  }

  h=0;
  for (i=k1+1; i<k2; i++) 
    if (sym[i].type==NOTE) {
      x = sym[i].x;
      yy = sym[i].ymn; if (s>0) yy=sym[i].ymx;
      y = extreme (s, yy+6*s, sym[i].ys+2*s);
      z = (y2*(x-x1)+y1*(x2-x))/(x2-x1);
      h = extreme (s, h, y-z);
    }

  y1=y1+0.4*h;
  y2=y2+0.4*h;
  h=0.6*h;
  
  hmin=s*(0.03*(x2-x1)+8);
  if (nn>3) hmin=s*(0.12*(x2-x1)+12);
  height = extreme (s, hmin, 3.0*h);
  height = extreme (-s, height, s*50);
  
  y=y2-y1; if (y<0) y=-y;
  if ((s==1)  && (height< 0.8*y)) height=0.8*y;
  if ((s==-1) && (height>-0.8*y)) height=-0.8*y; 

  shift=3*s*level;

  output_slur (x1,y1,x2,y2,s,height,shift);

  return;
}


/* ----- prev_scut, next_scut: find place to terminate/start slur --- */
int next_scut (i)
int i;
{
  int j,cut,ok;
  
  cut=nsym-1;
  for (j=i+1;j<nsym;j++) {
    ok=0;
    if (sym[j].type==BAR) {
      if (sym[j].u==B_RREP) ok=1;
      if (sym[j].u==B_DREP) ok=1;
      if (sym[j].u==B_FAT1) ok=1;
      if (sym[j].u==B_FAT2) ok=1;
      if (sym[j].v==2)      ok=1;
    }
    if(ok) {
      cut=j;
      break;
    }
  }
  return cut;
}

int prev_scut(i)
int i;
{
  int j,cut,ok;

  cut=-1;
  for (j=i;j>=0;j--) {
    ok=0;
    if (sym[j].type==BAR) {
      if (sym[j].u==B_LREP) ok=1;
      if (sym[j].u==B_DREP) ok=1;
      if (sym[j].u==B_FAT1) ok=1;
      if (sym[j].u==B_FAT2) ok=1;
      if (sym[j].v==2)      ok=1;
    }
    if(ok) {
      cut=j;
      break;
    }
  }

  if (cut==-1) {    /* return sym before first note */
    cut=0;
    for (j=0;j<nsym;j++) {
      if((sym[j].type==REST) || (sym[j].type==NOTE)) {
        cut=j-1;
        break;
      }
    }
  }

  return cut;
}
  

/* ----- draw_chord_slurs ----- */
void draw_chord_slurs(k1,k2,nh1,nh2,nslur,mhead1,mhead2,job)
int k1,k2,nh1,nh2,nslur,mhead1[MAXHD],mhead2[MAXHD],job;
{

  int i,pbot,ptop,m1,m2,p1,p2,y,cut;
  float s,x1,y1,x2,y2,height,shift,addx,addy;

  if (nslur==0) return;

  pbot=1000;
  ptop=-1000;
  for (i=0;i<sym[k1].npitch;i++) {
    p1=sym[k1].pits[i];
    if (p1<pbot) pbot=p1;
    if (p1>ptop) ptop=p1;
  }
  
  for (i=0;i<nslur;i++) {
    m1=mhead1[i];
    m2=mhead2[i];
    p1=sym[k1].pits[m1];
    p2=sym[k2].pits[m2];
    s=slur_direction (k1,k2);
    if (p1==pbot) s=-1;
    if (p1==ptop) s=1;
    
    x1=sym[k1].x;
    x2=sym[k2].x;
    if (job==2) {
      cut=next_scut(k1);
      x2=sym[cut].x;
      if (cut==k1) x2=x1+30;
    }

    if (job==1) {
      cut=prev_scut(k1);
      x1=sym[cut].x;
      if (cut==k1) x2=x1-30;
    }
      
    addx=0.04*(x2-x1);
    if (addx>3.0) addx=3.0;
    addy=0.02*(x2-x1);
    if (addy>3.0) addy=3.0;

    x1=x1+3+addx;
    x2=x2-3-addx;
    if ((s==1)  && (sym[k1].stem==1))  x1=x1+1.5;
    if ((s==-1) && (sym[k2].stem==-1)) x2=x2-1.5;

    y=3*(p1-18)+sym[k1].yadd;
    y1=y2=y+s*(4+addy);
    y=3*(p2-18)+sym[k2].yadd;
    y2=y+s*(4+addy);

    if ((s==1) && !(y%6) && (sym[k1].dots>0)) {
      y2=y1=y+s*(5.5+addy);
      x1=x1-2;
      x2=x2+2;
    }
    height=s*(0.04*(x2-x1)+5);
    shift=0;
    output_slur (x1,y1,x2,y2,s,height,shift);
  }

}



/* ----- draw_slurs: draw slurs/ties between neighboring notes/chords  --- */
void draw_slurs (k1,k2,job)
int k1,k2,job;
{
  int i,m1,m2;
  int mhead1[MAXHD],mhead2[MAXHD],nslur,nh1,nh2;

  if (nbuf+100>BUFFSZ) 
    rx ("PS output exceeds reserved space per staff",
        " -- increase BUFFSZ1");

  nslur=0;

  if (job==2) {                    /* half slurs from last note in line */
    nh1=sym[k1].npitch;
    for (i=1;i<=nh1;i++) {
      for (m1=0;m1<nh1;m1++) {
        if (sym[k1].sl1[m1]==i) {
          nslur=nslur+1;
          mhead1[nslur-1]=m1;
        }
        if (sym[k1].ti1[m1]) {
          nslur=nslur+1;
          mhead1[nslur-1]=m1;
        }
      }
    }
    draw_chord_slurs(k1,k1,nh1,nh1,nslur,mhead1,mhead1,job);
    return;
  }

  if (job==1) {                    /* half slurs to first note in line */
    nh1=sym[k1].npitch;
    for (i=1;i<=nh1;i++) {
      for (m1=0;m1<nh1;m1++) {
        if (sym[k1].sl2[m1]==i) {
          nslur=nslur+1;
          mhead1[nslur-1]=m1;
        }
        if (sym[k1].ti2[m1]) {
          nslur=nslur+1;
          mhead1[nslur-1]=m1;
        }
      }
    }
    draw_chord_slurs(k1,k1,nh1,nh1,nslur,mhead1,mhead1,job);
    return;
  }
  
  /* real 2-note case: set up list of slurs/ties to draw */
  if ((sym[k1].type==NOTE) && (sym[k2].type==NOTE)) {
    nh1=sym[k1].npitch;
    nh2=sym[k2].npitch;

    for (m1=0;m1<nh1;m1++) {
      if (sym[k1].ti1[m1]) {
        for (m2=0;m2<nh2;m2++) {
          if (sym[k2].pits[m2]==sym[k1].pits[m1]) {
            nslur++;
            mhead1[nslur-1]=m1;
            mhead2[nslur-1]=m2;
            break;
          }
        }
      }
    }

    for (i=1;i<=nh1;i++) {
      for (m1=0;m1<nh1;m1++) {
        if (sym[k1].sl1[m1]==i) {
          nslur++;
          mhead1[nslur-1]=m1;
          mhead2[nslur-1]=-1;
          for (m2=0;m2<nh2;m2++) {
            if (sym[k2].sl2[m2]==i) mhead2[nslur-1]=m2;
          }
          if (mhead2[nslur-1]==-1) nslur--;
        }
      }  
    }
  }
    
  draw_chord_slurs(k1,k2,nh1,nh2,nslur,mhead1,mhead2,job);
}



/* ----- draw_phrasing: draw phrasing slur between two symbols --- */
void draw_phrasing (k1,k2,level)
int k1,k2,level;
{
  int nn,i,m1,m2;
  
  if (k1==k2) return;
  if (nbuf+100>BUFFSZ) 
    rx ("PS output exceeds reserved space per staff",
        " -- increase BUFFSZ1");
  nn=0;
  for (i=k1;i<=k2;i++) 
    if ((sym[i].type==NOTE)||(sym[i].type==REST)) nn++;
  
  draw_slur (k1,k2,nn,level);
  
}

/* ----- draw_all_slurs: draw all slurs/ties between neighboring notes --- */
void draw_all_slurs ()
{
  int i,i1,i2;

  i1=-1;
  for (i=0;i<nsym;i++) {
    if (sym[i].type==NOTE) {
      i1=i;
      break;
    }
  }
  if (i1<0) return;
  draw_slurs(i1,i1,1);
  
  for (;;) {
    i2=-1;
    for (i=i1+1;i<nsym;i++) {
      if (sym[i].type==NOTE) {
        i2=i;
        break;
      }
    }
    if (i2<0) break;
    draw_slurs(i1,i2,0);
    i1=i2;
  }
  
  draw_slurs(i1,i1,2);

}

/* ----- draw_all_phrasings: draw all phrasing slurs for one staff ----- */
void draw_all_phrasings ()
{
  int i,j,k,cut,pass,num;

  for (pass=0;;pass++) {
    num=0;
    for (i=0;i<nsym;i++) {
      
      if (sym[i].slur_st) {      
        k=-1;                       /* find matching slur end */
        for (j=i+1;j<nsym;j++) {
          if (sym[j].slur_st && (!sym[j].slur_end)) break;
          if (sym[j].slur_end) {
            k=j;
            break;
          }
        }
        if (k>=0) {
          cut=next_scut(i);
          if (cut<k) {
            draw_phrasing (i,cut,pass);
            cut=prev_scut(k);
            draw_phrasing (cut,k,pass);
          }
          else {
            draw_phrasing (i,k,pass);
          }
          num++;
          sym[i].slur_st--;
          sym[k].slur_end--;
        }
      }
    }
    if (num==0) break;
  }

  /* do unbalanced slurs still left over */
  
  for (i=0;i<nsym;i++) {
    if (sym[i].slur_end) {
      cut=prev_scut(i);
      draw_phrasing (cut,i,0);
    }
    if (sym[i].slur_st) {
      cut=next_scut(i);
      draw_phrasing (i,cut,0);
    }
  }    
  
}

/* ----- check_bars ---------- */
void check_bars ()
{
  int i;

  /* split up unsuitable bars at staff end */
  i=nsym-1;               
  if (sym[i].type==BAR) {
    if (sym[i].u==B_LREP) {
      sym[i].u=B_SNGL; 
      insert_btype=B_LREP; 
      insert_num=0;
      if (sym[i-1].type==BAR) {   /* avoid consecutive bars */
        sym[i].u=sym[i-1].u;
        sym[i].v=sym[i-1].v;
        sym[i-1].u=B_INVIS;
      }
    }
    else if (sym[i].u==B_DREP) {
      sym[i].u=B_RREP;               
      insert_btype=B_LREP; 
      insert_num=0;
    }
    else if ((sym[i].u==B_RREP) && (sym[i].v!=0)) {
      insert_btype=B_INVIS; 
      insert_num=sym[i].v;
      sym[i].v=0;
    }
    else if ((sym[i].u==B_SNGL) && (sym[i].v!=0)) {
      insert_btype=B_INVIS; 
      insert_num=sym[i].v;
      sym[i].v=0;
    }
  }

  /* merge back-to-back repeat bars */
  for (i=0;i<nsym-1;i++) {
    if ((sym[i].type==BAR) && (sym[i].u==B_RREP)) {
      if ((sym[i+1].type==BAR) && (sym[i+1].u==B_LREP)) {
        sym[i].type=INVISIBLE;
        sym[i+1].u=B_DREP;
        sym[i+1].x=0.5*(sym[i].x+sym[i+1].x);
      }
    }
  }

  /* remove single bars next to another bar */
  for (i=1;i<nsym-1;i++) {
    if ((sym[i].type==BAR) && (sym[i].u==B_SNGL)) {
      if ((sym[i+1].type==BAR) && (sym[i+1].u!=B_INVIS))
        sym[i].type=INVISIBLE;
      if ((sym[i-1].type==BAR) && (sym[i-1].u!=B_INVIS))
        sym[i].type=INVISIBLE;
    }
  }

  /* remove double bars next to another bar */
/*for (i=1;i<nsym-1;i++) {
    if ((sym[i].type==BAR) && (sym[i].u==B_DBL)) {
      if ((sym[i+1].type==BAR) && (sym[i+1].u!=B_INVIS))
        sym[i].type=INVISIBLE;
      if ((sym[i-1].type==BAR) && (sym[i-1].u!=B_INVIS))
        sym[i].type=INVISIBLE;
    }
  } */

}


/* ----- draw_vocals ----- */
void draw_vocals (fp,nwl,botnote,botpos)
FILE *fp;
float botnote;
float *botpos;
int nwl;
{
  int i,hyflag,l,j,p;
  float x,x0,yword,lastx,spc,vfsize,w,swfac,lskip;
  char word[81],t[81];
  
  if (nwl<=0) return;
  vfsize=cfmt.vocalfont.size;
  lskip=1.1*vfsize;
  set_font (fp, cfmt.vocalfont, 0);
  yword=-cfmt.vocalspace;
  swfac=1.05;
  if (strstr(cfmt.vocalfont.name,"Helvetica")) swfac=1.10;
  if (botnote-cfmt.vocalfont.size<yword) 
    yword=botnote-cfmt.vocalfont.size;
  
  for (j=0;j<nwl;j++) {
    hyflag=0;
    lastx=-10;
    for (i=0;i<nsym;i++) {          
      if (sym[i].wordp[j]) {
        strcpy(word,sym[i].wordp[j]);
        x0=sym[i].x-5;
        p=0;
        while (isdig(word[p]) || word[p]=='~' || word[p]=='.' || 
               word[p]=='\"' || word[p]=='\'') p++; 
        x0=x0-p*vfsize*swfac*cwid('1');
        l=strlen(word);

        if (hyflag) {
          spc=x0-lastx;
          x = lastx+0.5*spc-0.5*swfac*vfsize*cwid('-');
          PUT2("%.1f %.1f whf ",x,yword)
          hyflag=0;
        }

        if ((l>1) && (word[l-1]=='^')) {
          word[l-1]='\0';
          hyflag=1;
        }

        if ((l==1) && (word[0]=='_')) {
          if (lastx<0) lastx=sym[i-1].x+sym[i-1].wr;
          PUT3("%.1f %.1f %.1f wln ", lastx+3, sym[i].x+1, yword)
        } 
        else if ((l==1) && (word[0]=='^')) {
          PUT2("%.1f %.1f whf ", x0, yword)
          lastx=x0+vfsize*swfac*w;
        }
        else {
          tex_str (word,t,&w);
          PUT3("(%s) %.1f %.1f wd ", t, x0, yword)
          lastx=x0+vfsize*swfac*w;
        }
      }
    }
    if (hyflag) PUT2("%.1f %.1f whf ",lastx+5,yword)
    yword=yword-lskip;
  } 
  *botpos=yword + lskip - 0.5*cfmt.staffsep;
}  


/* ----- draw_symbols: draw symbols at proper positions on staff ----- */
void draw_symbols (fp,bpos)
FILE *fp;
float *bpos;
{
  int i,inbeam,j,nwl;
  float x,y,top,xl,d,w,gchy,botnote,botpos;
  struct BEAM bm;
  
  inbeam=do_words=0;
  botnote=0;
  nwl=0;
  for (i=0;i<nsym;i++) {                      /* draw the symbols */

    for (j=0;j<NWLINE;j++) 
      if (sym[i].wordp[j]) {
        if (j+1>nwl) nwl=j+1;
      }
    if (nbuf+100>BUFFSZ) 
      rx ("PS output exceeds reserved space per staff",
          " -- increase BUFFSZ1");
    x=sym[i].x;

    switch (sym[i].type) {
      
    case NOTE:
      nnote++;
      xl=0;
      if (i>0) xl=sym[i-1].x;
      d=x-xl;
      w=sym[i].shrink;

      if (sym[i].word_st && !sym[i].word_end) {
        if (calculate_beam (i,&bm)) inbeam=1;
      }
      if (inbeam) {
        top=draw_note(x,w,d,&sym[i],0,&gchy);
        if (i==bm.i2) {
          inbeam=0;
          draw_beams (&bm);
        }
      }
      else {
        top=draw_note(x,w,d,&sym[i],1,&gchy);
      }
      sym[i].gchy=gchy;
      sym[i].dc.top=top;
      if (sym[i].ymn-5<botnote) botnote=sym[i].ymn-5;
      break;
      
    case REST:
      nnote++;
      y=sym[i].y;
      if (inbeam) y=rest_under_beam (sym[i].x,sym[i].head,&bm);
      draw_rest(x,y,sym[i],&gchy);
      sym[i].gchy=gchy;
      break;
      
    case BAR:
      update_endings (x,sym[i]);
      draw_bar (x,sym[i]);
      break;
      
    case CLEF:
      if (sym[i].u==TREBLE) {
        if (sym[i].v) PUT1("%.1f stclef\n", x)
        else          PUT1("%.1f tclef\n", x)
      }
      else if (sym[i].u==BASS) {
        if (sym[i].v) PUT1("%.1f sbclef\n", x)
        else          PUT1("%.1f bclef\n", x)
      }
      else if (sym[i].u==ALTO) {
        if (sym[i].v) PUT1("%.1f scclef\n", x)
        else          PUT1("%.1f cclef\n", x)
      }
      else 
        bug("unknown keytype", 0);
      keytype=sym[i].u;
      y_add=0;
      if (keytype==BASS) y_add=-6;
      if (keytype==ALTO) y_add=-3;
      break;
      
    case TIMESIG:
      draw_timesig (x,sym[i]);
      break;
      
    case KEYSIG:
      draw_keysig (x,sym[i]);
      sharps_flats=sym[i].z;
      break;

    case INVISIBLE:
      break;
      
    default:
      printf (">>> cannot draw symbol type %d\n", sym[i].type);
    }
  }

  set_font(fp,cfmt.gchordfont,0);
  for (i=0;i<nsym;i++) {                       /* draw guitar chords */
    if ((sym[i].type==NOTE)||(sym[i].type==REST)) {
      if (strlen(sym[i].text)>0) {
        PUT3("%.1f %.1f (%s) gc ", sym[i].x-5, sym[i].gchy, sym[i].text)
      }
    }
  }


  draw_nplet_brackets ();

  draw_all_slurs ();

  draw_all_phrasings ();

  draw_endings ();

  botpos=-0.5*cfmt.staffsep;
  if (botnote<botpos) botpos=botnote;

  if (nwl>0 && !cfmt.musiconly) 
    draw_vocals (fp,nwl,botnote,&botpos);

  *bpos=botpos;

}


/* ----- find_piece: returns number of syms for piece to output ------ */
int find_piece ()
{
  int i,i0,j0,num,count_this,was_first_ending,number,marked;
  
  number=cfmt.barsperstaff;

  marked=nsym;                    /* find first marked symbol */
  for (i=0;i<nsym;i++) {
    if (sym[i].eoln) {
      marked=i+1;
      break;
    }
  }
  if (number==0) return marked;

  j0=0;
  for (i=0;i<nsym;i++) {             /* find first note or rest */
    if ((sym[i].type==NOTE)||(sym[i].type==REST)) {
      j0=i;
      break;
    }
  }
  
  num=0;
  for (i=j0+1;i<nsym;i++) {  
    count_this=0;
    if (sym[i].type==BAR) {
      count_this=1;
      if (sym[i].u==B_INVIS) count_this=0;
      if ((i>0) && (sym[i-1].type==BAR)) count_this=0;
/*      if ((sym[i].v==2) && was_first_ending) count_this=0;  */
      was_first_ending=0;
      if (sym[i].v==1) was_first_ending=1;
    }
    i0=i+1;
    num=num+count_this;
    if (num==number) break;
  }
  
  return i0;
  
}


/* ----- cut_symbols: cut out symbols up to number ------ */
int cut_symbols (number,nsymtot)
int number,nsymtot;
{
  int i,nsymleft,nsymstart;
    
  nsym=0;
  init_music_line ();
  nsymstart=nsym;
  if (number>nsymtot) rx("Cannot cut more symbols than left","");
  nsymleft=nsymstart+nsymtot-number;
  
  for (i=nsymstart;i<nsymleft;i++) {
    sym[i]=sym[i+number-nsymstart];
  }

  mes1=mes2=0; 

  return nsymleft;
}


/* ----- output_music: output for parsed symbol list ----- */
void output_music (fp)
FILE *fp;
{
  int nsymtot,nsym1;
  float realwidth,staffwidth;
  float lscale,lwidth,bpos;

  if (verbose>8) printf ("output_music: nsym=%d\n", nsym);
  if (verbose>9) print_syms (nsym);

  if (!file_initialized && !epsf) {
    init_ps (fout,infostr,0,0.0,0.0,0.0,0.0); 
    init_page (fout);
  }
  if (nsym==0) return;

  mline=0;
  alfa_last=0.1; beta_last=0.0;
  meter_flag=1;

  lwidth=cfmt.staffwidth;   
  lscale=cfmt.scale;
  check_margin (cfmt.leftmargin);

  /* dump buffer if not enough space for a staff line */
  check_buffer (fp, BUFFSZ1);

  for (;;) {          /* loop over pieces of line for output */
    mline++;

    nsymtot=nsym;
    nsym1=find_piece ();
    nsym=nsym1;
    
    set_sym_chars ();
    set_beams ();
    set_stems ();
    set_sym_widths ();
    nsym1=set_sym_glue (nsymtot,lwidth/lscale,&realwidth);
    nsym=nsym1;
      
    PUT1("\n%% --- line %d\n", mline)  
    bskip (lscale*(0.5*cfmt.staffsep+24));
    PUT3("gsave %.3f %.3f scale %.2f setlinewidth\n", 
         lscale, lscale, BASEWIDTH)
    staffwidth=realwidth;
/*    if (STRETCH_STAFF) staffwidth=lwidth/lscale; */
    PUT1("%.2f staff\n", staffwidth)
    check_bars ();
    draw_symbols (fp,&bpos);
    PUT0("grestore\n")
    bskip(-bpos*lscale);
    buffer_eob (fp);
    if (verbose>8) printf ("... staff %d, wrote %d symbols of %d\n\n", 
                           mline, nsym, nsymtot);
    if (nsymtot<=nsym1) break;
    nsym=cut_symbols (nsym1,nsymtot);
  }
  nsym=0;
}

/* ----- reset_music_line: init pars for parsing music line ------ */
void reset_music_line ()
{

  /* nsym=0 tells parser to initialize line with clef and key */
  nsym=nsym0=0;  
  word=0;
  carryover=0;
  last_note=last_real_note=-1;
  pplet=qplet=rplet=0;
  nnote=0;
  num_ending=0;
  mes1=mes2=0;
  strcpy (gch, "");

}

/* ----- process_textblock ----- */
void process_textblock(fpin,fp,job)
FILE *fp,*fpin;
int  job;
{
  char w1[81],ln[BSIZE],ln1[BSIZE];
  float lwidth,baseskip,parskip;
  int i,ll,add_final_nl;

  baseskip = cfmt.textfont.size * cfmt.lineskipfac;
  parskip  = cfmt.textfont.size * cfmt.parskipfac;
  add_final_nl=0;
  if (job==OBEYLINES) add_final_nl=1;
  lwidth=cfmt.staffwidth;
  output_music (fp); 
  buffer_eob (fp); 
  set_font (fp, cfmt.textfont, 0);
  ntxt=0;
  for (i=0;i<100;i++) {
    if (feof(fpin)) rx("EOF reached scanning text block","");
    strcpy (ln, "");
    fgets(ln, BSIZE, fpin);
    ll=strlen(ln);
    linenum++;
    if (ln[ll-1]=='\n') ln[ll-1]='\0';
    if ((verbose>=5) || (vb>=10) ) printf ("%3d  %s \n", linenum, ln);
    if ((ln[0]=='%') && (ln[1]=='%')) {
      strcpy(ln1,ln+2);
      strcpy(ln,ln1);
    }

    strcpy(w1,"");
    sscanf(ln,"%s",w1);
    if (!strcmp(w1,"endtext")) break;

    if (job!=SKIP) {
      if (isblank(ln)) {
        write_text_block (fp,job);
        ntxt=0;
      }
      else {
        add_to_text_block (ln,add_final_nl);
      }
    }
  }
  if (job!=SKIP) write_text_block (fp,job);
}


/* ----- process_pscomment  ----- */
void process_pscomment (fpin,fp,line)
FILE *fp,*fpin;
char line[];
{
  char w[81],fstr[81],unum1[41],unum2[41],unum3[41];
  float h1,h2,len,lwidth;
  int i,nch,job;

  lwidth=cfmt.staffwidth;
  line[0]=' ';
  line[1]=' ';
  for (i=0;i<strlen(line);i++) if (line[i]=='%') line[i]='\0';
  strcpy(w," ");
  sscanf(line,"%s%n", w, &nch);

  if (!strcmp(w,"begintext")) {
    if (epsf && !within_block) return;
    strcpy(fstr,"");
    sscanf(line, "%*s %s", fstr);
    if (isblank(fstr)) strcpy(fstr,"obeylines");
    if      (!strcmp(fstr,"obeylines")) job=OBEYLINES;
    else if (!strcmp(fstr,"align"))     job=ALIGN;
    else if (!strcmp(fstr,"skip"))      job=SKIP;
    else if (!strcmp(fstr,"ragged"))    job=RAGGED;
    else rx("bad argument for begintext: ",fstr);
    if (within_block && !do_this_tune) job=SKIP;
    process_textblock (fpin,fp,job);
    return;
  }
  
  if (!strcmp(w,"text") || !strcmp(w,"center")) {
    if (epsf && !within_block) return;
    if (within_block && !do_this_tune) return;
    output_music (fp); 
    set_font (fp, cfmt.textfont, 0);
    ntxt=0;
    add_to_text_block (line+nch+1,1);
    if (!strcmp(w,"text"))
      write_text_block (fp,OBEYLINES);
    else
      write_text_block (fp,OBEYCENTER);
    buffer_eob (fp); 
  }

  else if (!strcmp(w,"sep")) {
    if (within_block && !do_this_tune) return;
    output_music (fp); 
    strcpy(unum1,"");
    strcpy(unum2,"");
    strcpy(unum3,"");
    sscanf(line,"%*s %s %s %s", unum1,unum2,unum3);
    g_unum(unum1,0,&h1);
    g_unum(unum2,0,&h2);
    g_unum(unum3,0,&len);
    if (h1*h1<0.00001) h1=0.5*CM;
    if (h2*h2<0.00001) h2=h1;
    if (len*len<0.0001) len=3.0*CM;
    bskip (h1);
    PUT2("%.1f %.1f sep0\n", lwidth/2-len/2, lwidth/2+len/2);
    bskip (h2);
    buffer_eob (fp); 
  }

  else if (!strcmp(w,"vskip")) {
    if (within_block && !do_this_tune) return;
    output_music (fp); 
    strcpy(unum1,"");
    sscanf(line,"%*s %s", unum1);
    g_unum(unum1,0,&h1);
    if (h1*h1<0.00001) h1=0.5*CM;
    bskip (h1);
    buffer_eob (fp); 
  }

  else if (!strcmp(w,"newpage")) {
    if (within_block && !do_this_tune) return;
    output_music (fp); 
    write_buffer (fp);
    use_buffer=0; 
    write_pagebreak (fp);
  }
  
  else  {
    if (within_block) {
      interpret_format_line (line,&cfmt);
      ops_into_fmt (&cfmt);
    }
    else {
      interpret_format_line (line,&dfmt);
      ops_into_fmt (&dfmt);
      cfmt=dfmt;
    }
  }


}   

/* ----- check_selected ----- */
void check_selected(fp,xref_str,npat,pat,sel_all,search_field)
FILE *fp;
int npat,sel_all,search_field;
char xref_str[],pat[][STRL1];
{
  
  if (!do_this_tune) {
    if (is_selected(xref_str,npat,pat,sel_all,search_field)) {
      do_this_tune=1;
      verbose=vb;
      clear_buffer ();
/*    set to 0 to permit staff breaks in a tune */
      use_buffer=1;
      write_tunetop(fp);
    }
  }
}


/* ----- process_line ----- */
void process_line (fp,type,xref_str,npat,pat,sel_all,search_field)
FILE *fp;
int type,npat,sel_all,search_field;
char xref_str[],pat[][STRL1];
{
  char fnm[81],finf[MAXINF];
  FILE *feps;

  if ((vb>15) || ((verbose>10)&&within_block)) {
    printf ("process_line, type %d ", type); print_linetype(type); }
  
  
  switch (type) {
        
  case XREF:                       /* start of new block */
    if (!epsf) write_buffer (fp);    /* flush stuff left from %% lines */
    if (within_block) 
      printf ("\n++++ Last tune not closed properly\n");
    get_default_info ();
    within_block  = 1;
    within_tune   = 0;
    do_this_tune  = 0;
    numtitle=0;
    ntext=0;
    init_pdims();
    cfmt=dfmt;
    break;
    
  case TITLE:    
    if (!within_block) break;
    if (within_tune) {             /* title within tune */
      if (do_this_tune ) {       
        output_music (fp); 
        write_inside_title (fp);
        reset_music_line ();
        insert_meter=1;
      }
    }
    else 
      check_selected(fp,xref_str,npat,pat,sel_all,search_field);
    break;
    
  case KEY:                        
    if (!within_block) break;
    if (within_tune) {             /* key change within tune */
      if (do_this_tune) {
        if (nsym>0)  
          append_key_change();
        else 
          get_sharps_flats(info.key, &sharps_flats, &keytype);
      }
    }
    else {                         /* end of header.. start now */
      check_selected(fp,xref_str,npat,pat,sel_all,search_field);
      if (do_this_tune) {
        tunenum++;
        if (verbose>=3) 
          printf ("---- start %d (%s) ----\n", xrefnum, info.title);
        fflush (stdout);
        get_sharps_flats(info.key, &sharps_flats, &keytype);
        set_meter (info.meter);
        set_dlen (info.len);
        check_margin (cfmt.leftmargin);
        write_heading (fp); 
        init_parse_params ();
        reset_music_line ();
        insert_meter=1;
      }
    }
    within_tune=1;
    break;

  case METER:                      
    if (!within_block) break;
    if (do_this_tune && within_tune) {
      if ((nsym>0) && (sym[nsym-1].eoln==0))  {
        append_meter_change();  
      }
      else {
        set_meter (info.meter);
        if (nsym==0) init_music_line ();
        append_meter();  
      }
    }
    break;

  case DLEN:                      
    if (!within_block) break;
    if (do_this_tune && within_tune) {
      set_dlen (info.len);
    }
    break;
    
  case PARTS:
    if (!within_block) break;
    if (do_this_tune && within_tune) {
      output_music (fp); 
      reset_music_line (); 
      insert_meter=1;
      write_parts(fp); 
    }
    break;
    
  case BLANK:                      /* end of block or file */
  case E_O_F:
    if (do_this_tune) {
      output_music (fp); 
      put_words (fp);
      if (cfmt.writehistory) put_history (fp);
      if (epsf) {
        close_output_file ();
        if (choose_outname) {
          epsf_title (info.title, fnm);
          strcat (fnm,".eps");
        }
        else {
          nepsf++;
          sprintf (fnm, "%s%03d.eps", outf, nepsf);
        }
        sprintf (finf, "%s (%d)", in_file[0], xrefnum); 
        if ((feps = fopen (fnm,"w")) == NULL) 
            rx ("Cannot open output file ", fnm);
        init_ps (feps, finf, 1,
                 cfmt.leftmargin-5, posy+bposy-5, 
                 cfmt.leftmargin+cfmt.staffwidth+5, 
                 cfmt.pageheight-cfmt.topmargin);
        init_epsf (feps);
        write_buffer (feps); 
        printf ("\n[%s] %s", fnm, info.title);
        close_epsf (feps);
        fclose (feps);
        in_page=0;
        init_pdims ();
      }
      else {
        buffer_eob (fp);
        write_buffer (fp); 
        if ((verbose==0) && (tunenum%10==0)) printf (".");
        if (verbose==2) printf ("%s - ", info.title);
      }
      verbose=0;
    }
    info=default_info;
    if (within_block && !within_tune) 
      printf ("\n++++ Header not closed in tune %d\n", xrefnum);
    within_tune=within_block=do_this_tune=0;
    break;
    
  }
}

/* ----- process_file ----- */
void process_file (fpin,fpout,xref_str,npat,pat,sel_all,search_field)
FILE *fpin,*fpout;
int npat,sel_all,search_field;
char xref_str[],pat[][STRL1];
{
  char line[BSIZE];
  int type;

  within_tune=within_block=do_this_tune=0;
  linenum=0;
  numtitle=0;
  reset_info (&default_info);
  info=default_info;
  verbose=0;
  if (vb>=20) db=3;
  if (vb>=25) db=5;
  
  type=read_line (fpin,0,line);            
  for (;;) {

    if (type==PSCOMMENT) {
      process_pscomment(fpin,fpout,line);
    }      
    else {
      process_line (fpout,type,xref_str,npat,pat,sel_all,search_field);
    }
    
    if (type==E_O_F) break;
    type=read_line (fpin,do_this_tune,line);
  }
  if (!epsf) {
    buffer_eob (fpout);
    write_buffer (fpout); 
  }
  
}


