;; $Id: dbgloss.dsl 1.1 1998/02/01 18:18:12 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ========================= GLOSSARY ELEMENTS ==========================

;; HACK ALERT!  There is no top-level wrapper around one or more GLOSSENTRYs,
;; so this code has to look around and output the right thing for the
;; front matter and then the GLOSSENTRYs.  Ugh.

(define ($glossary-frontmatter$)
  (let loop ((nl (children (current-node))) (headlist (empty-node-list)))
    (if (node-list-empty? nl)
	headlist
	(if (equal? (gi (node-list-first nl)) "GLOSSENTRY")
	    headlist
	    (loop (node-list-rest nl) (node-list
				       headlist
				       (node-list-first nl)))))))

(define ($glossary-glossentrys$)
  (let loop ((nl (children (current-node))) (gelist (empty-node-list)))
    (if (node-list-empty? nl)
	gelist
	(loop (node-list-rest nl)
	      (if (equal? (gi (node-list-first nl)) "GLOSSENTRY")
		  (node-list gelist (node-list-first nl))
		  gelist)))))

(define ($glossary-body$)
  (make element gi: "DIV"
	attributes: '(("CLASS" "GLOSSARY"))
	($component-title$)
	(process-node-list ($glossary-frontmatter$))
	(if (not (node-list-empty? ($glossary-glossentrys$)))
	    (make element gi: "DL"
		  (process-node-list ($glossary-glossentrys$)))
	    (empty-sosofo))))

(element GLOSSARY
  (html-document (with-mode title-mode (process-first-descendant "TITLE"))
		 ($glossary-body$)))

(element (GLOSSARY TITLE) (empty-sosofo))

(element GLOSSDIV 
  (make element gi: "DIV"
	attributes: (list 
		     (list "CLASS" (gi)))
	($section-title$)
	(process-node-list ($glossary-frontmatter$))
	(if (not (node-list-empty? ($glossary-glossentrys$)))
	    (make element gi: "DL"
		  (process-node-list ($glossary-glossentrys$)))
	    (empty-sosofo))))

(element (GLOSSDIV TITLE) (empty-sosofo))

(element GLOSSLIST 
  (make element gi: "DIV"
	attributes: (list 
		     (list "CLASS" (gi)))
	(make element gi: "DL"
	      (process-children))))

(element GLOSSENTRY (process-children))

(element (GLOSSENTRY GLOSSTERM) 
  (let ((id (attribute-string "ID" (parent (current-node)))))
    (make element gi: "DT"
	  (if id
	      (make element gi: "A"
		    attributes: (list
				 (list "NAME" id))
		    (make element gi: "B"
			  (process-children)))
	      (make element gi: "B"
		    (process-children))))))

(element (GLOSSENTRY ACRONYM) (empty-sosofo))
(element (GLOSSENTRY ABBREV) (empty-sosofo))

(element (GLOSSENTRY GLOSSDEF)
  (make element gi: "DD"
	(process-children)))

(element (GLOSSTERM REVHISTORY)
  (empty-sosofo))

(element (GLOSSENTRY GLOSSSEE)
  (make element gi: "DD"
	(if (attribute-string "OTHERTERM")
	    (make element gi: "P"
	      (make element gi: "EM"
		    (literal (gentext-element-name (gi))
			     (gentext-label-title-sep (gi))))
	      (make element gi: "A"
		    attributes: (list (list "href"
					    (link-target 
					     (attribute-string
					      "OTHERTERM"))))
		    (with-mode otherterm
		      (process-element-with-id
		       (attribute-string "OTHERTERM")))))
	    (process-children))))

;; When we hit the first GLOSSSEEALSO, process all of them as a node-list
(element GLOSSSEEALSO
  (if (first-sibling?)
      (make element gi: "P"
	    (make sequence
	      (make element gi: "EM"
		    (literal (gentext-element-name (gi))
			     (gentext-label-title-sep (gi))))
	      (with-mode glossseealso
		(process-node-list
		 (select-elements (children (parent)) '(glossseealso))))
	      (literal ".")))
      (empty-sosofo)))

(mode glossseealso
  (element GLOSSSEEALSO
    (make sequence
      (if (first-sibling?)
	  (empty-sosofo)
	  (make element gi: "EM"
		(literal ", ")))
      (if (attribute-string "OTHERTERM") ;; but this should be required...
	  (make element gi: "A"
		attributes: (list (list "href"
					(link-target
					 (attribute-string
					  "OTHERTERM"))))
		(with-mode otherterm
		  (process-element-with-id
		   (attribute-string "OTHERTERM"))))
	  (process-children)))))

;; This is referenced within the GLOSSSEE and GLOSSSEEALSO element
;; construction expressions.  The OTHERTERM attributes on GLOSSSEE and
;; GLOSSSEEALSO (should) refer to GLOSSENTRY elements but we're only
;; interested in the text within the GLOSSTERM.  Discard the revision
;; history and the definition from the referenced term.
(mode otherterm
  (element GLOSSTERM
    (process-children))
  (element GLOSSDEF
    (empty-sosofo))
  (element REVHISTORY
    (empty-sosofo))
  (element GLOSSSEE
    (empty-sosofo))
  (element (GLOSSENTRY ACRONYM)
    (empty-sosofo))
  (element (GLOSSENTRY ABBREV)
    (empty-sosofo)))

;; an inline gloss term
(element GLOSSTERM ($italic-seq$))
