#include <stdio.h>
#include <sys/mtio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define BLKSZ (1024*32)

int main(int argc, char *argv[])
{
	int tape_fd;
	struct mtop mtop;
	char buffer[BLKSZ];
	int i;
	int result;

	tape_fd = open(DEFTAPE, O_WRONLY);
	if (tape_fd == -1) {
		perror("open() of " DEFTAPE " failed");
		exit(1);
	}
	mtop.mt_op    = MTSETBLK;
	mtop.mt_count = 32*1024;
	if (ioctl(tape_fd, MTIOCTOP, &mtop) == -1) {
		perror("MTSETBLK failed");
		exit(1);
	}
	memset(buffer, 0xff, BLKSZ);
	for (i = 0; i < 100; i++) {
		result = write(tape_fd, buffer, BLKSZ);
		if (result == -1) {
			perror("write() failed");
			exit(1);
		}
		if (result != BLKSZ) {
			fprintf(stderr, "Partial write\n");
			exit(1);
		}
	}
	mtop.mt_op    = MTWEOF;
	mtop.mt_count = 1;
	if (ioctl(tape_fd, MTIOCTOP, &mtop) == -1) {
		perror("MTWEOF failed");
		exit(1);
	}
	memset(buffer, 0xaa, BLKSZ);
	for (i = 0; i < 100; i++) {
		result = write(tape_fd, buffer, BLKSZ);
		if (result == -1) {
			perror("write() failed");
			exit(1);
		}
		if (result != BLKSZ) {
			fprintf(stderr, "Partial write\n");
			exit(1);
		}
	}
	mtop.mt_op    = MTREW;
	mtop.mt_count = 1;
	if (ioctl(tape_fd, MTIOCTOP, &mtop) == -1) {
		perror("MTREW failed");
		exit(1);
	}
	if (close(tape_fd) == -1) {
		perror("close() failed");
		exit(1);
	}
	return 0;
}
