.\" Man page for the pscol procps utility
.\" Copywrong (C) 1996-97 William Thompson
.\" wakko@ani.ml.org
.\" This file may be distributed freely under the GNU Public Licence as long
.\" this copywrong is included intact.
.\" If it breaks, you get to keep both pieces =)
.TH PSCOL 1 "July 13 1997" "Commands"
.SH NAME
pscol \- set up ps and top colorization
.SH SYNOPSIS
.B eval `pscol [\fIfile\fP] [\fI-s\fP<\fIp\fP|\fIt\fP>] [\fI-C\fP] [\fI-f file\fP] [\fI-V\fP]`
.P
.B \fIvar\fP=`pscol -o\fI\fP[\fIp\fP|\fIt\fP] [\fI-f file\fP] [\fI-V\fP]`
.P
.B pscol \fI-c\fP[\fIu+cm\fP[\fIp\fP|\fIt\fP]] [\fI-f file\fP] [\fI-V\fP]
.P
.B pscol [\fI-h\fP] [\fI-v\fP]
.SH DESCRIPTION
\fIpscol\fP sets environment variables to control the colorization of
\fBps\fP(1) and \fBtop\fP(1).  \fIpscol\fP cannot directly set variables in you
environement, so it outputs environement variable settings to \fIstdout\fP, and
you must instruct your shell to use them.
.SH OPTIONS
.TP 0.5i
\fIfile\fP	If specified, must be the first parameter listed
.TP 0.5i
.I -c\fP[\fIu+cm\fP[\fIp\fP|\fIt\fP]]
takes the current \fBPS_COLORS\fP and/or \fBTOP_COLORS\fP and creates
\fI$HOME/.pscolor\fP.  Use \fI-f\fP to override this file

.br
Creation features:
.RS
.TP 0.4i
.I c
turn off converting \fBANSI\fP codes to readable format
.TP 0.4i
.I m
turn off converting the mark-up type to readable format
.TP 0.4i
.I u
turn off converting UID to user names
.TP 0.4i
.I +
turn off converting current UID to +
.RE

.br
.RS
Other:
.TP 0.3i
.I p
writes out only the \fBPS_COLORS\fP variable
.TP 0.3i
.I t
writes out only the \fBTOP_COLORS\fP variable
.RE
.TP 0.5i
.I -f file
Use a different \fIfile\fP instead of \fI/etc/pscolors\fP or
\fI$HOME/.pscolor\fP
.TP 0.5i
.I -h
Displays a help screen and exits
.TP 0.5i
.I -o\fP<\fIp\fP|\fIt\fP>
prints the PS or TOP color string to \fIstdout\fP.
.br
this would be used to set a variable.
.br
\fIp\fP returns the \fBPS\fP color string
.br
\fIt\fP returns the \fBTOP\fP color string
.br
Ie: ps=`pscol -op`
.TP 0.5i
.I -s\fP[\fIp\fP|\fIt\fP]
used to set the PS or TOP color variable.
.br
\fIp\fP set \fBPS_COLORS\fP only
.br
\fIt\fP set \fBTOP_COLORS\fP only
.TP 0.5i
.I -v
Prints the version info and exits
.TP 0.5i
.I -C
use CSH style setenv instead of using bourne style export
.TP 0.5i
.I -V
Verbose mode.  Reports what goes on to \fIstderr\fP.
.SH FILES
.TP 0.5i
.I /etc/pscolor
System wide colorization file.  See \fBpscolor\fP(5) for more information
.TP 0.5i
.I $HOME/.pscolor
Per user colorization file.  See \fBpscolor\fP(5) for more information
.SH ENVIRONMENT
.TP 0.5i
.B PS_COLORS
\fBps\fP(1) color string
.TP 0.5i
.B TOP_COLORS
\fBtop\fP(1) color string
.TP 0.5i
.B HOME
user's home directory where the per user colorization file is stored
.SH DISTRIBUTION
Redistribution is subject to the GNU public license.
.SH BUGS
See \fIKNOWNBUGS\fP for more information
.SH AUTHOR
William Thompson, <wakko@ani.ml.org> or <wakko@kite.ml.org>.
.SH SEE ALSO
\fBps\fP(1), \fBps_color\fP(7), \fBpscolor\fP(5), \fBtop\fP(1)
.br
