#include "config.h"
#include "pscol.h"

/*******************************************************************/
/*                                                                 */
/* readfile: reads the pscolors file and returns a set of poiners  */
/*           to ps and top colors                                  */
/*                                                                 */
/*******************************************************************/

void readfile(char *filename, int useetcfile, colorrec *cols)
{
 FILE *pscol;
 int type = 0, lineno = 0, topc = 0, psc = 0, pseqtop = 0, topeqps = 0;
 int topeqcommon = 0, pseqcommon = 0, comhit = 0, tophit = 0, pshit = 0;
 char *line, *ptr, *l;
 linklist *ps, *top, *common, *tmp;

 /* allow for 512 character lines, why would you need more? */
 line = malloc(514);
 ps = listinit();
 top = listinit();
 common = listinit();
 if (!strcmp(filename, "-"))
  pscol = stdin;
 else
  if ((pscol = fopen(filename, "r")) == NULL)
   if (useetcfile)
   {
    if ((pscol = fopen(ETC_FILE, "r")) == NULL)
     error("cannot open either %s or %s for reading", filename, ETC_FILE);
    filename = ETC_FILE;
   }
   else
    error("cannot open %s for reading", filename);

 /* read the file and parse at the same time */
 ptr = line;
 while(!feof(pscol))
 {
  /* 512 for line, +1 for the \n */
  lineno++;
  line = ptr;
  bzero(line, 514);  /* causes bugs if I don't */
  fgets(line, 513, pscol);
  if (line[strlen(line) - 1] == '\n') line[strlen(line) - 1] = 0;
  /* strip everything starting at the first # */
  if ((line = strstr(line, "#")) == NULL)
   line = ptr + strlen(ptr);
  else
   *line = 0;
  /* strip leading white space */
  for (--line;line >= ptr && (*line == ' ' || *line == '	');line--);
  line[1] = 0;
  line = ptr;
  if (!*line) continue;
  /* type: 0 = n/a 1 = PS 2 = TOP 3 = COMMON */
  switch (type)
  {
   case 0: if (!strcmp(line, "[PS]"))
           {
            type = 1;
            pshit = 1;
           }
           if (!strcmp(line, "[TOP]"))
           {
            type = 2;
            tophit = 1;
           }
           if (!strcmp(line, "[COMMON]"))
           {
            type = 3;
            comhit = 1;
           }
           if (type == 0)
            error("%s: %d: line found outside of block '%s'", filename, lineno,
                  line);
           break;
   case 1: if (!strcmp(line, "[PS]"))
           {
            warn("%s: %d: [PS] declared more than once");
            break;
           }
           if (!strcmp(line, "[TOP]"))
           {
            if (tophit) warn("%s: %d: [TOP] declared more than once");
            type = 2;
            tophit = 1;
            break;
           }
           if (!strcmp(line, "[COMMON]"))
           {
            if (comhit) warn("%s: %d: [COMMON] declared more than once");
            type = 3;
            comhit = 1;
            break;
           }
           psc++;
           if (!strcmp(line, "=PS"))
            error("%s: %d: Infinite loop detected", filename, lineno);
           if (!strcmp(line, "=TOP"))
           {
            if (topeqps)
             error("%s: %d: Infinite loop detected", filename, lineno);
            if (pseqtop)
             warn("%s: %d: Adding TOP in with PS again", filename, lineno);
            pseqtop = 1;
            listadd(ps, line);
            break;
           }
           if (!strcmp(line, "=COMMON"))
           {
            if (pseqcommon)
             warn("%s: %d: Adding COMMON in with PS again", filename, lineno);
            pseqcommon = 1;
            listadd(ps, line);
            break;
           }
           if ((l = convline(line, filename, lineno)) != NULL) listadd(ps, l);
           break;
   case 2: if (!strcmp(line, "[TOP]"))
           {
            warn("%s: %d: [TOP] declared more than once");
            break;
           }
           if (!strcmp(line, "[PS]"))
           {
            if (pshit)
            {
             warn("%s: %d: [PS] declared more than once");
             break;
            }
            pshit = 1;
            type = 1;
            break;
           }
           if (!strcmp(line, "[COMMON]"))
           {
            if (comhit) warn("%s: %d: [COMMON] declared more than once");
            type = 3;
            comhit = 1;
            break;
           }
           topc++;
           if (!strcmp(line, "=TOP"))
            error("%s: %d: Infinite loop detected", filename, lineno);
           if (!strcmp(line, "=PS"))
           {
            if (pseqtop)
             error("%s: %d: Infinite loop detected", filename, lineno);
            if (topeqps)
             warn("%s: %d: Adding PS in with TOP again", filename, lineno);
            topeqps = 1;
            listadd(top, line);
            break;
           }
           if (!strcmp(line, "=COMMON"))
           {
            if (topeqcommon)
             warn("%s: %d: Adding COMMON in with TOP again", filename, lineno);
            topeqcommon = 1;
            listadd(top, line);
            break;
           }
           if ((l = convline(line, filename, lineno)) != NULL) listadd(top, l);
           break;
   case 3: if (!strcmp(line, "[PS]"))
           {
            if (pshit) warn("%s: %d: [COMMON] declared more than once");
            pshit = 1;
            type = 1;
            break;
           }
           if (!strcmp(line, "[TOP]"))
           {
            if (tophit) warn("%s: %d: [COMMON] declared more than once");
            tophit = 1;
            type = 2;
            break;
           }
           if (!strcmp(line, "[COMMON]"))
           {
            warn("%s: %d: [COMMON] declared more than once");
            break;
           }
           if (!strcmp(line, "=PS") || !strcmp(line, "=TOP") || 
               !strcmp(line, "=COMMON"))
           {
            warn("%s: %d: neither =PS, =TOP, nor =COMMON may be in the "
                 "[COMMON] block");
            break;
           }
           if ((l = convline(line, filename, lineno)) != NULL) listadd(common, l);
           break;
   default: error("error in program, contact author");
  }
 }
 if (pseqcommon)
 {
  tmp = ps;
  ps = listinit();
  for (;tmp->next;tmp = tmp->next)
  {
   if (!strcmp(tmp->line, "=COMMON"))
    listappend(ps, common);
   else
    listadd(ps, tmp->line);
  }
  listdestroy(tmp);
 }
 if (topeqcommon)
 {
  tmp = top;
  top = listinit();
  for (;tmp->next;tmp = tmp->next)
  {
   if (!strcmp(tmp->line, "=COMMON"))
    listappend(top, common);
   else
    listadd(top, tmp->line);
  }
  listdestroy(tmp);
 }
 if (pseqtop)
 {
  tmp = ps;
  ps = listinit();
  for (;tmp->next;tmp = tmp->next)
  {
   if (!strcmp(tmp->line, "=TOP"))
    listappend(ps, top);
   else
    listadd(ps, tmp->line);
  }
  listdestroy(tmp);
 }
 if (topeqps)
 {
  tmp = top;
  top = listinit();
  for (;tmp->next;tmp = tmp->next)
  {
   if (!strcmp(tmp->line, "=PS"))
    listappend(top, ps);
   else
    listadd(top, tmp->line);
  }
  listdestroy(tmp);
 }
 if (!ps->line) ps = common;
 if (!top->line) top = common;
 cols->ps = ps;
 cols->top = top;
}
