/*
   Time-stamp: <97/08/10 12:21:30 yusuf>

   $Id: sel_restore.c,v 1.49 1997/08/10 04:25:23 yusuf Exp $	

*/

#ifndef lint
static char vcid[] = "$Id: sel_restore.c,v 1.49 1997/08/10 04:25:23 yusuf Exp $";
#endif /* lint */



#include "taper.h"
#include "restore.h"
#include <pwd.h>
#include <grp.h>

/* Handling of selected files.
 * 
 * Files selected are stored in a memory block of file_entry starting
 * at sel_files. All the files on the volume are stored in a memory
 * block of file_entry starting at archive_files
 * 
 * When files are selected, they are put into this memory block and
 * the selected field of the structure in the memory block pointed to
 * by archive_files is set to 1.
 * 
 * If the file selected is a directory, then all the files in that directory
 * are searched for and their selected field is set to 2.
 * 
 * Selected field:  0 = not selected
 *                  1 = explicity selected by user
 *                  2 = indirectly selected by user
 *                  3 = explicity & indirectly selected by user
*/

extern select_details file_sd, select_sd, vol_sd;
char start_path[MAX_FNAME];



_errstat look_most_recent(char *s, struct info_file_data *i_data)
{
/* Looks through archive files and finds the entry that is the most recent
   for filename s

   Assumes that the memory block has been setup so that the most recent
   file entries are up to date

   Returns -1 if err
   or otherwise 0
   
 
 */

     _u32 rec;

    rec = (m_files+i_data->recnum)->most_recent;
    if (rec) {
	if (rec == i_data->recnum) return 0;	 /* already have most recent */
	if (read_info_rec(rec, i_data) == -1) return -1; /* read record in */
    }
    return 0;
}


void restore_update_selected_sizes()
{
    /* Goes through the selections and updates their sizes and updates
       the selected entries in the memory file representation

       Also sees if any entries are indirectly selected, and
       marks them accordingly

     */

    _s32 c, c1, rec, x;
    struct selected_entry *se, *se1;
    struct info_file_data i_data;
    struct info_file_key i_key;
    struct memory_file *m;

    m = m_files;				 /* reset these */
    for (c=0; c<ifd.no_in_archive; c++) {
	m->selected = 0;
	m->unselected = 0;
	m++;
    }
    se=sel_files;
    for (c=0; c<no_sel; c++) {
	se = sel_files + c;
	if (!S_ISDIR(se->i.f.mode)) {
	    i_data = se->i;
	    se->ab_size = (S_ISREG(se->i.f.mode)) ? i_data.f.size : 0;
	    if (!se->incremental) (m_files+i_data.recnum)->selected = 1;
	    if (look_most_recent(i_data.name, &i_data) == -1) continue;
	    se->mm_size = (S_ISREG(se->i.f.mode)) ? i_data.f.size : 0;
	    if (se->incremental) (m_files+i_data.recnum)->selected = 1;
	}
	else {
	    memset(&i_key, 0, sizeof(i_key));	 /* a directory */
	    strcpy(i_key.name, se->i.name);
	    x = ntraverse(0, &i_key, NULL, &rec, TRAVERSE_SEARCH, INFO_NAME);
	    se->ab_size = 0; se->mm_size = 0;
	    /* Keep on cycling through until selections no longer match */
	    while (1) {
		if (x > 0) break;		 /* finished traversing */
		if (read_info_rec(rec, &i_data) == -1) return; /* read record in */
		if (i_data.f.pos_in_archive) {
		    if (strlen(i_data.name) < strlen(se->i.name)) break; /* no longer part of selection */
		    if (strncmp(i_data.name, se->i.name, strlen(se->i.name))) break;
		    if (!S_ISDIR(i_data.f.mode)) se->ab_size += i_data.f.size;
		    if (!se->incremental)
			(m_files+i_data.recnum)->selected = 1 + S_ISDIR(i_data.f.mode);
		    if (se->incremental) {
			look_most_recent(i_data.name, &i_data);
			if (!S_ISDIR(i_data.f.mode)) se->mm_size += i_data.f.size;
			(m_files+i_data.recnum)->selected = 1 + S_ISDIR(i_data.f.mode);
		    }
		}
		x = ntraverse(0, &i_key, NULL, &rec, TRAVERSE_CONTINUE, INFO_NAME);
	    }
	}
	se->selected=1;				 /* assume directly selected */
	for (c1=0; c1<no_sel; c1++) {
	    se1 = sel_files+c1;
	    if (c == c1) continue;		 /* don't check this one */
	    if (!S_ISDIR(se1->i.f.mode)) continue; /* not a directory - can't be indirectly */
	    if (strlen(se1->i.name) < strlen(se->i.name)) {
		if (strncmp(se1->i.name, se->i.name, strlen(se1->i.name)))
		    continue;			 /* files don't match */
		se->selected=2;			 /* indirectly */
		break;
	    }
	}
    }
    m = m_files;				 /* work out total selected files */
    total_selected = 0;
    total_excluded = 0;
    for (c=0; c<ifd.no_in_archive; c++) {
	if (m->selected == 1) total_selected += m->size; /* don't add directory */
	if (m->unselected == 1) total_excluded += m->size; /* sizes to this */
	m++;
    }
}	    


void restore_asterix_line(WINDOW *win, int ent_num, int line)
{
    struct dir_file_entry *fe;
    
    if (!ent_num) return;
    fe = dirs + ent_num-1;
    if (check_selected(fe->i.recnum))
	mvwaddch(files, line+1, top_left_width-3, '*');
    else
	mvwaddch(files, line+1, top_left_width-3, ' ');
}


void restore_asterix_dir(WINDOW *win, _s32 start, char *p_scroll) {
    int    cur_line=1, cur_ent;
    
    cur_ent = start;
    while (cur_line < screen_ylen_files-3) {
	restore_asterix_line(win, cur_ent++, cur_line++); /*  */
	if (start+cur_line > in_dir)		 /* check that not at end of dir */
	  break;
    }
    wrefresh(win);
}


void restore_print_voldir_line(WINDOW *win, _s32 entry, int line, char ref) {
/*  Prints one entry in a directory at line 'line'  */

    char   s[NAME_MAX+1], s2[50], s3[MAX_FNAME];
    struct dir_file_entry *fe;
    struct tm t;
    
    int top_left_width=files->_maxx-3;
    if (entry) {
	fe = dirs + entry-1;
	get_file_type(s, fe->i.f.mode);
	*s2 = 0;
	if (S_ISDIR(fe->i.f.mode) || S_ISREG(fe->i.f.mode))
	    convert(s2, fe->size);
	if (S_ISLNK(fe->i.f.mode))
	  strcat(s, " @");
	else if (S_ISDIR(fe->i.f.mode))
	  strcat(s, "  ");
	else if (!(S_ISREG(fe->i.f.mode)))
	  strcat(s, " +");
	else
	  strcat(s, "  ");
	pr_filename(fe->name, s3, top_left_width-strlen(s)-1);
	strcat(s, s3);
	t = *localtime(&fe->i.f.backup_time);
	if (fe->i.f.checksum == -1)			 /* error backing up */
	  strcpy(s2, "BACK ERROR");
	if (fe->i.f.checksum == -2)
	  strcpy(s2, "   ABORTED");
	s[top_left_width-22] = 0;
	if (fe->i.f.pos_in_archive)
	  sprintf(s, "%s %d %5d %12s", s, abs(fe->i.f.volume), fe->i.f.pos_in_archive, s2);
	else
	  sprintf(s, "%s %d %5s %12s", s, abs(fe->i.f.volume), "-", s2);
	mvwaddstr(win, line+1, 2, s);
	restore_asterix_line(win, entry, line);
	centre(bottom, 0, fe->name, COLOR_BOTTOM); wrefresh(bottom);
    }
    else 
      if (*start_path)
        mvwaddstr(win, line+1, 2, "d  ../");
      else
        mvwaddstr(win, line+1, 2, "Top of tree");
    if (ref)
      wrefresh(win);
}


void restore_print_vol_dir(WINDOW *win, _s32 start, char *p_scroll) {
    int    cur_line=1, cur_ent;
    char   s[50], s1[MAX_FNAME], s2[MAX_FNAME];
    
    my_werase(win, COLOR_DIRECTORY);
    *p_scroll = 0;
    wattron(win, A_BOLD);
    *s1 = 0;					 /* print directory */
    strcpy(s1, start_path);
    if (strlen(s1) > win->_maxx-strlen(s)-2) { /* make sure dir name not too long */
	strcpy(s2, &s1[strlen(s1)-(win->_maxx-strlen(s)-1)+2]);
	s2[0] = '~';
    }
    else
      strcpy(s2, s1);
    if (*s2)
      mvwaddstr(win, 1, 1, s2);
    else {
	if (only_vol)
	  mvwprintw(win, 1, 1, "Only volume %d", only_vol);
	else
	  mvwaddstr(win, 1, 1, "All volumes");
    }
    mvwaddstr(win, 2, win->_maxx-6, "Size");
    mvwaddstr(win, 2, win->_maxx-18, "Pos");
    mvwaddstr(win, 2, win->_maxx-24, "Vol");
    wattroff(win, A_BOLD);
    cur_ent = start;
    while (cur_line < screen_ylen_files-2) {
	restore_print_voldir_line(win, cur_ent, cur_line, FALSE); /* print line */
	cur_line++;				 /* increment */
	cur_ent++;
	if (start+cur_line > in_dir)		 /* check that not at end of dir */
	  break;
    }
    *p_scroll = 0;
    print_scroll_bar(win, no_in_archive, &file_sd, win->_maxy,
		     win->_maxx, p_scroll);
    wrefresh(win);
}

    
void restore_print_selected_line(WINDOW *win, _s32 entry, int line, char ref) {
    
    struct selected_entry *mr;
    char   s1[50], s2[MAX_FNAME];
    
    mr = sel_files + entry;
    if (((mr->incremental == 1) ? mr->mm_size : mr->ab_size) < 1024) {
    (mr->selected == 1) ?  mvwprintw(win, line+1, 5, " %8d   %s ", 
				     (mr->incremental == 1) ? mr->mm_size : mr->ab_size,
				     trunc_filename(mr->i.name, s2, win->_maxx-24)):
                           mvwprintw(win, line+1, 5, "(%8d   %s)",  
				     (mr->incremental == 1) ? mr->mm_size : mr->ab_size,
				     trunc_filename(mr->i.name, s2, win->_maxx-24));
    }
    else {
	(mr->selected == 1) ?  mvwprintw(win, line+1, 5, " %9s  %s ", 
					 print_kb(s1,(mr->incremental == 1) ? mr->mm_size : mr->ab_size),
					 trunc_filename(mr->i.name, s2, win->_maxx-24)) :
	                       mvwprintw(win, line+1, 5, "(%9s  %s)",  
		                         print_kb(s1,(mr->incremental == 1) ? mr->mm_size : mr->ab_size),
		                         trunc_filename(mr->i.name, s2, win->_maxx-24));
    }
    (mr->incremental == 1) ? mvwaddstr(win, line+1, win->_maxx-5, "M  ") :
                             mvwprintw(win, line+1, win->_maxx-5, "%03d", abs(mr->i.f.volume));
    wattroff(win, A_DIM);
    centre(bottom, 0, mr->i.name, COLOR_BOTTOM); wrefresh(bottom);
    if (ref)
      wrefresh(win);
}


void restore_print_selected_size(WINDOW *win)
{
    char s[100];
    
    wattron(win, A_BOLD); 
    mvwprintw(win, 1, 3, "Selected files %s", print_kb(s, total_selected));
    mvwaddstr(win, 1, win->_maxx-5, "Vol");
    wattroff(win, A_BOLD);
}


void  restore_print_selected(WINDOW *win, _s32 top_sel, char *p_scroll) {
    _s32   cur;
    
    my_werase(win, COLOR_SELECTED);
    restore_print_selected_size(win);
    cur=1;
    while ((cur < screen_ylen_selection-2) && (top_sel+cur-1 < no_sel)) {
	restore_print_selected_line(win, top_sel+cur-1, cur, FALSE);
	cur++;
    }
    *p_scroll = 0;
    print_scroll_bar(win, no_sel, &select_sd, win->_maxy,
		     win->_maxx, p_scroll);
    wrefresh(win);
}


void restore_del_engine(_s32 entry)
{
    int   c;
    char dummy;

    for (c=entry; c<no_sel-1; c++) 
	*(sel_files+c) = *(sel_files+c+1);
    (no_sel)--;
    restore_update_selected_sizes();
    restore_print_selected_size(selection);
    restore_asterix_dir(files, file_sd.top_entry, &dummy);
}

void restore_del_cur_entry(select_details *sd, _s32 *dummy)
{
    restore_del_engine(sd->cur_entry);
}


void restore_unselect_dir(select_details *sd, _s32 *dummy)
{
     _s32 c;
     struct selected_entry *se;

     se=sel_files; 
     for (c=0; c<no_sel;c++) {      /* look for this entry in selections  */
	 if (se->i.recnum == (dirs+sd->cur_entry-1)->i.recnum) break;
	 se++;
     } 
     if (c==no_sel) {
	 if (check_selected((dirs+sd->cur_entry-1)->i.recnum))
	     bmessage_box("File indirectly selected", MB_OK); 
	 else
	     bmessage_box("File not selected", MB_OK);
	 return; 
     } 
     restore_del_engine(c);
}

       
	

void restore_ed_engine(struct info_file_data *id, char lns[][150])
{
    char s[200];
    struct passwd *p;
    struct group *g;

    strcpy(lns[0], "Name          : ");
    strcpy(lns[1], "File type     : ");
    strcpy(lns[2], "Size          : ");
    strcpy(lns[3], "");
    strcpy(lns[4], "Permissions   : ");
    strcpy(lns[5], "Owner         : ");
    strcpy(lns[6], "Group         : ");
    strcpy(lns[7], "");
    strcpy(lns[8], "Last modified : ");
    strcpy(lns[9], "Last acces    : ");
    strcpy(lns[10], "");

    pr_filename(id->name, s, win_main->_maxx-20);
    strcat(lns[0], s);
    if (S_ISDIR(id->f.mode))
	strcat(lns[0], "/");
    if (S_ISDIR(id->f.mode))
	strcat(lns[1], "Directory");
    if (S_ISREG(id->f.mode))
	strcat(lns[1], "Regular File");
    if (S_ISLNK(id->f.mode))
	strcat(lns[1], "Link");
    if (S_ISCHR(id->f.mode))
	strcat(lns[1], "Character device");
    if (S_ISBLK(id->f.mode))
	strcat(lns[1], "Block device");
    if (S_ISSOCK(id->f.mode))
	strcat(lns[1], "Socket");
    if (S_ISFIFO(id->f.mode))
	strcat(lns[1], "FIFO");
    (S_ISREG(id->f.mode)) ? strcat(lns[2], (convert(s, id->f.size))) :
	                             strcat(lns[2], "-");
    strcat(lns[4], (make_permstring(s, id->f.mode)));

    p = getpwuid(id->f.uid);
    (p == NULL) ? strcat(lns[5], "Unknown") : strcat(lns[5], p->pw_name);
    g = getgrgid(id->f.gid);
    (g == NULL) ? strcat(lns[6], "Unknown") : strcat(lns[6], g->gr_name);

    strcat(lns[8], ctime(&id->f.mtime)); lns[8][strlen(lns[8])-1] = 0;
    strcat(lns[9], ctime(&id->f.atime)); lns[9][strlen(lns[9])-1] = 0;
}


void restore_ed(select_details *sd)
{
    /* Prints details about an entry */

    struct dir_file_entry *fe;
    char  lns[11][150];

    if (!sd->cur_entry) return;
    fe = dirs + sd->cur_entry-1;
    restore_ed_engine(&fe->i, lns);
    multi_message_box(lns, 11, MB_OK, FALSE);
}


int toggle_selection(_s32 cur_entry)
{
/* Toggles the currently selected item from most recent restore to volume
   restore & vice-versa
*/
    struct selected_entry *se;
    char dummy;
    struct info_file_data x;

    se=sel_files + cur_entry;
    se->incremental = !se->incremental;
    x = se->savedi;				 /* swap the two entries */
    se->savedi = se->i;
    se->i = x;
    restore_update_selected_sizes();
    restore_print_selected_size(selection);
    restore_asterix_dir(files, file_sd.top_entry, &dummy);
    return 0;
}


int tag_voldir(_s32 rec)
{
/* Tags this entry which is in archive

   Returns 0 : no selected; -1 error; 1  OK

 */

    struct info_file_data i_data;
    struct selected_entry se;
    
    if (read_info_rec(rec, &i_data) == -1) return -1;
    if (S_ISDIR(i_data.f.mode)) 
      if (dir_selection)
        if (!message_box("Is a directory. Confirm?", MB_YESNO))
          return 0;

    se.savedi = i_data;
    if (most_recent == 1) 			 /* look at the actual */
	if (look_most_recent(i_data.name, &i_data) == -1) return -1;

    if ((!(m_files+i_data.recnum)->unselected) && ((m_files+i_data.recnum)->selected)) {
	message_box("File already selected", MB_OK);
	return 0;
    }
    se.i = i_data;
    se.size = 0;
    se.incremental = most_recent;
    se.selected = 1;
    no_sel++;
    sel_files = my_realloc(sel_files, no_sel*sizeof(struct selected_entry));
    *(sel_files+no_sel-1) = se;
    restore_update_selected_sizes();
    return 1;
}


int tag_voldir_line(_s32 cur_entry) {
/* Selects the file at cur_entry.
 * It then checks through the whole file directory looking
 * if any other files should also be selected (eg. if you
 * select the dir usr/games/tetris, then the file /usr/games/tetris/high_score
 * should automatically be selected)
 * 
 * Also adds file to selected list
 * Checks for duplicates
*/
    struct dir_file_entry *dfe;

    if (!cur_entry) return 0;			 /* top/previous dir */
    dfe = dirs + cur_entry-1;
    return tag_voldir(dfe->i.recnum);
}


void make_mydir(int vol)
{
/* If volume is non-zero, then only selects those files which belong
 * to vol volume */
/* Makes a directory with the path pointed to by start_path */
    _s32 c=0, z=0;
    char *s, *x;
    struct info_file_data i_data;
    struct info_file_key i_key;

    if (*start_path)  {				 /* add trailing / if not already there */
	if (start_path[strlen(start_path)-1] != '/')
	    strcat(start_path, "/");
    }
    else
	strcpy(start_path, "/");
    in_dir=0;
    memset(&i_key, 0, sizeof(i_key)); strcpy(i_key.name, start_path);
    if (ntraverse(0, &i_key, NULL, &c, TRAVERSE_SEARCH, INFO_NAME) == 2) return;
    while (1) {
	if (read_info_rec(c, &i_data) == -1) return;
	if (strlen(start_path) < strlen(i_data.name)) {
	    if (!strncmp(i_data.name, start_path, strlen(start_path))) {
		s = &i_data.name[strlen(start_path)];
		x = strchr(s, '/');
		if ((x == NULL) || (*(x+1) == 0)) 
		    if (((vol) && (abs(i_data.f.volume) == vol)) || (!vol)) 
			if ((i_data.f.checksum != -1) && (i_data.f.checksum != -2)) {	 /* don't include error files */
				for (z=0; z<in_dir; z++) 
				    if (!strcmp(s, (dirs+z)->name))
					if (abs(i_data.f.volume) == abs((dirs+z)->i.f.volume))
					    break;
				if (z == in_dir)
				    if  (S_ISDIR(i_data.f.mode) || (i_data.f.pos_in_archive)) {
					in_dir++;
					dirs = my_realloc(dirs, in_dir*sizeof(struct dir_file_entry));
					(dirs+in_dir-1)->i = i_data;
					strcpy((dirs+in_dir-1)->name, s);
					(dirs+in_dir-1)->size = (m_files+i_data.recnum)->size;
					if ((!(m_files+c)->unselected) && ((m_files+c)->selected))
					    (dirs+in_dir-1)->selected = 1;
					else
					    (dirs+in_dir-1)->selected = 0;
				    }
			    }
	    }
	    else
		break;			 /* not in this dir anymore */
	}
	else
	    if (strlen(start_path) > strlen(i_data.name))
		break;
	if (ntraverse(0, &i_key, NULL, &c, TRAVERSE_CONTINUE, INFO_NAME) != 0) break;
    }
    in_dir++;					 /* for the up dir */
    clear_sd(&file_sd);
}

    
void restore_restore_backupset(void)
{
    char ln[MAX_FNAME], s[MAX_FNAME];
    FILE *f;
    _s32 c;
    struct info_file_data i_data;

    f = backrest_restore_backupset(NULL);
    if (f==NULL) 
	return;
    while (!feof(f)) {
	fgets(ln, sizeof(ln), f);		 /* get name */
	if (ln[strlen(ln)-1] == '\n')
	  ln[strlen(ln)-1] = 0;
	if (*ln) {				 /* ignore empty lines */
	    for (c=0; c<no_in_archive; c++) {	 /* in restore list */
		read_info_rec(c, &i_data);
		if (!strcmp(i_data.name, ln)) {
		    tag_voldir_line(c);
		    break;
		}
	    }
	    if (c==no_in_archive) {
		strcpy(s, "Couldn't find "); strcat(s, ln);
		bmessage_box(s, MB_OK);
	    }
	}
	fgets(ln, sizeof(ln), f);		 /* ignore filter */
    }
    fclose(f);
}

int restore_on_vol_select(_s32 entry)
{
/* Selects entry for restore */
    _s32 c=0;
    char *s;
    int  lv=0;
    struct info_file_data i_data;
    
    s = vol_details;				 /* find appropriate */
    while (c++<entry) {				 /* line in vol_details buffer */
	if (!strncmp(s, "Volume ", strlen("Volume ")))   /* get volume we are on */
	  lv = atoi(&s[strlen("Volume ")]);
	while (*s++);
    }

    if (lv==0) return 0;			 /* nothing */
    if (!strncmp(s, "Volume ", strlen("Volume ")) ||   /* don't use this */
	!strncmp(s, "Contains ", strlen("Contains ")) ||
	!strncmp(s, "Backed up at ", strlen("Backed up at ")) ) 
	    return 0;
    
    if (search_file(s, lv, &i_data) == -1) return 0; /* couldn't find it in archive */
    return tag_voldir(i_data.recnum);
}


void autod(select_details *sd)
{
    if (S_ISDIR((dirs+sd->cur_entry-1)->i.f.mode)) {
	while (1) {			 /* auto-descend routine */
	    strcat(start_path, (dirs+sd->cur_entry-1)->name);
	    make_mydir(abs((dirs+sd->cur_entry-1)->i.f.volume));
	    if ((in_dir != 2) || (!auto_descend))
		break;
	    if (!S_ISDIR(dirs->i.f.mode))/* make sure that it is a directory */
		break;
	    sd->cur_entry = 1;
	}
    }
}


int select_restore_files(void) 
{
/* Returns 0 if quit
 * Returns 1 if wants to restore
*/
    int ret, oldvol;
    struct dir_file_entry *s;
    char p;
    char old_start[MAX_FNAME];
    _s32 c, x;
    char ssearch[MAX_FNAME], spath[MAX_FNAME];
    struct info_file_data i_data;
    struct info_file_key i_key;

    clear_sd(&file_sd);
    clear_sd(&select_sd);
    clear_sd(&vol_sd);

    ret=0;
    *ssearch=0;
    print_on_vol_dir(on_vol, vol_sd.top_entry, &p);	/* print files currently on volume */
    p=0;
    restore_print_selected(selection, select_sd.top_entry, &p);

    strcpy(start_path, cf);
    make_mydir(only_vol);
    if (in_dir == 2) {				 /* only one directory */
	file_sd.cur_entry = 1;			 /* entry - autodescend */
	autod(&file_sd);
    }
    while (1) {
	ret = select_box(files, &in_dir, &file_sd,
			 restore_print_vol_dir, restore_print_voldir_line,
			 tag_voldir_line, tag_voldir_line, restore_unselect_dir,
			 backrest_paint,
			 restore_ed, selection, &no_sel, &select_sd,
			 restore_print_selected,
			 NULL, NULL, NULL, NULL,
			 NULL, NULL,
			 "Select file/directory for restore",
			 backrest_save_backupset, restore_restore_backupset,
			 TRUE, TRUE,
			 NULL, NULL, NULL);
	switch(ret) {
	case SELECT_SEARCH:
	    if (get_string(win_main, ssearch, sizeof(ssearch), "Enter entry to search for")) {
		c=file_sd.cur_entry  ;
		while (c<in_dir-1) {
		    if (strstr((dirs+c)->name, ssearch))
			break;
		    c++;
		}
		if (c==in_dir-1) {
		    if (message_box("Not found. Search whole archive", MB_YESNO)) {
			memset(&i_data, 0, sizeof(i_data)); /* start search at */
			strcpy(i_data.name, start_path); /* entry + 1 */
			if (file_sd.cur_entry) {
			    strcat(i_data.name, (dirs+file_sd.cur_entry-1)->name);
			    strcpy(spath, i_data.name);
			}
			fill_info_key(i_data, &i_key);
			if (ntraverse(0, &i_key, NULL, &c, TRAVERSE_SEARCH, INFO_NAME))
			    message_box("Not found", MB_OK);
			else {
			    while (1) {
				x = ntraverse(0, &i_key, NULL, &c, TRAVERSE_CONTINUE,
					      INFO_NAME);
				if (x == 2) {	 /* error */
				    message_box("Not found", MB_OK);
				    c =-1;
				    break;
				}
				if (x == 1) {	 /* end of tree */
				    x = ntraverse(0, &i_key, NULL, &c, TRAVERSE_TOP, 
						  INFO_NAME); /* go to beginning */
				    if (x) {
					message_box("Not found", MB_OK);
					c=-1;
					break;
				    }
				}
				if (read_info_rec(c, &i_data) == -1) {
				    do_exit(ERROR_READING_INFO);
				    c =  -1;
				    break;
				}
				if (!strcmp(i_data.name, spath)) {
				    message_box("Not found", MB_OK); /* back to where we started */
				    c = -1;
				    break;
				}
				if (strstr(i_data.name, ssearch))
				    break;
			    }
			    if (c == -1)
				break;
			    if (!strrchr(i_data.name, '/')) {
				message_box("Problem...", MB_OK);
				break;
			    }
			    strcpy(start_path, i_data.name);
			    if (start_path[strlen(start_path)-1] == '/') /* is a directory */
				*strrchr(start_path, '/') = 0; /* so go back one */
			    *strrchr(start_path, '/') = 0;
			    make_mydir(abs(i_data.f.volume));
			    c=0;
			    while (c<in_dir-1) {
				if (!strcmp((dirs+c)->name, &i_data.name[strlen(start_path)]))
				    break;
				c++;
			    }
			    adjust_cur_entry(files, &file_sd, restore_print_vol_dir, &p,
					     &in_dir, c+1);
			}
		    }
		}
		else
		    adjust_cur_entry(files, &file_sd, restore_print_vol_dir, &p,
				     &in_dir, c+1);
	    }
	    break;
	case SELECT_ABORT:
	    return 0;
	case SELECT_FINISHED:
	    return 1;
	case SELECT_ENTER:
	    if (file_sd.cur_entry == 0) {	 /* going up */
		if (!strcmp(start_path, "/"))
		    break; /* can't go up there */
		if (!strcmp(start_path, cf))
		    break;			 /* can't go up beyond cf */
		while (1) {
		    if (!*start_path)		 /* empty directory already */
		      break;
		    oldvol = abs((dirs+file_sd.cur_entry)->i.f.volume);
		    strcpy(old_start, start_path);
 		    start_path[strlen(start_path)-1] = 0;   /* get rid of trailing / */
		    if (strrchr(start_path, '/') == NULL) 
		      *start_path = 0;
		    else
		      *strrchr(start_path, '/') = 0;
		    if (strcmp(start_path, cf))
			make_mydir(only_vol);
		    else
			make_mydir(oldvol);
		    s=dirs;			 /* try & find old dir in new dir */
		    for (c=0; c<in_dir; c++) 	 /* so can position on it */
		      if ( (!strcmp(s->name, &old_start[strlen(start_path)])) &&
			   ((abs(s->i.f.volume) == abs(oldvol))) )
		      break;
		    else
		      s++;
		    if (c < in_dir) {		 /* found entry */
			c++;			 /* to skip the .. entry */
			file_sd.cur_entry = c;		 
			file_sd.top_entry = c-5;	 /* give it 5 lines */
			file_sd.cursor_line = 6;
			if (file_sd.top_entry < 0) {/* not five entries in directory */
			    file_sd.cursor_line += file_sd.top_entry;
			    file_sd.top_entry = 0;
			}
		    }
		    if ((in_dir != 2) || (!auto_descend) || (!strcmp(start_path, "/"))) 
		      break;
		    if (!S_ISDIR(dirs->i.f.mode))/* make sure that it is a directory */
			break;
		    if (!*start_path) 		 /* reached top */
			break;
		    file_sd.cur_entry = 0;
		}
	    }
	    else
		autod(&file_sd);
	restore_print_vol_dir(files, file_sd.top_entry, &p);
	break;
    case SELECT_TAB:
	    if (no_sel) 
	      ret =select_box(selection, &no_sel, &select_sd,
			      restore_print_selected, 
			      restore_print_selected_line,
			      toggle_selection, toggle_selection,
			      restore_del_cur_entry, backrest_paint, NULL,
			      selection, &no_sel, &select_sd, restore_print_selected,
			      NULL, NULL, NULL, NULL,
			      restore_asterix_dir, &file_sd,
			      "Change to/from most recent restore",
			      backrest_save_backupset, restore_restore_backupset,
			      FALSE, FALSE,
			      NULL, NULL, NULL);
	    switch(ret) {
	       case SELECT_ABORT:
		return 0;
	       case SELECT_FINISHED:
		return 1;
	       case SELECT_TAB:
		if (no_vol_details)		 /* if nothing in vol, will  */
		  ret = select_box(on_vol, &no_vol_details, &vol_sd,   /* fall through as SELECT_TAB */
				   print_on_vol_dir,
				   print_on_voldir_line, restore_on_vol_select,
				   restore_on_vol_select, NULL,
				   backrest_paint, NULL, selection, &no_sel,
				   &select_sd, restore_print_selected,
				   NULL, NULL, NULL, NULL,
				   NULL, NULL, "Select file/directory for restore",
				   backrest_save_backupset, restore_restore_backupset,
				   FALSE, FALSE,
				   NULL, NULL, NULL);
		switch(ret) {
		   case SELECT_ABORT:
		    return 0;
		   case SELECT_FINISHED:
		    return 1;
		   default:
		    break;
		}
	    }
	    break; 
	case SELECT_GOTO:
	    if (get_string(win_main, ssearch, sizeof(ssearch), "Enter directory to go to")) {
		memset(&i_data, 0, sizeof(i_data)); /* start search at */
		strcpy(i_data.name, ssearch); /* entry + 1 */
		fill_info_key(i_data, &i_key);
		if (ntraverse(0, &i_key, NULL, &c, TRAVERSE_SEARCH, INFO_NAME))
		    message_box("Not found", MB_OK);
		else 
		    if (read_info_rec(c, &i_data) == -1)
			message_box("Unable to find", MB_OK);
		    else
			if (!S_ISDIR(i_data.f.mode))
			    message_box("Not a directory", MB_OK);
			else {
			    strcpy(start_path, i_data.name);
			    make_mydir(only_vol);
			    clear_sd(&file_sd);
			}
	    }
	    backrest_paint();
	    break;
	 default:
	    break;
	}
    }
    return 0; /* never get here */
}
    
