static char dqs_shutdown_rcsid[]="$Id: dqs_shutdown.c,v 1.1.1.1 1997/04/10 15:10:34 green Exp $";

/*----------------------------------------------------
 * dqs_shutdown.c Tom Green Mon Jan 31 10:43:04 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_shutdown.c,v $
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.2  1996/11/20 23:04:31  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.1  1996/03/22  04:21:24  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.0  1994/03/07  04:14:39  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:47  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

 
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/******************************************************************************/
void dqs_shutdown()
{

     int fd;

     DENTER((DQS_EVENT,"dqs_shutdown"));
     
     CRITICAL((DQS_EVENT,"DQS_ERROR_0504 Controlled shutdown"));
 
     DEXIT;

     for (fd=0;fd<NOFILE;fd++)
     close(fd);
     exit(0);
     
}
