static char dqs_tid_rcsid[]="$Id: dqs_tid.c,v 1.1.1.1 1997/04/10 15:10:34 green Exp $";

/*----------------------------------------------------
 * dqs_tid.c Tom Green Mon Jan 31 10:43:05 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_tid.c,v $
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.6  1996/11/20 23:04:41  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.5  1996/06/27  01:56:10  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.4  1996/03/22  04:21:33  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.3  1995/02/05  00:51:16  nrl
 * Changed meaning of "-clean" option to mean cleanout all
 * options potentially resettable by qalter. Added interactive
 * prompting.
 *
 * Revision 3.2  1995/02/01  23:17:50  nrl
 * Tidied up and hopefully bulletproofed "tid" management. Reversed
 * tid file naming to sort by time.
 *
 * Revision 3.1  1995/01/30  15:22:09  nrl
 * added "tid" verification between execd and qmaster to prevent
 * "ghost" jobs from persisting in visible queue. Changed ERROR messages
 * which were for information only to DEBUG messages.
 *
 * Revision 3.0  1994/03/07  04:14:44  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:48  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/

 
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/************************************************************************/
dqs_list_type *dqs_get_tid()

{
     
     string        str;
     dqs_list_type *tid;
     
     DENTER((DQS_EVENT,"dqs_get_tid"));
     
     tid=(dqs_list_type *)dqs_malloc(sizeof(dqs_list_type));
     tid->str0=dqs_string_insert(NULL,me.qualified_hostname);
     tid->int0=dqs_rand(0,9999999);
     tid->int1=dqs_get_gmt();
     DEXIT;
     return(tid);
     
}

/************************************************************************/
void dqs_save_tid(lp,from_who)
dqs_list_type *lp;
int           from_who;

{

     string        str;
     dqs_list_type listel;
     
     DENTER((DQS_EVENT,"dqs_save_tid"));
     
     bzero((char *)&listel,sizeof(listel));
     if (lp->tid)
     { /* must be a "reply_head" */
	  listel.str0=dqs_string_insert(NULL,lp->tid->str0);
	  listel.int0=lp->tid->int0;
	  listel.int1=lp->tid->int1;
     }
     else
     { /* must be a "raw" tid */
          listel.str0=dqs_string_insert(NULL,lp->str0);
          listel.int0=lp->int0;
          listel.int1=lp->int1;
     }

     if ((from_who==DQS_EXECD)||(from_who==QMASTER))
     listel.int2=0; /* DON'T TIME OUT TIDS! */
     else
     listel.int2=dqs_get_gmt();
     listel.chain=lp;
     sprintf(str,"%d.%s.%d",listel.int1,listel.str0,listel.int0);
     dqs_write_list_to_disk(TID_DIR,str,&listel,ALL);

     Tid_head=dqs_insert(DQS_STR0,HEAD,Tid_head,&listel);


     if (listel.int2)
     {
          DPRINTF((DQS_EVENT,"saving ANCILLARY TID ===>%s<",str));
     }
     else
     {
          DPRINTF((DQS_EVENT,"saving DQS_EXECD TID ===>%s<",str));
     }
/*     

lp=Tid_head;
while (lp)
{
INFO((DQS_EVENT,"DQS_ERROR_0517 SAVING(%d.%s.%d)",lp->int0,lp->str0,lp->int1));

lp=lp->next;
}
*/
     
     DEXIT;
     return;
}

/************************************************************************/
void dqs_tid_garbage_collector()

{
     
     int             status;
     string          str;
     u_long32        now;
     u_long32        d_day_gmt;
     static u_long   then=0;
     dqs_list_type   *lp;
     dqs_list_type   *freeptr;
     
     DENTER((DQS_EVENT,"dqs_tid_garbage_collector"));
/*

INFO((DQS_EVENT,"DQS_ERROR_0518 ++++++++++++dqs_tid_garbage_collector()++++++++++"));

lp=Tid_head;
while (lp)
{
INFO((DQS_EVENT,"DQS_ERROR_0519 GARBAGE_COLLECTOR(%d.%s.%d)",lp->int1,lp->str0,lp->int0));

lp=lp->next;
}
*/

     if (!Tid_head)
     {
          DEXIT;
          return;
     }

     d_day_gmt=2*conf.alarml*DQS_NRETRIES;
     now=dqs_get_gmt();
     if ((now-then>d_day_gmt)||(then-now>d_day_gmt))
     {
	  then=now;
     }
     else
     {
	  DEXIT;
	  return;
     }

   tid_garbage_collector_one_more_time:
     DTRACE;
     
     lp=Tid_head;
     if (!lp)
     {
	  DEXIT;
	  return;
     }
     DTRACE;

     d_day_gmt=2*conf.alarml*DQS_NRETRIES;

     if ((lp->int2)&&(now>(lp->int2+d_day_gmt)))
     {
          freeptr=lp;
          Tid_head=lp->next;
	  freeptr->next=NULL;
	  sprintf(str,"%d.%s.%d",freeptr->int1,freeptr->str0,freeptr->int0);
/*          INFO((DQS_EVENT,"DQS_ERROR_0520 TID_GARBAGE_COLLECTOR nuking %s",str)); */
	  dqs_unlink(TID_DIR,str);
          freeptr=dqs_free_list(freeptr);
          goto tid_garbage_collector_one_more_time;
     }

     while(lp->next)
     {
          if ((lp->next->int2)&&(now>(lp->next->int2+d_day_gmt)))
          {
               freeptr=lp->next;
               lp->next=lp->next->next;
               freeptr->next=NULL;
	       sprintf(str,"%d.%s.%d",freeptr->int1,freeptr->str0,freeptr->int0);
/*	       INFO((DQS_EVENT,"DQS_ERROR_0521 TID_GARBAGE_COLLECTOR nuking %s",str)); */
	       dqs_unlink(TID_DIR,str);
               freeptr=dqs_free_list(freeptr);
	       continue;
          }
          lp=lp->next;
     }
     
     DEXIT;
     return;
     
}

/************************************************************************/
dqs_list_type *dqs_locate_tid(tid)
dqs_list_type *tid;

{
     
     dqs_list_type *lp;
     
     DENTER((DQS_EVENT,"dqs_locate_tid"));
     
     lp=Tid_head;
     while (lp)
     {
	  if (tid->int0==lp->int0)
	  {
	       if (tid->int1==lp->int1)
	       {
/*  bullet proofing in case of garbage TID       */
	       	
	       	if( (!tid->str0 ) || ( !lp->str0) ) {
	       DPRINTF((DQS_EVENT,"garbage tid.. no string %d %d",tid->int0,tid->int1) );
	       		 DEXIT;                 
	       		 return(NULL);
	       	}
		    if (!strcmp(tid->str0,lp->str0))
		    {
			 DEXIT;
			 return(lp->chain);
		    }
	       }
	  }
	  lp=lp->next;
     }
     
     DEXIT;
     return(NULL);
}
/************************************************************************/
int dqs_ifequal_tid(tid1, tid2)
dqs_list_type *tid1;
dqs_list_type *tid2;

{
     DENTER((DQS_EVENT,"dqs_ifequal_tid"));

	  if (tid1->int0==tid2->int0)
	  {
	       if (tid1->int1==tid2->int1)
	       {
/*  bullet proofing in case of garbage TID       */
	       	
	       	if( (!tid1->str0 ) || ( !tid2->str0) ) {
	       DPRINTF ((DQS_EVENT,"garbage tid.. no string %d %d",
                                               tid1->int0,tid1->int1) );
	       		 DEXIT;                 
	       		 return(0);
	       	}
	       	
		    if (!strcmp(tid1->str0,tid2->str0))
		    {
			 DEXIT;
			 return(1);
		    }
	       }
	  }
     
     DEXITE;
     return(0);
}

/************************************************************************/
void dqs_tid_del_x_host(host)
char *host;

{
     
     int             status;
     string          str;
     u_long32        now;
     u_long32        d_day_gmt;
     static u_long   then=0;
     dqs_list_type   *lp;
     dqs_list_type   *freeptr;
     
     DENTER((DQS_EVENT,"dqs_tid_del_x_host"));

/*
     INFO((DQS_EVENT,"DQS_ERROR_0522 =================dqs_tid_del_x_host(%s)",host)); 

lp=Tid_head;
while (lp)
{
INFO((DQS_EVENT,"DQS_ERROR_0523 dqs_tid_del_x_host(%d.%s.%d)",lp->int1,lp->str0,lp->int0));
lp=lp->next;
}
*/

   dqs_tid_del_x_host_one_more_time:
   
     DTRACE;
     
     lp=Tid_head;
     if (!lp)
     {
          DEXIT;
          return;
     }
     DTRACE;

     if (!lp->int2)
     { /* originated from either QMASTER or DQS_EXECD */
	  if (!strcmp(lp->str0,host))
	  {
	       freeptr=lp;
	       Tid_head=lp->next;
	       freeptr->next=NULL;
	       sprintf(str,"%d.%s.%d",freeptr->int1,freeptr->str0,freeptr->int0);
/*               INFO((DQS_EVENT,"DQS_ERROR_0524 dqs_tid_del_x_host nuking %s",str)); */
	       dqs_unlink(TID_DIR,str);
	       freeptr=dqs_free_list(freeptr);
	       goto dqs_tid_del_x_host_one_more_time;
	  }
     }

     while(lp->next)
     {
/*	  INFO((DQS_EVENT,"DQS_ERROR_0525 dqs_tid_del_x_host >%s<>%s<",lp->next->str0,host)); */
          if (!lp->next->int2)
	  { /* originated from either QMASTER or DQS_EXECD */
	        if (!strcmp(lp->next->str0,host))
		{
		     freeptr=lp->next;
		     lp->next=lp->next->next;
		     freeptr->next=NULL;
		     sprintf(str,"%d.%s.%d",freeptr->int1,freeptr->str0,freeptr->int0);
/*		     INFO((DQS_EVENT,"DQS_ERROR_0526 dqs_tid_del_x_host nuking %s",str)); */
		     dqs_unlink(TID_DIR,str);
		     freeptr=dqs_free_list(freeptr);
		     continue;
		}
	   }
          lp=lp->next;
     }
     
     DEXITE;
     return;
     
}
