;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Cgen/capp.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Jul  3 07:50:47 1996                          */
;*    Last change :  Tue Apr 22 08:29:54 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The C production for application (apply, funcall, app) nodes.    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_capp
   (include "Tools/trace.sch")
   (import  tools_error
	    tools_shape
	    type_type
	    type_tools
	    type_cache
	    ast_var
	    ast_node
	    ast_local
	    effect_effect
	    cgen_emit
	    cgen_cop
	    cgen_cgen))

;*---------------------------------------------------------------------*/
;*    node->cop ::app-ly ...                                           */
;*---------------------------------------------------------------------*/
(define-method (node->cop node::app-ly kont)
   (trace (cgen 3) "(node->cop node::app-ly kont): " (shape node) #\Newline
	  "  kont: " kont #\Newline)
   (with-access::app-ly node (fun arg)
      (let* ((value arg)
	     (vaux  (make-local-svar/name 'aux *obj*))
	     (vcop  (node->cop (node-setq vaux value) *id-kont*))
	     (fun   fun)
	     (faux  (make-local-svar/name 'fun *procedure*))
	     (fcop  (node->cop (node-setq faux fun) *id-kont*)))
	 (cond
	    ((and (csetq? vcop) (eq? (varc-variable (csetq-var vcop)) vaux)
		  (csetq? fcop) (eq? (varc-variable (csetq-var fcop)) faux))
	     (kont (instantiate::capply
		      (fun (csetq-value fcop))
		      (arg (csetq-value vcop)))))
	    ((and (csetq? vcop) (eq? (varc-variable (csetq-var vcop)) vaux))
	     (instantiate::block
		(body (instantiate::csequence
			 (cops
			  (list
			   (instantiate::local-var (vars (list faux)))
			   (instantiate::csequence (cops (list fcop)))
			   (kont (instantiate::capply
				    (fun (instantiate::varc (variable faux)))
				    (arg (csetq-value vcop))))))))))
	    ((and (csetq? fcop) (eq? (varc-variable (csetq-var fcop)) faux))
	     (instantiate::block
		(body (instantiate::csequence
			 (cops
			  (list
			   (instantiate::local-var
			      (vars (list vaux)))
			   (instantiate::csequence
			      (cops (list vcop)))
			   (kont (instantiate::capply
				    (fun (csetq-value fcop))
				    (arg (instantiate::varc
					    (variable vaux)))))))))))
	    (else
	     (instantiate::block
		(body (instantiate::csequence
			 (cops
			  (list
			   (instantiate::local-var
			      (vars (list faux vaux)))
			   (instantiate::csequence
			      (cops (list fcop vcop)))
			   (kont (instantiate::capply
				    (fun (instantiate::varc
					    (variable faux)))
				    (arg (instantiate::varc
					    (variable vaux)))))))))))))))

;*---------------------------------------------------------------------*/
;*    node->cop ::funcall ...                                          */
;*---------------------------------------------------------------------*/
(define-method (node->cop node::funcall kont)
   (trace (cgen 3) "(node->cop node::funcall kont): " (shape node) #\Newline
	  "  kont: " kont #\Newline)
   (with-access::funcall node (fun args strength loc)
      (let loop ((old-actuals  args)
		 (new-actuals  '())
		 (aux          (make-local-svar/name 'aux *obj*))
		 (auxs         '())
		 (exps         '()))
	 (if (null? old-actuals)
	     (let* ((aux (make-local-svar/name 'aux *obj*))
		    (cop (node->cop (node-setq aux fun) *id-kont*)))
		(if (and (csetq? cop)
			 (var? fun)
			 (eq? (varc-variable (csetq-var cop)) aux))
		    (let ((cfun (csetq-value cop)))
		       (if (null? auxs)
			   (kont (instantiate::cfuncall
				    (fun cfun)
				    (args (reverse! new-actuals))
				    (strength strength)))
			   (instantiate::block
			      (body (instantiate::csequence
				       (cops
					(list
					 (instantiate::local-var
					    (vars auxs))
					 (instantiate::csequence
					    (cops exps))
					 (kont (instantiate::cfuncall
						  (fun cfun)
						  (args (reverse! new-actuals))
						  (strength strength))))))))))
		    (let ((cfun cop))
		       (instantiate::block
			  (body (instantiate::csequence
				   (cops
				    (list
				     (instantiate::local-var
					(vars (cons aux auxs)))
				     (instantiate::csequence
					(cops (cons cfun exps)))
				     (kont (instantiate::cfuncall
					      (fun (instantiate::varc
						      (variable aux)))
					      (args (reverse! new-actuals))
					      (strength strength)))))))))))
	     (let ((cop (node->cop (node-setq aux (car old-actuals))
				   *id-kont*)))
		(if (and (csetq? cop)
			 (eq? (varc-variable (csetq-var cop)) aux))
		    ;; the local is useless, we ignore it
		    (loop (cdr old-actuals)
			  (cons (csetq-value cop) new-actuals)
			  aux
			  auxs
			  exps)
		    (begin
		       (loop (cdr old-actuals)
			     (cons (instantiate::varc (variable aux))
				   new-actuals)
			     (make-local-svar/name 'aux *obj*)
			     (cons aux auxs)
			     (cons cop exps)))))))))
		
;*---------------------------------------------------------------------*/
;*    node->cop ::app ...                                              */
;*---------------------------------------------------------------------*/
(define-method (node->cop node::app kont)
   (trace (cgen 3) "(node->cop node::app kont): " (shape node) #\Newline
	  "  kont: " kont #\Newline)
   (with-access::app node (fun)
      (let ((var (var-variable fun)))
      (if (and (global? var)
	       (or (not (eq? var *the-global*))
		   (not (eq? kont *return-kont*)))) 
	  (node-non-tail-app->cop var node kont)
	  (node-tail-app->cop var node kont)))))

;*---------------------------------------------------------------------*/
;*    node-non-tail-app->cop ...                                       */
;*---------------------------------------------------------------------*/
(define (node-non-tail-app->cop var node kont)
   (trace (cgen 2) "node-non-tail-app->cop: "
	  (shape var) " " 
	  (shape node) " "
	  "kont: " kont
	  #\Newline)
   (if (sfun? (variable-value var))
       (node-sfun-non-tail-app->cop var node kont)
       (node-cfun-non-tail-app->cop var node kont)))

;*---------------------------------------------------------------------*/
;*    node-sfun-non-tail-app->cop ...                                  */
;*---------------------------------------------------------------------*/
(define (node-sfun-non-tail-app->cop var node kont)
   (let* ((args      (sfun-args (variable-value var)))
	  (args-type (cond
			((null? args)
			 '())
			((local? (car args))
			 (map local-type args))
			(else
			 args)))
	  (useless?  (lambda (cop aux)
			(and (csetq? cop)
			     (eq? (varc-variable (csetq-var cop)) aux)))))
      (node-sfun/cfun-non-tail-app->cop var node kont args-type useless?)))

;*---------------------------------------------------------------------*/
;*    node-cfun-non-tail-app->cop ...                                  */
;*---------------------------------------------------------------------*/
(define (node-cfun-non-tail-app->cop var node kont)
   (let ((args-type (cfun-args-type (variable-value var)))
	 (useless?  (lambda (cop aux)
		       (and (csetq? cop)
			    (eq? (varc-variable (csetq-var cop)) aux)
			    (or (catom? (csetq-value cop))
				(varc? (csetq-value cop)))))))
      (node-sfun/cfun-non-tail-app->cop var node kont args-type useless?)))

;*---------------------------------------------------------------------*/
;*    node-sfun/cfun-non-tail-app->cop ...                             */
;*---------------------------------------------------------------------*/
(define (node-sfun/cfun-non-tail-app->cop var node kont args-type useless?)
   (let loop ((old-actuals  (app-args node))
	      (args-type    args-type)
	      (new-actuals  '())
	      (aux          (make-local-svar/name 'aux *obj*))
	      (auxs         '())
	      (exps         '()))
      (if (null? old-actuals)
	  (if (null? auxs)
	      (kont (instantiate::capp
		       (fun (node->cop (app-fun node) *id-kont*))
		       (args (reverse! new-actuals))))
	      (instantiate::block
		 (body (instantiate::csequence
			  (cops
			   (list
			    (instantiate::local-var (vars auxs))
			    (instantiate::csequence (cops exps))
			    (kont (instantiate::capp
				     (fun (node->cop (app-fun node) *id-kont*))
				     (args (reverse! new-actuals))))))))))
	  (let ((cop (node->cop (node-setq aux (car old-actuals)) *id-kont*)))
	     (if (useless? cop aux)
		 (loop (cdr old-actuals)
		       (cdr args-type)
		       (cons (csetq-value cop) new-actuals)
		       aux
		       auxs
		       exps)
		 (begin
		    (local-type-set! aux (car args-type))
		    (loop (cdr old-actuals)
			  (cdr args-type)
			  (cons (instantiate::varc (variable aux)) new-actuals)
			  (make-local-svar/name 'aux (car args-type))
			  (cons aux auxs)
			  (cons cop exps))))))))

;*---------------------------------------------------------------------*/
;*    node-tail-app->cop ...                                           */
;*    -------------------------------------------------------------    */
;*    For local functions, the first time we see it, we have           */
;*    to expand their body. So we check if the functions is            */
;*    already expanded then, we jump to the definition otherwise       */
;*    we expand the body and don't produce jump.                       */
;*---------------------------------------------------------------------*/
(define (node-tail-app->cop var node kont)
   (let ((label (sfun/C-label (variable-value var)))
	 (args  (sfun-args (variable-value var))))
      (if (not (sfun/C-integrated (variable-value var)))
	  (begin
	     (sfun/C-integrated-set! (variable-value var) #t)
	     (let ((body (node->cop (sfun-body (local-value var)) kont)))
		(clabel-body-set! label body)
		(if (null? args)
		    label
		    (let loop ((formals args)
			       (actuals (app-args node))
			       (seq     '()))
		       (if (null? formals)
			   (instantiate::csequence
			      (cops (reverse! (cons label seq))))
			   (loop (cdr formals)
				 (cdr actuals)
				 (cons (node->cop (node-setq (car formals)
							     (car actuals))
						  *stop-kont*)
				       seq)))))))
	  ;; before branching, we create local variable to hold
	  ;; new formal cops.
	  (if (null? args)
	      (begin
		 (clabel-used?-set! label #t)
		 (instantiate::cgoto (label label)))
	      (let loop ((args    args) 
			 (actuals (app-args node))
			 (auxs    '())
			 (seq1    '())
			 (seq2    (list (begin
					   (clabel-used?-set! label #t)
					   (instantiate::cgoto
					      (label label))))))
		 (if (null? args)
		     (begin
			(if (null? seq1)
			    (set! seq1 seq2)
			    (begin
			       (set! seq1 (reverse! seq1))
			       (set-cdr! (last-pair seq1) seq2)))
			(*block-kont*
			 (instantiate::csequence
			    (cops (cons (instantiate::local-var (vars auxs))
					seq1)))))
		     (let ((arg (car args))
			   (act (car actuals)))
			;; we look for this special case in order to avoid
			;; local variable creations for constant parameters
			;; (as kaptured ones).
			(if (and (var? act) (eq? arg (var-variable act)))
			    (loop (cdr args)
				  (cdr actuals)
				  auxs
				  seq1
				  seq2)
			    (let ((aux (make-local-svar/name
					(local-id arg)
					(local-type arg))))
			       (loop (cdr args)
				     (cdr actuals)
				     (cons aux auxs)
				     (cons (node->cop (node-setq aux act)
						      *stop-kont*)
					   seq1)
				     (cons
				      (instantiate::stop
					 (value
					  (instantiate::csetq
					     (var (instantiate::varc
						     (variable arg)))
					     (value (instantiate::varc
						       (variable aux))))))
				      seq2)))))))))))



