;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Cgen/emit-cop.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Jul  2 14:39:37 1996                          */
;*    Last change :  Tue Jun 24 11:30:57 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The emission of cop code.                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_emit-cop
   (import type_type
	   type_tools
	   type_cache
	   engine_param
	   ast_var
	   ast_node
	   cgen_emit
	   cgen_cop)
   (export (generic emit-cop::bool ::cop)
	   (untrigraph::bstring ::bstring)))

;*---------------------------------------------------------------------*/
;*    emit-cop ...                                                     */
;*    -------------------------------------------------------------    */
;*    If emit-cop emit an expression with a `;' it returns #f,         */
;*    otherwise it returns #t.                                         */
;*---------------------------------------------------------------------*/
(define-generic (emit-cop::bool cop::cop))
 
;*---------------------------------------------------------------------*/
;*    emit-cop ::clabel ...                                            */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::clabel)
   (with-access::clabel cop (used? name body)
      (if used?
	  (begin
	     (display name *c-port*)
	     (write-char #\: *c-port*)
	     (newline *c-port*)))
      (emit-cop body)))

;*---------------------------------------------------------------------*/
;*    emit-cop ::cgoto ...                                             */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::cgoto)
   (with-access::cgoto cop (label)
      (fprint *c-port* "goto " (clabel-name label) #\;)
      #f))

;*---------------------------------------------------------------------*/
;*    emit-cop ::block ...                                             */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::block)
   (with-access::block cop (body)
      (if (block? body)
	  (emit-cop body)
	  (begin
	     (write-char #\{ *c-port*)
	     (newline *c-port*)
	     (if (emit-cop body) (fprint *c-port* #\;))
	     (write-char #\} *c-port*)
	     (newline *c-port*)
	     #f))))

;*---------------------------------------------------------------------*/
;*    emit-cop ::creturn ...                                           */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::creturn)
   (with-access::creturn cop (value)
      (display "return " *c-port*)
      (if (emit-cop value) (fprint *c-port* #\;))
      #f))

;*---------------------------------------------------------------------*/
;*    emit-cop ::catom ...                                             */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::catom)
   (with-access::catom cop (value)
      (emit-atom-value value)
      #t))

;*---------------------------------------------------------------------*/
;*    emit-cop ::cvoid ...                                             */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::cvoid)
   (with-access::cvoid cop (value)
      (emit-cop value)))

;*---------------------------------------------------------------------*/
;*    emit-cop ::varc ...                                              */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::varc)
   (with-access::varc cop (variable)
      (display (variable-name variable) *c-port*)
      #t))

;*---------------------------------------------------------------------*/
;*    emit-cop ::cpragma ...                                           */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::cpragma)
   (with-access::cpragma cop (args format)
      (if (null? args)
	  (display format *c-port*)
	  (let* ((sport  (open-input-string format))
		 (args   (list->vector args))
		 (parser (regular-grammar ()
			    ((#\$ (+ (>-< #\0 #\9)))
			     (let* ((str   (the-string))
				    (len   (the-length))
				    (index (string->number
					    (substring str 1 len))))
				(emit-cop (vector-ref args (-fx index 1)))
				(ignore)))
			    ((+ (out #\$))
			     (display (the-string) *c-port*)
			     (ignore))
			    (else
			     (the-failing-char)))))
	     (read/rp parser sport)
	     #t))))

;*---------------------------------------------------------------------*/
;*    emit-cop ::ccast ...                                             */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::ccast)
   (with-access::ccast cop (arg type)
      (display "((" *c-port*)
      (display (type-name type) *c-port*)
      (write-char #\) *c-port*)
      (emit-cop arg)
      (write-char #\) *c-port*)
      #t))

;*---------------------------------------------------------------------*/
;*    emit-cop ::csequence ...                                         */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::csequence)
   (with-access::csequence cop (c-exp? cops)
      (if c-exp?
	  (begin
	     (if (null? cops)
		 (emit-atom-value #unspecified)
		 (begin
		    (write-char #\( *c-port*)
		    (let liip ((exp cops))
		       (if (null? (cdr exp))
			   (begin
			      (emit-cop (car exp))
			      (write-char #\) *c-port*)
			      #t)
			   (begin
			      (emit-cop (car exp))
			      (if (cfail? (car exp))
				  (begin
				     (write-char #\) *c-port*)
				     #t)
				  (begin
				     (write-char #\, *c-port*)
				     (newline *c-port*)
				     (liip (cdr exp))))))))))
	  (let liip ((exp cops))
	     (if (null? exp)
		 #f
		 (let ((e (car exp)))
		    (if (emit-cop e) (fprint *c-port* #\;))
		    (if (cfail? e)
			(liip '())
			(liip (cdr exp)))))))))

;*---------------------------------------------------------------------*/
;*    emit-cop ::nop ...                                               */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::nop)
   (fprint *c-port* #\;)
   #f)

;*---------------------------------------------------------------------*/
;*    emit-cop ::stop ...                                              */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::stop)
   (with-access::stop cop (value)
      (if (emit-cop value) (fprint *c-port* #\;))
      #f))

;*---------------------------------------------------------------------*/
;*    emit-cop ::csetq ...                                             */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::csetq)
   (with-access::csetq cop (var value)
      (emit-cop var)
      ;; don't omit to put space sourrounding `=' otherwise
      ;; it could become an ambiguous assignement (e.g. x=-1).
      (display " = " *c-port*)
      (emit-cop value)
      #t))

;*---------------------------------------------------------------------*/
;*    emit-cop ::cif ...                                               */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::cif)
   (with-access::cif cop (test true false)
      (display "if(" *c-port*)
      (emit-cop test)
      (write-char #\) *c-port*)
      (emit-cop true)
      (display " else " *c-port*)
      (emit-cop false)))

;*---------------------------------------------------------------------*/
;*    emit-cop ::branch ...                                            */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::branch)
   (with-access::branch cop (test true false end)
      (emit-cop test)
      (if (emit-cop true) (fprint *c-port* #\;))
      (if (emit-cop false) (fprint *c-port* #\;))
      (emit-cop end)))

;*---------------------------------------------------------------------*/
;*    emit-cop ::local ...                                             */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::local-var)
   (with-access::local-var cop (vars)
      (for-each (lambda (local)
		   (fprint *c-port*
			   (make-typed-declaration (local-type local)
						   (local-name local))
			   #\;))
		vars)
      #f))

;*---------------------------------------------------------------------*/
;*    emit-cop ::cfuncall ...                                          */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::cfuncall)
   (labels ((emit-extra-light-cfuncall (cop)
               (let ((actuals (cfuncall-args cop)))
		  (emit-cop (cfuncall-fun cop))
		  (write-char #\( *c-port*)
		  (let loop ((actuals actuals))
		     ;; actuals are never empty because their are always
		     ;; the EOA.
		     (if (null? (cddr actuals))
			 (begin
			    (emit-cop (car actuals))
			    (write-char #\) *c-port*)
			    #t)
			 (begin
			    (emit-cop (car actuals))
			    (display ", " *c-port*)
			    (loop (cdr actuals)))))))
	    (emit-light-cfuncall (cop)
               (let ((actuals (cfuncall-args cop)))
		  (display "PROCEDURE_L_ENTRY(" *c-port*)
		  (emit-cop (cfuncall-fun cop))
		  (display ")(" *c-port*)
		  (let loop ((actuals actuals))
		     ;; actuals are never empty because their are always
		     ;; the function and EOA.
		     (if (null? (cddr actuals))
			 (begin
			    (emit-cop (car actuals))
			    (display ")" *c-port*)
			    #t)
			 (begin
			    (emit-cop (car actuals))
			    (display ", " *c-port*)
			    (loop (cdr actuals)))))))
	    (emit-regular-cfuncall/eoa (cop)
	       (let ((actuals (cfuncall-args cop)))
		  (display "PROCEDURE_ENTRY(" *c-port*)
		  (emit-cop (cfuncall-fun cop))
		  (display ")(" *c-port*)
		  (let loop ((actuals actuals))
		     ;; actuals are never empty because their are always
		     ;; the function and EOA.
		     (if (null? (cdr actuals))
			 (begin
			    (emit-cop (car actuals))
			    (display ")" *c-port*)
			    #t)
			 (begin
			    (emit-cop (car actuals))
			    (display ", " *c-port*)
			    (loop (cdr actuals)))))))
	    (emit-regular-cfuncall/oeoa (cop)
	       (let ((actuals (cfuncall-args cop)))
		  (display "PROCEDURE_ENTRY(" *c-port*)
		  (emit-cop (cfuncall-fun cop))
		  (display ")(" *c-port*)
		  (let loop ((actuals actuals))
		     ;; actuals are never empty because their are always
		     ;; the function and EOA.
		     (if (null? (cddr actuals))
			 (begin
			    (emit-cop (car actuals))
			    (display ")" *c-port*)
			    #t)
			 (begin
			    (emit-cop (car actuals))
			    (display ", " *c-port*)
			    (loop (cdr actuals)))))))
	    (emit-stdc-regular-cfuncall (cop)
	       (begin
		  (display "(VA_PROCUDUREP( " *c-port*)
		  (emit-cop (cfuncall-fun cop))
		  (display " ) ? " *c-port*)
		  (emit-regular-cfuncall/eoa cop)
		  (display " : " *c-port*)
		  (emit-regular-cfuncall/oeoa cop)
		  (display " )" *c-port*)
		  #t)))
      (case (cfuncall-strength cop)
	 ((elight)
	  (emit-extra-light-cfuncall cop))
	 ((light)
	  (emit-light-cfuncall cop))
	 (else
	  (if *stdc*
	      (emit-stdc-regular-cfuncall cop)
	      (emit-regular-cfuncall/eoa cop))))))

;*---------------------------------------------------------------------*/
;*    emit-cop ::capply ...                                            */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::capply)
   (with-access::capply cop (fun arg)
      (display "apply(" *c-port*)
      (emit-cop fun)
      (display ", " *c-port*)
      (emit-cop arg)
      (write-char #\) *c-port*)
      #t))
	     
;*---------------------------------------------------------------------*/
;*    emit-cop ::capp ...                                              */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::capp)
   (labels ((emit-infix-capp ()
	       (let ((actuals (capp-args cop)))
		  (write-char #\( *c-port*)
		  (emit-cop (car actuals))
		  (emit-cop (capp-fun cop))
		  (emit-cop (cadr actuals))
		  (write-char #\) *c-port*)
		  #t))
	    (emit-prefix-capp ()
               (let ((actuals (capp-args cop)))
		  (emit-cop (capp-fun cop))
		  (write-char #\( *c-port*)
		  (if (null? actuals)
		      (begin
			 (write-char #\) *c-port*)
			 #t)
		      (let loop ((actuals actuals))
			 (if (null? (cdr actuals))
			     (begin
				(emit-cop (car actuals))
				(write-char #\) *c-port*)
				#t)
			     (begin
				(emit-cop (car actuals))
				(display ", " *c-port*)
				(loop (cdr actuals)))))))))
      (let ((fun (varc-variable (capp-fun cop))))
	 (if (and (cfun? (global-value fun)) (cfun-infix? (global-value fun)))
	     (emit-infix-capp)
	     (emit-prefix-capp)))))

;*---------------------------------------------------------------------*/
;*    emit-cop ::cfail ...                                             */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::cfail)
   (with-access::cfail cop (proc msg obj)
      (display "FAILURE(" *c-port*)
      (emit-cop proc)
      (write-char #\, *c-port*)
      (emit-cop msg)
      (write-char #\, *c-port*)
      (emit-cop obj)
      (display ");" *c-port*)
      #f))

;*---------------------------------------------------------------------*/
;*    emit-cop ::cswitch ...                                           */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::cswitch)
   (with-access::cswitch cop (test clauses)
      (display "switch " *c-port*)
      (write-char #\( *c-port*)
      (emit-cop test)
      (write-char #\) *c-port*)
      (write-char #\{ *c-port*)
      (newline *c-port*)
      (let loop ((clauses clauses))
	 (let ((clause (car clauses)))
	    (if (eq? (car clause) 'else)
		(begin
		   (display "default: " *c-port*)
		   (newline *c-port*)
		   (if (emit-cop (cdr clause)) (fprint *c-port* #\;))
		   (write-char #\} *c-port*)
		   (newline *c-port*)
		   #f)
		(begin
		   (for-each (lambda (t)
				(display "case " *c-port*)
				(emit-atom-value t)
				(display " : " *c-port*)
				(newline *c-port*))
			     (car clause))
		   (if (emit-cop (cdr clause)) (fprint *c-port* #\;))
		   (fprint *c-port* "break;")
		   (loop (cdr clauses))))))))

;*---------------------------------------------------------------------*/
;*    emit-cop ::cmake-box ...                                         */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::cmake-box)
   (with-access::cmake-box cop (value)
      (display "MAKE_CELL(" *c-port*)
      (emit-cop value)
      (write-char #\) *c-port*)
      #t))

;*---------------------------------------------------------------------*/
;*    emit-cop ::cbox-ref ...                                          */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::cbox-ref)
   (with-access::cbox-ref cop (var)
      (display "CELL_REF(" *c-port*)
      (emit-cop var)
      (write-char #\) *c-port*)
      #t))

;*---------------------------------------------------------------------*/
;*    emit-cop ::cbox-set! ...                                         */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::cbox-set!)
   (with-access::cbox-set! cop (var value)
      (display "CELL_SET(" *c-port*)
      (emit-cop var)
      (display ", " *c-port*)
      (emit-cop value)
      (write-char #\) *c-port*)
      #t))

;*---------------------------------------------------------------------*/
;*    emit-cop ::cset-ex-it ...                                        */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::cset-ex-it)
   (with-access::cset-ex-it cop (exit jump-value body)
      (display "if( SET_EXIT(" *c-port*)
      (emit-cop exit)
      (display ") ) {" *c-port*)
      (display "RESTORE_TRACE(); " *c-port*)
      (emit-cop jump-value)
      (display "} else {" *c-port*)
      (emit-cop body)
      (write-char #\} *c-port*)
      (newline *c-port*)
      #f))

;*---------------------------------------------------------------------*/
;*    emit-cop ::cjump-ex-it ...                                       */
;*---------------------------------------------------------------------*/
(define-method (emit-cop cop::cjump-ex-it)
   (with-access::cjump-ex-it cop (exit value)
      (display "JUMP_EXIT( " *c-port*)
      (emit-cop exit)
      (write-char #\, *c-port*)
      (emit-cop value)
      (write-char #\) *c-port*)
      #t))

;*---------------------------------------------------------------------*/
;*    emit-atom-value ...                                              */
;*---------------------------------------------------------------------*/
(define (emit-atom-value value)
   (cond
      ((boolean? value)
       (display "((" *c-port*)
       (display (string-sans-$ (type-name *bool*)) *c-port*)
       (display #\) *c-port*)
       (display (if value 1 0) *c-port*)
       (display #\) *c-port*))
      ((null? value)
       (display "BNIL" *c-port*))
      ((char? value)
       (display "((" *c-port*)
       (display (string-sans-$ (type-name *char*)) *c-port*)
       (display ")" *c-port*)
       (if (=fx (char->integer value) 0)
	   (display "'\\000'" *c-port*)
	   (begin
	      (write-char #\' *c-port*)
	      (if (=fx (char->integer value) 39)
		  (display "\\''" *c-port*)
		  (begin
		     (case value
			((#\return)
			 (write-char #\\ *c-port*)
			 (write-char #\r *c-port*))
			((#\tab)
			 (write-char #\\ *c-port*)
			 (write-char #\t *c-port*))
			((#\newline)
			 (write-char #\\ *c-port*)
			 (write-char #\n *c-port*))
			((#\\)
			 (write-char #\\ *c-port*)
			 (write-char #\\ *c-port*))
			(else
			 (write-char value *c-port*)))
		     (write-char #\' *c-port*)))))
       (write-char #\) *c-port*))
      ((eq? value #unspecified)
       (display "BUNSPEC" *c-port*))
      ((cnst? value)
       (display "BCNST(" *c-port*)
       (display (cnst->integer value) *c-port*)
       (display #\) *c-port*))
      ((string? value)
       (display #\" *c-port*)
       (display (untrigraph (string-for-read value)) *c-port*)
       (display #\" *c-port*))
      ((fixnum? value)
       (display "((" *c-port*)
       (display (string-sans-$ (type-name *long*)) *c-port*)
       (display ")" *c-port*)
       (display value *c-port*)
       (display ")" *c-port*))
      ((flonum? value)
       (display "((" *c-port*)
       (display (string-sans-$ (type-name *real*)) *c-port*)
       (display ")" *c-port*)
       (display value *c-port*)
       (display ")" *c-port*))
      (else
       (display value *c-port*))))

;*---------------------------------------------------------------------*/
;*    untrigraph ...                                                   */
;*    -------------------------------------------------------------    */
;*    We remove ?? and replace it by \077\077\--- (the octal ascii     */
;*    code of ?) in order to avoir C trigraph confusions.              */
;*---------------------------------------------------------------------*/
(define (untrigraph from)
   (let* ((len   (string-length from))
	  (len-3 (-fx len 3)))
      ;; first we count how many collision we have
      (let ((nb-col (let loop ((i      0)
			       (nb-col 0))
		       (cond
			  ((>fx i len-3)
			   nb-col)
			  ((not (char=? (string-ref from i) #\?))
			   (loop (+fx i 1) nb-col))
			  ((not (char=? (string-ref from (+fx i 1)) #\?))
			   (loop (+fx i 2) nb-col))
			  ;; yes, we have one
			  (else
			   (loop (+fx i 3) (+fx nb-col 1)))))))
	 (if (=fx nb-col 0)
	     ;; there is no trigraph clashes
	     from
	     ;; there is some, we allocate a new string. Each trigraph
	     ;; require 4 times its size.
	     (let ((res   (make-string (+fx len (*fx 3 (*fx nb-col 3)))))
		   (len-1 (-fx len 1)))
		(let loop ((r 0)
			   (w 0))
		   (cond
		      ((=fx r len)
		       res)
		      ((or (not (char=? (string-ref from r) #\?))
			   (>fx r len-3))
		       (string-set! res w (string-ref from r))
		       (loop (+fx r 1) (+fx w 1)))
		      ((not (char=? (string-ref from (+fx r 1)) #\?))
		       (string-set! res w #\?)
		       (string-set! res (+fx w 1) (string-ref from (+fx r 1)))
		       (loop (+fx r 2) (+fx w 2)))
		      (else
		       ;; this is a trigraph
		       (string-set! res w #\\)
		       (string-set! res (+fx w 1) #\0)
		       (string-set! res (+fx w 2) #\7)
		       (string-set! res (+fx w 3) #\7)
		       (string-set! res (+fx w 4) #\\)
		       (string-set! res (+fx w 5) #\0)
		       (string-set! res (+fx w 6) #\7)
		       (string-set! res (+fx w 7) #\7)
		       (string-set! res (+fx w 8) #\\)
		       (let ((code (integer->string
				    (char->integer (string-ref from (+fx r 2)))
				    8)))
			  (if (=fx (string-length code) 4)
			      (begin
				 (string-set! res (+fx w 9) #\0)
				 (string-set! res (+fx w 10)
					      (string-ref code 2))
				 (string-set! res (+fx w 11)
					      (string-ref code 3)))
			      (begin
				 (string-set! res (+fx w 9)
					      (string-ref code 2))
				 (string-set! res (+fx w 10)
					      (string-ref code 3))
				 (string-set! res (+fx w 11)
					      (string-ref code 4)))))
		       (loop (+fx r 3) (+fx w 12))))))))))


