;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Cnst/walk.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Feb  3 09:46:40 1995                          */
;*    Last change :  Fri Aug  9 08:25:41 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `constant compilation'                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cnst_walk
   (include "Engine/pass.sch")
   (import  tools_shape
	    tools_error
	    engine_param
	    type_type
	    ast_var
	    ast_node
	    ast_remove
	    cnst_alloc
	    cnst_cache
	    cnst_node
	    cnst_initialize)
   (export  (cnst-walk! globals)))

;*---------------------------------------------------------------------*/
;*    cnst-walk! ...                                                   */
;*---------------------------------------------------------------------*/
(define (cnst-walk! globals)
   (pass-prelude "Cnst" start-cnst-cache! start-cnst-alloc! unsafe!)
   (verbose 2 "      [" *init-mode* #\] #\Newline)
   (for-each (lambda (global)
		(enter-function (global-id global))
		(let* ((fun      (global-value global))
		       (new-body (cnst! (sfun-body fun))))
		   (sfun-body-set! fun new-body))
		(leave-function))
	     globals)
   (pass-postlude (remove-var 'cnst (append (initialize-ast) globals))
		  stop-cnst-alloc!
		  safe!))

;*---------------------------------------------------------------------*/
;*    unsafe! ...                                                      */
;*---------------------------------------------------------------------*/
(define (unsafe!)
   (set! *old-unsafe-type* *unsafe-type*)
   (set! *unsafe-type* #t)
   (set! *old-unsafe-arity* *unsafe-arity*)
   (set! *unsafe-arity* #t)
   (set! *old-unsafe-range* *unsafe-range*)
   (set! *unsafe-range* #t)
   (set! *old-unsafe-struct* *unsafe-struct*)
   (set! *unsafe-struct* #t)
   (set! *old-unsafe-version* *unsafe-version*)
   (set! *unsafe-version* #t))

;*---------------------------------------------------------------------*/
;*    safe! ...                                                        */
;*---------------------------------------------------------------------*/
(define (safe!)
   (set! *unsafe-type* *old-unsafe-type*)
   (set! *unsafe-arity* *old-unsafe-arity*)
   (set! *unsafe-range* *old-unsafe-range*)
   (set! *unsafe-struct* *old-unsafe-struct*)
   (set! *unsafe-version* *old-unsafe-version*))

;*---------------------------------------------------------------------*/
;*    old-unsafes                                                      */
;*---------------------------------------------------------------------*/
(define *old-unsafe-type*    #f)
(define *old-unsafe-arity*   #f)
(define *old-unsafe-range*   #f)
(define *old-unsafe-struct*  #f)
(define *old-unsafe-version* #f)

