;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Type/pptype.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec 31 08:28:30 1994                          */
;*    Last change :  Tue Jun 11 16:46:26 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The type pretty-printer                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module type_pptype
   (import type_type
	   ast_var)
   (export (function-type->string::bstring ::variable)
	   (variable-type->string::bstring ::variable)))

;*---------------------------------------------------------------------*/
;*    type-id->string ...                                              */
;*---------------------------------------------------------------------*/
(define (type-id->string type)
   (if (not (type? type))
       "_"
       (string-downcase (symbol->string (type-id type)))))

;*---------------------------------------------------------------------*/
;*    function-type->string ...                                        */
;*---------------------------------------------------------------------*/
(define (function-type->string variable)
   (let ((sfun (variable-value variable)))
      (string-append (let loop ((args (sfun-args sfun)))
			(if (null? args)
			    ""
			    (string-append
			     (string-downcase
			      (symbol->string
			       (type-id (local-type (car args)))))
			     (if (null? (cdr args))
				 ""
				 " x ")
			     (loop (cdr args)))))
		     " -> "
		     (string-downcase
		      (symbol->string (type-id (variable-type variable)))))))

;*---------------------------------------------------------------------*/
;*    variable-type->string ...                                        */
;*---------------------------------------------------------------------*/
(define (variable-type->string variable)
   (string-downcase (symbol->string (type-id (variable-type variable)))))
