/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/

typedef enum {
  OPF_IF, OPF_ANYOP, OPF_MANYOP, OPF_ANYOPM, OPF_MANYOPM, 
  OPF_MIDDLE, OPF_MMIDDLE, OPF_MIDDLEM, OPF_MMIDDLEM,
  OPF_BMIDDLE, OPF_BMMIDDLE, 
  OPF_BMIDDLEM, OPF_BMMIDDLEM, 
  OPF_SELECT, OPF_MAP, 
  OPF_MSELECT, OPF_MMAP
  } opFormKind;

typedef union {
  int middle;
  ltoken anyop;
  ltoken id;
} opFormUnion;

typedef struct _opFormNode {
  ltoken tok;        /* keeps the openSym token */
  opFormKind kind;
  opFormUnion content;
  unsigned int key;
  ltoken close;      /* keeps the closeSym token */
} *opFormNode;

extern /*@unused@*/ /*@only@*/ cstring 
  opFormNode_unparse (/*@null@*/ opFormNode p_n) /*@*/ ;
