#!/bin/sh
# The default path should be /usr/local

# Get some info from configure
# chmod +x ./scripts/setsomevars

machine=@MACHINE_TYPE@
system=@SYSTEM_TYPE@
version=@VERSION@
export machine system version
PWD=`pwd` 

# Save temporary distribution here (must be full path) 
TMP=/tmp

#make

# This should really be integrated with automake and not duplicate the
# installation list.

BASE=$TMP/my_dist
mkdir $BASE $BASE/bin $BASE/data $BASE/data/mysql $BASE/data/test \
 $BASE/include $BASE/lib $BASE/perl \
 $BASE/share $BASE/share/mysql $BASE/tests $BASE/scripts $BASE/bench

for i in sql/ChangeLog \ PUBLIC README INSTALL-SOURCE INSTALL-SOURCE-GENERIC \
 Docs/manual.html Docs/manual.txt Docs/manual_toc.html
do
  cp -p $i $BASE
done

for i in extra/comp_err client/mysql sql/mysqld client/mysqlshow \
 extra/replace isam/isamchk client/mysqladmin client/mysqldump \
 extra/perror
do
  cp -p $i $BASE/bin
done

cp -p config.h include/* $BASE/include
rm $BASE/include/Makefile*; rm $BASE/include/*.in

cp -p tests/*.res tests/*.tst tests/*.pl $BASE/tests
cp -p data/mysql/*.frm $BASE/data/mysql 
cp -r -p client/libmysqlclient.a mysys/libmysys.a strings/libmystrings.a dbug/libdbug.a $BASE/lib
cd perl; cp -r -p . $BASE/perl; rm -f Makefile */Makefile */*/Makefile ; cd ..
sh -c "cd $BASE/perl ; make clean > /dev/null 2>&1"
cp -r -p sql/share/* $BASE/share/mysql; rm -f $BASE/share/mysql/Makefile* $BASE/share/mysql/*/*.OLD

cp -p scripts/* $BASE/bin
rm -f $BASE/bin/Makefile* $BASE/bin/*.in $BASE/bin/*.sh $BASE/bin/mysql_install_db $BASE/bin/make_binary_distribution $BASE/bin/setsomevars
$BASE/bin/replace \@localstatedir\@ ./data \@bindir\@ ./bin \@scriptdir\@ ./bin \@libexecdir\@ ./bin < $PWD/scripts/mysql_install_db.sh > $BASE/scripts/mysql_install_db
chmod a+x $BASE/bin/* $BASE/scripts/*

cp -r -p bench/* $BASE/bench
rm -f $BASE/bench/*.sh $BASE/bench/Makefile*

# hack for installation at TCX where perl is /my/gnu/bin/perl5
$BASE/bin/replace /my/gnu/bin/perl5 /usr/bin/perl /my/gnu/bin /usr/bin -- $BASE/scripts/* $BASE/bench/* $BASE/tests/* $BASE/perl/Makefile $BASE/perl/*/Makefile $BASE/perl/*/*/Makefile $BASE/perl/Mysql-modules/*/*.t $BASE/perl/Mysql-modules/*/*/*.t $BASE/perl/Mysql-modules/blib/script/* $BASE/DBI/README $BASE/bin/zap $BASE/bin/mysqlaccess > /dev/null 2>&1

# Change the distribution to a long descreptive name
NEW_NAME=mysql-$version-$system-$machine
BASE2=$TMP/$NEW_NAME
rm -rf $BASE2
mv $BASE $BASE2
BASE=$BASE2
#
# If we are compiling with gcc, copy libgcc.a to the distribution as libmygcc.a
#

if test "@GXX@" = "yes"
then
  cd $BASE/lib
  gcclib=`@CC@ --print-libgcc-file`
  if test $? -ne 0
  then
    print "Warning: Couldn't find libgcc.a!"
  else
    cp -p $gcclib libmygcc.a
  fi
  cd $PWD
fi

#
# this is needed to prefere gnu tar instead of tar because tar can't always
# handle long filenames
#

PATH_DIRS=`echo $PATH | sed -e 's/^:/. /' -e 's/:$/ ./' -e 's/::/ . /g' -e 's/:/ /g' `
which_1 ()
{
  for cmd
  do
    for d in $PATH_DIRS
    do
      for file in $d/$cmd
      do
	if test -x $file -a ! -d $file
	then
	  echo $file
	  exit 0
	fi
      done
    done
  done
  exit 1
}

#
# Create the result tar file
#

tar=`which_1 gtar`
if test "$?" = "1" -o "$tar" = ""
then
  tar=tar
fi

echo "Using $tar to create archive"
cd $TMP
$tar cvf $PWD/$NEW_NAME.tar $NEW_NAME
cd $PWD
echo "Compressing archive"
gzip -9 $NEW_NAME.tar
mv $NEW_NAME.tar.gz $NEW_NAME.tgz
echo "Removing temporary directory"
rm -rf $BASE

echo "$NEW_NAME.tgz created"
