(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         *)
(*                                                                     *)
(*  Copyright 1996 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* $Id: tbl.ml,v 1.7 1997/02/04 08:03:29 weis Exp $ *)

type ('a, 'b) t =
    Empty
  | Node of ('a, 'b) t * 'a * 'b * ('a, 'b) t * int

let empty = Empty

let height = function
    Empty -> 0
  | Node(_,_,_,_,h) -> h

let create l x d r =
  let hl = height l and hr = height r in
  Node(l, x, d, r, (if hl >= hr then hl + 1 else hr + 1))

let bal l x d r =
  let hl = height l and hr = height r in
  if hl > hr + 1 then
    let (Node(ll, lv, ld, lr, _)) = l in
    if height ll >= height lr then
      create ll lv ld (create lr x d r)
    else
      let (Node(lrl, lrv, lrd, lrr, _)) = lr in
      create (create ll lv ld lrl) lrv lrd (create lrr x d r)
  else if hr > hl + 1 then
    let (Node(rl, rv, rd, rr, _)) = r in
    if height rr >= height rl then
      create (create l x d rl) rv rd rr
    else
      let (Node(rll, rlv, rld, rlr, _)) = rl in
      create (create l x d rll) rlv rld (create rlr rv rd rr)
  else
    create l x d r

let rec add x data = function
    Empty ->
      Node(Empty, x, data, Empty, 1)
  | Node(l, v, d, r, h) as t ->
      let c = compare x v in
      if c = 0 then
        Node(l, x, data, r, h)
      else if c < 0 then
        bal (add x data l) v d r
      else
        bal l v d (add x data r)

let rec find x = function
    Empty ->
      raise Not_found
  | Node(l, v, d, r, _) ->
      let c = compare x v in
      if c = 0 then d
      else find x (if c < 0 then l else r)

let rec merge t1 t2 =
  match (t1, t2) with
    (Empty, t) -> t
  | (t, Empty) -> t
  | (Node(l1, v1, d1, r1, h1), Node(l2, v2, d2, r2, h2)) ->
      bal l1 v1 d1 (bal (merge r1 l2) v2 d2 r2)

let rec remove x = function
    Empty ->
      Empty
  | Node(l, v, d, r, h) as t ->
      let c = compare x v in
      if c = 0 then
        merge l r
      else if c < 0 then
        bal (remove x l) v d r
      else
        bal l v d (remove x r)

let rec iter f = function
    Empty -> ()
  | Node(l, v, d, r, _) ->
      iter f l; f v d; iter f r

open Format

let print print_key print_data tbl =
  open_hvbox 2;
  print_string "[[";
  iter (fun k d ->
          open_box 2;
          print_key k; print_string " ->"; print_space();
          print_data d; print_string ";";
          close_box(); print_space())
        tbl;
  print_string "]]";
  close_box()
