#include <stdio.h>
#include <stdlib.h>
#include "chess.h"
#include "evaluate.h"
  
   char           version[6];

   FILE           *input_stream;
   FILE           *book_file;
   FILE           *books_file;
   FILE           *history_file;
   FILE           *log_file;
   FILE           *auto_file;
   FILE           *book_lrn_file;
   FILE           *position_file;
   FILE           *position_lrn_file;
   int            log_id;
   int            EGTBlimit;
   char           whisper_text[500];
   int            whisper_value;
   int            whisper_depth;

   int            total_moves;
   int            last_mate_score;
   int            burp;
   int            time_abort;
   int            auto232;
   int            auto232_delay;
   signed char    abort_search;

   char           log_filename[64];
   char           history_filename[64];

   int            number_of_solutions;
   int            solutions[10];
   int            solution_type;
   char           book_path[128];
   char           log_path[128];
   char           tb_path[128];
   char           cmd_buffer[512];
   char           *args[32];
   char           buffer[512];
   int            nargs;
   int            move_number;
   int            wtm;
   int            iteration_depth;
   int            last_search_value;
   int            previous_search_value;
   int            search_failed_high;
   int            search_failed_low;
   int            largest_positional_score;
   int            root_alpha;
   int            root_beta;
   int            root_value;
   int            root_wtm;
   int            root_move;
   int            root_total_white_pieces;
   int            root_total_white_pawns;
   int            root_total_black_pieces;
   int            root_total_black_pawns;
   int            nodes_per_second;
   int            cpu_percent;

   int            tb_probes;
   int            tb_probes_successful;

   char           hint[16];
   int            easy_move;
   TIME_TYPE      time_type;
   int            time_limit;
   int            absolute_time_limit;
   int            search_time_limit;
   int            nodes_between_time_checks;
   int            next_time_check;

   int            ponder;
   int            ponder_move;
   int            made_predicted_move;
   int            ponder_moves[220];
   int            num_ponder_moves;

   unsigned int   opponent_start_time, opponent_end_time;
   unsigned int   program_start_time, program_end_time;
   unsigned int   start_time, end_time;
   unsigned int   elapsed_start, elapsed_end;
   unsigned int   nodes_searched;
   unsigned int   evaluations;
   int            transposition_probes;
   int            transposition_hits;
   int            pawn_probes;
   int            pawn_hits;
   int            check_extensions_done;
   int            recapture_extensions_done;
   int            passed_pawn_extensions_done;
   int            one_reply_extensions_done;

   int            book_move;
   int            book_accept_mask;
   int            book_reject_mask;
   int            book_random;
   int            book_search_trigger;
   int            book_selection_width;
   int            learning;
   int            book_learn_eval[LEARN_INTERVAL];
   int            book_learn_depth[LEARN_INTERVAL];

   int            tc_moves;
   int            tc_time;
   int            tc_time_remaining;
   int            tc_time_remaining_opponent;
   int            tc_moves_remaining;
   int            tc_secondary_moves;
   int            tc_secondary_time;

   int            log_hash;
   int            log_pawn_hash;
   int            hash_table_size;
   int            pawn_hash_table_size;

   int            hash_maska;
   int            hash_maskb;
   unsigned int   pawn_hash_mask;
   HASH_ENTRY      *trans_ref_wa;
   HASH_ENTRY      *trans_ref_wb;
   HASH_ENTRY      *trans_ref_ba;
   HASH_ENTRY      *trans_ref_bb;
   PAWN_HASH_ENTRY *pawn_hash_table;

   int            hash_move[MAXPLY];
   int            history_w[4096], history_b[4096];
   int            killer_move1[MAXPLY];
   int            killer_move2[MAXPLY];
   int            killer_count1[MAXPLY];
   int            killer_count2[MAXPLY];
   BITBOARD       replist_w[50+MAXPLY/2];
   BITBOARD       replist_b[50+MAXPLY/2];
   BITBOARD       *rephead_w;
   BITBOARD       *rephead_b;

   int            unblocked_pawns[9];
   int            p_values[15];
   int            current_move[MAXPLY];
   int            *last[MAXPLY];
   signed char    in_check[MAXPLY];
   signed char    extended_reason[MAXPLY];
   signed char    current_phase[MAXPLY];
   int            move_list[5120];
   int            sort_value[256];
   signed char    searched_this_root_move[256];
   unsigned int   root_nodes[256];
   CHESS_PATH     pv[MAXPLY];
   CHESS_PATH     last_pv;
   int            last_value;
   NEXT_MOVE      next_status[MAXPLY];
   SEARCH_POSITION position[MAXPLY+2];
   BITBOARD       save_hash_key[MAXPLY+2];
   unsigned int   save_pawn_hash_key[MAXPLY+2];

   char           white_outpost[64];
   char           black_outpost[64];
   char           square_color[64];
   int            passed_pawn_value[8];
   int            supported_passer[8];
   int            reduced_material_passer[20];
   int            pawn_advance[8];
   int            outside_passed[128];
   int            pawn_value_w[64];
   int            pawn_value_b[64];
   int            knight_value_w[64];
   int            knight_value_b[64];
   int            bishop_value_w[64];
   int            bishop_value_b[64];
   int            rook_value_w[64];
   int            rook_value_b[64];
   int            queen_value_w[64];
   int            queen_value_b[64];
   int            king_value_w[64];
   int            king_value_b[64];
   char           king_defects_w[64];
   char           king_defects_b[64];

   int            b_n_mate_dark_squares[64];
   int            b_n_mate_light_squares[64];
   int            mate[64];

   char           push_extensions[64];

   signed char    directions[64][64];
   BITBOARD       w_pawn_attacks[64];
   BITBOARD       b_pawn_attacks[64];
   BITBOARD       knight_attacks[64];
   BITBOARD       bishop_attacks[64];
#if defined(COMPACT_ATTACKS)
  /* Stuff these into a structure to make the addressing slightly cheaper */
  struct at {
    unsigned char which_attack[8][64];
    BITBOARD      file_attack_bitboards[8][MAX_ATTACKS_FROM_SQUARE];
    unsigned char rank_attack_bitboards[8][MAX_ATTACKS_FROM_SQUARE];
    unsigned char length8_mobility[8][MAX_ATTACKS_FROM_SQUARE];
    unsigned char short_mobility[NSHORT_MOBILITY];
  } at;

  BITBOARD       diag_attack_bitboards[NDIAG_ATTACKS];
  BITBOARD       anti_diag_attack_bitboards[NDIAG_ATTACKS];
  DIAG_INFO      diag_info[64];
#else
  BITBOARD       bishop_attacks_rl45[64][256];
  BITBOARD       bishop_attacks_rr45[64][256];
  int            bishop_mobility_rl45[64][256];
  int            bishop_mobility_rr45[64][256];
#endif
  BITBOARD       rook_attacks[64];
#if !defined(COMPACT_ATTACKS)
  BITBOARD       rook_attacks_r0[64][256];
  BITBOARD       rook_attacks_rl90[64][256];
  int            rook_mobility_r0[64][256];
  int            rook_mobility_rl90[64][256];
#endif

   CHESS_POSITION search;
   CHESS_POSITION display;

   BITBOARD       queen_attacks[64];
   BITBOARD       king_attacks[64];
   BITBOARD       king_attacks_1[64];
   BITBOARD       king_attacks_2[64];
   BITBOARD       obstructed[64][64];

   unsigned int   w_pawn_random32[64];
   unsigned int   b_pawn_random32[64];
   BITBOARD       w_pawn_random[64];
   BITBOARD       b_pawn_random[64];
   BITBOARD       w_knight_random[64];
   BITBOARD       b_knight_random[64];
   BITBOARD       w_bishop_random[64];
   BITBOARD       b_bishop_random[64];
   BITBOARD       w_rook_random[64];
   BITBOARD       b_rook_random[64];
   BITBOARD       w_queen_random[64];
   BITBOARD       b_queen_random[64];
   BITBOARD       w_king_random[64];
   BITBOARD       b_king_random[64];
   BITBOARD       enpassant_random[65];
   BITBOARD       castle_random_w[2];
   BITBOARD       castle_random_b[2];
   BITBOARD       wtm_random[2];
   BITBOARD       endgame_random_w;
   BITBOARD       endgame_random_b;
   BITBOARD       w_rooks_random;
   BITBOARD       b_rooks_random;

   BITBOARD       threat_flag;
   BITBOARD       clear_mask[65];
   BITBOARD       clear_mask_rl45[65];
   BITBOARD       clear_mask_rr45[65];
   BITBOARD       clear_mask_rl90[65];
   BITBOARD       set_mask[65];
   BITBOARD       set_mask_rl45[65];
   BITBOARD       set_mask_rr45[65];
   BITBOARD       set_mask_rl90[65];
   BITBOARD       file_mask[8];
   BITBOARD       rank_mask[8];
   BITBOARD       mask_not_rank8;
   BITBOARD       mask_not_rank1;
   BITBOARD       right_side_mask[8];
   BITBOARD       left_side_mask[8];
   BITBOARD       right_side_empty_mask[8];
   BITBOARD       left_side_empty_mask[8];
   BITBOARD       right_half_mask, left_half_mask;
   BITBOARD       mask_abs7_w, mask_abs7_b;
   BITBOARD       pawns_cramp_black;
   BITBOARD       pawns_cramp_white;
   BITBOARD       mask_advance_2_w;
   BITBOARD       mask_advance_2_b;
   BITBOARD       mask_left_edge;
   BITBOARD       mask_right_edge;
   BITBOARD       mask_corner_squares;
   BITBOARD       promote_mask_w;
   BITBOARD       promote_mask_b;
   BITBOARD       mask_G2G3;
   BITBOARD       mask_B2B3;
   BITBOARD       mask_G6G7;
   BITBOARD       mask_B6B7;
   BITBOARD       mask_F3H3;
   BITBOARD       mask_F6H6;
   BITBOARD       mask_A3C3;
   BITBOARD       mask_A6C6;
   BITBOARD       mask_A7H7;
   BITBOARD       mask_A2H2;
   BITBOARD       center;

   BITBOARD       stonewall_white;
   BITBOARD       stonewall_black;

   BITBOARD       mask_kr_trapped_w[3];
   BITBOARD       mask_qr_trapped_w[3];
   BITBOARD       mask_kr_trapped_b[3];
   BITBOARD       mask_qr_trapped_b[3];

   BITBOARD       good_bishop_kw;
   BITBOARD       good_bishop_qw;
   BITBOARD       good_bishop_kb;
   BITBOARD       good_bishop_qb;

   BITBOARD       light_squares;
   BITBOARD       dark_squares;
   BITBOARD       not_rook_pawns;

   BITBOARD       plus1dir[65];
   BITBOARD       plus7dir[65];
   BITBOARD       plus8dir[65];
   BITBOARD       plus9dir[65];
   BITBOARD       minus1dir[65];
   BITBOARD       minus7dir[65];
   BITBOARD       minus8dir[65];
   BITBOARD       minus9dir[65];

   BITBOARD       mask_eptest[64];
#  if !defined(CRAY1)
     BITBOARD       mask_1;
     BITBOARD       mask_2;
     BITBOARD       mask_3;
     BITBOARD       mask_4;
     BITBOARD       mask_8;
     BITBOARD       mask_16;
     BITBOARD       mask_32;
     BITBOARD       mask_72;
     BITBOARD       mask_80;
     BITBOARD       mask_85;
     BITBOARD       mask_96;
     BITBOARD       mask_107;
     BITBOARD       mask_108;
     BITBOARD       mask_112;
     BITBOARD       mask_118;
     BITBOARD       mask_120;
     BITBOARD       mask_121;
     BITBOARD       mask_127;
#  endif
   BITBOARD       mask_clear_entry;

#  if !defined(CRAY1)
     unsigned char  first_ones[65536];
     unsigned char  last_ones[65536];
#  endif
   unsigned char  first_ones_8bit[256];
   unsigned char  last_ones_8bit[256];
   unsigned char  connected_passed[256];

   BITBOARD       mask_kingside_attack_w1;
   BITBOARD       mask_kingside_attack_w2;
   BITBOARD       mask_kingside_attack_b1;
   BITBOARD       mask_kingside_attack_b2;
   BITBOARD       mask_queenside_attack_w1;
   BITBOARD       mask_queenside_attack_w2;
   BITBOARD       mask_queenside_attack_b1;
   BITBOARD       mask_queenside_attack_b2;

   BITBOARD       mask_pawn_protected_b[64];
   BITBOARD       mask_pawn_protected_w[64];
   BITBOARD       mask_pawn_isolated[64];
   BITBOARD       mask_pawn_passed_w[64];
   BITBOARD       mask_pawn_passed_b[64];
   BITBOARD       mask_promotion_threat_w[64];
   BITBOARD       mask_promotion_threat_b[64];
   BITBOARD       mask_pawn_connected[64];
   BITBOARD       mask_no_pawn_attacks_w[64];
   BITBOARD       mask_no_pawn_attacks_b[64];
   BITBOARD       mask_a1_corner;
   BITBOARD       mask_a8_corner;
   BITBOARD       mask_h1_corner;
   BITBOARD       mask_h8_corner;
   BITBOARD       white_minor_pieces;
   BITBOARD       black_minor_pieces;
   BITBOARD       white_center_pawns;
   BITBOARD       black_center_pawns;
   BITBOARD       white_pawn_race_wtm[64];
   BITBOARD       white_pawn_race_btm[64];
   BITBOARD       black_pawn_race_wtm[64];
   BITBOARD       black_pawn_race_btm[64];

   BITBOARD       mask_wk_4th, mask_wq_4th, mask_bk_4th, mask_bq_4th;
   BITBOARD       mask_wk_5th, mask_wq_5th, mask_bk_5th, mask_bq_5th;
   BOOK_POSITION  book_buffer[BOOK_CLUSTER_SIZE];

# define    VERSION                             "14.11"
  char      version[6] =                    {VERSION};

  PLAYING_MODE mode =                     normal_mode;

  int       batch_mode =                            0; /* no asynch reads */
  int       call_flag =                             0;
  int       crafty_rating =                      2500;
  int       opponent_rating =                    2500;
  char      pgn_event[32] = {"Private Match"};
  char      pgn_site[32] = {"Birmingham, AL"};
  char      pgn_date[32] = {"????.??.??"};
  char      pgn_round[32] = {"1"};
  char      pgn_white[64] = {"unknown"};
  char      pgn_white_elo[32] = {""};
  char      pgn_black[64] = {"Crafty " VERSION};
  char      pgn_black_elo[32] = {""};
  char      pgn_result[32] = {"*"};

  int       number_of_specials =                    1;

  char      special_list[100][20] = {
                                      {"mercilous"}};

  int       number_auto_kibitzers =                 9;

  char      auto_kibitz_list[100][20] = {
                                      {"diepx"},
                                      {"ferret"},
                                      {"knightc"},
                                      {"knightcap"},
                                      {"nowx"},
                                      {"otter"},
                                      {"rajah"},
                                      {"tcb"},
                                      {"zarkovx"}};
  

  int       number_of_computers =                  83;
  char      computer_list[100][20] = {
                                      {"abner"},
                                      {"afisher"},
                                      {"aragorn"},
                                      {"babyblue"},
                                      {"ban"},
                                      {"bigblue"},
                                      {"bikerbabe"},
                                      {"bobbyfischer"},
                                      {"bountyhunter"},
                                      {"braincan"},
                                      {"brause"},
                                      {"carokann"},
                                      {"chameleon"},
                                      {"chesskid"},
                                      {"chesst"},
                                      {"chessica"},
                                      {"chesscomputer"},
                                      {"chinook"},
                                      {"crazyknight"},
                                      {"cstal-x"},
                                      {"deep-modem"},
                                      {"deepviolet"},
                                      {"diep"},
                                      {"diepx"},
                                      {"destroyer"},
                                      {"doctorwho"},
                                      {"dominator"},
                                      {"dustbin"},
                                      {"ego-crusher"},
                                      {"ferret"},
                                      {"fitter"},
                                      {"fritzpentium"},
                                      {"futuregm"},
                                      {"gammaray"},
                                      {"gazaboy"},
                                      {"gballa"},
                                      {"gnusurf"},
                                      {"hiarcs"},
                                      {"kerrigan"},
                                      {"knightc"},
                                      {"knightcap"},
                                      {"kingtwoft"},
                                      {"killerchess"},
                                      {"killergrob"},
                                      {"klamath"},
                                      {"lightpurple"},
                                      {"lonnie"},
                                      {"lynnett"},
                                      {"mchesspro"},
                                      {"mephistoiii"},
                                      {"netsurfer"},
                                      {"norpico"},
                                      {"nowx"},
                                      {"otter"},
                                      {"pecabale"},
                                      {"phibs"},
                                      {"rajah"},
                                      {"ratbert"},
                                      {"rdx"},
                                      {"rebel"},
                                      {"rebel8"},
                                      {"robocop"},
                                      {"roborvl"},
                                      {"selectric"},
                                      {"shredder"},
                                      {"silmaril"},
                                      {"spectronic"},
                                      {"stobor"},
                                      {"stuspar"},
                                      {"tcb"},
                                      {"theextreme"},
                                      {"tingle"},
                                      {"turbocrafty"},
                                      {"turbogm"},
                                      {"ultragnu"},
                                      {"viktor2000"},
                                      {"virtualmachine"},
                                      {"wchess"},
                                      {"wchessx"},
                                      {"wheeler"},
                                      {"whoknows"},
                                      {"zarkovx"},
                                      {"zuntsu"}};

  int       number_of_GMs =                        27;
  char      GM_list[100][20] =       {
                                      {"anat"},
                                      {"badviking"},
                                      {"devin"},
                                      {"cleaner"},
                                      {"dgurevich"},
                                      {"dlugy"},
                                      {"flamingskull"},
                                      {"gum"},
                                      {"gmsoffer"},
                                      {"junior"},
                                      {"kaidanov"},
                                      {"kc"},
                                      {"kevlar"},
                                      {"kingloek"},
                                      {"kudrin"},
                                      {"logofet"},
                                      {"lombardy"},
                                      {"mohegan"},
                                      {"pnin"},
                                      {"psakhis"},
                                      {"roman"},
                                      {"sagalchik"},
                                      {"securitron"},
                                      {"smirin"},
                                      {"stefansson"},
                                      {"silvester"},
                                      {"wbrowne"}};

  int       number_of_IMs =                        11;
  char      IM_list[100][20] =       {
                                      {"adolf"},
                                      {"badviking"},
                                      {"bandora"},
                                      {"imorlov"},
                                      {"impolzin"},
                                      {"laflair"},
                                      {"lsokol"},
                                      {"oed"},
                                      {"thutters"},
                                      {"thumpster"},
                                      {"tim"}};

  int       ics =                                   0;
  int       output_format =                         0;
  int       EGTBlimit =                             5;
  int       xboard =                                0;
  int       whisper =                               0;
  int       channel =                               0;
  int       early_exit =                           99;
  int       new_game =                              0;
  char      channel_title[32] =                  {""};
#if defined(MACOS)
  char      book_path[128] =                {BOOKDIR};
  char      log_path[128] =                  {LOGDIR};
  char      tb_path[128] =                    {TBDIR};
#else
  char      book_path[128] =                    {"."};
  char      log_path[128] =                     {"."};
  char      tb_path[128] =                   {"./TB"};
#endif
  int       initialized =                           0;
  int       kibitz =                                0;
  int       post =                                  0;
  int       log_id =                                1;
  int       move_number =                           1;
  int       wtm =                                   1;
  int       crafty_is_white =                       0;
  int       last_opponent_move =                    0;
  int       largest_positional_score =            100;
  int       search_depth =                          0;
  int       search_move =                           0;
  TIME_TYPE time_type =                       elapsed;
  int       nodes_between_time_checks =         10000;
  int       nodes_per_second =                  10000;
  int       predicted =                             0;

  int       time_used =                             0;
  int       time_used_opponent =                    0;
  int       auto_kibitzing =                        0;
  signed char transposition_id =                    0;

  int       opening =                               1;
  int       middle_game =                           0;
  int       end_game =                              0;
  signed char thinking =                            0;
  signed char pondering =                           0;
  signed char puzzling =                            0;
  signed char booking =                             0;
  int       analyze_mode =                          0;
  int       annotate_mode =                         0;
  int       test_mode =                             0;
  int       analyze_move_read =                     0;
  signed char resign =                              5;
  signed char resign_counter =                      0;
  signed char resign_count =                        5;
  signed char draw_counter =                        0;
  signed char draw_count =                         10;
  int       tc_moves =                             60;
  int       tc_time =                          180000;
  int       tc_time_remaining =                180000;
  int       tc_time_remaining_opponent =       180000;
  int       tc_moves_remaining =                   60;
  int       tc_secondary_moves =                   30;
  int       tc_secondary_time =                 90000;
  int       tc_increment =                          0;
  int       tc_sudden_death =                       0;
  int       tc_operator_time =                      0;
  int       tc_safety_margin =                      0;
  int       time_limit =                          100;
  int       force =                                 0;
  char      initial_position[80] =               {""};
  int       over =                                  0;
  int       no_tricks =                             1;
  int       computer_opponent =                     0;
  int       usage_level =                           0;
  char      audible_alarm =                      0x07;
#if defined(MACOS)
  int       ansi =                                  0;
#else
  int       ansi =                                  1;
#endif
  int       book_accept_mask =                    ~03;
  int       book_reject_mask =                      3;
  int       book_random =                           3;
  int       book_search_trigger =                  20;
  int       learning =                              3;
  int       moves_out_of_book =                     0;
  int       show_book =                             0;
  int       book_selection_width =                  5;
  int       ponder =                                1;
  int       trace_level =                           0;
  int       display_options =                    4095;
  unsigned int noise_level =                    10000;
 
  int       hash_table_size =                    8192;
  int       log_hash =                             13;
  int       pawn_hash_table_size =               4096;
  int       log_pawn_hash =                        12;

  int       default_draw_score =                 DRAW;

  int       passed_pawn_value[8] = { 0,
                                     PAWN_PASSED*2, PAWN_PASSED*3,
                                     PAWN_PASSED*4, PAWN_PASSED*6,
                                     PAWN_PASSED*9, PAWN_PASSED*12,
                                     0};

  int       supported_passer[8] =  { 0,
                                     PAWN_SUPPORTED_PASSED_RANK2,
                                     PAWN_SUPPORTED_PASSED_RANK3,
                                     PAWN_SUPPORTED_PASSED_RANK4,
                                     PAWN_SUPPORTED_PASSED_RANK5,
                                     PAWN_SUPPORTED_PASSED_RANK6,
                                     PAWN_SUPPORTED_PASSED_RANK7,
                                     0};

  int       reduced_material_passer[20] = { 10,10,9,9,8,8,7,7,6,6,
                                             5,5,4,4,3,3,2,2,1,1};

  int       outside_passed[128] = { 50, 48, 46, 44, 42, 40, 38, 36,
                                    34, 32, 30, 28, 26, 24, 22, 20,
                                    18, 17, 16, 15, 14, 13, 12, 11,
                                    10,  9,  8,  7,  6,  5,  4,  3,
                                     1,  1,  1,  1,  1,  1,  1,  1,
                                     1,  1,  1,  1,  1,  1,  1,  1,
                                     1,  1,  1,  1,  1,  1,  1,  1,
                                     1,  1,  1,  1,  1,  1,  1,  1,
                                     1,  1,  1,  1,  1,  1,  1,  1,
                                     1,  1,  1,  1,  1,  1,  1,  1,
                                     1,  1,  1,  1,  1,  1,  1,  1,
                                     1,  1,  1,  1,  1,  1,  1,  1,
                                     1,  1,  1,  1,  1,  1,  1,  1,
                                     1,  1,  1,  1,  1,  1,  1,  1,
                                     1,  1,  1,  1,  1,  1,  1,  1,
                                     1,  1,  1,  1,  1,  1,  1,  1};

  char      square_color[64]  = { 1, 0, 1, 0, 1, 0, 1, 0,
                                  0, 1, 0, 1, 0, 1, 0, 1,
                                  1, 0, 1, 0, 1, 0, 1, 0,
                                  0, 1, 0, 1, 0, 1, 0, 1,
                                  1, 0, 1, 0, 1, 0, 1, 0,
                                  0, 1, 0, 1, 0, 1, 0, 1,
                                  1, 0, 1, 0, 1, 0, 1, 0,
                                  0, 1, 0, 1, 0, 1, 0, 1 };

  int       b_n_mate_dark_squares[64] = 
                             { 20, 15, 10,  5, -5,-10,-15,-20,
                               15, 15, 10,  5, -5,-10,-15,-15,
                               10, 10, 10,  5, -5,-10,-10,-10,
                                5,  5,  5,  5, -5, -5, -5, -5,
                               -5, -5, -5, -5,  5,  5,  5,  5,
                              -10,-10,-10, -5,  5, 10, 10, 10,
                              -15,-15,-10, -5,  5, 10, 15, 15,
                              -20,-15,-10, -5,  5, 10, 15, 20};

  int       b_n_mate_light_squares[64] =
                             {-20,-15,-10, -5,  5, 10, 15, 20,
                              -15,-15,-10, -5,  5, 10, 15, 15,
                              -10,-10,-10, -5,  5, 10, 10, 10,
                               -5, -5, -5, -5,  5,  5,  5,  5,
                                5,  5,  5,  5, -5, -5, -5, -5,
                               10, 10, 10,  5, -5,-10,-10,-10,
                               15, 15, 10,  5, -5,-10,-15,-15,
                               20, 15, 10,  5, -5,-10,-15,-20};

  int       mate[64] =        {28, 26, 24, 22, 22, 24, 26, 28,
                               26, 16, 14, 12, 12, 14, 16, 26,
                               24, 14,  4,  2,  2,  4, 14, 24,
                               22, 12,  2,  0,  0,  2, 12, 22,
                               22, 12,  2,  0,  0,  2, 12, 22,
                               24, 14,  4,  2,  2,  4, 14, 24,
                               26, 16, 14, 12, 12, 14, 16, 26,
                               28, 26, 24, 22, 22, 24, 26, 28};

  char            white_outpost[64] = { 0, 0, 0, 0, 0, 0, 0, 0,
                                        0, 0, 0, 0, 0, 0, 0, 0,
                                        0, 0, 0, 0, 0, 0, 0, 0,
                                        0, 0, 0, 2, 2, 0, 0, 0,
                                        0, 0, 4, 5, 5, 4, 0, 0,
                                        0, 0, 3, 6, 6, 3, 0, 0,
                                        0, 0, 0, 1, 1, 0, 0, 0,
                                        0, 0, 0, 0, 0, 0, 0, 0 };

  char            black_outpost[64] = { 0, 0, 0, 0, 0, 0, 0, 0,
                                        0, 0, 0, 1, 1, 0, 0, 0,
                                        0, 0, 3, 6, 6, 3, 0, 0,
                                        0, 0, 4, 5, 5, 4, 0, 0,
                                        0, 0, 0, 2, 2, 0, 0, 0,
                                        0, 0, 0, 0, 0, 0, 0, 0,
                                        0, 0, 0, 0, 0, 0, 0, 0,
                                        0, 0, 0, 0, 0, 0, 0, 0 };

  char           push_extensions[64] = { 0, 0, 0, 0, 0, 0, 0, 0,
                                         1, 1, 1, 1, 1, 1, 1, 1,
                                         0, 0, 0, 0, 0, 0, 0, 0,
                                         0, 0, 0, 0, 0, 0, 0, 0,
                                         0, 0, 0, 0, 0, 0, 0, 0,
                                         0, 0, 0, 0, 0, 0, 0, 0,
                                         1, 1, 1, 1, 1, 1, 1, 1,
                                         0, 0, 0, 0, 0, 0, 0, 0 };

  int    pawn_value_b[64] = { 0,  0,  0,  0,  0,  0,  0,  0,
                              0,  0,  0,  0,  0,  0,  0,  0,
                              0,  0,  3,  3,  3,  3,  0,  0,
                              0,  0,  3,  3,  3,  3,  0,  0,
                              0,  0,  0,  3,  3,  0,  0,  0,
                              0,  0,  0,  0,  0,  0,  0,  0,
                              0,  0,  0,  0,  0,  0,  0,  0,
                              0,  0,  0,  0,  0,  0,  0,  0};

  int    pawn_value_w[64] = { 0,  0,  0,  0,  0,  0,  0,  0,
                              0,  0,  0,  0,  0,  0,  0,  0,
                              0,  0,  0,  0,  0,  0,  0,  0,
                              0,  0,  0,  3,  3,  0,  0,  0,
                              0,  0,  3,  3,  3,  3,  0,  0,
                              0,  0,  3,  3,  3,  3,  0,  0,
                              0,  0,  0,  0,  0,  0,  0,  0,
                              0,  0,  0,  0,  0,  0,  0,  0};

  int  knight_value_w[64] = { -9, -3, -3, -2, -2, -3, -3,  -9,
                              -5, -3, -1,  0,  0, -1, -3,  -5,
                              -6,  0,  1,  1,  1,  1,  0,  -6,
                              -5,  0,  1,  2,  2,  1,  0,  -5,
                              -5,  0,  1,  2,  2,  1,  0,  -5,
                              -5,  0,  1,  1,  1,  1,  0,  -5,
                              -5,  0,  0,  0,  0,  0,  0,  -5,
                             -33, -5, -5, -5, -5, -5, -5, -33};

  int  knight_value_b[64] ={ -33, -5, -5, -5, -5, -5, -5, -33,
                              -5,  0,  0,  0,  0,  0,  0,  -5,
                              -5,  0,  1,  1,  1,  1,  0,  -5,
                              -5,  0,  1,  2,  2,  1,  0,  -5,
                              -5,  0,  1,  2,  2,  1,  0,  -5,
                              -6,  0,  1,  1,  1,  1,  0,  -6,
                              -5, -3, -1,  0,  0, -1, -3,  -5,
                              -9, -3, -3, -2, -2, -3, -3,  -9};

  int  bishop_value_w[64] = { -3, -3, -3, -3, -3, -3, -3, -3,
                              -3,  0,  0,  0,  0,  0,  0, -3,
                              -3,  0,  2,  2,  2,  2,  0, -2,
                              -3,  0,  2,  3,  3,  2,  0, -3,
                              -3,  0,  2,  3,  3,  2,  0, -3,
                              -3,  0,  2,  2,  2,  2,  0, -3,
                              -3,  0,  0,  0,  0,  0,  0, -3,
                              -3, -3, -3, -3, -3, -3, -3, -3};

  int  bishop_value_b[64] = { -3, -3, -3, -3, -3, -3, -3, -3,
                              -3,  0,  0,  0,  0,  0,  0, -3,
                              -3,  0,  2,  2,  2,  2,  0, -3,
                              -3,  0,  2,  3,  3,  2,  0, -3,
                              -3,  0,  2,  3,  3,  2,  0, -3,
                              -3,  0,  2,  2,  2,  2,  0, -3,
                              -3,  0,  0,  0,  0,  0,  0, -3,
                              -3, -3, -3, -3, -3, -3, -3, -3};
 
  int    rook_value_w[64] = {  0,  2,  3,  4,  4,  3,  2,  0,
                              -4,  2,  3,  4,  4,  3,  2, -4,
                              -4,  2,  3,  4,  4,  3,  2, -4,
                              -4,  2,  3,  4,  4,  3,  2, -4,
                               0,  2,  3,  4,  4,  3,  2,  0,
                               0,  2,  3,  4,  4,  3,  2,  0,
                               0,  2,  3,  4,  4,  3,  2,  0,
                               0,  2,  3,  4,  4,  3,  2,  0};

  int    rook_value_b[64] = {  0,  2,  3,  4,  4,  3,  2,  0,
                               0,  2,  3,  4,  4,  3,  2,  0,
                               0,  2,  3,  4,  4,  3,  2,  0,
                               0,  2,  3,  4,  4,  3,  2,  0,
                              -4,  2,  3,  4,  4,  3,  2, -4,
                              -4,  2,  3,  4,  4,  3,  2, -4,
                              -4,  2,  3,  4,  4,  3,  2, -4,
                               0,  2,  3,  4,  4,  3,  2,  0};

  int   queen_value_w[64] = {  0,  0,  0,  0,  0,  0,  0,  0,
                               0,  2,  2,  2,  2,  2,  2,  0,
                               0,  2,  4,  5,  5,  4,  2,  0,
                               0,  2,  4,  6,  6,  4,  2,  0,
                               0,  2,  4,  6,  6,  4,  2,  0,
                               0,  2,  4,  6,  6,  4,  2,  0,
                               0,  2,  4,  5,  5,  4,  2,  0,
                               0,  0,  0,  0,  0,  0,  0,  0};

  int   queen_value_b[64] = {  0,  0,  0,  0,  0,  0,  0,  0,
                               0,  2,  4,  5,  5,  4,  2,  0,
                               0,  2,  4,  6,  6,  4,  2,  0,
                               0,  2,  4,  6,  6,  4,  2,  0,
                               0,  2,  4,  6,  6,  4,  2,  0,
                               0,  2,  4,  5,  5,  4,  2,  0,
                               0,  2,  2,  2,  2,  2,  2,  0,
                               0,  0,  0,  0,  0,  0,  0,  0};

  int    king_value_w[64] = { -3,  0,  0,  0,  0,  0,  0, -3,
                               0,  0,  3,  3,  3,  3,  0,  0,
                               0,  3,  3,  5,  5,  3,  3,  0,
                               0,  3,  5,  8,  8,  5,  3,  0,
                               0,  3,  5,  8,  8,  5,  3,  0,
                               0,  3,  3,  5,  5,  3,  3,  0,
                               0,  0,  3,  3,  3,  3,  0,  0,
                              -3,  0,  0,  0,  0,  0,  0, -3};

  int    king_value_b[64] = { -3,  0,  0,  0,  0,  0,  0, -3,
                               0,  0,  3,  3,  3,  3,  0,  0,
                               0,  3,  3,  5,  5,  3,  3,  0,
                               0,  3,  5,  8,  8,  5,  3,  0,
                               0,  3,  5,  8,  8,  5,  3,  0,
                               0,  3,  3,  5,  5,  3,  3,  0,
                               0,  0,  3,  3,  3,  3,  0,  0,
                              -3,  0,  0,  0,  0,  0,  0, -3};

   char king_defects_w[64]= { 4, 2, 3, 4, 4, 2, 1, 2,
                              4, 3, 3, 7, 7, 3, 2, 2,
                              6, 4, 6, 7, 7, 6, 4, 6,
                              8, 5, 6, 8, 8, 6, 5, 8,
                              8, 5, 6, 8, 8, 6, 5, 8,
                              8, 5, 6, 8, 8, 6, 5, 8,
                              8, 5, 6, 8, 8, 6, 5, 8,
                              8, 5, 6, 8, 8, 6, 5, 8};

   char king_defects_b[64]= { 8, 5, 6, 8, 8, 6, 5, 8,
                              8, 5, 6, 8, 8, 6, 5, 8,
                              8, 5, 6, 8, 8, 6, 5, 8,
                              8, 5, 6, 8, 8, 6, 5, 8,
                              8, 5, 6, 8, 8, 6, 5, 8,
                              6, 4, 6, 7, 7, 6, 4, 6,
                              4, 3, 3, 7, 7, 3, 2, 2,
                              4, 2, 3, 4, 4, 2, 1, 2};

  int       p_values[15] =       {QUEEN_VALUE,ROOK_VALUE,BISHOP_VALUE,0,
                                  KING_VALUE,KNIGHT_VALUE,PAWN_VALUE,
                                  0,PAWN_VALUE,KNIGHT_VALUE,KING_VALUE,
                                  0, BISHOP_VALUE,ROOK_VALUE,QUEEN_VALUE};

  int       unblocked_pawns[9] = {-PAWN_UNBLOCKED*2,0,PAWN_UNBLOCKED,
                                   PAWN_UNBLOCKED*2, PAWN_UNBLOCKED*3,
                                   PAWN_UNBLOCKED*4, PAWN_UNBLOCKED*5,
                                   PAWN_UNBLOCKED*6, PAWN_UNBLOCKED*7};

#if !defined(COMPACT_ATTACKS)
  int            bishop_shift_rl45[64] = { 63, 61, 58, 54, 49, 43, 36, 28,
                                           61, 58, 54, 49, 43, 36, 28, 21,
                                           58, 54, 49, 43, 36, 28, 21, 15,
                                           54, 49, 43, 36, 28, 21, 15, 10,
                                           49, 43, 36, 28, 21, 15, 10,  6,
                                           43, 36, 28, 21, 15, 10,  6,  3,
                                           36, 28, 21, 15, 10,  6,  3,  1,
                                           28, 21, 15, 10,  6,  3,  1,  0 };

  int            bishop_shift_rr45[64] = { 28, 36, 43, 49, 54, 58, 61, 63,
                                           21, 28, 36, 43, 49, 54, 58, 61,
                                           15, 21, 28, 36, 43, 49, 54, 58,
                                           10, 15, 21, 28, 36, 43, 49, 54,
                                            6, 10, 15, 21, 28, 36, 43, 49,
                                            3,  6, 10, 15, 21, 28, 36, 43,
                                            1,  3,  6, 10, 15, 21, 28, 36,
                                            0,  1,  3,  6, 10, 15, 21, 28 };
#endif
