/***************************************************************************

Rally X memory map (preliminary)

0000-3fff ROM
8000-83ff Radar video RAM + other
8400-87ff video RAM
8800-8bff Radar color RAM + other
8c00-8fff color RAM
9800-9fff RAM

memory mapped ports:

read:
a000      IN0
a080      IN1
a100      DSW1

*
 * IN0 (all bits are inverted)
 * bit 7 : ?
 * bit 6 : START 1
 * bit 5 : UP player 1
 * bit 4 : DOWN player 1
 * bit 3 : RIGHT player 1
 * bit 2 : LEFT player 1
 * bit 1 : SMOKE player 1
 * bit 0 : CREDIT
 *
*
 * IN1 (all bits are inverted)
 * bit 7 : ?
 * bit 6 : START 2
 * bit 5 : UP player 2 (TABLE only)
 * bit 4 : DOWN player 2 (TABLE only)
 * bit 3 : RIGHT player 2 (TABLE only)
 * bit 2 : LEFT player 2 (TABLE only)
 * bit 1 : SMOKE player 2 (TABLE only)
 * bit 0 : COCKTAIL or UPRIGHT cabinet 1 = UPRIGHT
 *
*
 * DSW1 (all bits are inverted)
 * bit 7 :\ 00 = free play      01 = 2 coins 1 play
 * bit 6 :/ 10 = 1 coin 2 play  11 = 1 coin 1 play
 * bit 5 :\ xxx = cars,rank:
 * bit 4 :| 000 = 2,A  001 = 3,A  010 = 1,B  011 = 2,B
 * bit 3 :/ 100 = 3,B  101 = 1,C  110 = 2,C  111 = 3,C
 * bit 2 :  0 = bonus at 10(1 car)/15(2 cars)/20(3 cars)  1 = bonus at 30/40/60
 * bit 1 :  1 = bonus at xxx points  0 = no bonus
 * bit 0 :  TEST
 *

write:
8014-801f sprites - 6 pairs: code (including flipping) and X position
8814-881f sprites - 6 pairs: Y position and color
8034-880c radar car indicators x position
8834-883c radar car indicators y position
a004-a00c radar car indicators color and x position MSB
a080      watchdog reset?
a105      sound voice 1 waveform (nibble)
a111-a113 sound voice 1 frequency (nibble)
a115      sound voice 1 volume (nibble)
a10a      sound voice 2 waveform (nibble)
a116-a118 sound voice 2 frequency (nibble)
a11a      sound voice 2 volume (nibble)
a10f      sound voice 3 waveform (nibble)
a11b-a11d sound voice 3 frequency (nibble)
a11f      sound voice 3 volume (nibble)
a130      virtual screen X scroll position
a140      virtual screen Y scroll position
a170      ? this is written to A LOT of times every frame
a180      explosion sound trigger
a181      interrupt enable
a182-a183 ?
a184      1 player start lamp
a185      2 players start lamp
a186      ?

I/O ports:
OUT on port $0 sets the interrupt vector/instruction (the game uses both
IM 2 and IM 0)

***************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"


void pengo_sound_w(int offset,int data);
int rallyx_sh_start(void);
void pengo_sh_update(void);
extern unsigned char *pengo_soundregs;

extern unsigned char *rallyx_videoram2,*rallyx_colorram2;
extern unsigned char *rallyx_radarcarx,*rallyx_radarcary,*rallyx_radarcarcolor;
extern unsigned char *rallyx_scrollx,*rallyx_scrolly;
void rallyx_videoram2_w(int offset,int data);
void rallyx_colorram2_w(int offset,int data);
void rallyx_vh_convert_color_prom(unsigned char *palette, unsigned char *colortable,const unsigned char *color_prom);
int rallyx_vh_start(void);
void rallyx_vh_stop(void);
void rallyx_vh_screenrefresh(struct osd_bitmap *bitmap);


static void rallyx_play_sound_w(int offset, int data)
{
        static int counter=0;

	if (play_sound == 0 || Machine->samples->sample[0] == 0)
		return;

        if (data == 0 && counter > 0)
        {
          osd_play_sample(4,Machine->samples->sample[0]->data,
                          Machine->samples->sample[0]->length,
                          Machine->samples->sample[0]->smpfreq,
                          Machine->samples->sample[0]->volume,0);
        }
        counter = data;
}

static struct MemoryReadAddress readmem[] =
{
	{ 0x8000, 0x8fff, MRA_RAM },
	{ 0x9800, 0x9fff, MRA_RAM },
	{ 0x0000, 0x3fff, MRA_ROM },
	{ 0xa000, 0xa000, input_port_0_r },	/* IN0 */
	{ 0xa080, 0xa080, input_port_1_r },	/* IN1 */
	{ 0xa100, 0xa100, input_port_2_r },	/* DSW1 */
	{ -1 }	/* end of table */
};

static struct MemoryWriteAddress writemem[] =
{
	{ 0x8000, 0x83ff, videoram_w, &videoram, &videoram_size },
	{ 0x8400, 0x87ff, rallyx_videoram2_w, &rallyx_videoram2 },
	{ 0x8800, 0x8bff, colorram_w, &colorram },
	{ 0x8c00, 0x8fff, rallyx_colorram2_w, &rallyx_colorram2 },
	{ 0x9800, 0x9fff, MWA_RAM },
	{ 0xa080, 0xa080, MWA_NOP },
	{ 0xa130, 0xa130, MWA_RAM, &rallyx_scrollx },
	{ 0xa140, 0xa140, MWA_RAM, &rallyx_scrolly },
	{ 0xa004, 0xa00c, MWA_RAM, &rallyx_radarcarcolor },
	{ 0xa100, 0xa11f, pengo_sound_w, &pengo_soundregs },
	{ 0xa170, 0xa170, MWA_NOP },	/* ????? */
	{ 0xa180, 0xa180, rallyx_play_sound_w },
	{ 0xa181, 0xa181, interrupt_enable_w },
	{ 0xa182, 0xa183, MWA_NOP },
	{ 0xa184, 0xa185, osd_led_w },
	{ 0xa186, 0xa186, MWA_NOP },
	{ 0x0000, 0x3fff, MWA_ROM },
	{ 0x8014, 0x801f, MWA_RAM, &spriteram },	/* these are here just to initialize */
	{ 0x8814, 0x881f, MWA_RAM, &spriteram_2 },	/* the pointers. */
	{ 0x8034, 0x803c, MWA_RAM, &rallyx_radarcarx },	/* ditto */
	{ 0x8834, 0x883c, MWA_RAM, &rallyx_radarcary },
	{ -1 }	/* end of table */
};

static struct IOWritePort writeport[] =
{
	{ 0, 0, interrupt_vector_w },
	{ -1 }	/* end of table */
};



static struct InputPort input_ports[] =
{
	{	/* IN0 */
		0xff,
		{ OSD_KEY_3, OSD_KEY_LCONTROL, OSD_KEY_LEFT, OSD_KEY_RIGHT,
				OSD_KEY_DOWN, OSD_KEY_UP, OSD_KEY_1, 0 },
		{ 0, OSD_JOY_FIRE, OSD_JOY_LEFT, OSD_JOY_RIGHT,
				OSD_JOY_DOWN, OSD_JOY_UP, 0, 0 }
	},
	{	/* IN1 */
		0xff,
		{ 0, 0, 0, 0, 0, 0, OSD_KEY_2, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{	/* DSW1 */
		0xcb,
		{ OSD_KEY_F2, 0, 0, 0, 0, 0, 0, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ -1 }	/* end of table */
};

static struct TrakPort trak_ports[] =
{
        { -1 }
};

static struct KEYSet keys[] =
{
        { 0, 5, "MOVE UP" },
        { 0, 2, "MOVE LEFT"  },
        { 0, 3, "MOVE RIGHT" },
        { 0, 4, "MOVE DOWN" },
        { 0, 1, "SMOKE" },
        { -1 }
};


static struct DSW dsw[] =
{
	{ 2, 0x38, "DIFFICULTY", { "2 CARS, RANK A", "3 CARS, RANK A", "1 CAR , RANK B", "2 CARS, RANK B",
			"3 CARS, RANK B", "1 CAR , RANK C", "2 CARS, RANK C", "3 CARS, RANK C" } },
	{ 2, 0x02, "BONUS", { "OFF", "ON" } },
	{ 2, 0x04, "BONUS SCORE", { "LOW", "HIGH" } },
	{ -1 }
};



static struct GfxLayout charlayout =
{
	8,8,	/* 8*8 characters */
	256,	/* 256 characters */
	2,	/* 2 bits per pixel */
	{ 0, 4 },	/* the two bitplanes for 4 pixels are packed into one byte */
	{ 8*8+0, 8*8+1, 8*8+2, 8*8+3, 0, 1, 2, 3 },	/* bits are packed in groups of four */
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	16*8	/* every char takes 16 bytes */
};
static struct GfxLayout spritelayout =
{
	16,16,	/* 16*16 sprites */
	64,	/* 64 sprites */
	2,	/* 2 bits per pixel */
	{ 0, 4 },	/* the two bitplanes for 4 pixels are packed into one byte */
	{ 8*8+0, 8*8+1, 8*8+2, 8*8+3, 16*8+0, 16*8+1, 16*8+2, 16*8+3,	/* bits are packed in groups of four */
			 24*8+0, 24*8+1, 24*8+2, 24*8+3, 0, 1, 2, 3 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8,
			32*8, 33*8, 34*8, 35*8, 36*8, 37*8, 38*8, 39*8 },
	64*8	/* every sprite takes 64 bytes */
};
static struct GfxLayout radardotlayout =
{
	/* there is no gfx ROM for this one, it is generated by the hardware */
	2,2,	/* 2*2 square */
	1,	/* just one */
	1,	/* 1 bit per pixel */
	{ 0 },
	{ 0, 0 },	/* I "know" that this bit is 1 */
	{ 0, 0 },	/* I "know" that this bit is 1 */
	0	/* no use */
};



static struct GfxDecodeInfo gfxdecodeinfo[] =
{
	{ 1, 0x0000, &charlayout,        0, 64 },
	{ 1, 0x0000, &spritelayout,      0, 64 },
	{ 1, 0x0000, &radardotlayout, 64*4, 4 },
	{ -1 } /* end of array */
};



static unsigned char rallyx_color_prom[] =
{
	/* palette - might be wrong, I had to change the first two bytes from FF to 00 */
	0x00,0x00,0x06,0x3F,0x5A,0xF1,0x15,0x18,0x66,0xD1,0x2A,0x03,0xA4,0x91,0xBF,0xF6,
	0x00,0x07,0xF6,0x00,0x00,0x07,0xF6,0x00,0x00,0x07,0xF6,0x00,0x00,0x07,0xF6,0xF6,
	/* lookup table - this is NOT the original one, it's from New Rally X */
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF9,0xFE,0xF1,0xF0,0xF2,0xF5,0xF1,0xF0,0xFC,0xF8,0xF0,
	0xF0,0xF3,0xF8,0xF2,0xF0,0xF3,0xF8,0xFE,0xF0,0xF2,0xF8,0xF0,0xF8,0xF2,0xF2,0xF2,
	0xF8,0xFF,0xFF,0xFF,0xF8,0xFB,0xF9,0xFF,0xF8,0xFB,0xFF,0xF2,0xF0,0xF2,0xF3,0xF7,
	0xF0,0xF7,0xF3,0xFA,0xF0,0xFA,0xF8,0xF5,0xF0,0xF6,0xF8,0xF5,0xF0,0xF4,0xF8,0xF5,
	0xF0,0xFC,0xF8,0xF5,0xF0,0xF7,0xF3,0xFA,0xF0,0xFE,0xF2,0xF4,0xF0,0xF3,0xFF,0xFA,
	0xF0,0xF3,0xFC,0xF7,0xF0,0xFB,0xF8,0xF7,0xF0,0xF3,0xF8,0xF2,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF8,0xF0,0xF0,0xFF,0xF8,0xF0,0xF0,0xF2,0xF0,0xFD,0xF3,0xF4,
	0xF0,0xFD,0xF9,0xFE,0xF0,0xF0,0xF0,0xF0,0xF0,0xFF,0xFF,0xFF,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF3,0xF0,0xF0,0xF0,0xF0,0xF3,0xF3,0xF0,0xF0,0xF0,0xF3,0xF0,0xFE,0xF2,0xFC,
	0xF0,0xF9,0xF0,0xF0,0xF0,0xF0,0xF9,0xF9,0xF0,0xF0,0xF0,0xF9,0xF0,0xF2,0xF0,0xF0,
	0xF0,0xF0,0xF2,0xF2,0xF0,0xF0,0xF0,0xF2,0xF0,0xF0,0xF0,0xF6,0xF0,0xF2,0xF2,0xF2,
	0xF5,0xF0,0xF0,0xF0,0xF5,0xF0,0xF0,0xF2,0xF5,0xF0,0xF0,0xF3,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
};

static unsigned char nrallyx_color_prom[] =
{
	/* palette */
	0x00,0x00,0x07,0x3F,0x1F,0x80,0xE0,0x18,0x67,0xD1,0x87,0x04,0x69,0x91,0xBF,0xF6,
	0x00,0x07,0xF6,0x00,0x00,0x07,0xF6,0x00,0x00,0x07,0xF6,0x00,0x00,0x07,0xF6,0x00,
	/* lookup table */
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF9,0xFE,0xF1,0xF0,0xF2,0xF5,0xF1,0xF0,0xFC,0xF8,0xF0,
	0xF0,0xF3,0xF8,0xF2,0xF0,0xF3,0xF8,0xFE,0xF0,0xF2,0xF8,0xF0,0xF8,0xF2,0xF2,0xF2,
	0xF8,0xFF,0xFF,0xFF,0xF8,0xFB,0xF9,0xFF,0xF8,0xFB,0xFF,0xF2,0xF0,0xF2,0xF3,0xF7,
	0xF0,0xF7,0xF3,0xFA,0xF0,0xFA,0xF8,0xF5,0xF0,0xF6,0xF8,0xF5,0xF0,0xF4,0xF8,0xF5,
	0xF0,0xFC,0xF8,0xF5,0xF0,0xF7,0xF3,0xFA,0xF0,0xFE,0xF2,0xF4,0xF0,0xF3,0xFF,0xFA,
	0xF0,0xF3,0xFC,0xF7,0xF0,0xFB,0xF8,0xF7,0xF0,0xF3,0xF8,0xF2,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF8,0xF0,0xF0,0xFF,0xF8,0xF0,0xF0,0xF2,0xF0,0xFD,0xF3,0xF4,
	0xF0,0xFD,0xF9,0xFE,0xF0,0xF0,0xF0,0xF0,0xF0,0xFF,0xFF,0xFF,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF3,0xF0,0xF0,0xF0,0xF0,0xF3,0xF3,0xF0,0xF0,0xF0,0xF3,0xF0,0xFE,0xF2,0xFC,
	0xF0,0xF9,0xF0,0xF0,0xF0,0xF0,0xF9,0xF9,0xF0,0xF0,0xF0,0xF9,0xF0,0xF2,0xF0,0xF0,
	0xF0,0xF0,0xF2,0xF2,0xF0,0xF0,0xF0,0xF2,0xF0,0xF0,0xF0,0xF6,0xF0,0xF2,0xF2,0xF2,
	0xF5,0xF0,0xF0,0xF0,0xF5,0xF0,0xF0,0xF2,0xF5,0xF0,0xF0,0xF3,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
};



/* waveforms for the audio hardware */
/* these are from New Rally X, hopefully they are correct for Rally X as well */
static unsigned char samples[8*32] =
{
	0x00,0x00,0x00,0x00,0x00,0x77,0x77,0x00,0x00,0x88,0x88,0x88,0x00,0x00,0x00,0x00,
	0x77,0x77,0x77,0x00,0x88,0x88,0x00,0x00,0x00,0x00,0x77,0x77,0x00,0x00,0x88,0x88,
	0x00,0x00,0x00,0x88,0x00,0x77,0x77,0x77,0x00,0x00,0x00,0x88,0x00,0x00,0x00,0x88,
	0x88,0x88,0x88,0x00,0x88,0x88,0x00,0x00,0x00,0x00,0x88,0x88,0x88,0x00,0x88,0x88,
	0x00,0x00,0x77,0x00,0x00,0x00,0x77,0x00,0x00,0x88,0x88,0x88,0x00,0x77,0x00,0x00,
	0x77,0x00,0x00,0x88,0x88,0x88,0x00,0x77,0x00,0x00,0x00,0x77,0x00,0x88,0x88,0x88,
	0x00,0x00,0x00,0x88,0x00,0x00,0x77,0x77,0x88,0x88,0x00,0x00,0x00,0x77,0x77,0x77,
	0x88,0x00,0x00,0x88,0x77,0x77,0x00,0x00,0x00,0x00,0x77,0x00,0x88,0x88,0x88,0x00,
	0x77,0x88,0x77,0x88,0x77,0x88,0x77,0x88,0x77,0x88,0x77,0x88,0x77,0x88,0x77,0x88,
	0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
	0x99,0xaa,0xbb,0xcc,0xdd,0xee,0xff,0x00,0x11,0x22,0x33,0x44,0x55,0x66,0x77,0x77,
	0x66,0x55,0x44,0x33,0x22,0x11,0x00,0xff,0xee,0xdd,0xcc,0xbb,0xaa,0x99,0x88,0x88,
	0x99,0x99,0xaa,0xaa,0xbb,0xbb,0xcc,0xcc,0xdd,0xdd,0xee,0xee,0xff,0xff,0x00,0x00,
	0x11,0x11,0x22,0x22,0x33,0x33,0x44,0x44,0x55,0x55,0x66,0x66,0x77,0x77,0x88,0x88,
	0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
	0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88

#if 0
	0xF8,0xF8,0xF8,0xF8,0xF8,0xFF,0xFF,0xF8,0xF8,0xF0,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,
	0xFF,0xFF,0xFF,0xF8,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xFF,0xFF,0xF8,0xF8,0xF0,0xF0,
	0xF8,0xF8,0xF8,0xF0,0xF8,0xFF,0xFF,0xFF,0xF8,0xF8,0xF8,0xF0,0xF8,0xF8,0xF8,0xF0,
	0xF0,0xF0,0xF0,0xF8,0xF0,0xF0,0xF8,0xF8,0xF8,0xF8,0xF0,0xF0,0xF0,0xF8,0xF0,0xF0,
	0xF8,0xF8,0xFF,0xF8,0xF8,0xF8,0xFF,0xF8,0xF8,0xF0,0xF0,0xF0,0xF8,0xFF,0xF8,0xF8,
	0xFF,0xF8,0xF8,0xF0,0xF0,0xF0,0xF8,0xFF,0xF8,0xF8,0xF8,0xFF,0xF8,0xF0,0xF0,0xF0,
	0xF8,0xF8,0xF8,0xF0,0xF8,0xF8,0xFF,0xFF,0xF0,0xF0,0xF8,0xF8,0xF8,0xFF,0xFF,0xFF,
	0xF0,0xF8,0xF8,0xF0,0xFF,0xFF,0xF8,0xF8,0xF8,0xF8,0xFF,0xF8,0xF0,0xF0,0xF0,0xF8,
	0xFF,0xF0,0xFF,0xF0,0xFF,0xF0,0xFF,0xF0,0xFF,0xF0,0xFF,0xF0,0xFF,0xF0,0xFF,0xF0,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
	0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF,0xFF,
	0xFE,0xFD,0xFC,0xFB,0xFA,0xF9,0xF8,0xF7,0xF6,0xF5,0xF4,0xF3,0xF2,0xF1,0xF0,0xF0,
	0xF1,0xF1,0xF2,0xF2,0xF3,0xF3,0xF4,0xF4,0xF5,0xF5,0xF6,0xF6,0xF7,0xF7,0xF8,0xF8,
	0xF9,0xF9,0xFA,0xFA,0xFB,0xFB,0xFC,0xFC,0xFD,0xFD,0xFE,0xFE,0xFF,0xFF,0xF0,0xF0,
	0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
	0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0
#endif
};



static struct MachineDriver machine_driver =
{
	/* basic machine hardware */
	{
		{
			CPU_Z80,
			3072000,	/* 3.072 Mhz ? */
			0,
			readmem,writemem,0,writeport,
			interrupt,1
		}
	},
	60,
	1,	/* single CPU, no need for interleaving */
	0,

	/* video hardware */
	36*8, 28*8, { 0*8, 36*8-1, 0*8, 28*8-1 },
	gfxdecodeinfo,
	32,64*4+4*2,
	rallyx_vh_convert_color_prom,

	VIDEO_TYPE_RASTER,
	0,
	rallyx_vh_start,
	rallyx_vh_stop,
	rallyx_vh_screenrefresh,

	/* sound hardware */
	samples,
	0,
	rallyx_sh_start,
	0,
	pengo_sh_update
};



/***************************************************************************

  Game driver(s)

***************************************************************************/

ROM_START( rallyx_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "rallyx.1b", 0x0000, 0x1000, 0xbea90675 )
	ROM_LOAD( "rallyx.1e", 0x1000, 0x1000, 0xe4021276 )
	ROM_LOAD( "rallyx.1h", 0x2000, 0x1000, 0x429161ad )
	ROM_LOAD( "rallyx.1k", 0x3000, 0x1000, 0x8551812b )

	ROM_REGION(0x1000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "rallyx.8e", 0x0000, 0x1000, 0xd007b15b )
ROM_END

ROM_START( nrallyx_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "nrallyx.1b", 0x0000, 0x1000, 0x23704378 )
	ROM_LOAD( "nrallyx.1e", 0x1000, 0x1000, 0xd037b01f )
	ROM_LOAD( "nrallyx.1h", 0x2000, 0x1000, 0x2f558f09 )
	ROM_LOAD( "nrallyx.1k", 0x3000, 0x1000, 0xa37e7abe )

	ROM_REGION(0x1000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "nrallyx.8e", 0x0000, 0x1000, 0xe47b6ec7 )
ROM_END



static const char *rallyx_sample_names[] =
{
	"BANG.SAM",
	0	/* end of array */
};



static int hiload(void)     /* V.V */
{
	/* check if the hi score table has already been initialized */
	if (memcmp(&RAM[0x8060],"\x00\x00\x00\x30\x40\x40\x40\x02",8) == 0)
	{
		void *f;

		if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,0)) != 0)
		{
			osd_fread(f,&RAM[0x08060],8);
			osd_fclose(f);
		}

		return 1;
	}
	else return 0;   /* we can't load the hi scores yet */

}


static void hisave(void)    /* V.V */
{
	void *f;

	if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,1)) != 0)
	{
		osd_fwrite(f,&RAM[0x08060],8);
		osd_fclose(f);
	}
}



struct GameDriver rallyx_driver =
{
	"Rally X",
	"rallyx",
	"Nicola Salmoria (MAME driver)\nMirko Buffoni (bang sound)\nValerio Verrando (high score save)",
	&machine_driver,

	rallyx_rom,
	0, 0,
	rallyx_sample_names,

	input_ports, 0, trak_ports, dsw, keys,

	rallyx_color_prom, 0, 0,
	ORIENTATION_DEFAULT,

	hiload, hisave
};

struct GameDriver nrallyx_driver =
{
	"New Rally X",
	"nrallyx",
	"Nicola Salmoria (MAME driver)\nMirko Buffoni (bang sound)\nValerio Verrando (high score save)",
	&machine_driver,

	nrallyx_rom,
	0, 0,
	rallyx_sample_names,

	input_ports, 0, trak_ports, dsw, keys,

	nrallyx_color_prom, 0, 0,
	ORIENTATION_DEFAULT,

	hiload, hisave
};
