/* this file is a part of amp software, (C) tomislav uzelac 1996,1997

	Origional code by: tomislav uzelac
	Modified by:
	* Dan Nelson - BSD mods.
	* Andrew Richards - moved code from audio.c and added mixer support etc

 */

/* Support for Linux and BSD sound devices */

#include "amp.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include "audioIO.h"

/* declare these static to effectively isolate the audio device */

static int audio_fd;

/* audioOpen() */
/* should open the audio device, perform any special initialization		 */
/* Set the frequency, no of channels and volume. Volume is only set if */
/* it is not -1 */

void
audioOpen(int frequency, int stereo, int volume)
{
    audio_fd = STDOUT_FILENO;

    fflush(stdout);
    fprintf(stdout,"CTH channels: %d\n", stereo ? 2 : 1);
    fprintf(stdout,"CTH speed: %d\n", frequency);
    fprintf(stdout,"CTH format: %s\n", "S16_LE");
    fprintf(stdout,"CTH start\n");
    fflush(stdout);
}


/* audioSetVolume - only code this if your system can change the volume while */
/* playing. sets the output volume 0-100 */

void
audioSetVolume(int volume)
{
}


/* audioClose() */
/* should close the audio device and perform any special shutdown */

void
audioClose()
{
}


/* audioWrite */
/* writes count bytes from buffer to the audio device */
/* returns the number of bytes actually written */

inline int
audioWrite(char *buffer, int count)
{
	DB(audio, msg("audio: Writing %d bytes to audio descriptor %d\n",count,getAudioFd()) );
	return(write(audio_fd,buffer,count));
}


/* Let buffer.c have the audio descriptor so it can select on it. This means	*/
/* that the program is dependent on an file descriptor to work. Should really */
/* move the select's etc (with inlines of course) in here so that this is the */
/* ONLY file which has hardware dependent audio stuff in it										*/

int
getAudioFd()
{
	return(audio_fd);
}
