#include "cthugha.h"
#include "options.h"
#include "action.h"

#include <stdio.h>
#include <dirent.h>
#include <string.h>
#include <unistd.h>

int double_load = 0;			/* allow double loading */
int options_save = 0;			/* save options (and buffer) at end */

/*****************************************************************************/
void load_quiet_strings(char * fname) {

    FILE * file;
    char * s;
	
    if ( (fname == NULL) || (*fname == '\0'))
	return;
	
    if( (file = fopen(fname, "r")) == NULL) {
	printfee("Can't open quiet-strings-file %s", fname);
	return;
    }

    nr_silence_strings = 0;		
    do {
	/* read a line */
	s = fgets(silence_strings[nr_silence_strings], 255, file);	
	if ( s != NULL)
	    nr_silence_strings ++;
    } while ( (nr_silence_strings < MAX_SILENCE_STRINGS) && (s != NULL) );

    /* check if file was empty */
    if ( nr_silence_strings == 0) {
	nr_silence_strings = 1;
	strcpy( silence_strings[0], "Where is the musc?");
    }
}

/*****************************************************************************/

/*
 * general load-function
 */

static int is_compressed(const char * name) {
    int l = strlen(name);
    if ( l < 3)
	return 0;
    if ((name[l-3] == '.') && 
	(name[l-2] == 'g') && 
	(name[l-1] == 'z') )
	return 1;
    return 0;
}

static int has_extension(const char * name, const char * extension) {
    char * pos = strstr(name, extension);
    if ( pos == NULL)
	return 0;

    /* check if extension is at end of name, or is followed by a . */
    if ( (pos[strlen(extension)]=='\0') || (pos[strlen(extension)]=='.') ) 
	return 1;


    return 0;
}

feature_entry* load_feature(char * name, char * total_name, char * dir,		     
			    feature_entry* (* load_function)(FILE *, char *, char *)) {

    int compressed = is_compressed(total_name);
    FILE * file;
	    
    if ( compressed ) {	  
	/* open with 'gzip' - through pipe */
	char cmd[512];
	
	printfv(3,"uncompressing and ");
	
	sprintf(cmd, "gzip -cd %s", total_name);
	
	file = popen( cmd, "r");		
	
    } else {
	/* normal open - as file */
	file = fopen( total_name, "r");
    }
    
    printfv(3,"loading: %s", total_name);
    
    /* now do the loading */
    if ( file != NULL)  {
	feature_entry * entry;

	/* file was openen successfully  - now read it */
	if ( (entry = (*load_function)(file, name, dir)) != NULL) {
	    printfv(3," ... OK\n");
	}
	
	if ( compressed) 
	    pclose(file);	/* close pipe */
	else
	    fclose(file);	/* close file */

	return entry;

    } else {		/* file/pipe could not be opened */
	printfv(3," ... x\n");
	return NULL;
    }
}

static void load_dir(char * dir, char * extension, 
		     feature_entry* (* load_function)(FILE *, char *, char *),
		     feature * feat) {
    char total_name[255];
    char feat_name[255];
    DIR * directory;
    struct dirent * entry;
    feature_entry * fe;
    
    if ( (directory = opendir( dir )) != NULL) {	    
	while( (entry = readdir(directory))	 != NULL) {
	    if ( ! has_extension(entry->d_name, extension) ) 
		continue;
	    
	    /* create real filename */
	    strncpy( total_name, dir, 255);
	    strncat( total_name, entry->d_name, 255);
	    
	    printfv(3, "    ");

	    /* feature name only goes till first occurence of extension */
	    strncpy(feat_name, entry->d_name, 255);
	    *strstr(feat_name, extension) = '\0';
	    
	    if ( feature_defined(feat_name, feat) && !double_load) {
		printfv(3,"already loaded: %s\n", total_name);
		return;
	    }
	
	    if( (fe=load_feature(feat_name, total_name, dir, load_function)) != NULL)
		add_feature(feat, fe);

	}
	closedir(directory);
    }
}
	    

int load(char * search_path[], char * extra_path, char * extension, 
	 feature_entry* (* load_function)(FILE *, char *, char *),
	 feature * feat) {
    int path;
    char extra_path_dir[512];

    /* load normal search path */
    path = 0;
    while( search_path[path][0] != '\0') {
	load_dir(search_path[path], extension, load_function, feat);
	path ++;
    }
    /* load from extra path */
    if ( extra_lib_path[0] != '\0') {
	strncpy( extra_path_dir, extra_lib_path, 512);
	strncat( extra_path_dir, extra_path, 512);
	load_dir( extra_path_dir, extension, load_function, feat);
    }
    
    return 0;
}

