/*
    CTHUGHA-L								sound.h
	
    Funktions that deal with sound.
	
*/

#ifndef __SOUND_H__
#define __SOUND_H__

#include "cth_buffer.h"
#include "feature.h"

/* options for sound reading/writing */
typedef struct {
    int channels;
    int bps;
    int speed;
    int fragments;
} sound_opt;
extern sound_opt * sound_options;
extern sound_opt sound_options_init;


/* 
 *  General stuff
 */
int init_sound();
int exit_sound();
int alloc_sound();
int free_sound();

typedef char char2[2];
extern char2 * sound_data_unproc;
extern char2 * sound_data;			/* Stereo-Data */
extern int sound_bsize;
extern int sound_fork;				/* read in an extra process */

extern int sine[320];

typedef enum {
    sa_continue,
    sa_update
} sound_action_t;
extern sound_action_t * sound_action;

int sound_convert(unsigned char * data, int stereo, int bps);

/* 
 *  get-sound
 */
int get_sound();
extern int sound_minnoise;			/* quiet is below this */
extern int sound_quiet_change;			/* change after quiet-pause */
extern int sound_wait_quiet;			/* max. quiet interval */
extern int sound_firelevel;			/* level to change on beats */
extern int sound_wait;				/* time till change */
extern int sound_wait_beat;			/* peaks till change */
extern int sound_wait_random;			/* extra random time */
extern int sound_wait_min;			/* min time between change */
extern int sound_attack;			/* attack level */
extern int sound_fire;				/* fired noew */
extern int sound_amplitude;			/* sound amplitude (variance) */
void sound_random();
extern int sound_sync;				/* sync after reading sound */
int sound_read();
int sound_fork_process();
int sound_kill_process();

/* 
 *  sound-processing
 */
int massage_audio();				/* audio-processing 1 */
int change_massage_style(int to);
extern int sound_massage_style;			/* massage style */
extern int massage_first;			/* massage to start with */

extern int sound_flashlight;
extern int sound_use_flashlight;
int flashlight();
int change_flashlight(int to);

int FFT();					/* audio-processing 2 */
int change_FFT(int to);
extern int sound_FFT;				/* use FFT or don't */
extern int sound_use_fft;			/* allow fft-usage */



int init_sound_process();
int sound_noise_check();


/*
 * things for the mixer
 */
#if USE_MIXER == 1
extern char * mixer_names[];
extern int mixer_volumes[];
extern int mixer_nr_names;
extern int mixer_idx2dev[];
int mixer_set_volume(char * name, int volume);
#define MIXER_NAME(i)		(mixer_names[ mixer_idx2dev[i] ])
#define MIXER_VOL(i)		(mixer_volumes[ mixer_idx2dev[i] ])

int mixer_init_names();
int sound_set_mixer();
#endif

/*
 * functions and variables for reading from the different sound devices
 */
enum sound_dev_t {
    snddev_dsp_r = 0,
    snddev_dsp_w,
    snddev_mixer,
    snddev_cd,
    snddev_debug,
    snddev_sock,
    snddev_play,
    snddev_exec,
    snddev_max
};
extern int sound_use[snddev_max];
int sound_use_clear();


/* read sound from soundcard (DSP) */

int sound_dsp_init(int mode);
int sound_dsp_read(void);
int sound_dsp_write(unsigned char * buffer);
int sound_dsp_update(void);
int sound_dsp_exit(void);


/* generate random sound */
int sound_random_read(void);


/* reading via network */
int sound_net_init(void);
int net_request(int req);
int sound_net_read(void);
int sound_net_exit(void);	
extern char sound_hostname[256];


/* read sound from a file and play */
extern char sound_file_name[512];
int sound_play_init(void);
int sound_play_read(void);
int sound_play_exit(void);


/* start program and read data through pipe */
int sound_exec_init(void);
int sound_exec_read(void);
int sound_exec_exit(void);


#endif



