/* 
 *  sound-display (wave-functions)
 */
#ifndef __WAVES_H
#define __WAVES_H

extern feature waves;				/* possible wave-functions */
#define display_wave		((void (*)(void)) ( waves.entries[waves.current].data ) ) 
int select_wave();
extern char wave_first[256];			/* Start with this wave */
extern int wave_scale;

int init_tables();
int init_wave();
typedef unsigned char pal_table[256];		/* Table for display_wave */
#define MAX_TABLES	255			/* Max. nr. of tables */
extern pal_table tables[MAX_TABLES];		/* Palette-Tables */
extern int nr_tables;				/* number of tables */
extern int active_table;			/* active table */
extern int table_first;				/* table to start with */
int change_table(int to);
extern feature objects;
typedef int object[2][3];		/* a 3D object is a list of lines, each line
					 * is two 3-space points 1-X 2-Y 3-Z [line#][point#][coord#]
					 * the list is terminated by the final line having
					 * coordinates that are all -1 */
extern char object_first[256];
extern int use_objects;				/* use 3-D objects */


#endif
