/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgCombine.c                                                  */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:32 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Combine"
#define ERROR(e) imgError(e,PRGNAME)
#define ARG_ERROR(e,arg) imgArgError(e,arg,PRGNAME)

int main(int argc,char **argv)
{
  it_image *image;
  int file;

  IFHELP
    {
      fprintf(stderr,"img%s - Combine images from files to make a sequence\n",
	      PRGNAME);
      fprintf(stderr,"img%s file1 [file2 [...]]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: None\n");
      fprintf(stderr,"  stdout: Any\n");
      fprintf(stderr,"  file: Any\n");
      exit(0);
    }
  if(argc<2)
    ERROR("filename arguments required");

  imgStart(PRGNAME);
  for(file=1;file<argc;file++)
    {
      if((image=i_load_image(argv[file],-1,IT_ANY,IM_FRAGMENT))==NULL)
	ARG_ERROR("can't import %s",argv[file]);
      i_write_image_file(stdout,image,IF_BINARY);
      i_destroy_image(image);
    }
  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
