/*
 * Copyright(c) 1995,1996,1997 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *      
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: nntp.c,v 2.0 1997/09/23 15:56:20 gena Exp $
 */

#include <fmail.h>
#include <umail.h>

static char response[255];
static int nntpsock = -1;
FILE *nntp_in = NULL;
FILE *nntp_out = NULL;

int
nntp_command(fmt, a, b, c, d)
char   *fmt,
       *a,
       *b,
       *c,
       *d;
{
int res;
char buf[255];

 if (fmt) {
 (void)sprintf(response, fmt, a, b, c, d);

 if (logging & LOG_NNTP)	{
  if (!strncasecmp(response, "AUTHINFO PASS ", 14))
   display_msg(MSG_LOG, "nntp", "-> AUTHINFO PASS ******");
  else
   display_msg(MSG_LOG, "nntp", "-> %-.127s", response);
				}

 if (putline(response, nntp_out) == -1)
        return -1;
          }

 if (getline(response, sizeof(response), nntp_in) == NULL)
        return -1;

 if (logging & LOG_NNTP)
  display_msg(MSG_LOG, "nntp", "<- %-.127s", response);

 res = -1;
 sscanf(response, "%d%s", &res, buf);
 
 if (res == -1) {
        display_msg(MSG_WARN, "nntp", "%-.127s", response);
        return -1;
                }

 return res;
}

void
nntp_close()
{

 host_disconnect(&nntpsock);

 if (nntp_in != NULL)
        fclose(nntp_in);

 nntp_in = NULL;
 nntp_out = NULL;
}

void
nntp_end()
{
if (nntp_command("QUIT") != 205)
        display_msg(MSG_WARN, "nntp", "%-.127s", response);

nntp_close();
}

int 
nntp_init()
{
char buf[255];
int res, authusr = 0, authpass = 0;

 if (nntpsock != -1) {
        display_msg(MSG_WARN, "nntp", "NNTP busy");
        return -1;
                     }

 strcpy(buf, b_getcfg_str(conf_name, "nntphost", "news"));

 nntpsock = host_connect(buf, b_getcfg_str(conf_name, "nntport", "119"), NULL);
    
 if (nntpsock == -1)
        return -1;

 if ((nntp_in = fdopen(nntpsock, "r+")) == NULL) {
        display_msg(MSG_WARN, "nntp", "fdopen failed");
        nntp_close();
        return -1;				 }

 nntp_out = nntp_in;

 if (b_getcfg_int(conf_name, "nntpauth", 0))	{
   if ((strlen(b_getcfg_str(conf_name, "nntpasswd", "")) < 1) &&
	(b_getcfg_int(conf_name, "nntpstorpwd", 0) == 0))
	nntp_account();
   if (strlen(b_getcfg_str(conf_name, "nntpuser", user_n)))
	authusr = 1;
   authpass = 1;
						}

 switch (nntp_command(NULL))	{
  case 200:
  break;

  case 380:
  case 480:
	authusr = 1;
  break;

  case 381:
	authpass = 1;
  break;

  default:
        display_msg(MSG_WARN, "nntp", "%-.127s", response);
        nntp_close();
        return -1;
  break;
				}

nntp_user:
 if (authusr)	{
   if (strlen(b_getcfg_str(conf_name, "nntpuser", user_n)) == 0)
	nntp_account();
   switch (nntp_command("AUTHINFO USER %s", b_getcfg_str(conf_name, "nntpuser", user_n)))	{
    case 381:
	authpass = 1;
    break;

    case 281:
	authpass = 0;
    break;

    default:
        display_msg(MSG_WARN, "nntp", "%-.127s", response);
        nntp_close();
        return -1;
    break;
	}
		}

 if (authpass)	{
   if (strlen(b_getcfg_str(conf_name, "nntpasswd", "")) == 0)
	nntp_account();
   switch (nntp_command("AUTHINFO PASS %s", b_getcfg_str(conf_name, "nntpasswd", "")))	{
    case 281:
    break;

    case 482:
	authpass = 0;
	authusr = 1;
	goto nntp_user;
    break;

    default:
	nntp_account();
        if (nntp_command("AUTHINFO PASS %s", b_getcfg_str(conf_name, "nntpasswd", "")) != 281)	{
        display_msg(MSG_WARN, "nntp", "%-.127s", response);
        nntp_close();
        return -1;
		}
    break;
	}
		}

 if (((res = nntp_command("MODE READER")) != 200) &&
	(res != 500))	{
        display_msg(MSG_WARN, "nntp", "%-.127s", response);
        nntp_close();
        return -1;	}

 return 0;
}

int
nntp_send_message(msg)
struct _mail_msg *msg;
{
struct _head_field *hf;

 if (msg->header->News == NULL)
	return 0;

 if (nntp_init() == -1)
        return -1;

 if (nntp_command("POST") != 340) {
        display_msg(MSG_WARN, "nntp", "%-.127s", response);
        nntp_end();
        return -1;                }

 if ((hf = find_field(msg, "X-Mailer")) != NULL)
	strcpy(hf->f_name, "X-Newsreader");

 if (smtp_message(msg, nntp_out) == -1) {
        nntp_end();
	if (hf != NULL)
		strcpy(hf->f_name, "X-Mailer");
        return -1;                      }

 if (hf != NULL)
	strcpy(hf->f_name, "X-Mailer");

 if (nntp_command(".") != 240)  {
        display_msg(MSG_WARN, "nntp", "%-.127s", response);
        nntp_end();
        return -1;              }

 nntp_end();
 return 0;
}

int
is_newsgroup_addr(addr, strict)
struct _mail_addr *addr;
int strict;
{
char *p;

 if (addr->name || addr->comment || addr->pgpid)
	return 0;

 if (!strncmp(addr->addr, "#news.", 6))
	return 1;

 if (strict || !islower(*addr->addr))
	return 0;

 p = addr->addr + 1;
 while (*p)	{
  if (!islower(*p) && !isdigit(*p) &&
	(*p != '-') && (*p != '_') && (*p != '.'))
	return 0;

  if (*p == '.')	{
   if ((p[1] == '.') || (p[1] == '\0') || (p[-1] == '.'))
	return 0;	}

  p++;		}

 return 1;
}

struct _news_addr *
expand_news_addr_list(addr, strict)
struct _mail_addr *addr;
int strict;
{
struct _news_addr *ng, *naddr = NULL;

 while (addr)	{
   if (is_newsgroup_addr(addr, strict))	{
     if ((ng = get_news_addr(addr->addr)) != NULL) {
	ng->next = naddr;
	naddr = ng;
						   }
					}
   addr = addr->next_addr;
		}

 return naddr;
}

