/*
 * Copyright (c) 1989, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Ken Smith of The State University of New York at Buffalo.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Copyright(c) 1995,1996 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/*
 *	$Id: util.c,v 2.2 1997/12/09 16:36:08 gena Exp $
 */


#include <fmail.h>
#include <umail.h>
#ifdef __EMX__
#include <sys/types.h>
#endif

int	do_move (char *, char *);
int	fastcopy (char *, char *, struct stat *);

#ifndef	HAVE_UTIMES

#ifdef	HAVE_UTIME_H
#include <utime.h>
#endif

int utimes(char *file,struct timeval *tvp)
{
struct utimbuf tbuf;

    if (tvp == NULL ) 	{
#ifdef	HAVE_UTIME_NULL
        return(utime(file,NULL));
#else
	tbuf.actime = time(NULL);
	tbuf.modtime = time(NULL);
	return(utime(file,&tbuf));
#endif
			}

    tbuf.actime = tvp[0].tv_sec;
    tbuf.modtime = tvp[1].tv_sec;
    return(utime(file,&tbuf));
}
#endif

int
do_move(from, to)
	char *from, *to;
{
	struct stat sb;
	int st;

#ifdef __EMX__ /* Under OS/2 the file will not be deleted during rename() */
         if (access(to, 0)==0) { 
         	if (unlink(to)!=0) {
        		display_msg(MSG_WARN, "unlink", "delete %s before moving", to);
               	}
         }
#endif
	if (!rename(from, to))
		return (0);

	if (errno != EXDEV) {
		display_msg(MSG_WARN, "move", "rename %s to %s", from, to);
		return (1);
	}

	/*
	 * If rename fails because we're trying to cross devices, and
	 * it's a regular file, do the copy internally; otherwise, use
	 * cp and rm.
	 */
	if (stat(from, &sb)) {
		display_msg(MSG_WARN, "move", "%s", from);
		return (1);
	}

	if (!S_ISREG(sb.st_mode)) {
		display_msg(MSG_WARN, "move: not a regular file", "%s", from);
		return 1; }

	st = fastcopy(from, to, &sb);

	if (unlink(from)) {
		display_msg(MSG_WARN, "move", "%s: remove", from);
		return (1);
	}

	return st;
}

int
fastcopy(from, to, sbp)
	char *from, *to;
	struct stat *sbp;
{
	struct timeval tval[2];
	static u_int blen;
	static char *bp;
	register int nread, from_fd, to_fd;

	if ((from_fd = open(from, O_RDONLY, 0)) < 0) {
		display_msg(MSG_WARN, "fastcopy", "%s", from);
		return (1);
	}
	if ((to_fd =
	    open(to, O_CREAT | O_TRUNC | O_WRONLY, sbp->st_mode)) < 0) {
		display_msg(MSG_WARN, "fastcopy", "%s", to);
		(void)close(from_fd);
		return (1);
	}
#ifndef __EMX__
	if (!blen && !(bp = malloc(blen = sbp->st_blksize))) {
#else
	if (!blen && !(bp = malloc(blen = sbp->st_size))) {
#endif
		display_msg(MSG_WARN, "fastcopy", "");
		return (1);
	}
	while ((nread = read(from_fd, bp, blen)) > 0)
		if (write(to_fd, bp, nread) != nread) {
			display_msg(MSG_WARN, "fastcopy", "%s", to);
			goto err;
		}
	if (nread < 0) {
		display_msg(MSG_WARN, "fastcopy", "%s", from);
err:		if (unlink(to))
			display_msg(MSG_WARN, "fastcopy", "%s: remove", to);
		(void)close(from_fd);
		(void)close(to_fd);
		return (1);
	}
	(void)close(from_fd);

/*
	if (fchown(to_fd, sbp->st_uid, sbp->st_gid))
		display_msg(MSG_WARN, "fastcopy", "%s: set owner/group", to);
*/
#ifndef __EMX__
	fchown(to_fd, sbp->st_uid, sbp->st_gid);

	if (fchmod(to_fd, sbp->st_mode))
		display_msg(MSG_WARN, "fastcopy", "%s: set mode", to);

	tval[0].tv_sec = sbp->st_atime;
	tval[1].tv_sec = sbp->st_mtime;
	tval[0].tv_usec = tval[1].tv_usec = 0;
	if (utimes(to, tval))
		display_msg(MSG_WARN, "fastcopy", "%s: set times", to);
#endif

	if (close(to_fd)) {
		display_msg(MSG_WARN, "fastcopy", "%s", to);
		return (1);
	}

	return (0);
}

#ifndef	HAVE_UNSETENV
void
Unsetenv(name)
char *name;
{
int len;
char *cp, **p;

 if (!environ || !name)
	return;

 len = strlen(name);
 for (p = environ; (cp = *p) != NULL; ++p) {
  if (strncmp(cp, name, len) ||
	(cp[len] != '='))
	continue;

  for (;; ++p)
   if (!(*p = *(p + 1)))
	break;

  break;
					   }
}
#endif
