/*
 * Copyright(c) 1995,1996 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: view_edit.c,v 2.4 1997/12/17 14:56:58 gena Exp $
 */

#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include "configform.h"
#include "exit.xpm"

static FD_config_viewedit *edit_obj;
static FD_config_viewedit *view_obj;
int markincl, headcolor;

void View_EView_Call(FL_OBJECT *obj, long param)
{
}

void View_Wrap_Call(FL_OBJECT *obj, long param)
{
}

void View_Ext_Call(FL_OBJECT *obj, long param)
{
}

void Mark_HColor_Call(FL_OBJECT *obj, long param)
{
	headcolor = fl_show_colormap(FL_RED);
	fl_set_object_color(obj, headcolor, FL_BLACK);
}

void Mark_MColor_Call(FL_OBJECT *obj, long param)
{
	markincl = fl_show_colormap(FL_BLUE);
	fl_set_object_color(obj, markincl, FL_BLACK);
}

void Mark_Include_Call(FL_OBJECT *obj, long param)
{
  if (fl_get_button(obj))
	markincl = view_obj->View_MColor->col1;
  else
	markincl = 0;
}

void View_Header_Call(FL_OBJECT *obj, long param)
{
	headcolor = view_obj->View_HColor->col1;
}

void Edit_EEdit_Call(FL_OBJECT *obj, long param)
{
}

void Edit_Wrap_Call(FL_OBJECT *obj, long param)
{
}

void Edit_Keymap_Call(FL_OBJECT *obj, long param)
{
fl_deactivate_form(edit_obj->config_viewedit);
keymap_conf();
fl_activate_form(edit_obj->config_viewedit);
}

void Send_Confirm_Call(FL_OBJECT *obj, long param)
{
}

void
view_conf(int set_default, FD_config_viewedit *form) 
{

 view_obj = form;

 fl_clear_choice(view_obj->Send_Confirm);
 fl_addto_choice(view_obj->Send_Confirm, "Always");
 fl_addto_choice(view_obj->Send_Confirm, "Ask");
 fl_addto_choice(view_obj->Send_Confirm, "Never");

 fl_set_choice(view_obj->Send_Confirm, b_getcfg_int_default(conf_name, "vconfirm", 1, set_default));

 fl_set_counter_bounds(view_obj->View_Wrap, 40, 200);
 fl_set_counter_precision(view_obj->View_Wrap, 0);
 fl_set_counter_step(view_obj->View_Wrap, 1, 1);
 fl_set_counter_value(view_obj->View_Wrap, (double)((double)b_getcfg_int_default(conf_name,"viewrap",80, set_default)));

 fl_set_input(view_obj->View_EView, b_getcfg_str_default(conf_name, "extview", "/usr/bin/X11/xedit", set_default));
 fl_set_input(view_obj->View_URL, b_getcfg_str_default(conf_name, "urlview", "", set_default));
 fl_set_input(view_obj->View_FTP, b_getcfg_str_default(conf_name, "ftprog", "", set_default));

 headcolor = b_getcfg_int_default(conf_name, "headcolor", FL_RED, set_default);
 fl_set_button(view_obj->View_Header, b_getcfg_int_default(conf_name, "sheader", 0, set_default));
 fl_set_object_color(view_obj->View_HColor, headcolor, FL_BLACK);

 markincl = b_getcfg_int_default(conf_name, "markincl", 0, set_default);
 fl_set_button(view_obj->Mark_Included, markincl ? 1 : 0);
 fl_set_object_color(view_obj->View_MColor, markincl, FL_BLACK);

 fl_set_button(view_obj->View_Ext, b_getcfg_int_default(conf_name, "viewexit",0, set_default));
 fl_set_button(view_obj->View_Internal, b_getcfg_int_default(conf_name, "intview",0, set_default));
 fl_set_button(view_obj->View_Ofold, b_getcfg_int_default(conf_name, "switchfold",1, set_default));
}

void
handle_view_input(FD_config_viewedit *form)
{
 view_obj = form;
 b_putcfg_int(conf_name, "viewrap", (int)fl_get_counter_value(view_obj->View_Wrap));
 b_putcfg_str(conf_name, "extview", (char *)fl_get_input(view_obj->View_EView));
 b_putcfg_str(conf_name, "urlview", (char *)fl_get_input(view_obj->View_URL));
 b_putcfg_str(conf_name, "ftprog", (char *)fl_get_input(view_obj->View_FTP));
 b_putcfg_int(conf_name, "sheader", fl_get_button(view_obj->View_Header));
 b_putcfg_int(conf_name, "headcolor", headcolor);
 b_putcfg_int(conf_name, "markincl", markincl);

 b_putcfg_int(conf_name, "vconfirm", fl_get_choice(view_obj->Send_Confirm));
 b_putcfg_int(conf_name, "viewexit", fl_get_button(view_obj->View_Ext));
 b_putcfg_int(conf_name, "intview", fl_get_button(view_obj->View_Internal));
 b_putcfg_int(conf_name, "switchfold", fl_get_button(view_obj->View_Ofold));

 return;         
}

void
edit_conf(int set_default, FD_config_viewedit *form) 
{
int wrap;

 edit_obj = form;
 wrap = b_getcfg_int_default(conf_name,"editwrap",-80, set_default);

 fl_set_counter_bounds(edit_obj->Edit_Wrap, 40, 200);
 fl_set_counter_precision(edit_obj->Edit_Wrap, 0);
 fl_set_counter_step(edit_obj->Edit_Wrap, 1, 1);
 fl_set_counter_value(edit_obj->Edit_Wrap, (double)abs(wrap));

 fl_set_button(edit_obj->Edit_Word_Wrap, wrap < 0 ? 1 : 0);
 fl_set_button(edit_obj->Edit_Paste_Cursor, b_getcfg_int_default(conf_name, "editpastecur", 1, set_default));

 fl_set_input(edit_obj->Edit_EEdit, b_getcfg_str_default(conf_name, "extedit", "/usr/bin/X11/xedit", set_default));
}

void
handle_edit_input(FD_config_viewedit *form)
{
int wrap;
 edit_obj = form;
 wrap = (int)fl_get_counter_value(edit_obj->Edit_Wrap);
 if (fl_get_button(edit_obj->Edit_Word_Wrap))
	wrap *= -1;

 b_putcfg_int(conf_name, "editwrap", wrap);
 b_putcfg_str(conf_name, "extedit", (char *)fl_get_input(edit_obj->Edit_EEdit));
 b_putcfg_int(conf_name, "editpastecur", fl_get_button(edit_obj->Edit_Paste_Cursor));

 return;         

}

int
close_intview_form(form, data)
FL_FORM *form; 
void *data; 
{
struct _proc_info *pinfo;

  if (form->u_vdata)     {
   pinfo = (struct _proc_info *)form->u_vdata;
   if (pinfo->handle)
        (pinfo->handle)(pinfo);
    free(pinfo);
			 }
  fl_hide_form(form);
  fl_free_form(form);

  return FL_IGNORE;
}

void
cb_intview_button_exit(obj, param)
FL_OBJECT *obj;
long param;
{
 close_intview_form(obj->form, obj->form);
}

void
cb_view_browser(obj, param)
FL_OBJECT *obj;
long param;
{
}

int
file_view(file, pinfo)
char *file;
struct _proc_info *pinfo;
{
struct _proc_info *npinfo;
FL_OBJECT *obj;
FL_FORM *viewform;
int i, added, w, h;
char command[255], *e;

 if (!file)
	return -1;

 if (!b_getcfg_int(conf_name, "intview", 0)) {
  e = b_getcfg_str(conf_name, "extview", "/usr/bin/X11/xedit");
  command[0] = '\0';
  added = 0;
  for (i = 0; i < strlen(e); i++) {
   if ((e[i] == '$') && (e[i+1] == 'f') && i && (e[i-1] == ' ')) {
        added = 1;       
	i++;
        strcat(command, file);					 }
   else  {       
        command[strlen(command) + 1] = '\0';
        command[strlen(command)] = e[i];
         }
                                  }
        
  if (!added)   {
        strcat(command, " ");
        strcat(command, file);
                }

  return exec_child(command, pinfo);
					    }

 npinfo = dup_pid_info(pinfo);
 viewform = fl_bgn_form(FL_NO_BOX, 805, 605);
 fl_add_box(FL_FLAT_BOX,0,0,805,605,"");
 viewform->u_vdata = npinfo;

 obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,3,3,35,33,"");
 fl_set_object_resize(obj,FL_RESIZE_NONE);
 fl_set_object_gravity(obj,NorthWestGravity,0);
 fl_set_object_posthandler(obj, post_handler);
 obj->u_vdata = "Exit viewer";
 fl_set_pixmapbutton_data(obj,exit_xpm);
 fl_set_object_callback(obj,cb_intview_button_exit,0);
 fl_set_button_shortcut(obj, "^X", 0);

 obj = fl_add_textedit(FL_NORMAL_TEXTEDIT,3,40,799,562,"");
 fl_set_object_resize(obj,FL_RESIZE_ALL);
 fl_set_object_gravity(obj,NorthWestGravity,SouthEastGravity);
 fl_set_textedit_color(obj,b_getcfg_int(conf_name, "ViewBgCol", FL_TOP_BCOL), b_getcfg_int(conf_name, "ViewFgCol", FL_BLACK), FL_BLUE, 0);
 fl_set_textedit_fontstyle(obj, b_getcfg_int(conf_name, "ViewFStyle", FL_NORMAL_STYLE));
 fl_set_textedit_fontsize(obj, b_getcfg_int(conf_name, "ViewFSize", FL_NORMAL_SIZE));
 fl_textedit_readonly(obj, 1);
 fl_set_object_callback(obj,cb_view_browser,0);

 fl_set_form_atclose(viewform, close_intview_form, viewform);
 fl_end_form(); 
 fl_set_form_minsize(viewform, 600, 300);
 sscanf(b_getcfg_str(conf_name, "msgformsize", "800 600"), "%d %d", &w, &h);
 if (b_getcfg_int(conf_name, "wplace", 1))
  fl_set_initial_placement(viewform, 100, 150, w, h);
 else
  fl_set_form_size(viewform, w, h);

 fl_set_form_icon(viewform, icon_MailEdit, icon_MailEdit_sh);
 fl_load_textedit(obj, file);
 fl_show_form(viewform,FL_PLACE_FREE,FL_FULLBORDER,file);

 return 0;
}
