/*
 * Copyright (c) 1997 Massachusetts Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to use, copy, modify, and distribute the Software without
 * restriction, provided the Software, including any modified copies made
 * under this license, is not distributed for a fee, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY BE LIABLE
 * FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * Except as contained in this notice, the name of the Massachusetts
 * Institute of Technology shall not be used in advertising or otherwise
 * to promote the sale, use or other dealings in this Software without
 * prior written authorization from the Massachusetts Institute of
 * Technology.
 *  
 */

/* This file has been automatically generated --- DO NOT EDIT */

#include <fftw.h>
#include "konst.h"

/* Generated by $Id: genfft.ml,v 1.31 1997/08/27 20:46:08 fftw Exp $ */

/* This function contains 102 FP additions and 60 FP multiplications */

void fftwi_twiddle_7(FFTW_COMPLEX *A, const FFTW_COMPLEX *W, int stride, int m, int dist)
{
     int i;
     COMPLEX *inout;
     inout = A;
     for (i = 0; i < m; i = i + 1, inout = inout + dist, W = W + 6) {
	  FFTW_REAL tre0_0_0;
	  FFTW_REAL tim0_0_0;
	  FFTW_REAL tre0_1_0;
	  FFTW_REAL tim0_1_0;
	  FFTW_REAL tre0_2_0;
	  FFTW_REAL tim0_2_0;
	  FFTW_REAL tre0_3_0;
	  FFTW_REAL tim0_3_0;
	  FFTW_REAL tre0_4_0;
	  FFTW_REAL tim0_4_0;
	  FFTW_REAL tre0_5_0;
	  FFTW_REAL tim0_5_0;
	  FFTW_REAL tre0_6_0;
	  FFTW_REAL tim0_6_0;
	  tre0_0_0 = c_re(inout[0]);
	  tim0_0_0 = c_im(inout[0]);
	  {
	       FFTW_REAL tr;
	       FFTW_REAL ti;
	       FFTW_REAL twr;
	       FFTW_REAL twi;
	       tr = c_re(inout[stride]);
	       ti = c_im(inout[stride]);
	       twr = c_re(W[0]);
	       twi = c_im(W[0]);
	       tre0_1_0 = (tr * twr) + (ti * twi);
	       tim0_1_0 = (ti * twr) - (tr * twi);
	  }
	  {
	       FFTW_REAL tr;
	       FFTW_REAL ti;
	       FFTW_REAL twr;
	       FFTW_REAL twi;
	       tr = c_re(inout[2 * stride]);
	       ti = c_im(inout[2 * stride]);
	       twr = c_re(W[1]);
	       twi = c_im(W[1]);
	       tre0_2_0 = (tr * twr) + (ti * twi);
	       tim0_2_0 = (ti * twr) - (tr * twi);
	  }
	  {
	       FFTW_REAL tr;
	       FFTW_REAL ti;
	       FFTW_REAL twr;
	       FFTW_REAL twi;
	       tr = c_re(inout[3 * stride]);
	       ti = c_im(inout[3 * stride]);
	       twr = c_re(W[2]);
	       twi = c_im(W[2]);
	       tre0_3_0 = (tr * twr) + (ti * twi);
	       tim0_3_0 = (ti * twr) - (tr * twi);
	  }
	  {
	       FFTW_REAL tr;
	       FFTW_REAL ti;
	       FFTW_REAL twr;
	       FFTW_REAL twi;
	       tr = c_re(inout[4 * stride]);
	       ti = c_im(inout[4 * stride]);
	       twr = c_re(W[3]);
	       twi = c_im(W[3]);
	       tre0_4_0 = (tr * twr) + (ti * twi);
	       tim0_4_0 = (ti * twr) - (tr * twi);
	  }
	  {
	       FFTW_REAL tr;
	       FFTW_REAL ti;
	       FFTW_REAL twr;
	       FFTW_REAL twi;
	       tr = c_re(inout[5 * stride]);
	       ti = c_im(inout[5 * stride]);
	       twr = c_re(W[4]);
	       twi = c_im(W[4]);
	       tre0_5_0 = (tr * twr) + (ti * twi);
	       tim0_5_0 = (ti * twr) - (tr * twi);
	  }
	  {
	       FFTW_REAL tr;
	       FFTW_REAL ti;
	       FFTW_REAL twr;
	       FFTW_REAL twi;
	       tr = c_re(inout[6 * stride]);
	       ti = c_im(inout[6 * stride]);
	       twr = c_re(W[5]);
	       twi = c_im(W[5]);
	       tre0_6_0 = (tr * twr) + (ti * twi);
	       tim0_6_0 = (ti * twr) - (tr * twi);
	  }
	  c_re(inout[0]) = tre0_0_0 + tre0_1_0 + tre0_2_0 + tre0_3_0 + tre0_4_0 + tre0_5_0 + tre0_6_0;
	  c_im(inout[0]) = tim0_0_0 + tim0_1_0 + tim0_2_0 + tim0_3_0 + tim0_4_0 + tim0_5_0 + tim0_6_0;
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tre1_1_0;
	       tre1_0_0 = tre0_0_0 + (((FFTW_REAL) FFTW_K623489801) * (tre0_1_0 + tre0_6_0)) - (((FFTW_REAL) FFTW_K900968867) * (tre0_3_0 + tre0_4_0)) - (((FFTW_REAL) FFTW_K222520933) * (tre0_2_0 + tre0_5_0));
	       tre1_1_0 = (((FFTW_REAL) FFTW_K781831482) * (tim0_6_0 - tim0_1_0)) + (((FFTW_REAL) FFTW_K974927912) * (tim0_5_0 - tim0_2_0)) + (((FFTW_REAL) FFTW_K433883739) * (tim0_4_0 - tim0_3_0));
	       c_re(inout[stride]) = tre1_0_0 + tre1_1_0;
	       c_re(inout[6 * stride]) = tre1_0_0 - tre1_1_0;
	  }
	  {
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tim1_1_0;
	       tim1_0_0 = tim0_0_0 + (((FFTW_REAL) FFTW_K623489801) * (tim0_1_0 + tim0_6_0)) - (((FFTW_REAL) FFTW_K900968867) * (tim0_3_0 + tim0_4_0)) - (((FFTW_REAL) FFTW_K222520933) * (tim0_2_0 + tim0_5_0));
	       tim1_1_0 = (((FFTW_REAL) FFTW_K781831482) * (tre0_1_0 - tre0_6_0)) + (((FFTW_REAL) FFTW_K974927912) * (tre0_2_0 - tre0_5_0)) + (((FFTW_REAL) FFTW_K433883739) * (tre0_3_0 - tre0_4_0));
	       c_im(inout[stride]) = tim1_0_0 + tim1_1_0;
	       c_im(inout[6 * stride]) = tim1_0_0 - tim1_1_0;
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tre1_1_0;
	       tre1_0_0 = tre0_0_0 + (((FFTW_REAL) FFTW_K623489801) * (tre0_3_0 + tre0_4_0)) - (((FFTW_REAL) FFTW_K900968867) * (tre0_2_0 + tre0_5_0)) - (((FFTW_REAL) FFTW_K222520933) * (tre0_1_0 + tre0_6_0));
	       tre1_1_0 = (((FFTW_REAL) FFTW_K974927912) * (tim0_6_0 - tim0_1_0)) + (((FFTW_REAL) FFTW_K433883739) * (tim0_2_0 - tim0_5_0)) + (((FFTW_REAL) FFTW_K781831482) * (tim0_3_0 - tim0_4_0));
	       c_re(inout[2 * stride]) = tre1_0_0 + tre1_1_0;
	       c_re(inout[5 * stride]) = tre1_0_0 - tre1_1_0;
	  }
	  {
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tim1_1_0;
	       tim1_0_0 = tim0_0_0 + (((FFTW_REAL) FFTW_K623489801) * (tim0_3_0 + tim0_4_0)) - (((FFTW_REAL) FFTW_K900968867) * (tim0_2_0 + tim0_5_0)) - (((FFTW_REAL) FFTW_K222520933) * (tim0_1_0 + tim0_6_0));
	       tim1_1_0 = (((FFTW_REAL) FFTW_K974927912) * (tre0_1_0 - tre0_6_0)) + (((FFTW_REAL) FFTW_K433883739) * (tre0_5_0 - tre0_2_0)) + (((FFTW_REAL) FFTW_K781831482) * (tre0_4_0 - tre0_3_0));
	       c_im(inout[2 * stride]) = tim1_0_0 + tim1_1_0;
	       c_im(inout[5 * stride]) = tim1_0_0 - tim1_1_0;
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tre1_1_0;
	       tre1_0_0 = tre0_0_0 + (((FFTW_REAL) FFTW_K623489801) * (tre0_2_0 + tre0_5_0)) - (((FFTW_REAL) FFTW_K222520933) * (tre0_3_0 + tre0_4_0)) - (((FFTW_REAL) FFTW_K900968867) * (tre0_1_0 + tre0_6_0));
	       tre1_1_0 = (((FFTW_REAL) FFTW_K433883739) * (tim0_6_0 - tim0_1_0)) + (((FFTW_REAL) FFTW_K781831482) * (tim0_2_0 - tim0_5_0)) + (((FFTW_REAL) FFTW_K974927912) * (tim0_4_0 - tim0_3_0));
	       c_re(inout[3 * stride]) = tre1_0_0 + tre1_1_0;
	       c_re(inout[4 * stride]) = tre1_0_0 - tre1_1_0;
	  }
	  {
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tim1_1_0;
	       tim1_0_0 = tim0_0_0 + (((FFTW_REAL) FFTW_K623489801) * (tim0_2_0 + tim0_5_0)) - (((FFTW_REAL) FFTW_K222520933) * (tim0_3_0 + tim0_4_0)) - (((FFTW_REAL) FFTW_K900968867) * (tim0_1_0 + tim0_6_0));
	       tim1_1_0 = (((FFTW_REAL) FFTW_K433883739) * (tre0_1_0 - tre0_6_0)) + (((FFTW_REAL) FFTW_K781831482) * (tre0_5_0 - tre0_2_0)) + (((FFTW_REAL) FFTW_K974927912) * (tre0_3_0 - tre0_4_0));
	       c_im(inout[3 * stride]) = tim1_0_0 + tim1_1_0;
	       c_im(inout[4 * stride]) = tim1_0_0 - tim1_1_0;
	  }
     }
}
