/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *        Copyright (c) 1990, ..., 1996 Bellcore            *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *   dfs@research.att.com       dicook@iastate.edu          *
 *      (973) 360-8423    www.public.iastate.edu/~dicook/   *
 *                                                          *
 *                    Andreas Buja                          *
 *                andreas@research.att.com                  *
 *              www.research.att.com/~andreas/              *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"
#include "xgobiexterns.h"
/*
 * min and max for 'forget it' dotplotting axis
 * They're defined so as to locate the plot in the center of
 * the window, with the texturing values returned on a range
 * of [0,100]
*/
#define FORGETITAXIS_MIN -100.
#define FORGETITAXIS_MAX 200.

static Widget dotplot_panel;
static Widget dotplot_cycle_cmd, dotplot_delay_sbar, dotplot_chdir_cmd;
static int dotplot_cycle_dir = 1;
static XtIntervalId cycle_timeout_id = 0;
static float delay = 2.0;

static float *txtr_raw_data;
static lims txtr_lim;

void
init_dotplot_vars(xg)
  xgobidata *xg;
{
  xg->is_dotplotting = False;
  xg->is_dotplot_cycle = False;
  xg->dotplot_vars.x = -1 ;
  xg->dotplot_vars.y = 0;
}

int
dotplot_varselect(varno, event, xg)
/*
 * This is used during textured dot plotting.
*/
  int varno;
  XButtonEvent *event;
  xgobidata *xg;
{
  int prev;
  int newvar = 0;

/*
 * If it's a left click, ignore it.
*/
  if (event->button == 1)
    ;
/*
 * If it's a middle click ...
*/
  else if (event->button == 2)
  {
    /*
     * If it's the current y variable, generate a new dotplot.
    */
    if (varno == xg->dotplot_vars.y)
      newvar = 1;
    /*
     * Otherwise choose the new y.
    */
    else
    {
      prev = xg->dotplot_vars.y;
      xg->varchosen[prev] = False;
      refresh_vbox(xg, prev, 1);

      xg->dotplot_vars.y = varno;
      xg->varchosen[varno] = True;
      refresh_vbox(xg, xg->dotplot_vars.y, 1);
      newvar = 1;
    }
  }
  return(newvar);
}

void
dotplot_reproject(xg)
  xgobidata *xg;
{
/*
 * Project the y variable down from the ncols-dimensional world_data[]
 * to the 2-dimensional array planar[]; get the x variable directly
 * from txtr_raw_data[].
*/
  int i, k;
  float rdiff = txtr_lim.max - txtr_lim.min;
  float ftmp;
  float precis = PRECISION1;
  int iy = xg->dotplot_vars.y;

  for (i=0; i<xg->nrows_in_plot; i++)
  {
    k = xg->rows_in_plot[i];

    xg->planar[k].y = xg->world_data[k][iy];

    /*
     * Use txtr_raw_data[i] not [k] because txtr_raw_data[]
     * is of length xg->nrows_in_plot rather than xg->nrows.
    */
    ftmp = -1.0 + 2.0*(txtr_raw_data[i] - txtr_lim.min)/rdiff;
    xg->planar[k].x = (long) (precis * ftmp);
  }
}

void
dotplot_texture_var(xg)
  xgobidata *xg;
{
/*
 * Set up the next dot plot.
*/
  int i;
  float *yy;
  float del = 1.;
  int option = 1, stages = 3;

  /*
   * yy is a temporary variable.  It's used by textur, and then
   * junked immediately afterward.
  */
  yy = (float *) XtMalloc((Cardinal) xg->nrows_in_plot * sizeof(float));

  for (i=0; i<xg->nrows_in_plot; i++)
    yy[i] = xg->raw_data[i][xg->dotplot_vars.y];

  textur(yy, txtr_raw_data, xg->nrows_in_plot, option, del, stages);

  XtFree((XtPointer) yy);
}

void
free_txtr_var()
{
  XtFree((XtPointer) txtr_raw_data);
}

/* ARGSUSED */
static void
turn_on_dotplot_animation(xg, id)
  xgobidata *xg;
  XtIntervalId id;
{
  xg->is_dotplot_cycle = True;
  (void) XtAppAddWorkProc(app_con, RunWorkProcs, (XtPointer) NULL);
}

void
dotplot_cycle_proc(xg)
  xgobidata *xg;
{
  int varno;

  if (dotplot_cycle_dir == 1)
  {
    varno = xg->dotplot_vars.y + 1;
    if (varno > xg->ncols_used-1)
      varno = 0;
  } else {
    varno = xg->dotplot_vars.y - 1;
    if (varno < 0)
      varno = xg->ncols_used-1;
  }
  xg->varchosen[xg->dotplot_vars.y] = False;
  refresh_vbox(xg, xg->dotplot_vars.y, 1);
  xg->dotplot_vars.y = varno;
  xg->varchosen[xg->dotplot_vars.y] = True;
  refresh_vbox(xg, xg->dotplot_vars.y, 1);

  world_to_plane(xg);
  plane_to_screen(xg);
  init_ticks(&xg->dotplot_vars, xg);
  plot_once(xg);
  XSync(display, False);

  xg->is_dotplot_cycle = False;
  cycle_timeout_id =  XtAppAddTimeOut(app_con,
     (unsigned long) (1000*delay),
     (XtTimerCallbackProc) turn_on_dotplot_animation, (XtPointer) xg);
}


/* ARGSUSED */
XtCallbackProc
dotplot_cycle_cback(w, xg, callback_data)
/*
 * Turn on cycling.
*/
  Widget w;
  xgobidata *xg;
  caddr_t callback_data;
{
  if (!xg->is_dotplot_cycle && cycle_timeout_id == 0L)
  {
    xg->is_dotplot_cycle = True;
    (void) XtAppAddWorkProc(app_con, RunWorkProcs, (XtPointer) NULL);
  }
  else
  {
    XtRemoveTimeOut(cycle_timeout_id);
    cycle_timeout_id = 0L;
    xg->is_dotplot_cycle = False;
  }
}

/* ARGSUSED */
XtCallbackProc
dotplot_cycle_delay_cback(w, xg, slideposp)
/*
 * Change the cycling speed.
*/
  Widget w;
  xgobidata *xg;
  XtPointer slideposp;
{
  float fslidepos = * (float *) slideposp;

  delay = 1.0 / (2.0 * fslidepos + 0.2) ;
}

/* ARGSUSED */
XtCallbackProc
dotplot_chdir_cback(w, client_data, callback_data)
/*
 * Change the direction of cycling.
*/
  Widget w;
  caddr_t client_data;
  caddr_t callback_data;
{
  dotplot_cycle_dir = -1 * dotplot_cycle_dir;
}

static void
map_dotplot(on)
  int on;
{
  if (on)
    XtMapWidget(dotplot_panel);
  else
    XtUnmapWidget(dotplot_panel);
}


void
make_dotplot(xg)
  xgobidata *xg;
{
/*
 * DotPlotPanel: dotplot_panel
*/
  char str[35];
  Dimension max_width;
/*
 * Widest button label used in this panel.
*/
  (void) sprintf(str, "Change Direction");
  max_width = XTextWidth(appdata.font, str, strlen(str));

  dotplot_panel = XtVaCreateManagedWidget("DotPlotPanel",
    boxWidgetClass, xg->box0,
    XtNleft, (XtEdgeType) XtChainLeft,
    XtNright, (XtEdgeType) XtChainLeft,
    XtNtop, (XtEdgeType) XtChainTop,
    XtNbottom, (XtEdgeType) XtChainTop,
    XtNmappedWhenManaged, (Boolean) False,
    XtNorientation, (XtOrientation) XtorientVertical,
    NULL);
  if (mono) set_mono(dotplot_panel);

  dotplot_cycle_cmd = CreateToggle(xg, "Cycle",
    True, (Widget) NULL, (Widget) NULL, (Widget) NULL, False, ANY_OF_MANY,
    dotplot_panel, "DotPlot_Cycle");
  XtManageChild(dotplot_cycle_cmd);
  XtAddCallback(dotplot_cycle_cmd, XtNcallback,
    (XtCallbackProc) dotplot_cycle_cback, (XtPointer) xg);

  dotplot_delay_sbar = XtVaCreateManagedWidget("Scrollbar",
    scrollbarWidgetClass, dotplot_panel,
    XtNorientation, (XtOrientation) XtorientHorizontal,
    XtNwidth, (Dimension) max_width,
    XtNfromVert, (Widget) dotplot_cycle_cmd,
    NULL);
  if (mono) set_mono(dotplot_delay_sbar);

  /*
   * delay = 1 / (2*slidepos + .2)
   * slidepos = 1 / (2*delay) - .1
  */
  XawScrollbarSetThumb(dotplot_delay_sbar, 1.0 / (2.0 * delay) - 0.1, -1.);
  XtAddCallback(dotplot_delay_sbar, XtNjumpProc,
    (XtCallbackProc) dotplot_cycle_delay_cback, (XtPointer) xg);
  add_sbar_help(&xg->nhelpids.sbar,
    dotplot_delay_sbar, "DotPlot_Cycle");

  dotplot_chdir_cmd = CreateCommand(xg, "Change Direction",
    True, (Widget) NULL, (Widget) NULL,
    dotplot_panel, "DotPlot_Cycle");
  XtManageChild(dotplot_chdir_cmd);
  XtAddCallback(dotplot_chdir_cmd, XtNcallback,
    (XtCallbackProc) dotplot_chdir_cback, (XtPointer) NULL);
}

void
dotplot_on(xg)
  xgobidata *xg;
/*
 * Turn on and off the dotplot mode.
*/
{
  int j;
  Boolean cycle_on;
  extern xgobidata xgobi;

/*
 *  If this mode is currently selected, turn it off.
*/
  if (xg->prev_plot_mode == DOTPLOT_MODE && xg->plot_mode != DOTPLOT_MODE) {
    map_dotplot(0);

    xg->is_dotplot_cycle = False;
    if (cycle_timeout_id)
    {
      XtRemoveTimeOut(cycle_timeout_id);
      cycle_timeout_id = 0L;
    }
  }
  /* Else turn it on */
  else if (xg->plot_mode == DOTPLOT_MODE &&
           xg->prev_plot_mode != DOTPLOT_MODE)
  {
    map_dotplot(1);

    if (!xg->is_dotplotting)
    {
      if (xg->is_touring && xg->is_princ_comp)
      {
        xg->is_touring = False;
        reset_var_labels(xg, PRINCCOMP_OFF);
      }

      if (xg->carry_vars)
        carry_dotplot_vars(xg);

      xg->is_xyplotting = xg->is_spinning = xg->is_touring = False;
      xg->is_dotplotting = True;
      xg->is_corr_touring = False;

      txtr_raw_data = (float *) XtMalloc( (Cardinal)
        xg->nrows_in_plot * sizeof(float));
      txtr_lim.min = FORGETITAXIS_MIN ;
      txtr_lim.max = FORGETITAXIS_MAX ;

      dotplot_texture_var(xg);

      update_lims(xg);
      update_world(xg);
      world_to_plane(xg);
      plane_to_screen(xg);

      init_ticks(&xg->dotplot_vars, xg);

      plot_once(xg);
      /*
       * Reinitialize the sin and cos variables.  Why???
      */
      init_trig(xg);

      for (j=0; j<xg->ncols; j++)
      {
        if (j == xg->dotplot_vars.y)
          xg->varchosen[j] = True;
        else
          xg->varchosen[j] = False;
      }

      set_varsel_label(xg);
      refresh_vboxes(xg);
    }
    /*
     * If the cycle button is activated, start cycling.
    */
    XtVaGetValues(dotplot_cycle_cmd, XtNstate, &cycle_on, NULL);

    if (cycle_on)
    {
      xg->is_dotplot_cycle = True;
      (void) XtAppAddWorkProc(app_con, RunWorkProcs, (XtPointer) NULL);
    }

  }
}
